/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

import java.nio.ByteOrder;
import mitiv.base.Traits;

public class BaseUtils
implements Traits {
    protected BaseUtils() {
        throw new RuntimeException("Non instantiable");
    }

    static final int getNativeByteOrder() {
        ByteOrder order = ByteOrder.nativeOrder();
        if (order == ByteOrder.BIG_ENDIAN) {
            return 4321;
        }
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return 1234;
        }
        return -1;
    }

    public static void main(String[] args) {
        System.out.println("FLT_EPSILON = " + FLT_EPSILON);
        System.out.println("DBL_EPSILON = " + DBL_EPSILON);
        String name = NATIVE_BYTE_ORDER == 4321 ? "BIG_ENDIAN" : (NATIVE_BYTE_ORDER == 1234 ? "LITTLE_ENDIAN" : "UNKNOWN_BYTE_ORDER");
        System.out.println("This machine byte order: " + name);
        System.out.flush();
    }

    static final float machineEpsilonFloat() {
        float value = 1.0f;
        while (1.0f + value / 2.0f != 1.0f) {
            value /= 2.0f;
        }
        if (value <= 0.0f) {
            throw new RuntimeException("Failed to compute FLT_EPSILON.");
        }
        return value;
    }

    static final double machineEpsilonDouble() {
        double value = 1.0;
        while (1.0 + value / 2.0 != 1.0) {
            value /= 2.0;
        }
        if (value <= 0.0) {
            throw new RuntimeException("Failed to compute DBL_EPSILON.");
        }
        return value;
    }
}

