/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte4D;
import mitiv.array.Double4D;
import mitiv.array.Float4D;
import mitiv.array.Int4D;
import mitiv.array.Long4D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short3D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort4D;
import mitiv.array.impl.StriddenShort4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short4D
extends Array4D
implements ShortArray {
    protected Short4D(int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
    }

    protected Short4D(int[] dims) {
        super(dims);
    }

    protected Short4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, short var5);

    @Override
    public void fill(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            this.set(i1, i2, i3, i4, value);
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, value);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void increment(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            this.set(i1, i2, i3, i4, (short)(this.get(i1, i2, i3, i4) + value));
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, (short)(this.get(i1, i2, i3, i4) + value));
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void decrement(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            this.set(i1, i2, i3, i4, (short)(this.get(i1, i2, i3, i4) - value));
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, (short)(this.get(i1, i2, i3, i4) - value));
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void scale(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            this.set(i1, i2, i3, i4, (short)(this.get(i1, i2, i3, i4) * value));
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, (short)(this.get(i1, i2, i3, i4) * value));
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void map(ShortFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            this.set(i1, i2, i3, i4, function.apply(this.get(i1, i2, i3, i4)));
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, function.apply(this.get(i1, i2, i3, i4)));
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            this.set(i1, i2, i3, i4, generator.nextShort());
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, generator.nextShort());
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            if (initialized) {
                                scanner.update(this.get(i1, i2, i3, i4));
                            } else {
                                scanner.initialize(this.get(i1, i2, i3, i4));
                                initialized = true;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            if (initialized) {
                                scanner.update(this.get(i1, i2, i3, i4));
                            } else {
                                scanner.initialize(this.get(i1, i2, i3, i4));
                                initialized = true;
                            }
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        short[] out = new short[this.number];
        int i = -1;
        int i4 = 0;
        while (i4 < this.dim4) {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        out[++i] = this.get(i1, i2, i3, i4);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            ++i4;
        }
        return out;
    }

    @Override
    public short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short minValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            if (skip) {
                                skip = false;
                            } else {
                                short value = this.get(i1, i2, i3, i4);
                                if (value < minValue) {
                                    minValue = value;
                                }
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            if (skip) {
                                skip = false;
                            } else {
                                short value = this.get(i1, i2, i3, i4);
                                if (value < minValue) {
                                    minValue = value;
                                }
                            }
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
        return minValue;
    }

    @Override
    public short max() {
        short maxValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            if (skip) {
                                skip = false;
                            } else {
                                short value = this.get(i1, i2, i3, i4);
                                if (value > maxValue) {
                                    maxValue = value;
                                }
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            if (skip) {
                                skip = false;
                            } else {
                                short value = this.get(i1, i2, i3, i4);
                                if (value > maxValue) {
                                    maxValue = value;
                                }
                            }
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
        return maxValue;
    }

    @Override
    public short[] getMinAndMax() {
        short[] result = new short[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(short[] mm) {
        short minValue;
        short maxValue = minValue = this.get(0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            if (skip) {
                                skip = false;
                            } else {
                                short value = this.get(i1, i2, i3, i4);
                                if (value < minValue) {
                                    minValue = value;
                                }
                                if (value > maxValue) {
                                    maxValue = value;
                                }
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            if (skip) {
                                skip = false;
                            } else {
                                short value = this.get(i1, i2, i3, i4);
                                if (value < minValue) {
                                    minValue = value;
                                }
                                if (value > maxValue) {
                                    maxValue = value;
                                }
                            }
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            totalValue += this.get(i1, i2, i3, i4);
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            totalValue += this.get(i1, i2, i3, i4);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i4 = 0;
        while (i4 < this.dim4) {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        out[++i] = (byte)this.get(i1, i2, i3, i4);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            ++i4;
        }
        return Byte4D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    @Override
    public Short4D toShort() {
        return this;
    }

    @Override
    public Int4D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i4 = 0;
        while (i4 < this.dim4) {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        out[++i] = this.get(i1, i2, i3, i4);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            ++i4;
        }
        return Int4D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    @Override
    public Long4D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i4 = 0;
        while (i4 < this.dim4) {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        out[++i] = this.get(i1, i2, i3, i4);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            ++i4;
        }
        return Long4D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    @Override
    public Float4D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i4 = 0;
        while (i4 < this.dim4) {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        out[++i] = this.get(i1, i2, i3, i4);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            ++i4;
        }
        return Float4D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    @Override
    public Double4D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i4 = 0;
        while (i4 < this.dim4) {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        out[++i] = this.get(i1, i2, i3, i4);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            ++i4;
        }
        return Double4D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    @Override
    public Short4D copy() {
        return new FlatShort4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Short4D src = arr.getType() == 1 ? (Short4D)arr : (Short4D)arr.toShort();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            this.set(i1, i2, i3, i4, src.get(i1, i2, i3, i4));
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, src.get(i1, i2, i3, i4));
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, (short)src.get(++i));
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i4 = 0;
            while (i4 < this.dim4) {
                int i3 = 0;
                while (i3 < this.dim3) {
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            this.set(i1, i2, i3, i4, (short)src.get(++i));
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short4D create() {
        return new FlatShort4D(this.getShape());
    }

    public static Short4D create(int dim1, int dim2, int dim3, int dim4) {
        return new FlatShort4D(dim1, dim2, dim3, dim4);
    }

    public static Short4D create(int[] dims) {
        return new FlatShort4D(dims);
    }

    public static Short4D create(Shape shape) {
        return new FlatShort4D(shape);
    }

    public static Short4D wrap(short[] data, int dim1, int dim2, int dim3, int dim4) {
        return new FlatShort4D(data, dim1, dim2, dim3, dim4);
    }

    public static Short4D wrap(short[] data, int[] dims) {
        return new FlatShort4D(data, dims);
    }

    public static Short4D wrap(short[] data, Shape shape) {
        return new FlatShort4D(data, shape);
    }

    public static Short4D wrap(short[] data, int offset, int stride1, int stride2, int stride3, int stride4, int dim1, int dim2, int dim3, int dim4) {
        return new StriddenShort4D(data, offset, stride1, stride2, stride3, stride4, dim1, dim2, dim3, dim4);
    }

    @Override
    public abstract Short3D slice(int var1);

    @Override
    public abstract Short3D slice(int var1, int var2);

    @Override
    public abstract Short4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Short4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Short1D as1D();
}

