/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import java.util.ArrayList;
import mcib3d.geom.IntCoord3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;

public class Flood3D {
    public static void flood3d6(ImageInt imageInt, int n, int n2, int n3, int n4) {
        IntCoord3D intCoord3D = new IntCoord3D(n, n2, n3);
        if (imageInt instanceof ImageShort) {
            Flood3D.flood3DShort6((ImageShort)imageInt, intCoord3D, (short)n4);
        } else if (imageInt instanceof ImageByte) {
            Flood3D.flood3DByte6((ImageByte)imageInt, intCoord3D, (byte)n4);
        }
    }

    public static void flood3d26(ImageInt imageInt, int n, int n2, int n3, int n4) {
        IntCoord3D intCoord3D = new IntCoord3D(n, n2, n3);
        if (imageInt instanceof ImageShort) {
            Flood3D.flood3DShort26((ImageShort)imageInt, intCoord3D, (short)n4);
        } else if (imageInt instanceof ImageByte) {
            Flood3D.flood3DByte26((ImageByte)imageInt, intCoord3D, (byte)n4);
        }
    }

    private static void flood3DShort6(ImageShort imageShort, IntCoord3D intCoord3D, short s) {
        short[][] sArray = imageShort.pixels;
        int n = imageShort.sizeX;
        int n2 = imageShort.sizeY;
        int n3 = imageShort.sizeZ;
        short s2 = sArray[intCoord3D.z][intCoord3D.x + intCoord3D.y * n];
        ArrayList<IntCoord3D> arrayList = new ArrayList<IntCoord3D>();
        arrayList.add(intCoord3D);
        while (!arrayList.isEmpty()) {
            IntCoord3D intCoord3D2 = (IntCoord3D)arrayList.remove(0);
            int n4 = intCoord3D2.x + intCoord3D2.y * n;
            if (sArray[intCoord3D2.z][n4] != s2) continue;
            sArray[intCoord3D2.z][n4] = s;
            if (intCoord3D2.x > 0 && sArray[intCoord3D2.z][n4 - 1] == s2) {
                arrayList.add(new IntCoord3D(intCoord3D2.x - 1, intCoord3D2.y, intCoord3D2.z));
            }
            if (intCoord3D2.x < n - 1 && sArray[intCoord3D2.z][n4 + 1] == s2) {
                arrayList.add(new IntCoord3D(intCoord3D2.x + 1, intCoord3D2.y, intCoord3D2.z));
            }
            if (intCoord3D2.y > 0 && sArray[intCoord3D2.z][n4 - n] == s2) {
                arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y - 1, intCoord3D2.z));
            }
            if (intCoord3D2.y < n2 - 1 && sArray[intCoord3D2.z][n4 + n] == s2) {
                arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y + 1, intCoord3D2.z));
            }
            if (intCoord3D2.z > 0 && sArray[intCoord3D2.z - 1][n4] == s2) {
                arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y, intCoord3D2.z - 1));
            }
            if (intCoord3D2.z >= n3 - 1 || sArray[intCoord3D2.z + 1][n4] != s2) continue;
            arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y, intCoord3D2.z + 1));
        }
    }

    private static void flood3DByte6(ImageByte imageByte, IntCoord3D intCoord3D, byte by) {
        byte[][] byArray = imageByte.pixels;
        int n = imageByte.sizeX;
        int n2 = imageByte.sizeY;
        int n3 = imageByte.sizeZ;
        short s = byArray[intCoord3D.z][intCoord3D.x + intCoord3D.y * n];
        ArrayList<IntCoord3D> arrayList = new ArrayList<IntCoord3D>();
        arrayList.add(intCoord3D);
        while (!arrayList.isEmpty()) {
            IntCoord3D intCoord3D2 = (IntCoord3D)arrayList.remove(0);
            int n4 = intCoord3D2.x + intCoord3D2.y * n;
            if (byArray[intCoord3D2.z][n4] != s) continue;
            byArray[intCoord3D2.z][n4] = by;
            if (intCoord3D2.x > 0 && byArray[intCoord3D2.z][n4 - 1] == s) {
                arrayList.add(new IntCoord3D(intCoord3D2.x - 1, intCoord3D2.y, intCoord3D2.z));
            }
            if (intCoord3D2.x < n - 1 && byArray[intCoord3D2.z][n4 + 1] == s) {
                arrayList.add(new IntCoord3D(intCoord3D2.x + 1, intCoord3D2.y, intCoord3D2.z));
            }
            if (intCoord3D2.y > 0 && byArray[intCoord3D2.z][n4 - n] == s) {
                arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y - 1, intCoord3D2.z));
            }
            if (intCoord3D2.y < n2 - 1 && byArray[intCoord3D2.z][n4 + n] == s) {
                arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y + 1, intCoord3D2.z));
            }
            if (intCoord3D2.z > 0 && byArray[intCoord3D2.z - 1][n4] == s) {
                arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y, intCoord3D2.z - 1));
            }
            if (intCoord3D2.z >= n3 - 1 || byArray[intCoord3D2.z + 1][n4] != s) continue;
            arrayList.add(new IntCoord3D(intCoord3D2.x, intCoord3D2.y, intCoord3D2.z + 1));
        }
    }

    private static void flood3DShort26(ImageShort imageShort, IntCoord3D intCoord3D, short s) {
        short[][] sArray = imageShort.pixels;
        int n = imageShort.sizeX;
        int n2 = imageShort.sizeY;
        int n3 = imageShort.sizeZ;
        short s2 = sArray[intCoord3D.z][intCoord3D.x + intCoord3D.y * n];
        ArrayList<IntCoord3D> arrayList = new ArrayList<IntCoord3D>();
        arrayList.add(intCoord3D);
        while (!arrayList.isEmpty()) {
            IntCoord3D intCoord3D2 = (IntCoord3D)arrayList.remove(0);
            int n4 = intCoord3D2.x + intCoord3D2.y * n;
            if (sArray[intCoord3D2.z][n4] != s2) continue;
            sArray[intCoord3D2.z][n4] = s;
            for (int i = -1; i < 2; ++i) {
                int n5 = intCoord3D2.z + i;
                if (n5 <= 0 || n5 >= n3 - 1) continue;
                for (int j = -1; j < 2; ++j) {
                    int n6 = intCoord3D2.y + j;
                    if (n6 <= 0 || n6 >= n2 - 1) continue;
                    for (int k = -1; k < 2; ++k) {
                        int n7 = intCoord3D2.x + k;
                        if (n7 <= 0 || n7 >= n - 1 || k == 0 && j == 0 && i == 0 || sArray[n5][n7 + n6 * n] != s2) continue;
                        arrayList.add(new IntCoord3D(n7, n6, n5));
                    }
                }
            }
        }
    }

    private static void flood3DByte26(ImageByte imageByte, IntCoord3D intCoord3D, byte by) {
        byte[][] byArray = imageByte.pixels;
        int n = imageByte.sizeX;
        int n2 = imageByte.sizeY;
        int n3 = imageByte.sizeZ;
        short s = byArray[intCoord3D.z][intCoord3D.x + intCoord3D.y * n];
        ArrayList<IntCoord3D> arrayList = new ArrayList<IntCoord3D>();
        arrayList.add(intCoord3D);
        while (!arrayList.isEmpty()) {
            IntCoord3D intCoord3D2 = (IntCoord3D)arrayList.remove(0);
            int n4 = intCoord3D2.x + intCoord3D2.y * n;
            if (byArray[intCoord3D2.z][n4] != s) continue;
            byArray[intCoord3D2.z][n4] = by;
            for (int i = -1; i < 2; ++i) {
                int n5 = intCoord3D2.z + i;
                if (n5 <= 0 || n5 >= n3 - 1) continue;
                for (int j = -1; j < 2; ++j) {
                    int n6 = intCoord3D2.y + j;
                    if (n6 <= 0 || n6 >= n2 - 1) continue;
                    for (int k = -1; k < 2; ++k) {
                        int n7 = intCoord3D2.x + k;
                        if (n7 <= 0 || n7 >= n - 1 || k == 0 && j == 0 && i == 0 || byArray[n5][n7 + n6 * n] != s) continue;
                        arrayList.add(new IntCoord3D(n7, n6, n5));
                    }
                }
            }
        }
    }
}

