/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class ExponentialPower
extends AbstractContinousDoubleDistribution {
    private static final long serialVersionUID = 1L;
    protected double tau;
    private double s;
    private double sm1;
    private double tau_set = -1.0;
    protected static ExponentialPower shared = new ExponentialPower(1.0, ExponentialPower.makeDefaultGenerator());

    public ExponentialPower(double tau, DoubleRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(tau);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.tau);
    }

    public double nextDouble(double tau) {
        double u;
        double x;
        double v;
        if (tau != this.tau_set) {
            this.s = 1.0 / tau;
            this.sm1 = 1.0 - this.s;
            this.tau_set = tau;
        }
        do {
            u = this.randomGenerator.raw();
            u = 2.0 * u - 1.0;
            double u1 = Math.abs(u);
            v = this.randomGenerator.raw();
            if (u1 <= this.sm1) {
                x = u1;
                continue;
            }
            double y = tau * (1.0 - u1);
            x = this.sm1 - this.s * Math.log(y);
            v *= y;
        } while (Math.log(v) > -Math.exp(Math.log(x) * tau));
        if (u < 0.0) {
            return x;
        }
        return -x;
    }

    public void setState(double tau) {
        if (tau < 1.0) {
            throw new IllegalArgumentException();
        }
        this.tau = tau;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double tau) {
        ExponentialPower exponentialPower = shared;
        synchronized (exponentialPower) {
            return shared.nextDouble(tau);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.tau + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine randomGenerator) {
        ExponentialPower exponentialPower = shared;
        synchronized (exponentialPower) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

