/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;

class ExactFloatQuantileFinder
extends PersistentObject
implements FloatQuantileFinder {
    private static final long serialVersionUID = 1L;
    protected FloatArrayList buffer = new FloatArrayList(0);
    protected boolean isSorted;

    public ExactFloatQuantileFinder() {
        this.clear();
    }

    @Override
    public void add(float value) {
        this.buffer.add(value);
        this.isSorted = false;
    }

    @Override
    public void addAllOf(FloatArrayList values) {
        this.addAllOfFromTo(values, 0, values.size() - 1);
    }

    @Override
    public void addAllOfFromTo(FloatArrayList values, int from, int to) {
        this.buffer.addAllOfFromTo(values, from, to);
        this.isSorted = false;
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.buffer.trimToSize();
        this.isSorted = false;
    }

    @Override
    public Object clone() {
        ExactFloatQuantileFinder copy = (ExactFloatQuantileFinder)super.clone();
        if (this.buffer != null) {
            copy.buffer = copy.buffer.copy();
        }
        return copy;
    }

    public boolean contains(float element) {
        this.sort();
        return this.buffer.binarySearch(element) >= 0;
    }

    @Override
    public boolean forEach(FloatProcedure procedure) {
        float[] theElements = this.buffer.elements();
        int theSize = (int)this.size();
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long memory() {
        return this.buffer.elements().length;
    }

    @Override
    public float phi(float element) {
        this.sort();
        return FloatDescriptive.rankInterpolated(this.buffer, element) / (float)this.size();
    }

    @Override
    public FloatArrayList quantileElements(FloatArrayList phis) {
        this.sort();
        return FloatDescriptive.quantiles(this.buffer, phis);
    }

    @Override
    public long size() {
        return this.buffer.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.buffer.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        return String.valueOf(s) + "(mem=" + this.memory() + ", size=" + this.size() + ")";
    }

    @Override
    public long totalMemory() {
        return this.memory();
    }
}

