/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import java.util.Collections;
import java.util.List;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class MultiSelectorFilter
implements CrawlableDatasetFilter {
    private List<Selector> selectorGroup;

    public MultiSelectorFilter(List<Selector> selectorGroup) {
        if (selectorGroup == null) {
            throw new IllegalArgumentException("Selector group parameter must not be null.");
        }
        this.selectorGroup = selectorGroup;
    }

    public MultiSelectorFilter(Selector selector) {
        this.selectorGroup = selector == null ? Collections.emptyList() : Collections.singletonList(selector);
    }

    @Override
    public Object getConfigObject() {
        return this.selectorGroup;
    }

    @Override
    public boolean accept(CrawlableDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset parameter must not be null.");
        }
        if (this.selectorGroup.isEmpty()) {
            return true;
        }
        boolean accept = false;
        boolean doAnyIncludersApply = false;
        boolean doAnySelectorsApply = false;
        for (Selector curSelector : this.selectorGroup) {
            if (!curSelector.isApplicable(dataset)) continue;
            doAnySelectorsApply = true;
            if (curSelector.isIncluder()) {
                doAnyIncludersApply = true;
                if (!curSelector.match(dataset)) continue;
                accept = true;
                continue;
            }
            if (!curSelector.match(dataset)) continue;
            return false;
        }
        if (accept) {
            return true;
        }
        if (!doAnySelectorsApply) {
            return true;
        }
        return !doAnyIncludersApply;
    }

    public static class Selector {
        private boolean includer;
        private boolean applyToAtomicDataset;
        private boolean applyToCollectionDataset;
        private CrawlableDatasetFilter filter;

        public Selector(CrawlableDatasetFilter filter, boolean includer, boolean applyToAtomicDataset, boolean applyToCollectionDataset) {
            this.filter = filter;
            this.includer = includer;
            this.applyToAtomicDataset = applyToAtomicDataset;
            this.applyToCollectionDataset = applyToCollectionDataset;
        }

        public CrawlableDatasetFilter getFilter() {
            return this.filter;
        }

        public boolean isApplyToAtomicDataset() {
            return this.applyToAtomicDataset;
        }

        public boolean isApplyToCollectionDataset() {
            return this.applyToCollectionDataset;
        }

        public boolean match(CrawlableDataset dataset) {
            return this.filter.accept(dataset);
        }

        public boolean isApplicable(CrawlableDataset dataset) {
            if (this.applyToAtomicDataset && !dataset.isCollection()) {
                return true;
            }
            return this.applyToCollectionDataset && dataset.isCollection();
        }

        public boolean isIncluder() {
            return this.includer;
        }

        public boolean isExcluder() {
            return !this.includer;
        }
    }
}

