/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.Sound;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;

public class PointSound
extends Sound {
    public static final int ALLOW_POSITION_READ = 32;
    public static final int ALLOW_POSITION_WRITE = 33;
    public static final int ALLOW_DISTANCE_GAIN_READ = 34;
    public static final int ALLOW_DISTANCE_GAIN_WRITE = 35;
    private static final int[] readCapabilities = new int[]{32, 34};

    public PointSound() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public PointSound(MediaContainer mediaContainer, float f, Point3f point3f) {
        super(mediaContainer, f);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(point3f);
    }

    public PointSound(MediaContainer mediaContainer, float f, float f2, float f3, float f4) {
        super(mediaContainer, f);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(f2, f3, f4);
    }

    public PointSound(MediaContainer mediaContainer, float f, int n, boolean bl, boolean bl2, boolean bl3, Bounds bounds, float f2, Point3f point3f, Point2f[] point2fArray) {
        super(mediaContainer, f, n, bl, bl2, bl3, bounds, f2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(point3f);
        ((PointSoundRetained)this.retained).setDistanceGain(point2fArray);
    }

    public PointSound(MediaContainer mediaContainer, float f, int n, boolean bl, boolean bl2, boolean bl3, Bounds bounds, float f2, float f3, float f4, float f5, Point2f[] point2fArray) {
        super(mediaContainer, f, n, bl, bl2, bl3, bounds, f2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(f3, f4, f5);
        ((PointSoundRetained)this.retained).setDistanceGain(point2fArray);
    }

    public PointSound(MediaContainer mediaContainer, float f, int n, boolean bl, boolean bl2, boolean bl3, Bounds bounds, float f2, Point3f point3f, float[] fArray, float[] fArray2) {
        super(mediaContainer, f, n, bl, bl2, bl3, bounds, f2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(point3f);
        ((PointSoundRetained)this.retained).setDistanceGain(fArray, fArray2);
    }

    public PointSound(MediaContainer mediaContainer, float f, int n, boolean bl, boolean bl2, boolean bl3, Bounds bounds, float f2, float f3, float f4, float f5, float[] fArray, float[] fArray2) {
        super(mediaContainer, f, n, bl, bl2, bl3, bounds, f2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointSoundRetained)this.retained).setPosition(f3, f4, f5);
        ((PointSoundRetained)this.retained).setDistanceGain(fArray, fArray2);
    }

    void createRetained() {
        this.retained = new PointSoundRetained();
        this.retained.setSource(this);
    }

    public void setPosition(Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(33)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound0"));
        }
        ((PointSoundRetained)this.retained).setPosition(point3f);
    }

    public void setPosition(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(33)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound0"));
        }
        ((PointSoundRetained)this.retained).setPosition(f, f2, f3);
    }

    public void getPosition(Point3f point3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(32)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound2"));
        }
        ((PointSoundRetained)this.retained).getPosition(point3f);
    }

    public void setDistanceGain(Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound3"));
        }
        ((PointSoundRetained)this.retained).setDistanceGain(point2fArray);
    }

    public void setDistanceGain(float[] fArray, float[] fArray2) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound3"));
        }
        ((PointSoundRetained)this.retained).setDistanceGain(fArray, fArray2);
    }

    public int getDistanceGainLength() {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound4"));
        }
        return ((PointSoundRetained)this.retained).getDistanceGainLength();
    }

    public void getDistanceGain(Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound4"));
        }
        ((PointSoundRetained)this.retained).getDistanceGain(point2fArray);
    }

    public void getDistanceGain(float[] fArray, float[] fArray2) {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointSound4"));
        }
        ((PointSoundRetained)this.retained).getDistanceGain(fArray, fArray2);
    }

    public Node cloneNode(boolean bl) {
        PointSound pointSound = new PointSound();
        pointSound.duplicateNode(this, bl);
        return pointSound;
    }

    public void duplicateNode(Node node, boolean bl) {
        this.checkDuplicateNode(node, bl);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PointSoundRetained pointSoundRetained = (PointSoundRetained)node.retained;
        PointSoundRetained pointSoundRetained2 = (PointSoundRetained)this.retained;
        Point3f point3f = new Point3f();
        pointSoundRetained.getPosition(point3f);
        pointSoundRetained2.setPosition(point3f);
        int n = pointSoundRetained.getDistanceGainLength();
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        pointSoundRetained.getDistanceGain(fArray, fArray2);
        pointSoundRetained2.setDistanceGain(fArray, fArray2);
    }
}

