/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import java.io.PrintStream;
import mitiv.exception.NonConformableArrayException;

public class ArrayOps {
    protected ArrayOps() {
    }

    public static void main(String[] args) {
        int n = 200;
        double[] a = new double[n];
        double[] b = new double[n];
        double[] c = new double[n];
        int i = 0;
        while (i < n) {
            a[i] = 3.0 * (double)i - 10.0;
            b[i] = 50.0 - 7.0 * (double)i;
            c[i] = 4.0 * (double)i - 110.0;
            ++i;
        }
        try {
            System.out.println("dot(a,b) = " + ArrayOps.dot(a, b));
            System.out.println("dot(a,b,c) = " + ArrayOps.dot(a, b, c));
        }
        catch (Exception e) {
            System.err.println("error: " + e);
        }
    }

    public static final int getLength(byte[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(short[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(int[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(long[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(float[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(double[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getNonZeroLength(float[] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getNonZeroLength(double[] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(float[] x, float[] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] x, double[] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[] w, float[] x, float[] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] w, double[] x, double[] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] w, double[] x, double[] y, double[] z) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n || ArrayOps.getLength(z) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[] w, float[] x, float[] y, float[] z) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n || ArrayOps.getLength(z) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][] x, double[][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(double[][] w, double[][] x, double[][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(float[][] x, float[][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(float[][] w, float[][] x, float[][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(double[][][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(float[][][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][][] x, double[][][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(float[][][] x, float[][][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(double[][][] w, double[][][] x, double[][][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(float[][][] w, float[][][] x, float[][][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final float getMin(float[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        float xmin = x[0];
        int i = 1;
        while (i < n) {
            float xval = x[i];
            if (xval < xmin) {
                xmin = xval;
            }
            ++i;
        }
        return xmin;
    }

    public static final float getMax(float[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        float xmax = x[0];
        int i = 1;
        while (i < n) {
            float xval = x[i];
            if (xval > xmax) {
                xmax = xval;
            }
            ++i;
        }
        return xmax;
    }

    public static final float[] getMinMax(float[] x) {
        return ArrayOps.getMinMax(x, new float[2]);
    }

    public static final float[] getMinMax(float[] x, float[] minMax) {
        if (minMax == null || minMax.length < 2) {
            throw new IllegalArgumentException("Invalid storage for min/max value.");
        }
        int n = ArrayOps.getNonZeroLength(x);
        float xmin = x[0];
        float xmax = x[0];
        int i = 1;
        while (i < n) {
            float xval = x[i];
            if (xval < xmin) {
                xmin = xval;
            }
            if (xval > xmax) {
                xmax = xval;
            }
            ++i;
        }
        minMax[0] = xmin;
        minMax[1] = xmax;
        return minMax;
    }

    public static final double getMin(double[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        double xmin = x[0];
        int i = 1;
        while (i < n) {
            double xval = x[i];
            if (xval < xmin) {
                xmin = xval;
            }
            ++i;
        }
        return xmin;
    }

    public static final double getMax(double[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        double xmax = x[0];
        int i = 1;
        while (i < n) {
            double xval = x[i];
            if (xval > xmax) {
                xmax = xval;
            }
            ++i;
        }
        return xmax;
    }

    public static final double[] getMinMax(double[] x) {
        return ArrayOps.getMinMax(x, new double[2]);
    }

    public static final double[] getMinMax(double[] x, double[] minMax) {
        if (minMax == null || minMax.length < 2) {
            throw new IllegalArgumentException("Invalid storage for min/max value.");
        }
        int n = ArrayOps.getNonZeroLength(x);
        double xmin = x[0];
        double xmax = x[0];
        int i = 1;
        while (i < n) {
            double xval = x[i];
            if (xval < xmin) {
                xmin = xval;
            }
            if (xval > xmax) {
                xmax = xval;
            }
            ++i;
        }
        minMax[0] = xmin;
        minMax[1] = xmax;
        return minMax;
    }

    public static final float sum(float[] x) {
        float s = 0.0f;
        int n = ArrayOps.getLength(x);
        int i = 1;
        while (i < n) {
            s += x[i];
            ++i;
        }
        return s;
    }

    public static final float sum(float[][] x) {
        float s = 0.0f;
        int n = ArrayOps.getLength(x);
        int i = 1;
        while (i < n) {
            s += ArrayOps.sum(x[i]);
            ++i;
        }
        return s;
    }

    public static final float sum(float[][][] x) {
        float s = 0.0f;
        int n = ArrayOps.getLength(x);
        int i = 1;
        while (i < n) {
            s += ArrayOps.sum(x[i]);
            ++i;
        }
        return s;
    }

    public static final double sum(double[] x) {
        double s = 0.0;
        int n = ArrayOps.getLength(x);
        int i = 1;
        while (i < n) {
            s += x[i];
            ++i;
        }
        return s;
    }

    public static final double sum(double[][] x) {
        double s = 0.0;
        int n = ArrayOps.getLength(x);
        int i = 1;
        while (i < n) {
            s += ArrayOps.sum(x[i]);
            ++i;
        }
        return s;
    }

    public static final double sum(double[][][] x) {
        double s = 0.0;
        int n = ArrayOps.getLength(x);
        int i = 1;
        while (i < n) {
            s += ArrayOps.sum(x[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(int n, double[] x, double[] y) {
        double result = 0.0;
        int i = 0;
        while (i < n) {
            result += x[i] * y[i];
            ++i;
        }
        return result;
    }

    public static final double dot(int n, float[] x, float[] y) {
        float result = 0.0f;
        int i = 0;
        while (i < n) {
            result += x[i] * y[i];
            ++i;
        }
        return result;
    }

    public static final double dot(int n, double[] w, double[] x, double[] y) {
        double result = 0.0;
        int i = 0;
        while (i < n) {
            result += w[i] * x[i] * y[i];
            ++i;
        }
        return result;
    }

    public static final double dot(int n, float[] w, float[] x, float[] y) {
        float result = 0.0f;
        int i = 0;
        while (i < n) {
            result += w[i] * x[i] * y[i];
            ++i;
        }
        return result;
    }

    public static final double dot(double[] x, double[] y) {
        return ArrayOps.dot(ArrayOps.getLength(x, y), x, y);
    }

    public static final double dot(float[] x, float[] y) {
        return ArrayOps.dot(ArrayOps.getLength(x, y), x, y);
    }

    public static final double dot(double[] w, double[] x, double[] y) {
        return ArrayOps.dot(ArrayOps.getLength(w, x, y), w, x, y);
    }

    public static final double dot(float[] w, float[] x, float[] y) {
        return ArrayOps.dot(ArrayOps.getLength(w, x, y), w, x, y);
    }

    public static final double dot(double[][] x, double[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(float[][] x, float[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(double[][] w, double[][] x, double[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(float[][] w, float[][] x, float[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(double[][][] x, double[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(float[][][] x, float[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(double[][][] w, double[][][] x, double[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static final double dot(float[][][] w, float[][][] x, float[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        int i = 0;
        while (i < n) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
            ++i;
        }
        return s;
    }

    public static double norm2(double[] x) {
        double s = 0.0;
        int n = x.length;
        int i = 0;
        while (i < n) {
            s += x[i] * x[i];
            ++i;
        }
        return Math.sqrt(s);
    }

    public static double norm1(double[] x) {
        double s = 0.0;
        int n = x.length;
        int i = 0;
        while (i < n) {
            s += Math.abs(x[i]);
            ++i;
        }
        return s;
    }

    public static double normInf(double[] x) {
        double s = 0.0;
        int n = x.length;
        int i = 0;
        while (i < n) {
            double r = Math.abs(x[i]);
            if (r > s) {
                s = r;
            }
            ++i;
        }
        return s;
    }

    public static float norm2(float[] x) {
        float s = 0.0f;
        int n = x.length;
        int i = 0;
        while (i < n) {
            s += x[i] * x[i];
            ++i;
        }
        return (float)Math.sqrt(s);
    }

    public static double norm1(float[] x) {
        float s = 0.0f;
        int n = x.length;
        int i = 0;
        while (i < n) {
            s += Math.abs(x[i]);
            ++i;
        }
        return s;
    }

    public static float normInf(float[] x) {
        float s = 0.0f;
        int n = x.length;
        int i = 0;
        while (i < n) {
            float r = Math.abs(x[i]);
            if (r > s) {
                s = r;
            }
            ++i;
        }
        return s;
    }

    public static void zero(int n, double[] x) {
        ArrayOps.fill(n, x, 0.0);
    }

    public static void zero(int n, float[] x) {
        ArrayOps.fill(n, x, 0.0);
    }

    public static void zero(double[] x) {
        ArrayOps.zero(x.length, x);
    }

    public static void zero(float[] x) {
        ArrayOps.zero(x.length, x);
    }

    public static void zero(double[][] x) {
        int n = x.length;
        int i = 0;
        while (i < n) {
            ArrayOps.zero(x[i]);
            ++i;
        }
    }

    public static void zero(float[][] x) {
        int n = x.length;
        int i = 0;
        while (i < n) {
            ArrayOps.zero(x[i]);
            ++i;
        }
    }

    public static void zero(double[][][] x) {
        int n = x.length;
        int i = 0;
        while (i < n) {
            ArrayOps.zero(x[i]);
            ++i;
        }
    }

    public static void zero(float[][][] x) {
        int n = x.length;
        int i = 0;
        while (i < n) {
            ArrayOps.zero(x[i]);
            ++i;
        }
    }

    public static void copy(int n, double[] src, double[] dst) {
        int i = 0;
        while (i < n) {
            dst[i] = src[i];
            ++i;
        }
    }

    public static void copy(int n, float[] src, float[] dst) {
        int i = 0;
        while (i < n) {
            dst[i] = src[i];
            ++i;
        }
    }

    public static void copy(double[] src, double[] dst) {
        ArrayOps.copy(ArrayOps.getLength(src, dst), src, dst);
    }

    public static void copy(float[] src, float[] dst) {
        ArrayOps.copy(ArrayOps.getLength(src, dst), src, dst);
    }

    public static void copy(double[][] src, double[][] dst) {
        int n = ArrayOps.getLength(src, dst);
        int i = 0;
        while (i < n) {
            ArrayOps.copy(src[i], dst[i]);
            ++i;
        }
    }

    public static void copy(float[][] src, float[][] dst) {
        int n = ArrayOps.getLength(src, dst);
        int i = 0;
        while (i < n) {
            ArrayOps.copy(src[i], dst[i]);
            ++i;
        }
    }

    public static void fill(int n, double[] x, double alpha) {
        int i = 0;
        while (i < n) {
            x[i] = alpha;
            ++i;
        }
    }

    public static void fill(int n, float[] x, double alpha) {
        float a = (float)alpha;
        int i = 0;
        while (i < n) {
            x[i] = a;
            ++i;
        }
    }

    public static void axpby(int n, double alpha, double[] x, double beta, double[] y) {
        block37: {
            block35: {
                block38: {
                    block36: {
                        if (beta != 1.0) break block35;
                        if (alpha != 1.0) break block36;
                        int i = 0;
                        while (i < n) {
                            int n2 = i;
                            y[n2] = y[n2] + x[i];
                            ++i;
                        }
                        break block37;
                    }
                    if (alpha != -1.0) break block38;
                    int i = 0;
                    while (i < n) {
                        int n3 = i;
                        y[n3] = y[n3] - x[i];
                        ++i;
                    }
                    break block37;
                }
                if (alpha == 0.0) break block37;
                int i = 0;
                while (i < n) {
                    int n4 = i;
                    y[n4] = y[n4] + alpha * x[i];
                    ++i;
                }
                break block37;
            }
            if (beta == 0.0) {
                if (alpha == 1.0) {
                    ArrayOps.copy(n, x, y);
                } else if (alpha == 0.0) {
                    ArrayOps.zero(n, y);
                } else if (alpha == -1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = -x[i];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        y[i] = alpha * x[i];
                        ++i;
                    }
                }
            } else if (beta == -1.0) {
                if (alpha == 1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = x[i] - y[i];
                        ++i;
                    }
                } else if (alpha == 0.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = -y[i];
                        ++i;
                    }
                } else if (alpha == -1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = -x[i] - y[i];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        y[i] = alpha * x[i] - y[i];
                        ++i;
                    }
                }
            } else if (alpha == 1.0) {
                int i = 0;
                while (i < n) {
                    y[i] = x[i] + beta * y[i];
                    ++i;
                }
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    y[i] = beta * y[i] - x[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                int i = 0;
                while (i < n) {
                    int n5 = i++;
                    y[n5] = y[n5] * beta;
                }
            } else {
                int i = 0;
                while (i < n) {
                    y[i] = alpha * x[i] + beta * y[i];
                    ++i;
                }
            }
        }
    }

    public static void axpby(int n, double alpha, double[] x, double beta, double[] y, double[] dst) {
        if (beta == 1.0) {
            if (alpha == 1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = y[i] + x[i];
                    ++i;
                }
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = y[i] - x[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                int i = 0;
                while (i < n) {
                    ArrayOps.copy(n, y, dst);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < n) {
                    dst[i] = alpha * x[i] + y[i];
                    ++i;
                }
            }
        } else if (beta == -1.0) {
            if (alpha == 1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = x[i] - y[i];
                    ++i;
                }
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = -x[i] - y[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = -y[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < n) {
                    dst[i] = alpha * x[i] - y[i];
                    ++i;
                }
            }
        } else if (beta == 0.0) {
            if (alpha == 1.0) {
                ArrayOps.copy(n, x, dst);
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = -x[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                ArrayOps.zero(n, dst);
            } else {
                int i = 0;
                while (i < n) {
                    dst[i] = alpha * x[i];
                    ++i;
                }
            }
        } else if (alpha == 1.0) {
            int i = 0;
            while (i < n) {
                dst[i] = x[i] + beta * y[i];
                ++i;
            }
        } else if (alpha == -1.0) {
            int i = 0;
            while (i < n) {
                dst[i] = beta * y[i] - x[i];
                ++i;
            }
        } else if (alpha == 0.0) {
            int i = 0;
            while (i < n) {
                dst[i] = beta * y[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                dst[i] = alpha * x[i] + beta * y[i];
                ++i;
            }
        }
    }

    public static void axpby(double alpha, double[] x, double beta, double[] y) {
        ArrayOps.axpby(ArrayOps.getLength(x, y), alpha, x, beta, y);
    }

    public static void axpby(double alpha, double[] x, double beta, double[] y, double[] dst) {
        ArrayOps.axpby(ArrayOps.getLength(x, y, dst), alpha, x, beta, y, dst);
    }

    public static void axpby(int n, double alpha, float[] x, double beta, float[] y) {
        block37: {
            block35: {
                block38: {
                    block36: {
                        if (beta != 1.0) break block35;
                        if (alpha != 1.0) break block36;
                        int i = 0;
                        while (i < n) {
                            int n2 = i;
                            y[n2] = y[n2] + x[i];
                            ++i;
                        }
                        break block37;
                    }
                    if (alpha != -1.0) break block38;
                    int i = 0;
                    while (i < n) {
                        int n3 = i;
                        y[n3] = y[n3] - x[i];
                        ++i;
                    }
                    break block37;
                }
                if (alpha == 0.0) break block37;
                float a = (float)alpha;
                int i = 0;
                while (i < n) {
                    int n4 = i;
                    y[n4] = y[n4] + a * x[i];
                    ++i;
                }
                break block37;
            }
            if (beta == 0.0) {
                if (alpha == 1.0) {
                    ArrayOps.copy(n, x, y);
                } else if (alpha == 0.0) {
                    ArrayOps.zero(n, y);
                } else if (alpha == -1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = -x[i];
                        ++i;
                    }
                } else {
                    float a = (float)alpha;
                    int i = 0;
                    while (i < n) {
                        y[i] = a * x[i];
                        ++i;
                    }
                }
            } else if (beta == -1.0) {
                if (alpha == 1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = x[i] - y[i];
                        ++i;
                    }
                } else if (alpha == 0.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = -y[i];
                        ++i;
                    }
                } else if (alpha == -1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = -x[i] - y[i];
                        ++i;
                    }
                } else {
                    float a = (float)alpha;
                    int i = 0;
                    while (i < n) {
                        y[i] = a * x[i] - y[i];
                        ++i;
                    }
                }
            } else {
                float b = (float)beta;
                if (alpha == 1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = x[i] + b * y[i];
                        ++i;
                    }
                } else if (alpha == -1.0) {
                    int i = 0;
                    while (i < n) {
                        y[i] = b * y[i] - x[i];
                        ++i;
                    }
                } else if (alpha == 0.0) {
                    int i = 0;
                    while (i < n) {
                        int n5 = i++;
                        y[n5] = y[n5] * b;
                    }
                } else {
                    float a = (float)alpha;
                    int i = 0;
                    while (i < n) {
                        y[i] = a * x[i] + b * y[i];
                        ++i;
                    }
                }
            }
        }
    }

    public static void axpby(int n, double alpha, float[] x, double beta, float[] y, float[] dst) {
        if (beta == 1.0) {
            if (alpha == 1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = y[i] + x[i];
                    ++i;
                }
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = y[i] - x[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                int i = 0;
                while (i < n) {
                    ArrayOps.copy(n, y, dst);
                    ++i;
                }
            } else {
                float a = (float)alpha;
                int i = 0;
                while (i < n) {
                    dst[i] = a * x[i] + y[i];
                    ++i;
                }
            }
        } else if (beta == -1.0) {
            if (alpha == 1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = x[i] - y[i];
                    ++i;
                }
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = -x[i] - y[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = -y[i];
                    ++i;
                }
            } else {
                float a = (float)alpha;
                int i = 0;
                while (i < n) {
                    dst[i] = a * x[i] - y[i];
                    ++i;
                }
            }
        } else if (beta == 0.0) {
            if (alpha == 1.0) {
                ArrayOps.copy(n, x, dst);
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = -x[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                ArrayOps.zero(n, dst);
            } else {
                float a = (float)alpha;
                int i = 0;
                while (i < n) {
                    dst[i] = a * x[i];
                    ++i;
                }
            }
        } else {
            float b = (float)beta;
            if (alpha == 1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = x[i] + b * y[i];
                    ++i;
                }
            } else if (alpha == -1.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = b * y[i] - x[i];
                    ++i;
                }
            } else if (alpha == 0.0) {
                int i = 0;
                while (i < n) {
                    dst[i] = b * y[i];
                    ++i;
                }
            } else {
                float a = (float)alpha;
                int i = 0;
                while (i < n) {
                    dst[i] = a * x[i] + b * y[i];
                    ++i;
                }
            }
        }
    }

    public static void axpby(double alpha, float[] x, double beta, float[] y) {
        ArrayOps.axpby(ArrayOps.getLength(x, y), alpha, x, beta, y);
    }

    public static void axpby(double alpha, float[] x, double beta, float[] y, float[] dst) {
        ArrayOps.axpby(ArrayOps.getLength(x, y, dst), alpha, x, beta, y, dst);
    }

    public static void axpbypcz(int n, double alpha, double[] x, double beta, double[] y, double gamma, double[] z, double[] dst) {
        if (alpha == 0.0) {
            ArrayOps.axpby(beta, y, gamma, z, dst);
        } else if (beta == 0.0) {
            ArrayOps.axpby(alpha, x, gamma, z, dst);
        } else if (gamma == 0.0) {
            ArrayOps.axpby(alpha, x, beta, y, dst);
        } else {
            int i = 0;
            while (i < n) {
                dst[i] = alpha * x[i] + beta * y[i] + gamma * z[i];
                ++i;
            }
        }
    }

    public static void axpbypcz(double alpha, double[] x, double beta, double[] y, double gamma, double[] z, double[] dst) {
        ArrayOps.axpbypcz(ArrayOps.getLength(x, y, z, dst), alpha, x, beta, y, gamma, z, dst);
    }

    public static void axpbypcz(int n, double alpha, float[] x, double beta, float[] y, double gamma, float[] z, float[] dst) {
        if (alpha == 0.0) {
            ArrayOps.axpby(beta, y, gamma, z, dst);
        } else if (beta == 0.0) {
            ArrayOps.axpby(alpha, x, gamma, z, dst);
        } else if (gamma == 0.0) {
            ArrayOps.axpby(alpha, x, beta, y, dst);
        } else {
            float a = (float)alpha;
            float b = (float)beta;
            float c = (float)gamma;
            int i = 0;
            while (i < n) {
                dst[i] = a * x[i] + b * y[i] + c * z[i];
                ++i;
            }
        }
    }

    public static void axpbypcz(float alpha, float[] x, float beta, float[] y, float gamma, float[] z, float[] dst) {
        ArrayOps.axpbypcz(ArrayOps.getLength(x, y, z, dst), (double)alpha, x, (double)beta, y, (double)gamma, z, dst);
    }

    public static double dot(Object x, Object y) {
        return 0.0;
    }

    public static double dot(Object w, Object x, Object y) {
        return 0.0;
    }

    public static void printArray(Object obj) {
        ArrayOps.printArray(obj, System.out, true);
    }

    public static void printArray(Object obj, boolean newline) {
        ArrayOps.printArray(obj, System.out, newline);
    }

    public static void printArray(Object obj, PrintStream stream) {
        ArrayOps.printArray(obj, stream, true);
    }

    public static void printArray(Object obj, PrintStream stream, boolean newline) {
        if (obj == null) {
            stream.print("null");
        } else {
            String classname = obj.getClass().getName();
            char c0 = classname.charAt(0);
            if (c0 == '[') {
                char c1 = classname.charAt(1);
                if (c1 == 'B') {
                    byte[] arr = (byte[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'S') {
                    short[] arr = (short[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'I') {
                    int[] arr = (int[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'J') {
                    long[] arr = (long[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'F') {
                    float[] arr = (float[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'D') {
                    double[] arr = (double[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'C') {
                    char[] arr = (char[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'Z') {
                    boolean[] arr = (boolean[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        stream.print(String.valueOf(i == 0 ? "{" : ", ") + arr[i]);
                        ++i;
                    }
                    stream.print("}");
                } else if (c1 == 'L') {
                    stream.print(classname.substring(2));
                } else if (c1 == '[') {
                    Object[] arr = (Object[])obj;
                    stream.print("{");
                    int i = 0;
                    while (i < arr.length) {
                        if (i > 0) {
                            stream.print(", ");
                        }
                        ArrayOps.printArray(arr[i], stream, false);
                        ++i;
                    }
                    stream.print("}");
                } else {
                    stream.print("{*unknown*}");
                }
            }
        }
        if (newline) {
            stream.println();
        }
    }
}

