/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.Future;
import org.jtransforms.dct.DoubleDCT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;

public class DoubleDCT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleDCT_1D dctSlices;
    private DoubleDCT_1D dctRows;
    private DoubleDCT_1D dctColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDCT_3D(long l, long l2, long l3) {
        if (l <= 1L || l2 <= 1L || l3 <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)l;
        this.rows = (int)l2;
        this.columns = (int)l3;
        this.slicesl = l;
        this.rowsl = l2;
        this.columnsl = l3;
        this.sliceStride = (int)(l2 * l3);
        this.rowStride = (int)l3;
        this.sliceStridel = l2 * l3;
        this.rowStridel = l3;
        if (l * l2 * l3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2) && ConcurrencyUtils.isPowerOf2(l3)) {
            this.isPowerOfTwo = true;
        }
        long l4 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 * l3 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(Math.min(l2, l3), l));
        }
        this.dctSlices = new DoubleDCT_1D(l);
        this.dctRows = l == l2 ? this.dctSlices : new DoubleDCT_1D(l2);
        this.dctColumns = l == l3 ? this.dctSlices : (l2 == l3 ? this.dctRows : new DoubleDCT_1D(l3));
        ConcurrencyUtils.setLargeArraysBeginN(l4);
    }

    public void forward(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, dArray, bl);
                this.ddxt3db_subth(-1, dArray, bl);
            } else {
                this.ddxt3da_sub(-1, dArray, bl);
                this.ddxt3db_sub(-1, dArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            int n = i * DoubleDCT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleDCT_3D.this.rows; ++j) {
                                DoubleDCT_3D.this.dctColumns.forward(dArray, n + j * DoubleDCT_3D.this.rowStride, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * DoubleDCT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < DoubleDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * DoubleDCT_3D.this.rowStride + j;
                                    dArray2[n32] = dArray[n22];
                                }
                                DoubleDCT_3D.this.dctRows.forward(dArray2, bl);
                                for (n32 = 0; n32 < DoubleDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * DoubleDCT_3D.this.rowStride + j;
                                    dArray[n22] = dArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * DoubleDCT_3D.this.rowStride;
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < DoubleDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * DoubleDCT_3D.this.sliceStride + n + j;
                                    dArray2[n32] = dArray[n22];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(dArray2, bl);
                                for (n32 = 0; n32 < DoubleDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * DoubleDCT_3D.this.sliceStride + n + j;
                                    dArray[n22] = dArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            for (int i = 0; i < this.slices; ++i) {
                n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.forward(dArray, n10 + n9 * this.rowStride, bl);
                }
            }
            double[] dArray2 = new double[this.rows];
            for (n10 = 0; n10 < this.slices; ++n10) {
                n9 = n10 * this.sliceStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        dArray2[n7] = dArray[n6];
                    }
                    this.dctRows.forward(dArray2, bl);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        dArray[n6] = dArray2[n7];
                    }
                }
            }
            dArray2 = new double[this.slices];
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = n10 * this.rowStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        dArray2[n7] = dArray[n6];
                    }
                    this.dctSlices.forward(dArray2, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        dArray[n6] = dArray2[n7];
                    }
                }
            }
        }
    }

    public void forward(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, doubleLargeArray, bl);
                this.ddxt3db_subth(-1, doubleLargeArray, bl);
            } else {
                this.ddxt3da_sub(-1, doubleLargeArray, bl);
                this.ddxt3db_sub(-1, doubleLargeArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
            long l;
            long l2;
            int n2;
            Future[] futureArray = new Future[n];
            long l3 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l2; i < l; ++i) {
                            long l3 = i * DoubleDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < DoubleDCT_3D.this.rowsl; ++j) {
                                DoubleDCT_3D.this.dctColumns.forward(doubleLargeArray, l3 + j * DoubleDCT_3D.this.rowStridel, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDCT_3D.this.rowsl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * DoubleDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < DoubleDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * DoubleDCT_3D.this.rowStridel + j;
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                }
                                DoubleDCT_3D.this.dctRows.forward(doubleLargeArray2, bl);
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * DoubleDCT_3D.this.rowStridel + j;
                                    doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l3 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.rowsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDCT_3D.this.slicesl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * DoubleDCT_3D.this.rowStridel;
                            for (long j = 0L; j < DoubleDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * DoubleDCT_3D.this.sliceStridel + l4 + j;
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                }
                                DoubleDCT_3D.this.dctSlices.forward(doubleLargeArray2, bl);
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * DoubleDCT_3D.this.sliceStridel + l4 + j;
                                    doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l;
            long l4;
            long l5;
            long l6;
            long l7;
            for (long i = 0L; i < this.slicesl; ++i) {
                long l8 = i * this.sliceStridel;
                for (long j = 0L; j < this.rowsl; ++j) {
                    this.dctColumns.forward(doubleLargeArray, l8 + j * this.rowStridel, bl);
                }
            }
            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.rowsl, false);
            for (l7 = 0L; l7 < this.slicesl; ++l7) {
                l6 = l7 * this.sliceStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                    }
                    this.dctRows.forward(doubleLargeArray2, bl);
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                    }
                }
            }
            doubleLargeArray2 = new DoubleLargeArray(this.slicesl, false);
            for (l7 = 0L; l7 < this.rowsl; ++l7) {
                l6 = l7 * this.rowStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                    }
                    this.dctSlices.forward(doubleLargeArray2, bl);
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                    }
                }
            }
        }
    }

    public void forward(final double[][][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, dArray, bl);
                this.ddxt3db_subth(-1, dArray, bl);
            } else {
                this.ddxt3da_sub(-1, dArray, bl);
                this.ddxt3db_sub(-1, dArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < DoubleDCT_3D.this.rows; ++j) {
                                DoubleDCT_3D.this.dctColumns.forward(dArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < DoubleDCT_3D.this.rows; ++n) {
                                    dArray2[n] = dArray[i][n][j];
                                }
                                DoubleDCT_3D.this.dctRows.forward(dArray2, bl);
                                for (n = 0; n < DoubleDCT_3D.this.rows; ++n) {
                                    dArray[i][n][j] = dArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < DoubleDCT_3D.this.slices; ++n) {
                                    dArray2[n] = dArray[n][i][j];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(dArray2, bl);
                                for (n = 0; n < DoubleDCT_3D.this.slices; ++n) {
                                    dArray[n][i][j] = dArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            for (int i = 0; i < this.slices; ++i) {
                for (n8 = 0; n8 < this.rows; ++n8) {
                    this.dctColumns.forward(dArray[i][n8], bl);
                }
            }
            double[] dArray2 = new double[this.rows];
            for (n8 = 0; n8 < this.slices; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray2[n6] = dArray[n8][n6][n7];
                    }
                    this.dctRows.forward(dArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray[n8][n6][n7] = dArray2[n6];
                    }
                }
            }
            dArray2 = new double[this.slices];
            for (n8 = 0; n8 < this.rows; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        dArray2[n6] = dArray[n6][n8][n7];
                    }
                    this.dctSlices.forward(dArray2, bl);
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        dArray[n6][n8][n7] = dArray2[n6];
                    }
                }
            }
        }
    }

    public void inverse(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, dArray, bl);
                this.ddxt3db_subth(1, dArray, bl);
            } else {
                this.ddxt3da_sub(1, dArray, bl);
                this.ddxt3db_sub(1, dArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            int n = i * DoubleDCT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleDCT_3D.this.rows; ++j) {
                                DoubleDCT_3D.this.dctColumns.inverse(dArray, n + j * DoubleDCT_3D.this.rowStride, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * DoubleDCT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < DoubleDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * DoubleDCT_3D.this.rowStride + j;
                                    dArray2[n32] = dArray[n22];
                                }
                                DoubleDCT_3D.this.dctRows.inverse(dArray2, bl);
                                for (n32 = 0; n32 < DoubleDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * DoubleDCT_3D.this.rowStride + j;
                                    dArray[n22] = dArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * DoubleDCT_3D.this.rowStride;
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < DoubleDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * DoubleDCT_3D.this.sliceStride + n + j;
                                    dArray2[n32] = dArray[n22];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(dArray2, bl);
                                for (n32 = 0; n32 < DoubleDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * DoubleDCT_3D.this.sliceStride + n + j;
                                    dArray[n22] = dArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            for (int i = 0; i < this.slices; ++i) {
                n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.inverse(dArray, n10 + n9 * this.rowStride, bl);
                }
            }
            double[] dArray2 = new double[this.rows];
            for (n10 = 0; n10 < this.slices; ++n10) {
                n9 = n10 * this.sliceStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        dArray2[n7] = dArray[n6];
                    }
                    this.dctRows.inverse(dArray2, bl);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        dArray[n6] = dArray2[n7];
                    }
                }
            }
            dArray2 = new double[this.slices];
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = n10 * this.rowStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        dArray2[n7] = dArray[n6];
                    }
                    this.dctSlices.inverse(dArray2, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        dArray[n6] = dArray2[n7];
                    }
                }
            }
        }
    }

    public void inverse(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, doubleLargeArray, bl);
                this.ddxt3db_subth(1, doubleLargeArray, bl);
            } else {
                this.ddxt3da_sub(1, doubleLargeArray, bl);
                this.ddxt3db_sub(1, doubleLargeArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
            long l;
            long l2;
            int n2;
            Future[] futureArray = new Future[n];
            long l3 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l2; i < l; ++i) {
                            long l3 = i * DoubleDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < DoubleDCT_3D.this.rowsl; ++j) {
                                DoubleDCT_3D.this.dctColumns.inverse(doubleLargeArray, l3 + j * DoubleDCT_3D.this.rowStridel, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDCT_3D.this.rowsl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * DoubleDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < DoubleDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * DoubleDCT_3D.this.rowStridel + j;
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                }
                                DoubleDCT_3D.this.dctRows.inverse(doubleLargeArray2, bl);
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * DoubleDCT_3D.this.rowStridel + j;
                                    doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l3 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.rowsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDCT_3D.this.slicesl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * DoubleDCT_3D.this.rowStridel;
                            for (long j = 0L; j < DoubleDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * DoubleDCT_3D.this.sliceStridel + l4 + j;
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l22));
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(doubleLargeArray2, bl);
                                for (l3 = 0L; l3 < DoubleDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * DoubleDCT_3D.this.sliceStridel + l4 + j;
                                    doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l;
            long l4;
            long l5;
            long l6;
            long l7;
            for (long i = 0L; i < this.slicesl; ++i) {
                long l8 = i * this.sliceStridel;
                for (long j = 0L; j < this.rowsl; ++j) {
                    this.dctColumns.inverse(doubleLargeArray, l8 + j * this.rowStridel, bl);
                }
            }
            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.rowsl, false);
            for (l7 = 0L; l7 < this.slicesl; ++l7) {
                l6 = l7 * this.sliceStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                    }
                    this.dctRows.inverse(doubleLargeArray2, bl);
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                    }
                }
            }
            doubleLargeArray2 = new DoubleLargeArray(this.slicesl, false);
            for (l7 = 0L; l7 < this.rowsl; ++l7) {
                l6 = l7 * this.rowStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l));
                    }
                    this.dctSlices.inverse(doubleLargeArray2, bl);
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l4));
                    }
                }
            }
        }
    }

    public void inverse(final double[][][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, dArray, bl);
                this.ddxt3db_subth(1, dArray, bl);
            } else {
                this.ddxt3da_sub(1, dArray, bl);
                this.ddxt3db_sub(1, dArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < DoubleDCT_3D.this.rows; ++j) {
                                DoubleDCT_3D.this.dctColumns.inverse(dArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < DoubleDCT_3D.this.rows; ++n) {
                                    dArray2[n] = dArray[i][n][j];
                                }
                                DoubleDCT_3D.this.dctRows.inverse(dArray2, bl);
                                for (n = 0; n < DoubleDCT_3D.this.rows; ++n) {
                                    dArray[i][n][j] = dArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[DoubleDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < DoubleDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < DoubleDCT_3D.this.slices; ++n) {
                                    dArray2[n] = dArray[n][i][j];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(dArray2, bl);
                                for (n = 0; n < DoubleDCT_3D.this.slices; ++n) {
                                    dArray[n][i][j] = dArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            for (int i = 0; i < this.slices; ++i) {
                for (n8 = 0; n8 < this.rows; ++n8) {
                    this.dctColumns.inverse(dArray[i][n8], bl);
                }
            }
            double[] dArray2 = new double[this.rows];
            for (n8 = 0; n8 < this.slices; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray2[n6] = dArray[n8][n6][n7];
                    }
                    this.dctRows.inverse(dArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray[n8][n6][n7] = dArray2[n6];
                    }
                }
            }
            dArray2 = new double[this.slices];
            for (n8 = 0; n8 < this.rows; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        dArray2[n6] = dArray[n6][n8][n7];
                    }
                    this.dctSlices.inverse(dArray2, bl);
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        dArray[n6][n8][n7] = dArray2[n6];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int n, double[] dArray, boolean bl) {
        int n2 = 4 * this.rows;
        if (this.columns == 2) {
            n2 >>= 1;
        }
        double[] dArray2 = new double[n2];
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5 = i * this.sliceStride;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    this.dctColumns.forward(dArray, n5 + n4 * this.rowStride, bl);
                }
                if (this.columns > 2) {
                    for (n4 = 0; n4 < this.columns; n4 += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n3 = n5 + n7 * this.rowStride + n4;
                            n6 = this.rows + n7;
                            dArray2[n7] = dArray[n3];
                            dArray2[n6] = dArray[n3 + 1];
                            dArray2[n6 + this.rows] = dArray[n3 + 2];
                            dArray2[n6 + 2 * this.rows] = dArray[n3 + 3];
                        }
                        this.dctRows.forward(dArray2, 0, bl);
                        this.dctRows.forward(dArray2, this.rows, bl);
                        this.dctRows.forward(dArray2, 2 * this.rows, bl);
                        this.dctRows.forward(dArray2, 3 * this.rows, bl);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n3 = n5 + n7 * this.rowStride + n4;
                            n6 = this.rows + n7;
                            dArray[n3] = dArray2[n7];
                            dArray[n3 + 1] = dArray2[n6];
                            dArray[n3 + 2] = dArray2[n6 + this.rows];
                            dArray[n3 + 3] = dArray2[n6 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n5 + n4 * this.rowStride;
                    dArray2[n4] = dArray[n3];
                    dArray2[this.rows + n4] = dArray[n3 + 1];
                }
                this.dctRows.forward(dArray2, 0, bl);
                this.dctRows.forward(dArray2, this.rows, bl);
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n5 + n4 * this.rowStride;
                    dArray[n3] = dArray2[n4];
                    dArray[n3 + 1] = dArray2[this.rows + n4];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n8;
                int n9;
                int n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.inverse(dArray, n10 + n9 * this.rowStride, bl);
                }
                if (this.columns > 2) {
                    for (n9 = 0; n9 < this.columns; n9 += 4) {
                        int n11;
                        int n12;
                        for (n12 = 0; n12 < this.rows; ++n12) {
                            n8 = n10 + n12 * this.rowStride + n9;
                            n11 = this.rows + n12;
                            dArray2[n12] = dArray[n8];
                            dArray2[n11] = dArray[n8 + 1];
                            dArray2[n11 + this.rows] = dArray[n8 + 2];
                            dArray2[n11 + 2 * this.rows] = dArray[n8 + 3];
                        }
                        this.dctRows.inverse(dArray2, 0, bl);
                        this.dctRows.inverse(dArray2, this.rows, bl);
                        this.dctRows.inverse(dArray2, 2 * this.rows, bl);
                        this.dctRows.inverse(dArray2, 3 * this.rows, bl);
                        for (n12 = 0; n12 < this.rows; ++n12) {
                            n8 = n10 + n12 * this.rowStride + n9;
                            n11 = this.rows + n12;
                            dArray[n8] = dArray2[n12];
                            dArray[n8 + 1] = dArray2[n11];
                            dArray[n8 + 2] = dArray2[n11 + this.rows];
                            dArray[n8 + 3] = dArray2[n11 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    n8 = n10 + n9 * this.rowStride;
                    dArray2[n9] = dArray[n8];
                    dArray2[this.rows + n9] = dArray[n8 + 1];
                }
                this.dctRows.inverse(dArray2, 0, bl);
                this.dctRows.inverse(dArray2, this.rows, bl);
                for (n9 = 0; n9 < this.rows; ++n9) {
                    n8 = n10 + n9 * this.rowStride;
                    dArray[n8] = dArray2[n9];
                    dArray[n8 + 1] = dArray2[this.rows + n9];
                }
            }
        }
    }

    private void ddxt3da_sub(int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l, false);
        if (n == -1) {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l2;
                long l3;
                long l4 = i * this.sliceStridel;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    this.dctColumns.forward(doubleLargeArray, l4 + l3 * this.rowStridel, bl);
                }
                if (this.columnsl > 2L) {
                    for (l3 = 0L; l3 < this.columnsl; l3 += 4L) {
                        long l5;
                        long l6;
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l2 = l4 + l6 * this.rowStridel + l3;
                            l5 = this.rowsl + l6;
                            doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l2));
                            doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l2 + 1L));
                            doubleLargeArray2.setDouble(l5 + this.rowsl, doubleLargeArray.getDouble(l2 + 2L));
                            doubleLargeArray2.setDouble(l5 + 2L * this.rowsl, doubleLargeArray.getDouble(l2 + 3L));
                        }
                        this.dctRows.forward(doubleLargeArray2, 0L, bl);
                        this.dctRows.forward(doubleLargeArray2, this.rowsl, bl);
                        this.dctRows.forward(doubleLargeArray2, 2L * this.rowsl, bl);
                        this.dctRows.forward(doubleLargeArray2, 3L * this.rowsl, bl);
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l2 = l4 + l6 * this.rowStridel + l3;
                            l5 = this.rowsl + l6;
                            doubleLargeArray.setDouble(l2, doubleLargeArray2.getDouble(l6));
                            doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray2.getDouble(l5));
                            doubleLargeArray.setDouble(l2 + 2L, doubleLargeArray2.getDouble(l5 + this.rowsl));
                            doubleLargeArray.setDouble(l2 + 3L, doubleLargeArray2.getDouble(l5 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l4 + l3 * this.rowStridel;
                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l2));
                    doubleLargeArray2.setDouble(this.rowsl + l3, doubleLargeArray.getDouble(l2 + 1L));
                }
                this.dctRows.forward(doubleLargeArray2, 0L, bl);
                this.dctRows.forward(doubleLargeArray2, this.rowsl, bl);
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l4 + l3 * this.rowStridel;
                    doubleLargeArray.setDouble(l2, doubleLargeArray2.getDouble(l3));
                    doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray2.getDouble(this.rowsl + l3));
                }
            }
        } else {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l7;
                long l8;
                long l9 = i * this.sliceStridel;
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    this.dctColumns.inverse(doubleLargeArray, l9 + l8 * this.rowStridel, bl);
                }
                if (this.columnsl > 2L) {
                    for (l8 = 0L; l8 < this.columnsl; l8 += 4L) {
                        long l10;
                        long l11;
                        for (l11 = 0L; l11 < this.rowsl; ++l11) {
                            l7 = l9 + l11 * this.rowStridel + l8;
                            l10 = this.rowsl + l11;
                            doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l7));
                            doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l7 + 1L));
                            doubleLargeArray2.setDouble(l10 + this.rowsl, doubleLargeArray.getDouble(l7 + 2L));
                            doubleLargeArray2.setDouble(l10 + 2L * this.rowsl, doubleLargeArray.getDouble(l7 + 3L));
                        }
                        this.dctRows.inverse(doubleLargeArray2, 0L, bl);
                        this.dctRows.inverse(doubleLargeArray2, this.rowsl, bl);
                        this.dctRows.inverse(doubleLargeArray2, 2L * this.rowsl, bl);
                        this.dctRows.inverse(doubleLargeArray2, 3L * this.rowsl, bl);
                        for (l11 = 0L; l11 < this.rowsl; ++l11) {
                            l7 = l9 + l11 * this.rowStridel + l8;
                            l10 = this.rowsl + l11;
                            doubleLargeArray.setDouble(l7, doubleLargeArray2.getDouble(l11));
                            doubleLargeArray.setDouble(l7 + 1L, doubleLargeArray2.getDouble(l10));
                            doubleLargeArray.setDouble(l7 + 2L, doubleLargeArray2.getDouble(l10 + this.rowsl));
                            doubleLargeArray.setDouble(l7 + 3L, doubleLargeArray2.getDouble(l10 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    l7 = l9 + l8 * this.rowStridel;
                    doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l7));
                    doubleLargeArray2.setDouble(this.rowsl + l8, doubleLargeArray.getDouble(l7 + 1L));
                }
                this.dctRows.inverse(doubleLargeArray2, 0L, bl);
                this.dctRows.inverse(doubleLargeArray2, this.rowsl, bl);
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    l7 = l9 + l8 * this.rowStridel;
                    doubleLargeArray.setDouble(l7, doubleLargeArray2.getDouble(l8));
                    doubleLargeArray.setDouble(l7 + 1L, doubleLargeArray2.getDouble(this.rowsl + l8));
                }
            }
        }
    }

    private void ddxt3da_sub(int n, double[][][] dArray, boolean bl) {
        int n2 = 4 * this.rows;
        if (this.columns == 2) {
            n2 >>= 1;
        }
        double[] dArray2 = new double[n2];
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    this.dctColumns.forward(dArray[i][n3], bl);
                }
                if (this.columns > 2) {
                    for (n3 = 0; n3 < this.columns; n3 += 4) {
                        int n4;
                        int n5;
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            dArray2[n5] = dArray[i][n5][n3];
                            dArray2[n4] = dArray[i][n5][n3 + 1];
                            dArray2[n4 + this.rows] = dArray[i][n5][n3 + 2];
                            dArray2[n4 + 2 * this.rows] = dArray[i][n5][n3 + 3];
                        }
                        this.dctRows.forward(dArray2, 0, bl);
                        this.dctRows.forward(dArray2, this.rows, bl);
                        this.dctRows.forward(dArray2, 2 * this.rows, bl);
                        this.dctRows.forward(dArray2, 3 * this.rows, bl);
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            dArray[i][n5][n3] = dArray2[n5];
                            dArray[i][n5][n3 + 1] = dArray2[n4];
                            dArray[i][n5][n3 + 2] = dArray2[n4 + this.rows];
                            dArray[i][n5][n3 + 3] = dArray2[n4 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    dArray2[n3] = dArray[i][n3][0];
                    dArray2[this.rows + n3] = dArray[i][n3][1];
                }
                this.dctRows.forward(dArray2, 0, bl);
                this.dctRows.forward(dArray2, this.rows, bl);
                for (n3 = 0; n3 < this.rows; ++n3) {
                    dArray[i][n3][0] = dArray2[n3];
                    dArray[i][n3][1] = dArray2[this.rows + n3];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    this.dctColumns.inverse(dArray[i][n6], bl);
                }
                if (this.columns > 2) {
                    for (n6 = 0; n6 < this.columns; n6 += 4) {
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n7 = this.rows + n8;
                            dArray2[n8] = dArray[i][n8][n6];
                            dArray2[n7] = dArray[i][n8][n6 + 1];
                            dArray2[n7 + this.rows] = dArray[i][n8][n6 + 2];
                            dArray2[n7 + 2 * this.rows] = dArray[i][n8][n6 + 3];
                        }
                        this.dctRows.inverse(dArray2, 0, bl);
                        this.dctRows.inverse(dArray2, this.rows, bl);
                        this.dctRows.inverse(dArray2, 2 * this.rows, bl);
                        this.dctRows.inverse(dArray2, 3 * this.rows, bl);
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n7 = this.rows + n8;
                            dArray[i][n8][n6] = dArray2[n8];
                            dArray[i][n8][n6 + 1] = dArray2[n7];
                            dArray[i][n8][n6 + 2] = dArray2[n7 + this.rows];
                            dArray[i][n8][n6 + 3] = dArray2[n7 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n6] = dArray[i][n6][0];
                    dArray2[this.rows + n6] = dArray[i][n6][1];
                }
                this.dctRows.inverse(dArray2, 0, bl);
                this.dctRows.inverse(dArray2, this.rows, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray[i][n6][0] = dArray2[n6];
                    dArray[i][n6][1] = dArray2[this.rows + n6];
                }
            }
        }
    }

    private void ddxt3db_sub(int n, double[] dArray, boolean bl) {
        block20: {
            double[] dArray2;
            block18: {
                block19: {
                    int n2 = 4 * this.slices;
                    if (this.columns == 2) {
                        n2 >>= 1;
                    }
                    dArray2 = new double[n2];
                    if (n != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int i = 0; i < this.rows; ++i) {
                        int n3 = i * this.rowStride;
                        for (int j = 0; j < this.columns; j += 4) {
                            int n4;
                            int n5;
                            int n6;
                            for (n6 = 0; n6 < this.slices; ++n6) {
                                n5 = n6 * this.sliceStride + n3 + j;
                                n4 = this.slices + n6;
                                dArray2[n6] = dArray[n5];
                                dArray2[n4] = dArray[n5 + 1];
                                dArray2[n4 + this.slices] = dArray[n5 + 2];
                                dArray2[n4 + 2 * this.slices] = dArray[n5 + 3];
                            }
                            this.dctSlices.forward(dArray2, 0, bl);
                            this.dctSlices.forward(dArray2, this.slices, bl);
                            this.dctSlices.forward(dArray2, 2 * this.slices, bl);
                            this.dctSlices.forward(dArray2, 3 * this.slices, bl);
                            for (n6 = 0; n6 < this.slices; ++n6) {
                                n5 = n6 * this.sliceStride + n3 + j;
                                n4 = this.slices + n6;
                                dArray[n5] = dArray2[n6];
                                dArray[n5 + 1] = dArray2[n4];
                                dArray[n5 + 2] = dArray2[n4 + this.slices];
                                dArray[n5 + 3] = dArray2[n4 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int i = 0; i < this.rows; ++i) {
                    int n7;
                    int n8;
                    int n9 = i * this.rowStride;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = n8 * this.sliceStride + n9;
                        dArray2[n8] = dArray[n7];
                        dArray2[this.slices + n8] = dArray[n7 + 1];
                    }
                    this.dctSlices.forward(dArray2, 0, bl);
                    this.dctSlices.forward(dArray2, this.slices, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = n8 * this.sliceStride + n9;
                        dArray[n7] = dArray2[n8];
                        dArray[n7 + 1] = dArray2[this.slices + n8];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n10 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 4) {
                        int n11;
                        int n12;
                        int n13;
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n10 + j;
                            n11 = this.slices + n13;
                            dArray2[n13] = dArray[n12];
                            dArray2[n11] = dArray[n12 + 1];
                            dArray2[n11 + this.slices] = dArray[n12 + 2];
                            dArray2[n11 + 2 * this.slices] = dArray[n12 + 3];
                        }
                        this.dctSlices.inverse(dArray2, 0, bl);
                        this.dctSlices.inverse(dArray2, this.slices, bl);
                        this.dctSlices.inverse(dArray2, 2 * this.slices, bl);
                        this.dctSlices.inverse(dArray2, 3 * this.slices, bl);
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n10 + j;
                            n11 = this.slices + n13;
                            dArray[n12] = dArray2[n13];
                            dArray[n12 + 1] = dArray2[n11];
                            dArray[n12 + 2] = dArray2[n11 + this.slices];
                            dArray[n12 + 3] = dArray2[n11 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n14;
                    int n15;
                    int n16 = i * this.rowStride;
                    for (n15 = 0; n15 < this.slices; ++n15) {
                        n14 = n15 * this.sliceStride + n16;
                        dArray2[n15] = dArray[n14];
                        dArray2[this.slices + n15] = dArray[n14 + 1];
                    }
                    this.dctSlices.inverse(dArray2, 0, bl);
                    this.dctSlices.inverse(dArray2, this.slices, bl);
                    for (n15 = 0; n15 < this.slices; ++n15) {
                        n14 = n15 * this.sliceStride + n16;
                        dArray[n14] = dArray2[n15];
                        dArray[n14 + 1] = dArray2[this.slices + n15];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        block20: {
            DoubleLargeArray doubleLargeArray2;
            block18: {
                block19: {
                    long l = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        l >>= 1;
                    }
                    doubleLargeArray2 = new DoubleLargeArray(l, false);
                    if (n != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long i = 0L; i < this.rowsl; ++i) {
                        long l2 = i * this.rowStridel;
                        for (long j = 0L; j < this.columnsl; j += 4L) {
                            long l3;
                            long l4;
                            long l5;
                            for (l5 = 0L; l5 < this.slicesl; ++l5) {
                                l4 = l5 * this.sliceStridel + l2 + j;
                                l3 = this.slicesl + l5;
                                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l4));
                                doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l4 + 1L));
                                doubleLargeArray2.setDouble(l3 + this.slicesl, doubleLargeArray.getDouble(l4 + 2L));
                                doubleLargeArray2.setDouble(l3 + 2L * this.slicesl, doubleLargeArray.getDouble(l4 + 3L));
                            }
                            this.dctSlices.forward(doubleLargeArray2, 0L, bl);
                            this.dctSlices.forward(doubleLargeArray2, this.slicesl, bl);
                            this.dctSlices.forward(doubleLargeArray2, 2L * this.slicesl, bl);
                            this.dctSlices.forward(doubleLargeArray2, 3L * this.slicesl, bl);
                            for (l5 = 0L; l5 < this.slicesl; ++l5) {
                                l4 = l5 * this.sliceStridel + l2 + j;
                                l3 = this.slicesl + l5;
                                doubleLargeArray.setDouble(l4, doubleLargeArray2.getDouble(l5));
                                doubleLargeArray.setDouble(l4 + 1L, doubleLargeArray2.getDouble(l3));
                                doubleLargeArray.setDouble(l4 + 2L, doubleLargeArray2.getDouble(l3 + this.slicesl));
                                doubleLargeArray.setDouble(l4 + 3L, doubleLargeArray2.getDouble(l3 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l6;
                    long l7 = i * this.rowStridel;
                    for (l6 = 0L; l6 < this.slicesl; ++l6) {
                        l = l6 * this.sliceStridel + l7;
                        doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l));
                        doubleLargeArray2.setDouble(this.slicesl + l6, doubleLargeArray.getDouble(l + 1L));
                    }
                    this.dctSlices.forward(doubleLargeArray2, 0L, bl);
                    this.dctSlices.forward(doubleLargeArray2, this.slicesl, bl);
                    for (l6 = 0L; l6 < this.slicesl; ++l6) {
                        l = l6 * this.sliceStridel + l7;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l6));
                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(this.slicesl + l6));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l = i * this.rowStridel;
                    for (long j = 0L; j < this.columnsl; j += 4L) {
                        long l8;
                        long l9;
                        long l10;
                        for (l10 = 0L; l10 < this.slicesl; ++l10) {
                            l9 = l10 * this.sliceStridel + l + j;
                            l8 = this.slicesl + l10;
                            doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l9));
                            doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l9 + 1L));
                            doubleLargeArray2.setDouble(l8 + this.slicesl, doubleLargeArray.getDouble(l9 + 2L));
                            doubleLargeArray2.setDouble(l8 + 2L * this.slicesl, doubleLargeArray.getDouble(l9 + 3L));
                        }
                        this.dctSlices.inverse(doubleLargeArray2, 0L, bl);
                        this.dctSlices.inverse(doubleLargeArray2, this.slicesl, bl);
                        this.dctSlices.inverse(doubleLargeArray2, 2L * this.slicesl, bl);
                        this.dctSlices.inverse(doubleLargeArray2, 3L * this.slicesl, bl);
                        for (l10 = 0L; l10 < this.slicesl; ++l10) {
                            l9 = l10 * this.sliceStridel + l + j;
                            l8 = this.slicesl + l10;
                            doubleLargeArray.setDouble(l9, doubleLargeArray2.getDouble(l10));
                            doubleLargeArray.setDouble(l9 + 1L, doubleLargeArray2.getDouble(l8));
                            doubleLargeArray.setDouble(l9 + 2L, doubleLargeArray2.getDouble(l8 + this.slicesl));
                            doubleLargeArray.setDouble(l9 + 3L, doubleLargeArray2.getDouble(l8 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l11;
                    long l12 = i * this.rowStridel;
                    for (l11 = 0L; l11 < this.slicesl; ++l11) {
                        l = l11 * this.sliceStridel + l12;
                        doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l));
                        doubleLargeArray2.setDouble(this.slicesl + l11, doubleLargeArray.getDouble(l + 1L));
                    }
                    this.dctSlices.inverse(doubleLargeArray2, 0L, bl);
                    this.dctSlices.inverse(doubleLargeArray2, this.slicesl, bl);
                    for (l11 = 0L; l11 < this.slicesl; ++l11) {
                        l = l11 * this.sliceStridel + l12;
                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l11));
                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(this.slicesl + l11));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, double[][][] dArray, boolean bl) {
        block20: {
            double[] dArray2;
            block18: {
                block19: {
                    int n2 = 4 * this.slices;
                    if (this.columns == 2) {
                        n2 >>= 1;
                    }
                    dArray2 = new double[n2];
                    if (n != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int i = 0; i < this.rows; ++i) {
                        for (int j = 0; j < this.columns; j += 4) {
                            int n3;
                            int n4;
                            for (n4 = 0; n4 < this.slices; ++n4) {
                                n3 = this.slices + n4;
                                dArray2[n4] = dArray[n4][i][j];
                                dArray2[n3] = dArray[n4][i][j + 1];
                                dArray2[n3 + this.slices] = dArray[n4][i][j + 2];
                                dArray2[n3 + 2 * this.slices] = dArray[n4][i][j + 3];
                            }
                            this.dctSlices.forward(dArray2, 0, bl);
                            this.dctSlices.forward(dArray2, this.slices, bl);
                            this.dctSlices.forward(dArray2, 2 * this.slices, bl);
                            this.dctSlices.forward(dArray2, 3 * this.slices, bl);
                            for (n4 = 0; n4 < this.slices; ++n4) {
                                n3 = this.slices + n4;
                                dArray[n4][i][j] = dArray2[n4];
                                dArray[n4][i][j + 1] = dArray2[n3];
                                dArray[n4][i][j + 2] = dArray2[n3 + this.slices];
                                dArray[n4][i][j + 3] = dArray2[n3 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int i = 0; i < this.rows; ++i) {
                    int n5;
                    for (n5 = 0; n5 < this.slices; ++n5) {
                        dArray2[n5] = dArray[n5][i][0];
                        dArray2[this.slices + n5] = dArray[n5][i][1];
                    }
                    this.dctSlices.forward(dArray2, 0, bl);
                    this.dctSlices.forward(dArray2, this.slices, bl);
                    for (n5 = 0; n5 < this.slices; ++n5) {
                        dArray[n5][i][0] = dArray2[n5];
                        dArray[n5][i][1] = dArray2[this.slices + n5];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = this.slices + n7;
                            dArray2[n7] = dArray[n7][i][j];
                            dArray2[n6] = dArray[n7][i][j + 1];
                            dArray2[n6 + this.slices] = dArray[n7][i][j + 2];
                            dArray2[n6 + 2 * this.slices] = dArray[n7][i][j + 3];
                        }
                        this.dctSlices.inverse(dArray2, 0, bl);
                        this.dctSlices.inverse(dArray2, this.slices, bl);
                        this.dctSlices.inverse(dArray2, 2 * this.slices, bl);
                        this.dctSlices.inverse(dArray2, 3 * this.slices, bl);
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = this.slices + n7;
                            dArray[n7][i][j] = dArray2[n7];
                            dArray[n7][i][j + 1] = dArray2[n6];
                            dArray[n7][i][j + 2] = dArray2[n6 + this.slices];
                            dArray[n7][i][j + 3] = dArray2[n6 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n8;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        dArray2[n8] = dArray[n8][i][0];
                        dArray2[this.slices + n8] = dArray[n8][i][1];
                    }
                    this.dctSlices.inverse(dArray2, 0, bl);
                    this.dctSlices.inverse(dArray2, this.slices, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        dArray[n8][i][0] = dArray2[n8];
                        dArray[n8][i][1] = dArray2[this.slices + n8];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        final int n4 = n3;
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n4];
                    if (n == -1) {
                        for (int i = n5; i < DoubleDCT_3D.this.slices; i += n2) {
                            int n10;
                            int n22;
                            int n3 = i * DoubleDCT_3D.this.sliceStride;
                            for (n22 = 0; n22 < DoubleDCT_3D.this.rows; ++n22) {
                                DoubleDCT_3D.this.dctColumns.forward(dArray, n3 + n22 * DoubleDCT_3D.this.rowStride, bl);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (n22 = 0; n22 < DoubleDCT_3D.this.columns; n22 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < DoubleDCT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * DoubleDCT_3D.this.rowStride + n22;
                                        n42 = DoubleDCT_3D.this.rows + n52;
                                        dArray2[n52] = dArray[n10];
                                        dArray2[n42] = dArray[n10 + 1];
                                        dArray2[n42 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[n10 + 2];
                                        dArray2[n42 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[n10 + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, 0, bl);
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, 2 * DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, 3 * DoubleDCT_3D.this.rows, bl);
                                    for (n52 = 0; n52 < DoubleDCT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * DoubleDCT_3D.this.rowStride + n22;
                                        n42 = DoubleDCT_3D.this.rows + n52;
                                        dArray[n10] = dArray2[n52];
                                        dArray[n10 + 1] = dArray2[n42];
                                        dArray[n10 + 2] = dArray2[n42 + DoubleDCT_3D.this.rows];
                                        dArray[n10 + 3] = dArray2[n42 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (n22 = 0; n22 < DoubleDCT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * DoubleDCT_3D.this.rowStride;
                                dArray2[n22] = dArray[n10];
                                dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).rows + n22] = dArray[n10 + 1];
                            }
                            DoubleDCT_3D.this.dctRows.forward(dArray2, 0, bl);
                            DoubleDCT_3D.this.dctRows.forward(dArray2, DoubleDCT_3D.this.rows, bl);
                            for (n22 = 0; n22 < DoubleDCT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * DoubleDCT_3D.this.rowStride;
                                dArray[n10] = dArray2[n22];
                                dArray[n10 + 1] = dArray2[DoubleDCT_3D.this.rows + n22];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleDCT_3D.this.slices; i += n2) {
                            int n11;
                            int n6;
                            int n7 = i * DoubleDCT_3D.this.sliceStride;
                            for (n6 = 0; n6 < DoubleDCT_3D.this.rows; ++n6) {
                                DoubleDCT_3D.this.dctColumns.inverse(dArray, n7 + n6 * DoubleDCT_3D.this.rowStride, bl);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < DoubleDCT_3D.this.columns; n6 += 4) {
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * DoubleDCT_3D.this.rowStride + n6;
                                        n8 = DoubleDCT_3D.this.rows + n9;
                                        dArray2[n9] = dArray[n11];
                                        dArray2[n8] = dArray[n11 + 1];
                                        dArray2[n8 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[n11 + 2];
                                        dArray2[n8 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[n11 + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, 0, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, 2 * DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, 3 * DoubleDCT_3D.this.rows, bl);
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * DoubleDCT_3D.this.rowStride + n6;
                                        n8 = DoubleDCT_3D.this.rows + n9;
                                        dArray[n11] = dArray2[n9];
                                        dArray[n11 + 1] = dArray2[n8];
                                        dArray[n11 + 2] = dArray2[n8 + DoubleDCT_3D.this.rows];
                                        dArray[n11 + 3] = dArray2[n8 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < DoubleDCT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * DoubleDCT_3D.this.rowStride;
                                dArray2[n6] = dArray[n11];
                                dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).rows + n6] = dArray[n11 + 1];
                            }
                            DoubleDCT_3D.this.dctRows.inverse(dArray2, 0, bl);
                            DoubleDCT_3D.this.dctRows.inverse(dArray2, DoubleDCT_3D.this.rows, bl);
                            for (n6 = 0; n6 < DoubleDCT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * DoubleDCT_3D.this.rowStride;
                                dArray[n11] = dArray2[n6];
                                dArray[n11 + 1] = dArray2[DoubleDCT_3D.this.rows + n6];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3da_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        Future[] futureArray = new Future[n2];
        final long l2 = l;
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2, false);
                    if (n == -1) {
                        for (long i = l3; i < DoubleDCT_3D.this.slicesl; i += (long)n2) {
                            long l;
                            long l22;
                            long l32 = i * DoubleDCT_3D.this.sliceStridel;
                            for (l22 = 0L; l22 < DoubleDCT_3D.this.rowsl; ++l22) {
                                DoubleDCT_3D.this.dctColumns.forward(doubleLargeArray, l32 + l22 * DoubleDCT_3D.this.rowStridel, bl);
                            }
                            if (DoubleDCT_3D.this.columnsl > 2L) {
                                for (l22 = 0L; l22 < DoubleDCT_3D.this.columnsl; l22 += 4L) {
                                    long l4;
                                    long l5;
                                    for (l5 = 0L; l5 < DoubleDCT_3D.this.rowsl; ++l5) {
                                        l = l32 + l5 * DoubleDCT_3D.this.rowStridel + l22;
                                        l4 = DoubleDCT_3D.this.rowsl + l5;
                                        doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l));
                                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l + 1L));
                                        doubleLargeArray2.setDouble(l4 + DoubleDCT_3D.this.rowsl, doubleLargeArray.getDouble(l + 2L));
                                        doubleLargeArray2.setDouble(l4 + 2L * DoubleDCT_3D.this.rowsl, doubleLargeArray.getDouble(l + 3L));
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(doubleLargeArray2, 0L, bl);
                                    DoubleDCT_3D.this.dctRows.forward(doubleLargeArray2, DoubleDCT_3D.this.rowsl, bl);
                                    DoubleDCT_3D.this.dctRows.forward(doubleLargeArray2, 2L * DoubleDCT_3D.this.rowsl, bl);
                                    DoubleDCT_3D.this.dctRows.forward(doubleLargeArray2, 3L * DoubleDCT_3D.this.rowsl, bl);
                                    for (l5 = 0L; l5 < DoubleDCT_3D.this.rowsl; ++l5) {
                                        l = l32 + l5 * DoubleDCT_3D.this.rowStridel + l22;
                                        l4 = DoubleDCT_3D.this.rowsl + l5;
                                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l5));
                                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(l4));
                                        doubleLargeArray.setDouble(l + 2L, doubleLargeArray2.getDouble(l4 + DoubleDCT_3D.this.rowsl));
                                        doubleLargeArray.setDouble(l + 3L, doubleLargeArray2.getDouble(l4 + 2L * DoubleDCT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columnsl != 2L) continue;
                            for (l22 = 0L; l22 < DoubleDCT_3D.this.rowsl; ++l22) {
                                l = l32 + l22 * DoubleDCT_3D.this.rowStridel;
                                doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l));
                                doubleLargeArray2.setDouble(DoubleDCT_3D.this.rowsl + l22, doubleLargeArray.getDouble(l + 1L));
                            }
                            DoubleDCT_3D.this.dctRows.forward(doubleLargeArray2, 0L, bl);
                            DoubleDCT_3D.this.dctRows.forward(doubleLargeArray2, DoubleDCT_3D.this.rowsl, bl);
                            for (l22 = 0L; l22 < DoubleDCT_3D.this.rowsl; ++l22) {
                                l = l32 + l22 * DoubleDCT_3D.this.rowStridel;
                                doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l22));
                                doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDCT_3D.this.rowsl + l22));
                            }
                        }
                    } else {
                        for (long i = l3; i < DoubleDCT_3D.this.slicesl; i += (long)n2) {
                            long l;
                            long l6;
                            long l7 = i * DoubleDCT_3D.this.sliceStridel;
                            for (l6 = 0L; l6 < DoubleDCT_3D.this.rowsl; ++l6) {
                                DoubleDCT_3D.this.dctColumns.inverse(doubleLargeArray, l7 + l6 * DoubleDCT_3D.this.rowStridel, bl);
                            }
                            if (DoubleDCT_3D.this.columnsl > 2L) {
                                for (l6 = 0L; l6 < DoubleDCT_3D.this.columnsl; l6 += 4L) {
                                    long l8;
                                    long l9;
                                    for (l9 = 0L; l9 < DoubleDCT_3D.this.rowsl; ++l9) {
                                        l = l7 + l9 * DoubleDCT_3D.this.rowStridel + l6;
                                        l8 = DoubleDCT_3D.this.rowsl + l9;
                                        doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l));
                                        doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l + 1L));
                                        doubleLargeArray2.setDouble(l8 + DoubleDCT_3D.this.rowsl, doubleLargeArray.getDouble(l + 2L));
                                        doubleLargeArray2.setDouble(l8 + 2L * DoubleDCT_3D.this.rowsl, doubleLargeArray.getDouble(l + 3L));
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(doubleLargeArray2, 0L, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(doubleLargeArray2, DoubleDCT_3D.this.rowsl, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(doubleLargeArray2, 2L * DoubleDCT_3D.this.rowsl, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(doubleLargeArray2, 3L * DoubleDCT_3D.this.rowsl, bl);
                                    for (l9 = 0L; l9 < DoubleDCT_3D.this.rowsl; ++l9) {
                                        l = l7 + l9 * DoubleDCT_3D.this.rowStridel + l6;
                                        l8 = DoubleDCT_3D.this.rowsl + l9;
                                        doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l9));
                                        doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(l8));
                                        doubleLargeArray.setDouble(l + 2L, doubleLargeArray2.getDouble(l8 + DoubleDCT_3D.this.rowsl));
                                        doubleLargeArray.setDouble(l + 3L, doubleLargeArray2.getDouble(l8 + 2L * DoubleDCT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columnsl != 2L) continue;
                            for (l6 = 0L; l6 < DoubleDCT_3D.this.rowsl; ++l6) {
                                l = l7 + l6 * DoubleDCT_3D.this.rowStridel;
                                doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l));
                                doubleLargeArray2.setDouble(DoubleDCT_3D.this.rowsl + l6, doubleLargeArray.getDouble(l + 1L));
                            }
                            DoubleDCT_3D.this.dctRows.inverse(doubleLargeArray2, 0L, bl);
                            DoubleDCT_3D.this.dctRows.inverse(doubleLargeArray2, DoubleDCT_3D.this.rowsl, bl);
                            for (l6 = 0L; l6 < DoubleDCT_3D.this.rowsl; ++l6) {
                                l = l7 + l6 * DoubleDCT_3D.this.rowStridel;
                                doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l6));
                                doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDCT_3D.this.rowsl + l6));
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3da_subth(final int n, final double[][][] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n4];
                    if (n == -1) {
                        for (int i = n5; i < DoubleDCT_3D.this.slices; i += n2) {
                            int n6;
                            for (n6 = 0; n6 < DoubleDCT_3D.this.rows; ++n6) {
                                DoubleDCT_3D.this.dctColumns.forward(dArray[i][n6], bl);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < DoubleDCT_3D.this.columns; n6 += 4) {
                                    int n22;
                                    int n3;
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.rows; ++n3) {
                                        n22 = DoubleDCT_3D.this.rows + n3;
                                        dArray2[n3] = dArray[i][n3][n6];
                                        dArray2[n22] = dArray[i][n3][n6 + 1];
                                        dArray2[n22 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[i][n3][n6 + 2];
                                        dArray2[n22 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[i][n3][n6 + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, 0, bl);
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, 2 * DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.forward(dArray2, 3 * DoubleDCT_3D.this.rows, bl);
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.rows; ++n3) {
                                        n22 = DoubleDCT_3D.this.rows + n3;
                                        dArray[i][n3][n6] = dArray2[n3];
                                        dArray[i][n3][n6 + 1] = dArray2[n22];
                                        dArray[i][n3][n6 + 2] = dArray2[n22 + DoubleDCT_3D.this.rows];
                                        dArray[i][n3][n6 + 3] = dArray2[n22 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < DoubleDCT_3D.this.rows; ++n6) {
                                dArray2[n6] = dArray[i][n6][0];
                                dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).rows + n6] = dArray[i][n6][1];
                            }
                            DoubleDCT_3D.this.dctRows.forward(dArray2, 0, bl);
                            DoubleDCT_3D.this.dctRows.forward(dArray2, DoubleDCT_3D.this.rows, bl);
                            for (n6 = 0; n6 < DoubleDCT_3D.this.rows; ++n6) {
                                dArray[i][n6][0] = dArray2[n6];
                                dArray[i][n6][1] = dArray2[DoubleDCT_3D.this.rows + n6];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleDCT_3D.this.slices; i += n2) {
                            int n7;
                            for (n7 = 0; n7 < DoubleDCT_3D.this.rows; ++n7) {
                                DoubleDCT_3D.this.dctColumns.inverse(dArray[i][n7], bl);
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                for (n7 = 0; n7 < DoubleDCT_3D.this.columns; n7 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < DoubleDCT_3D.this.rows; ++n52) {
                                        n42 = DoubleDCT_3D.this.rows + n52;
                                        dArray2[n52] = dArray[i][n52][n7];
                                        dArray2[n42] = dArray[i][n52][n7 + 1];
                                        dArray2[n42 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[i][n52][n7 + 2];
                                        dArray2[n42 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = dArray[i][n52][n7 + 3];
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, 0, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, 2 * DoubleDCT_3D.this.rows, bl);
                                    DoubleDCT_3D.this.dctRows.inverse(dArray2, 3 * DoubleDCT_3D.this.rows, bl);
                                    for (n52 = 0; n52 < DoubleDCT_3D.this.rows; ++n52) {
                                        n42 = DoubleDCT_3D.this.rows + n52;
                                        dArray[i][n52][n7] = dArray2[n52];
                                        dArray[i][n52][n7 + 1] = dArray2[n42];
                                        dArray[i][n52][n7 + 2] = dArray2[n42 + DoubleDCT_3D.this.rows];
                                        dArray[i][n52][n7 + 3] = dArray2[n42 + 2 * DoubleDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.columns != 2) continue;
                            for (n7 = 0; n7 < DoubleDCT_3D.this.rows; ++n7) {
                                dArray2[n7] = dArray[i][n7][0];
                                dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).rows + n7] = dArray[i][n7][1];
                            }
                            DoubleDCT_3D.this.dctRows.inverse(dArray2, 0, bl);
                            DoubleDCT_3D.this.dctRows.inverse(dArray2, DoubleDCT_3D.this.rows, bl);
                            for (n7 = 0; n7 < DoubleDCT_3D.this.rows; ++n7) {
                                dArray[i][n7][0] = dArray2[n7];
                                dArray[i][n7][1] = dArray2[DoubleDCT_3D.this.rows + n7];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] dArray2;
                        block17: {
                            block18: {
                                dArray2 = new double[n4];
                                if (n != -1) break block17;
                                if (DoubleDCT_3D.this.columns <= 2) break block18;
                                for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                    int n12 = i * DoubleDCT_3D.this.rowStride;
                                    for (int j = 0; j < DoubleDCT_3D.this.columns; j += 4) {
                                        int n22;
                                        int n3;
                                        int n42;
                                        for (n42 = 0; n42 < DoubleDCT_3D.this.slices; ++n42) {
                                            n3 = n42 * DoubleDCT_3D.this.sliceStride + n12 + j;
                                            n22 = DoubleDCT_3D.this.slices + n42;
                                            dArray2[n42] = dArray[n3];
                                            dArray2[n22] = dArray[n3 + 1];
                                            dArray2[n22 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n3 + 2];
                                            dArray2[n22 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n3 + 3];
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, 0, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, DoubleDCT_3D.this.slices, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, 2 * DoubleDCT_3D.this.slices, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, 3 * DoubleDCT_3D.this.slices, bl);
                                        for (n42 = 0; n42 < DoubleDCT_3D.this.slices; ++n42) {
                                            n3 = n42 * DoubleDCT_3D.this.sliceStride + n12 + j;
                                            n22 = DoubleDCT_3D.this.slices + n42;
                                            dArray[n3] = dArray2[n42];
                                            dArray[n3 + 1] = dArray2[n22];
                                            dArray[n3 + 2] = dArray2[n22 + DoubleDCT_3D.this.slices];
                                            dArray[n3 + 3] = dArray2[n22 + 2 * DoubleDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columns != 2) break block19;
                            for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                int n13;
                                int n52;
                                int n6 = i * DoubleDCT_3D.this.rowStride;
                                for (n52 = 0; n52 < DoubleDCT_3D.this.slices; ++n52) {
                                    n13 = n52 * DoubleDCT_3D.this.sliceStride + n6;
                                    dArray2[n52] = dArray[n13];
                                    dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).slices + n52] = dArray[n13 + 1];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(dArray2, 0, bl);
                                DoubleDCT_3D.this.dctSlices.forward(dArray2, DoubleDCT_3D.this.slices, bl);
                                for (n52 = 0; n52 < DoubleDCT_3D.this.slices; ++n52) {
                                    n13 = n52 * DoubleDCT_3D.this.sliceStride + n6;
                                    dArray[n13] = dArray2[n52];
                                    dArray[n13 + 1] = dArray2[DoubleDCT_3D.this.slices + n52];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columns > 2) {
                            for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                int n14 = i * DoubleDCT_3D.this.rowStride;
                                for (int j = 0; j < DoubleDCT_3D.this.columns; j += 4) {
                                    int n7;
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.slices; ++n9) {
                                        n8 = n9 * DoubleDCT_3D.this.sliceStride + n14 + j;
                                        n7 = DoubleDCT_3D.this.slices + n9;
                                        dArray2[n9] = dArray[n8];
                                        dArray2[n7] = dArray[n8 + 1];
                                        dArray2[n7 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n8 + 2];
                                        dArray2[n7 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n8 + 3];
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, 0, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, DoubleDCT_3D.this.slices, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, 2 * DoubleDCT_3D.this.slices, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, 3 * DoubleDCT_3D.this.slices, bl);
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.slices; ++n9) {
                                        n8 = n9 * DoubleDCT_3D.this.sliceStride + n14 + j;
                                        n7 = DoubleDCT_3D.this.slices + n9;
                                        dArray[n8] = dArray2[n9];
                                        dArray[n8 + 1] = dArray2[n7];
                                        dArray[n8 + 2] = dArray2[n7 + DoubleDCT_3D.this.slices];
                                        dArray[n8 + 3] = dArray2[n7 + 2 * DoubleDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.columns == 2) {
                            for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                int n15;
                                int n10;
                                int n11 = i * DoubleDCT_3D.this.rowStride;
                                for (n10 = 0; n10 < DoubleDCT_3D.this.slices; ++n10) {
                                    n15 = n10 * DoubleDCT_3D.this.sliceStride + n11;
                                    dArray2[n10] = dArray[n15];
                                    dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).slices + n10] = dArray[n15 + 1];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(dArray2, 0, bl);
                                DoubleDCT_3D.this.dctSlices.inverse(dArray2, DoubleDCT_3D.this.slices, bl);
                                for (n10 = 0; n10 < DoubleDCT_3D.this.slices; ++n10) {
                                    n15 = n10 * DoubleDCT_3D.this.sliceStride + n11;
                                    dArray[n15] = dArray2[n10];
                                    dArray[n15 + 1] = dArray2[DoubleDCT_3D.this.slices + n10];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        DoubleLargeArray doubleLargeArray2;
                        block17: {
                            block18: {
                                doubleLargeArray2 = new DoubleLargeArray(l2, false);
                                if (n != -1) break block17;
                                if (DoubleDCT_3D.this.columnsl <= 2L) break block18;
                                for (long i = l3; i < DoubleDCT_3D.this.rowsl; i += (long)n2) {
                                    long l = i * DoubleDCT_3D.this.rowStridel;
                                    for (long j = 0L; j < DoubleDCT_3D.this.columnsl; j += 4L) {
                                        long l22;
                                        long l32;
                                        long l4;
                                        for (l4 = 0L; l4 < DoubleDCT_3D.this.slicesl; ++l4) {
                                            l32 = l4 * DoubleDCT_3D.this.sliceStridel + l + j;
                                            l22 = DoubleDCT_3D.this.slicesl + l4;
                                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l32));
                                            doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l32 + 1L));
                                            doubleLargeArray2.setDouble(l22 + DoubleDCT_3D.this.slicesl, doubleLargeArray.getDouble(l32 + 2L));
                                            doubleLargeArray2.setDouble(l22 + 2L * DoubleDCT_3D.this.slicesl, doubleLargeArray.getDouble(l32 + 3L));
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(doubleLargeArray2, 0L, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(doubleLargeArray2, DoubleDCT_3D.this.slicesl, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(doubleLargeArray2, 2L * DoubleDCT_3D.this.slicesl, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(doubleLargeArray2, 3L * DoubleDCT_3D.this.slicesl, bl);
                                        for (l4 = 0L; l4 < DoubleDCT_3D.this.slicesl; ++l4) {
                                            l32 = l4 * DoubleDCT_3D.this.sliceStridel + l + j;
                                            l22 = DoubleDCT_3D.this.slicesl + l4;
                                            doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l4));
                                            doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l22));
                                            doubleLargeArray.setDouble(l32 + 2L, doubleLargeArray2.getDouble(l22 + DoubleDCT_3D.this.slicesl));
                                            doubleLargeArray.setDouble(l32 + 3L, doubleLargeArray2.getDouble(l22 + 2L * DoubleDCT_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columnsl != 2L) break block19;
                            for (long i = l3; i < DoubleDCT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l5;
                                long l6 = i * DoubleDCT_3D.this.rowStridel;
                                for (l5 = 0L; l5 < DoubleDCT_3D.this.slicesl; ++l5) {
                                    l = l5 * DoubleDCT_3D.this.sliceStridel + l6;
                                    doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l));
                                    doubleLargeArray2.setDouble(DoubleDCT_3D.this.slicesl + l5, doubleLargeArray.getDouble(l + 1L));
                                }
                                DoubleDCT_3D.this.dctSlices.forward(doubleLargeArray2, 0L, bl);
                                DoubleDCT_3D.this.dctSlices.forward(doubleLargeArray2, DoubleDCT_3D.this.slicesl, bl);
                                for (l5 = 0L; l5 < DoubleDCT_3D.this.slicesl; ++l5) {
                                    l = l5 * DoubleDCT_3D.this.sliceStridel + l6;
                                    doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l5));
                                    doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDCT_3D.this.slicesl + l5));
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columnsl > 2L) {
                            for (long i = l3; i < DoubleDCT_3D.this.rowsl; i += (long)n2) {
                                long l = i * DoubleDCT_3D.this.rowStridel;
                                for (long j = 0L; j < DoubleDCT_3D.this.columnsl; j += 4L) {
                                    long l7;
                                    long l8;
                                    long l9;
                                    for (l9 = 0L; l9 < DoubleDCT_3D.this.slicesl; ++l9) {
                                        l8 = l9 * DoubleDCT_3D.this.sliceStridel + l + j;
                                        l7 = DoubleDCT_3D.this.slicesl + l9;
                                        doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l8));
                                        doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l8 + 1L));
                                        doubleLargeArray2.setDouble(l7 + DoubleDCT_3D.this.slicesl, doubleLargeArray.getDouble(l8 + 2L));
                                        doubleLargeArray2.setDouble(l7 + 2L * DoubleDCT_3D.this.slicesl, doubleLargeArray.getDouble(l8 + 3L));
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(doubleLargeArray2, 0L, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(doubleLargeArray2, DoubleDCT_3D.this.slicesl, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(doubleLargeArray2, 2L * DoubleDCT_3D.this.slicesl, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(doubleLargeArray2, 3L * DoubleDCT_3D.this.slicesl, bl);
                                    for (l9 = 0L; l9 < DoubleDCT_3D.this.slicesl; ++l9) {
                                        l8 = l9 * DoubleDCT_3D.this.sliceStridel + l + j;
                                        l7 = DoubleDCT_3D.this.slicesl + l9;
                                        doubleLargeArray.setDouble(l8, doubleLargeArray2.getDouble(l9));
                                        doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray2.getDouble(l7));
                                        doubleLargeArray.setDouble(l8 + 2L, doubleLargeArray2.getDouble(l7 + DoubleDCT_3D.this.slicesl));
                                        doubleLargeArray.setDouble(l8 + 3L, doubleLargeArray2.getDouble(l7 + 2L * DoubleDCT_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.columnsl == 2L) {
                            for (long i = l3; i < DoubleDCT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l10;
                                long l11 = i * DoubleDCT_3D.this.rowStridel;
                                for (l10 = 0L; l10 < DoubleDCT_3D.this.slicesl; ++l10) {
                                    l = l10 * DoubleDCT_3D.this.sliceStridel + l11;
                                    doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l));
                                    doubleLargeArray2.setDouble(DoubleDCT_3D.this.slicesl + l10, doubleLargeArray.getDouble(l + 1L));
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(doubleLargeArray2, 0L, bl);
                                DoubleDCT_3D.this.dctSlices.inverse(doubleLargeArray2, DoubleDCT_3D.this.slicesl, bl);
                                for (l10 = 0L; l10 < DoubleDCT_3D.this.slicesl; ++l10) {
                                    l = l10 * DoubleDCT_3D.this.sliceStridel + l11;
                                    doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l10));
                                    doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(DoubleDCT_3D.this.slicesl + l10));
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final double[][][] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] dArray2;
                        block17: {
                            block18: {
                                dArray2 = new double[n4];
                                if (n != -1) break block17;
                                if (DoubleDCT_3D.this.columns <= 2) break block18;
                                for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                    for (int j = 0; j < DoubleDCT_3D.this.columns; j += 4) {
                                        int n6;
                                        int n22;
                                        for (n22 = 0; n22 < DoubleDCT_3D.this.slices; ++n22) {
                                            n6 = DoubleDCT_3D.this.slices + n22;
                                            dArray2[n22] = dArray[n22][i][j];
                                            dArray2[n6] = dArray[n22][i][j + 1];
                                            dArray2[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n22][i][j + 2];
                                            dArray2[n6 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n22][i][j + 3];
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, 0, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, DoubleDCT_3D.this.slices, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, 2 * DoubleDCT_3D.this.slices, bl);
                                        DoubleDCT_3D.this.dctSlices.forward(dArray2, 3 * DoubleDCT_3D.this.slices, bl);
                                        for (n22 = 0; n22 < DoubleDCT_3D.this.slices; ++n22) {
                                            n6 = DoubleDCT_3D.this.slices + n22;
                                            dArray[n22][i][j] = dArray2[n22];
                                            dArray[n22][i][j + 1] = dArray2[n6];
                                            dArray[n22][i][j + 2] = dArray2[n6 + DoubleDCT_3D.this.slices];
                                            dArray[n22][i][j + 3] = dArray2[n6 + 2 * DoubleDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columns != 2) break block19;
                            for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                int n7;
                                for (n7 = 0; n7 < DoubleDCT_3D.this.slices; ++n7) {
                                    dArray2[n7] = dArray[n7][i][0];
                                    dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).slices + n7] = dArray[n7][i][1];
                                }
                                DoubleDCT_3D.this.dctSlices.forward(dArray2, 0, bl);
                                DoubleDCT_3D.this.dctSlices.forward(dArray2, DoubleDCT_3D.this.slices, bl);
                                for (n7 = 0; n7 < DoubleDCT_3D.this.slices; ++n7) {
                                    dArray[n7][i][0] = dArray2[n7];
                                    dArray[n7][i][1] = dArray2[DoubleDCT_3D.this.slices + n7];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columns > 2) {
                            for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                for (int j = 0; j < DoubleDCT_3D.this.columns; j += 4) {
                                    int n8;
                                    int n3;
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.slices; ++n3) {
                                        n8 = DoubleDCT_3D.this.slices + n3;
                                        dArray2[n3] = dArray[n3][i][j];
                                        dArray2[n8] = dArray[n3][i][j + 1];
                                        dArray2[n8 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n3][i][j + 2];
                                        dArray2[n8 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = dArray[n3][i][j + 3];
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, 0, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, DoubleDCT_3D.this.slices, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, 2 * DoubleDCT_3D.this.slices, bl);
                                    DoubleDCT_3D.this.dctSlices.inverse(dArray2, 3 * DoubleDCT_3D.this.slices, bl);
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.slices; ++n3) {
                                        n8 = DoubleDCT_3D.this.slices + n3;
                                        dArray[n3][i][j] = dArray2[n3];
                                        dArray[n3][i][j + 1] = dArray2[n8];
                                        dArray[n3][i][j + 2] = dArray2[n8 + DoubleDCT_3D.this.slices];
                                        dArray[n3][i][j + 3] = dArray2[n8 + 2 * DoubleDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.columns == 2) {
                            for (int i = n5; i < DoubleDCT_3D.this.rows; i += n2) {
                                int n9;
                                for (n9 = 0; n9 < DoubleDCT_3D.this.slices; ++n9) {
                                    dArray2[n9] = dArray[n9][i][0];
                                    dArray2[((DoubleDCT_3D)DoubleDCT_3D.this).slices + n9] = dArray[n9][i][1];
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(dArray2, 0, bl);
                                DoubleDCT_3D.this.dctSlices.inverse(dArray2, DoubleDCT_3D.this.slices, bl);
                                for (n9 = 0; n9 < DoubleDCT_3D.this.slices; ++n9) {
                                    dArray[n9][i][0] = dArray2[n9];
                                    dArray[n9][i][1] = dArray2[DoubleDCT_3D.this.slices + n9];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }
}

