/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import mcib3d.geom.GeomTransform3D;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;

public class Gradient {
    public static final int TRANSITION_LINEAR = 0;
    public static final int TRANSITION_ARC_69 = 1;
    public static final int TRANSITION_ARC_90 = 2;
    public static final int TRANSITION_ARC_03 = 3;
    public static final int TRANSITION_ARC_36 = 4;
    public static final int TRANSITION_GAUSSIAN_01 = 5;
    public static final int TRANSITION_GAUSSIAN_001 = 6;
    public static final int TRANSITION_GAUSSIAN_0001 = 7;
    public static final Vector3D X_ROTATION = new Vector3D(1.0f, 0.0f, 0.0f);
    public static final Vector3D Y_ROTATION = new Vector3D(0.0f, 1.0f, 0.0f);
    public static final Vector3D Z_ROTATION = new Vector3D(0.0f, 0.0f, 1.0f);
    int transition;
    int[] colors;
    double[] ratios;
    double[] alphas;
    GeomTransform3D matrix = new GeomTransform3D();
    Vector3D center = new Vector3D(0.5, 0.5, 0.5);
    double alpha = 1.0;

    public Gradient() {
    }

    public Gradient(int[] nArray, double[] dArray, double[] dArray2) {
        this.init(nArray, dArray, dArray2, 0);
    }

    public Gradient(int[] nArray, double[] dArray, double[] dArray2, int n) {
        this.init(nArray, dArray, dArray2, n);
    }

    private void init(int[] nArray, double[] dArray, double[] dArray2, int n) {
        this.setValues(nArray);
        this.setAlphas(dArray);
        this.setRatios(dArray2);
        this.setTransition(n);
    }

    public int getLinearPixelAt(double d, double d2, double d3) {
        Vector3D vector3D = this.matrix.getVectorTransformed(new Vector3D(d, d2, d3), this.center);
        return this.getValue(vector3D.getX());
    }

    public int getRadialPixelAt(double d, double d2, double d3) {
        Vector3D vector3D = this.matrix.getVectorTransformed(new Vector3D(d, d2, d3), this.center);
        vector3D.setX(2.0 * (vector3D.getX() - this.center.getX()));
        vector3D.setY(2.0 * (vector3D.getY() - this.center.getY()));
        vector3D.setZ(2.0 * (vector3D.getZ() - this.center.getZ()));
        return this.getValue(vector3D.getLength());
    }

    private int getValue(double d) {
        if (d <= 0.0) {
            this.alpha = this.alphas[0];
            return this.colors[0];
        }
        if (d >= 1.0) {
            this.alpha = this.alphas[this.alphas.length - 1];
            return this.colors[this.colors.length - 1];
        }
        d = this.evaluate(d);
        int[] nArray = this.copy(this.colors[0], this.colors, this.colors[this.colors.length - 1]);
        double[] dArray = this.copy(this.alphas[0], this.alphas, this.alphas[this.alphas.length - 1]);
        double[] dArray2 = this.copy(0.0, this.ratios, 1.0);
        int n = -1;
        int n2 = dArray2.length - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(dArray2[i] <= d) || !(dArray2[i + 1] > d)) continue;
            double d2 = (d - dArray2[i]) / (dArray2[i + 1] - dArray2[i]);
            this.alpha = (dArray[i + 1] - dArray[i]) * d2 + dArray[i];
            n = (int)((double)(nArray[i + 1] - nArray[i]) * d2 + (double)nArray[i]);
            break;
        }
        return n;
    }

    public double getLastAlpha() {
        return this.alpha;
    }

    public void reset() {
        this.alpha = 1.0;
    }

    public void setValues(int[] nArray) {
        this.colors = (int[])nArray.clone();
    }

    public void setAlphas(double[] dArray) {
        this.alphas = (double[])dArray.clone();
    }

    public void setRatios(double[] dArray) {
        this.ratios = (double[])dArray.clone();
    }

    public void setTransformation(GeomTransform3D geomTransform3D) {
        this.matrix = geomTransform3D;
    }

    public void setCenter(Vector3D vector3D) {
        this.center.setCoord(vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public void setCenter(Point3D point3D) {
        this.center.setCoord(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void appendTranslation(double d, double d2, double d3) {
        this.matrix.setTranslation(-d, -d2, -d3);
    }

    public void appendScale(double d, double d2, double d3) {
        this.matrix.setScale(1.0 / d, 1.0 / d2, 1.0 / d3);
    }

    public void appendRotation(double d, Vector3D vector3D) {
        this.matrix.setRotation(vector3D, d);
    }

    public void setTransition(int n) {
        this.transition = n;
    }

    private int[] copy(int n, int[] nArray, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + 2];
        nArray2[0] = n;
        for (int i = 0; i < n3; ++i) {
            nArray2[i + 1] = nArray[i];
        }
        nArray2[n3 + 1] = n2;
        return nArray2;
    }

    private double[] copy(double d, double[] dArray, double d2) {
        int n = dArray.length;
        double[] dArray2 = new double[n + 2];
        dArray2[0] = d;
        for (int i = 0; i < n; ++i) {
            dArray2[i + 1] = dArray[i];
        }
        dArray2[n + 1] = d2;
        return dArray2;
    }

    protected double evaluate(double d) {
        double d2 = d;
        switch (this.transition) {
            case 0: {
                break;
            }
            case 3: {
                d2 = Math.sqrt(1.0 - d * d);
                break;
            }
            case 4: {
                d2 = 1.0 - Math.sqrt(1.0 - d * d);
                break;
            }
            case 1: {
                d2 = d - 1.0;
                d2 = 1.0 - Math.sqrt(1.0 - d2 * d2);
                break;
            }
            case 2: {
                d2 = d - 1.0;
                d2 = Math.sqrt(1.0 - d2 * d2);
                break;
            }
            case 5: {
                d2 = 1.0 - Math.exp(-4.6 * d * d);
                break;
            }
            case 6: {
                d2 = 1.0 - Math.exp(-6.9 * d * d);
                break;
            }
            case 7: {
                d2 = 1.0 - Math.exp(-9.21 * d * d);
            }
        }
        return d2;
    }
}

