/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ShapedArray;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.random.FloatGenerator;

public class FloatShapedVector
extends ShapedVector {
    protected float[] data;

    public FloatShapedVector(FloatShapedVectorSpace owner) {
        super(owner);
        this.data = new float[owner.getNumber()];
    }

    public FloatShapedVector(FloatShapedVectorSpace owner, float[] data) {
        super(owner);
        if (data == null || data.length != owner.getNumber()) {
            throw new IllegalArgumentException("Array size not compatible with vector space.");
        }
        this.data = data;
    }

    @Override
    public FloatShapedVectorSpace getOwner() {
        return (FloatShapedVectorSpace)this.space;
    }

    @Override
    public FloatShapedVectorSpace getSpace() {
        return this.getOwner();
    }

    @Override
    public final double get(int i) {
        return this.data[i];
    }

    @Override
    public final void set(int i, double value) {
        this.data[i] = (float)value;
    }

    public final void set(int i, float value) {
        this.data[i] = value;
    }

    public void set(float[] arr) {
        ArrayOps.copy(this.data, arr);
    }

    public float[] getData() {
        return this.data;
    }

    public void fill(FloatGenerator generator) {
        int k = 0;
        while (k < this.number) {
            this.data[k] = generator.nextFloat();
            ++k;
        }
    }

    @Override
    public FloatShapedVector clone() {
        return ((FloatShapedVectorSpace)this.space)._clone(this);
    }

    @Override
    public void assign(ShapedArray arr) {
        ((ShapedVectorSpace)this.space).checkShape(arr);
        float[] arrData = arr.toFloat().flatten();
        if (arrData != this.data) {
            System.arraycopy(arrData, 0, this.data, 0, this.getNumber());
        }
    }
}

