/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class SparseDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;

    public SparseDComplexMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseDComplexMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new ConcurrentHashMap(rows * (columns / 1000));
    }

    protected SparseDComplexMatrix2D(int rows, int columns, ConcurrentHashMap<Long, double[]> elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix2D assign(double[] value) {
        if (this.isNoView && value[0] == 0.0 && value[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D source) {
        if (!(source instanceof SparseDComplexMatrix2D)) {
            return super.assign(source);
        }
        SparseDComplexMatrix2D other = (SparseDComplexMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            this.elements.clear();
            this.elements.putAll(other.elements);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D y, DComplexDComplexDComplexFunction function) {
        if (!this.isNoView) {
            return super.assign(y, function);
        }
        this.checkShape(y);
        if (function instanceof DComplexPlusMultSecond) {
            final double[] alpha = ((DComplexPlusMultSecond)function).multiplicator;
            if (alpha[0] == 0.0 && alpha[1] == 1.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDComplexFunction(){

                @Override
                public double[] apply(int i, int j, double[] value) {
                    SparseDComplexMatrix2D.this.setQuick(i, j, DComplex.plus(SparseDComplexMatrix2D.this.getQuick(i, j), DComplex.mult(alpha, value)));
                    return value;
                }
            });
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized double[] getQuick(int row, int column) {
        double[] elem = this.elements.get((long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
        if (elem != null) {
            return new double[]{elem[0], elem[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D other) {
        if (other instanceof SelectedSparseDComplexMatrix2D) {
            SelectedSparseDComplexMatrix2D otherMatrix = (SelectedSparseDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDComplexMatrix2D) {
            SparseDComplexMatrix2D otherMatrix = (SparseDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new SparseDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return new SparseDComplexMatrix1D(size);
    }

    @Override
    protected DComplexMatrix1D like1D(int size, int offset, int stride) {
        return new SparseDComplexMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    public synchronized void setQuick(int row, int column, double[] value) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value[0] == 0.0 && value[1] == 0.0) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public DComplexMatrix1D vectorize() {
        final SparseDComplexMatrix1D v = new SparseDComplexMatrix1D((int)this.size());
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = 0;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            idx = c * SparseDComplexMatrix2D.this.rows;
                            int r = 0;
                            while (r < SparseDComplexMatrix2D.this.rows) {
                                double[] elem = SparseDComplexMatrix2D.this.getQuick(r, c);
                                if (elem[0] != 0.0 || elem[1] != 0.0) {
                                    v.setQuick(idx++, elem);
                                }
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    double[] elem = this.getQuick(r, c);
                    if (elem[0] != 0.0 || elem[1] != 0.0) {
                        v.setQuick(idx++, elem);
                    }
                    ++r;
                }
                ++c;
            }
        }
        return v;
    }

    @Override
    public synchronized void setQuick(int row, int column, double re, double im) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (re == 0.0 && im == 0.0) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, new double[]{re, im});
        }
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseDComplexMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        final SparseDoubleMatrix2D Im = new SparseDoubleMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < SparseDComplexMatrix2D.this.columns) {
                                Im.setQuick(r, c, SparseDComplexMatrix2D.this.getQuick(r, c)[1]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    ((DoubleMatrix2D)Im).setQuick(r, c, this.getQuick(r, c)[1]);
                    ++c;
                }
                ++r;
            }
        }
        return Im;
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        final SparseDoubleMatrix2D Re = new SparseDoubleMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < SparseDComplexMatrix2D.this.columns) {
                                Re.setQuick(r, c, SparseDComplexMatrix2D.this.getQuick(r, c)[0]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    ((DoubleMatrix2D)Re).setQuick(r, c, this.getQuick(r, c)[0]);
                    ++c;
                }
                ++r;
            }
        }
        return Re;
    }
}

