/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;

public class RankOneOperator
extends LinearOperator {
    protected Vector u;
    protected Vector v;

    public RankOneOperator(Vector u, Vector v) {
        super(v.getSpace(), u.getSpace());
        this.u = u;
        this.v = v;
    }

    public RankOneOperator(Vector u, Vector v, boolean clone) throws IncorrectSpaceException {
        super(v.getSpace(), u.getSpace());
        if (clone) {
            this.u = this.outputSpace.clone(u);
            this.v = this.inputSpace.clone(v);
        } else {
            this.u = u;
            this.v = v;
        }
    }

    @Override
    protected void privApply(Vector src, Vector dst, int job) {
        if (job == DIRECT) {
            this.outputSpace.axpby(this.inputSpace.dot(this.v, src), this.u, 0.0, dst);
        } else if (job == ADJOINT) {
            this.inputSpace.axpby(this.outputSpace.dot(this.u, src), this.v, 0.0, dst);
        } else {
            throw new NotImplementedException();
        }
    }

    public Vector getU() {
        return this.u;
    }

    public void setU(Vector u) throws IncorrectSpaceException {
        if (u.getSpace() != this.outputSpace) {
            throw new IncorrectSpaceException();
        }
        this.u = u;
    }

    public Vector getV() {
        return this.v;
    }

    public void setV(Vector v) throws IncorrectSpaceException {
        if (v.getSpace() != this.inputSpace) {
            throw new IncorrectSpaceException();
        }
        this.v = v;
    }
}

