package plugins.ylemontag.sequencecomparator;

import plugins.ylemontag.sequencecomparator.comparators.GlobalL1;
import plugins.ylemontag.sequencecomparator.comparators.GlobalL2;
import plugins.ylemontag.sequencecomparator.comparators.GlobalLInf;
import plugins.ylemontag.sequencecomparator.comparators.GlobalMSE;
import plugins.ylemontag.sequencecomparator.comparators.GlobalPSNR;
import plugins.ylemontag.sequencecomparator.comparators.GlobalRMSE;
import plugins.ylemontag.sequencecomparator.comparators.GlobalSSIM;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * List of available global comparators
 */
public enum GlobalComparatorFactory implements ComparatorFactory<GlobalComparator>
{
	L1  ("L1 norm"     ),
	L2  ("L2 norm"     ),
	LInf("L\u221E norm"),
	MSE ("MSE"         ),
	RMSE("RMSE"        ),
	PSNR("PSNR"        ),
	SSIM("SSIM"        );
	
	private String _name;
	
	/**
	 * Constructor
	 */
	private GlobalComparatorFactory(String name)
	{
		_name = name;
	}
	
	@Override
	public String getDistanceName()
	{
		return _name;
	}
	
	@Override
	public String toString()
	{
		return _name;
	}

	@Override
	public GlobalComparator createInstance(ParameterProvider provider)
	{
		switch(this) {
			case L1  : return new GlobalL1  (_name);
			case L2  : return new GlobalL2  (_name);
			case LInf: return new GlobalLInf(_name);
			case MSE : return new GlobalMSE (_name);
			case RMSE: return new GlobalRMSE(_name);
			case PSNR: return new GlobalPSNR(_name, provider.getPSNRDynamicRange());
			case SSIM: return new GlobalSSIM(_name, provider.getSSIMCalculator());
		}
		throw new RuntimeException("Unreachable code point");
	}
}
