/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte3D;
import mitiv.array.Double3D;
import mitiv.array.Float3D;
import mitiv.array.Int1D;
import mitiv.array.Int2D;
import mitiv.array.IntArray;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatInt3D;
import mitiv.array.impl.StriddenInt3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int3D
extends Array3D
implements IntArray {
    protected Int3D(int dim1, int dim2, int dim3) {
        super(dim1, dim2, dim3);
    }

    protected Int3D(int[] dims) {
        super(dims);
    }

    protected Int3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, int var4);

    @Override
    public void fill(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void increment(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) + value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) + value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void decrement(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) - value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) - value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void scale(int value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) * value);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, this.get(i1, i2, i3) * value);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void map(IntFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, generator.nextInt());
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, generator.nextInt());
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                        } else {
                            scanner.initialize(this.get(i1, i2, i3));
                            initialized = true;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                        } else {
                            scanner.initialize(this.get(i1, i2, i3));
                            initialized = true;
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public int[] flatten(boolean forceCopy) {
        int[] out = new int[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return out;
    }

    @Override
    public int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (skip) {
                            skip = false;
                        } else {
                            int value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (skip) {
                            skip = false;
                        } else {
                            int value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (skip) {
                            skip = false;
                        } else {
                            int value = this.get(i1, i2, i3);
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (skip) {
                            skip = false;
                        } else {
                            int value = this.get(i1, i2, i3);
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        if (skip) {
                            skip = false;
                        } else {
                            int value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        if (skip) {
                            skip = false;
                        } else {
                            int value = this.get(i1, i2, i3);
                            if (value < minValue) {
                                minValue = value;
                            }
                            if (value > maxValue) {
                                maxValue = value;
                            }
                        }
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        totalValue += this.get(i1, i2, i3);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        totalValue += this.get(i1, i2, i3);
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = (byte)this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Byte3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Short3D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = (short)this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Short3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Int3D toInt() {
        return this;
    }

    @Override
    public Long3D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Long3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Float3D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Float3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Double3D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i3 = 0;
        while (i3 < this.dim3) {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    out[++i] = this.get(i1, i2, i3);
                    ++i1;
                }
                ++i2;
            }
            ++i3;
        }
        return Double3D.wrap(out, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Int3D copy() {
        return new FlatInt3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Int3D src = arr.getType() == 2 ? (Int3D)arr : (Int3D)arr.toInt();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, (int)src.get(++i));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i3 = 0;
            while (i3 < this.dim3) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        this.set(i1, i2, i3, (int)src.get(++i));
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int3D create() {
        return new FlatInt3D(this.getShape());
    }

    public static Int3D create(int dim1, int dim2, int dim3) {
        return new FlatInt3D(dim1, dim2, dim3);
    }

    public static Int3D create(int[] dims) {
        return new FlatInt3D(dims);
    }

    public static Int3D create(Shape shape) {
        return new FlatInt3D(shape);
    }

    public static Int3D wrap(int[] data, int dim1, int dim2, int dim3) {
        return new FlatInt3D(data, dim1, dim2, dim3);
    }

    public static Int3D wrap(int[] data, int[] dims) {
        return new FlatInt3D(data, dims);
    }

    public static Int3D wrap(int[] data, Shape shape) {
        return new FlatInt3D(data, shape);
    }

    public static Int3D wrap(int[] data, int offset, int stride1, int stride2, int stride3, int dim1, int dim2, int dim3) {
        return new StriddenInt3D(data, offset, stride1, stride2, stride3, dim1, dim2, dim3);
    }

    @Override
    public abstract Int2D slice(int var1);

    @Override
    public abstract Int2D slice(int var1, int var2);

    @Override
    public abstract Int3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Int3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Int1D as1D();
}

