/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import javax.vecmath.Point3f;
import mcib3d.geom.Point3D;

public class Vector3D
extends Point3D {
    double length = -1.0;

    public Vector3D() {
    }

    public Vector3D(float f, float f2, float f3) {
        super(f, f2, f3);
    }

    public Vector3D(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public Vector3D(Vector3D vector3D) {
        super(vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public Vector3D(Point3D point3D) {
        super(point3D);
    }

    public Vector3D(Point3D point3D, Point3D point3D2) {
        super(point3D2.getX() - point3D.getX(), point3D2.getY() - point3D.getY(), point3D2.getZ() - point3D.getZ());
    }

    public Vector3D(Point3f point3f, Point3f point3f2) {
        super(point3f2.x - point3f.x, point3f2.y - point3f.y, point3f2.z - point3f.z);
    }

    public Vector3D(Point3f point3f) {
        super(point3f.x, point3f.y, point3f.z);
    }

    public void setCoord(double d, double d2, double d3) {
        this.setX(d);
        this.setY(d2);
        this.setZ(d3);
    }

    @Override
    public void setCoordRandom() {
        super.setCoordRandom();
        this.normalize();
    }

    public double getLength() {
        return this.getLength(1.0, 1.0);
    }

    public double getLengthSquare() {
        return this.getLengthSquare(1.0, 1.0);
    }

    public double getLength(double d, double d2) {
        this.computeLength(d, d2);
        return this.length;
    }

    public double getLengthSquare(double d, double d2) {
        return this.computeLengthSquare(d, d2);
    }

    public double distance(Vector3D vector3D) {
        Vector3D vector3D2 = this.add(vector3D, 1.0f, -1.0f);
        return vector3D2.getLength();
    }

    public double distanceSquare(Vector3D vector3D) {
        Vector3D vector3D2 = this.add(vector3D, 1.0f, -1.0f);
        return vector3D2.getX() * vector3D2.getX() + vector3D2.getY() * vector3D2.getY() + vector3D2.getZ() * vector3D2.getZ();
    }

    private void computeLength(double d, double d2) {
        this.length = Math.sqrt(this.getX() * this.getX() * d * d + this.getY() * this.getY() * d * d + this.getZ() * this.getZ() * d2 * d2);
    }

    private double computeLengthSquare(double d, double d2) {
        return this.getX() * this.getX() * d * d + this.getY() * this.getY() * d * d + this.getZ() * this.getZ() * d2 * d2;
    }

    public Vector3D add(Vector3D vector3D) {
        return this.add(vector3D, 1.0f, 1.0f);
    }

    public void addMe(Vector3D vector3D) {
        this.x += vector3D.getX();
        this.y += vector3D.getY();
        this.z += vector3D.getZ();
    }

    public void addMe(Vector3D vector3D, double d) {
        this.x += vector3D.getX() * d;
        this.y += vector3D.getY() * d;
        this.z += vector3D.getZ() * d;
    }

    public Vector3D add(Vector3D vector3D, float f, float f2) {
        return new Vector3D((double)f * this.getX() + (double)f2 * vector3D.getX(), (double)f * this.getY() + (double)f2 * vector3D.getY(), (double)f * this.getZ() + (double)f2 * vector3D.getZ());
    }

    public Vector3D add(Vector3D vector3D, double d, double d2) {
        return new Vector3D(d * this.getX() + d2 * vector3D.getX(), d * this.getY() + d2 * vector3D.getY(), d * this.getZ() + d2 * vector3D.getZ());
    }

    public Vector3D multiply(double d) {
        return new Vector3D(d * this.getX(), d * this.getY(), d * this.getZ());
    }

    public void multiplyMe(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public Vector3D multiply(double d, double d2, double d3) {
        return new Vector3D(d * this.getX(), d2 * this.getY(), d3 * this.getZ());
    }

    public void multiplyMe(double d, double d2, double d3) {
        this.x *= d;
        this.y *= d2;
        this.z *= d3;
    }

    public double angle(Vector3D vector3D) {
        double d = this.getLength() * vector3D.getLength();
        double d2 = 0.0;
        if (d > 0.0) {
            double d3 = this.dotProduct(vector3D);
            if ((d3 /= d) < 0.0) {
                d3 *= -1.0;
            }
            d2 = Math.acos(d3);
        }
        return d2;
    }

    public double anglePlane(double d, double d2, double d3, double d4) {
        Vector3D vector3D = new Vector3D(this.projectionPlane(d, d2, d3, d4));
        if (vector3D.getLength() > 0.0) {
            return this.angle(vector3D);
        }
        return 1.5707963267948966;
    }

    public double anglePlaneDegrees(double d, double d2, double d3, double d4) {
        return Math.toDegrees(this.anglePlane(d, d2, d3, d4));
    }

    public double angleDegrees(Vector3D vector3D) {
        return Math.toDegrees(this.angle(vector3D));
    }

    public double dotProduct(Vector3D vector3D) {
        return this.getX() * vector3D.getX() + this.getY() * vector3D.getY() + this.getZ() * vector3D.getZ();
    }

    public double dotProduct(Vector3D vector3D, double d, double d2) {
        return this.getX() * vector3D.getX() * d * d + this.getY() * vector3D.getY() * d * d + this.getZ() * vector3D.getZ() * d2 * d2;
    }

    public Vector3D getRandomPerpendicularVector() {
        Vector3D vector3D = new Vector3D();
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getZ();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 != 0.0) {
            d4 = 2.0 * Math.random() - 1.0;
            d5 = 2.0 * Math.random() - 1.0;
            d6 = (-d * d4 - d2 * d5) / d3;
        } else if (d2 != 0.0) {
            d4 = 1.0;
            d5 = -d / d2;
            d6 = 0.0;
        } else {
            d4 = 0.0;
            d5 = 1.0;
            d6 = 0.0;
        }
        vector3D.setX(d4);
        vector3D.setY(d5);
        vector3D.setZ(d6);
        vector3D.normalize();
        return vector3D;
    }

    public Vector3D crossProduct(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D();
        vector3D2.setCoord(this.getY() * vector3D.getZ() - this.getZ() * vector3D.getY(), this.getZ() * vector3D.getX() - this.getX() * vector3D.getZ(), this.getX() * vector3D.getY() - this.getY() * vector3D.getX());
        return vector3D2;
    }

    public double colinear(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D(this);
        vector3D2.normalize();
        Vector3D vector3D3 = new Vector3D(vector3D);
        vector3D3.normalize();
        double d = vector3D2.dotProduct(vector3D3);
        return d;
    }

    public void normalize() {
        this.computeLength(1.0, 1.0);
        if (this.length > 0.0) {
            this.setX(this.getX() / this.length);
            this.setY(this.getY() / this.length);
            this.setZ(this.getZ() / this.length);
            this.length = 1.0;
        } else {
            this.length = 0.0;
        }
    }

    public Vector3D getNormalizedVector() {
        Vector3D vector3D = new Vector3D(this);
        vector3D.normalize();
        return vector3D;
    }

    public Vector3D getComposante(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D(this);
        Vector3D vector3D3 = vector3D.getNormalizedVector();
        double d = vector3D2.dotProduct(vector3D);
        return vector3D.multiply(d);
    }

    public double intersection_unit_cube(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n = 0;
        double d10 = 1.0E-7;
        Vector3D vector3D = new Vector3D(d4 - d, d5 - d2, d6 - d3);
        if (this.getX() != 0.0) {
            d9 = (0.5 - vector3D.getX()) / this.getX();
            if (Math.abs(vector3D.getX() + d9 * this.getX()) - d10 <= 0.5 && Math.abs(vector3D.getY() + d9 * this.getY()) - d10 <= 0.5 && Math.abs(vector3D.getZ() + d9 * this.getZ()) - d10 <= 0.5) {
                if (n == 0) {
                    ++n;
                    d7 = d9;
                } else if (n == 1) {
                    ++n;
                    d8 = d9;
                }
            }
            d9 = (-0.5 - vector3D.getX()) / this.getX();
            if (Math.abs(vector3D.getX() + d9 * this.getX()) - d10 <= 0.5 && Math.abs(vector3D.getY() + d9 * this.getY()) - d10 <= 0.5 && Math.abs(vector3D.getZ() + d9 * this.getZ()) - d10 <= 0.5) {
                if (n == 0) {
                    ++n;
                    d7 = d9;
                } else if (n == 1) {
                    ++n;
                    d8 = d9;
                }
            }
        }
        if (this.getY() != 0.0 && n != 2) {
            d9 = (0.5 - vector3D.getY()) / this.getY();
            if (Math.abs(vector3D.getX() + d9 * this.getX()) - d10 <= 0.5 && Math.abs(vector3D.getY() + d9 * this.getY()) - d10 <= 0.5 && Math.abs(vector3D.getZ() + d9 * this.getZ()) - d10 <= 0.5) {
                if (n == 0) {
                    ++n;
                    d7 = d9;
                } else if (n == 1) {
                    ++n;
                    d8 = d9;
                }
            }
            d9 = (-0.5 - vector3D.getY()) / this.getY();
            if (Math.abs(vector3D.getX() + d9 * this.getX()) - d10 <= 0.5 && Math.abs(vector3D.getY() + d9 * this.getY()) - d10 <= 0.5 && Math.abs(vector3D.getZ() + d9 * this.getZ()) - d10 <= 0.5) {
                if (n == 0) {
                    ++n;
                    d7 = d9;
                } else if (n == 1) {
                    ++n;
                    d8 = d9;
                }
            }
        }
        if (this.getZ() != 0.0 && n != 2) {
            d9 = (0.5 - vector3D.getZ()) / this.getZ();
            if (Math.abs(vector3D.getX() + d9 * this.getX()) - d10 <= 0.5 && Math.abs(vector3D.getY() + d9 * this.getY()) - d10 <= 0.5 && Math.abs(vector3D.getZ() + d9 * this.getZ()) - d10 <= 0.5) {
                if (n == 0) {
                    ++n;
                    d7 = d9;
                } else if (n == 1) {
                    ++n;
                    d8 = d9;
                }
            }
            d9 = (-0.5 - vector3D.getZ()) / this.getZ();
            if (Math.abs(vector3D.getX() + d9 * this.getX()) - d10 <= 0.5 && Math.abs(vector3D.getY() + d9 * this.getY()) - d10 <= 0.5 && Math.abs(vector3D.getZ() + d9 * this.getZ()) - d10 <= 0.5) {
                if (n == 0) {
                    ++n;
                    d7 = d9;
                } else if (n == 1) {
                    ++n;
                    d8 = d9;
                }
            }
        }
        if (n == 2) {
            return Math.abs(d7 - d8);
        }
        return 0.0;
    }

    @Override
    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        String string = "(" + numberFormat.format(this.getX()) + ", " + numberFormat.format(this.getY()) + ", " + numberFormat.format(this.getZ()) + ")";
        return string;
    }

    @Override
    public void xmlWrite(Writer writer) {
        try {
            writer.write("<Vector3D x=\"" + this.getX() + "\" y=\"" + this.getY() + "\" z=\"" + this.getZ() + "\" />");
            writer.flush();
        }
        catch (IOException iOException) {
            System.out.println("error in Vector3D::xmlWrite " + iOException);
        }
    }
}

