/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.ZProjector;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import mcib3d.geom.Object3D;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.exceptionPrinter;

public abstract class ImageHandler {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int sizeXY;
    public int sizeXYZ;
    public int offsetX;
    public int offsetY;
    public int offsetZ;
    protected ImagePlus img;
    protected String title;
    HashMap<ImageHandler, ImageStats> stats = new HashMap(2);

    protected ImageHandler(ImagePlus imagePlus) {
        this.img = imagePlus;
        this.title = imagePlus.getShortTitle();
        this.sizeX = imagePlus.getWidth();
        this.sizeY = imagePlus.getHeight();
        this.sizeZ = imagePlus.getNSlices();
        this.sizeXY = this.sizeX * this.sizeY;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
    }

    protected ImageHandler(ImageStack imageStack) {
        this.img = new ImagePlus("Image", imageStack);
        this.title = this.img.getShortTitle();
        this.sizeX = this.img.getWidth();
        this.sizeY = this.img.getHeight();
        this.sizeZ = this.img.getNSlices();
        this.sizeXY = this.sizeX * this.sizeY;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
    }

    protected ImageHandler(String string, int n, int n2, int n3) {
        this.title = string;
        this.sizeX = n;
        this.sizeY = n2;
        this.sizeZ = n3;
        this.sizeXY = n * n2;
        this.sizeXYZ = this.sizeXY * n3;
    }

    protected ImageHandler(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.title = string;
        this.sizeX = n;
        this.sizeY = n2;
        this.sizeZ = n3;
        this.sizeXY = n * n2;
        this.sizeXYZ = this.sizeXY * n3;
        this.offsetX = n4;
        this.offsetY = n5;
        this.offsetZ = n6;
    }

    public abstract double getSizeInMb();

    public ImagePlus getImagePlus() {
        return this.img;
    }

    public abstract int getType();

    public String getTitle() {
        return this.title;
    }

    public boolean sameDimentions(ImageHandler imageHandler) {
        return this.sizeX == imageHandler.sizeX && this.sizeY == imageHandler.sizeY && this.sizeZ == imageHandler.sizeZ;
    }

    public boolean sameDimentions(ImagePlus imagePlus) {
        return this.sizeX == imagePlus.getWidth() && this.sizeY == imagePlus.getHeight() && this.sizeZ == imagePlus.getNSlices();
    }

    public boolean contains(int n, int n2, int n3) {
        return n >= 0 && n < this.sizeX && n2 >= 0 && n2 < this.sizeY && n3 >= 0 && n3 < this.sizeZ;
    }

    public boolean contains(double d, double d2, double d3) {
        return d >= 0.0 && d < (double)this.sizeX && d2 >= 0.0 && d2 < (double)this.sizeY && d3 >= 0.0 && d3 < (double)this.sizeZ;
    }

    public boolean contains(Voxel3D voxel3D) {
        return voxel3D.x >= 0.0 && voxel3D.x < (double)this.sizeX && voxel3D.y >= 0.0 && voxel3D.y < (double)this.sizeY && voxel3D.z >= 0.0 && voxel3D.z < (double)this.sizeZ;
    }

    public boolean maskContains(int n, int n2, int n3) {
        return this.contains(n, n2, n3) && this.getPixel(n, n2, n3) != 0.0f;
    }

    public abstract float getPixel(int var1);

    public abstract float getPixel(int var1, int var2, int var3);

    public abstract float getPixel(int var1, int var2);

    public abstract float getPixel(Point3D var1);

    public abstract float getPixelInterpolated(Point3D var1);

    public float getPixel(float f, float f2, float f3) {
        int n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f3;
        float f4 = f - (float)n;
        float f5 = f2 - (float)n2;
        float f6 = f3 - (float)n3;
        float f7 = this.getPixel(n, n2, n3);
        float f8 = n + 1 < this.sizeX ? this.getPixel(n + 1, n2, n3) : 0.0f;
        float f9 = n + 1 < this.sizeX && n2 + 1 < this.sizeY ? this.getPixel(n + 1, n2 + 1, n3) : 0.0f;
        float f10 = n + 1 < this.sizeX && n2 + 1 < this.sizeY && n3 + 1 < this.sizeZ ? this.getPixel(n + 1, n2 + 1, n3 + 1) : 0.0f;
        float f11 = n + 1 < this.sizeX && n3 + 1 < this.sizeZ ? this.getPixel(n + 1, n2, n3 + 1) : 0.0f;
        float f12 = n2 + 1 < this.sizeY ? this.getPixel(n, n2 + 1, n3) : 0.0f;
        float f13 = n2 + 1 < this.sizeY && n3 + 1 < this.sizeZ ? this.getPixel(n, n2 + 1, n3 + 1) : 0.0f;
        float f14 = n3 + 1 < this.sizeZ ? this.getPixel(n, n2, n3 + 1) : 0.0f;
        float f15 = f12 + f4 * (f9 - f12);
        float f16 = f7 + f4 * (f8 - f7);
        float f17 = f13 + f4 * (f10 - f13);
        float f18 = f14 + f4 * (f11 - f14);
        float f19 = f16 + f5 * (f15 - f16);
        float f20 = f18 + f5 * (f17 - f18);
        return f19 + f6 * (f20 - f19);
    }

    public float getPixel(float f, float f2, float f3, ImageInt imageInt) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        int n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f3;
        float f11 = f - (float)n;
        float f12 = f2 - (float)n2;
        float f13 = f3 - (float)n3;
        float f14 = imageInt.maskContains(n, n2, n3) ? this.getPixel(n, n2, n3) : Float.NaN;
        float f15 = imageInt.maskContains(n + 1, n2, n3) ? this.getPixel(n + 1, n2, n3) : Float.NaN;
        float f16 = imageInt.maskContains(n + 1, n2 + 1, n3) ? this.getPixel(n + 1, n2 + 1, n3) : Float.NaN;
        float f17 = imageInt.maskContains(n + 1, n2 + 1, n3 + 1) ? this.getPixel(n + 1, n2 + 1, n3 + 1) : Float.NaN;
        float f18 = imageInt.maskContains(n + 1, n2, n3 + 1) ? this.getPixel(n + 1, n2, n3 + 1) : Float.NaN;
        float f19 = imageInt.maskContains(n, n2 + 1, n3) ? this.getPixel(n, n2 + 1, n3) : Float.NaN;
        float f20 = imageInt.maskContains(n, n2 + 1, n3 + 1) ? this.getPixel(n, n2 + 1, n3 + 1) : Float.NaN;
        float f21 = f10 = imageInt.maskContains(n, n2, n3 + 1) ? this.getPixel(n, n2, n3 + 1) : Float.NaN;
        float f22 = Float.isNaN(f19) ? f16 : (f9 = Float.isNaN(f16) ? f19 : f19 + f11 * (f16 - f19));
        float f23 = Float.isNaN(f14) ? f15 : (f8 = Float.isNaN(f15) ? f14 : f14 + f11 * (f15 - f14));
        float f24 = Float.isNaN(f20) ? f17 : (f7 = Float.isNaN(f17) ? f20 : f20 + f11 * (f17 - f20));
        float f25 = Float.isNaN(f18) ? f10 : (f6 = Float.isNaN(f10) ? f18 : f10 + f11 * (f18 - f10));
        float f26 = Float.isNaN(f8) ? f9 : (f5 = Float.isNaN(f9) ? f8 : f8 + f12 * (f9 - f8));
        float f27 = Float.isNaN(f6) ? f7 : (f4 = Float.isNaN(f7) ? f6 : f6 + f12 * (f7 - f6));
        return Float.isNaN(f5) ? f4 : (Float.isNaN(f4) ? (Float.isNaN(f14) ? this.getPixel(n, n2, n3) : f14) : f5 + f13 * (f4 - f5));
    }

    public ArrayUtil getNeighborhood3x3x3(int n, int n2, int n3) {
        ArrayUtil arrayUtil = new ArrayUtil(27);
        int n4 = 0;
        for (int i = n3 - 1; i <= n3 + 1; ++i) {
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                for (int k = n - 1; k <= n + 1; ++k) {
                    if (k < 0 || j < 0 || i < 0 || k >= this.sizeX || j >= this.sizeY || i >= this.sizeZ) continue;
                    arrayUtil.putValue(n4, this.getPixel(k, j, i));
                    ++n4;
                }
            }
        }
        arrayUtil.setSize(n4);
        return arrayUtil;
    }

    public ArrayList<Voxel3D> getNeighborhood3x3x3ListNoCenter(int n, int n2, int n3) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>(27);
        for (int i = n3 - 1; i <= n3 + 1; ++i) {
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                for (int k = n - 1; k <= n + 1; ++k) {
                    if (k == n && j == n2 && i == n3 || k < 0 || j < 0 || i < 0 || k >= this.sizeX || j >= this.sizeY || i >= this.sizeZ) continue;
                    arrayList.add(new Voxel3D(k, j, i, this.getPixel(k, j, i)));
                }
            }
        }
        return arrayList;
    }

    public ArrayUtil getNeighborhoodCross3D(int n, int n2, int n3) {
        ArrayUtil arrayUtil = new ArrayUtil(7);
        arrayUtil.putValue(0, this.getPixel(n, n2, n3));
        int n4 = 1;
        if (n + 1 < this.sizeX) {
            arrayUtil.putValue(n4, this.getPixel(n + 1, n2, n3));
            ++n4;
        }
        if (n - 1 >= 0) {
            arrayUtil.putValue(n4, this.getPixel(n - 1, n2, n3));
            ++n4;
        }
        if (n2 + 1 < this.sizeY) {
            arrayUtil.putValue(n4, this.getPixel(n, n2 + 1, n3));
            ++n4;
        }
        if (n2 - 1 >= 0) {
            arrayUtil.putValue(n4, this.getPixel(n, n2 - 1, n3));
            ++n4;
        }
        if (n3 + 1 < this.sizeZ) {
            arrayUtil.putValue(n4, this.getPixel(n, n2, n3 + 1));
            ++n4;
        }
        if (n3 - 1 >= 0) {
            arrayUtil.putValue(n4, this.getPixel(n, n2, n3 - 1));
            ++n4;
        }
        arrayUtil.setSize(n4);
        return arrayUtil;
    }

    public ArrayList<Voxel3D> getNeighborhoodCross3DList(int n, int n2, int n3, boolean bl) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        if (!bl) {
            arrayList.add(new Voxel3D(n, n2, n3, this.getPixel(n, n2, n3)));
        }
        if (n + 1 < this.sizeX) {
            arrayList.add(new Voxel3D(n + 1, n2, n3, this.getPixel(n + 1, n2, n3)));
        }
        if (n - 1 >= 0) {
            arrayList.add(new Voxel3D(n - 1, n2, n3, this.getPixel(n - 1, n2, n3)));
        }
        if (n2 + 1 < this.sizeY) {
            arrayList.add(new Voxel3D(n, n2 + 1, n3, this.getPixel(n, n2 + 1, n3)));
        }
        if (n2 - 1 >= 0) {
            arrayList.add(new Voxel3D(n, n2 - 1, n3, this.getPixel(n, n2 - 1, n3)));
        }
        if (n3 + 1 < this.sizeZ) {
            arrayList.add(new Voxel3D(n, n2, n3 + 1, this.getPixel(n, n2, n3 + 1)));
        }
        if (n3 - 1 >= 0) {
            arrayList.add(new Voxel3D(n, n2, n3 - 1, this.getPixel(n, n2, n3 - 1)));
        }
        return arrayList;
    }

    public ArrayUtil getNeighborhood(int n, int n2, int n3, float f, float f2, float f3) {
        return this.getNeighborhoodSphere(n, n2, n3, f, f2, f3);
    }

    public ArrayUtil getNeighborhoodSphere(int n, int n2, int n3, float f, float f2, float f3) {
        int n4 = 0;
        double d = f != 0.0f ? (double)(f * f) : 1.0;
        double d2 = f2 != 0.0f ? (double)(f2 * f2) : 1.0;
        double d3 = f3 != 0.0f ? (double)(f3 * f3) : 1.0;
        int n5 = (int)Math.ceil(f);
        int n6 = (int)Math.ceil(f2);
        int n7 = (int)Math.ceil(f3);
        double[] dArray = new double[(2 * n5 + 1) * (2 * n6 + 1) * (2 * n7 + 1)];
        for (int i = n3 - n7; i <= n3 + n7; ++i) {
            for (int j = n2 - n6; j <= n2 + n6; ++j) {
                for (int k = n - n5; k <= n + n5; ++k) {
                    double d4;
                    if (k < 0 || j < 0 || i < 0 || k >= this.sizeX || j >= this.sizeY || i >= this.sizeZ || !((d4 = (double)((n - k) * (n - k)) / d + (double)((n2 - j) * (n2 - j)) / d2 + (double)((n3 - i) * (n3 - i)) / d3) <= 1.0)) continue;
                    dArray[n4] = this.getPixel(k, j, i);
                    ++n4;
                }
            }
        }
        ArrayUtil arrayUtil = new ArrayUtil(dArray);
        arrayUtil.setSize(n4);
        return arrayUtil;
    }

    public ArrayUtil getNeighborhoodKernel(int[] nArray, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        ArrayUtil arrayUtil = new ArrayUtil(n);
        int n5 = (int)Math.ceil(f);
        int n6 = (int)Math.ceil(f2);
        int n7 = (int)Math.ceil(f3);
        int n8 = 0;
        int n9 = 0;
        for (int i = n4 - n7; i <= n4 + n7; ++i) {
            for (int j = n3 - n6; j <= n3 + n6; ++j) {
                for (int k = n2 - n5; k <= n2 + n5; ++k) {
                    if (nArray[n9] > 0 && k >= 0 && j >= 0 && i >= 0 && k < this.sizeX && j < this.sizeY && i < this.sizeZ) {
                        arrayUtil.putValue(n8, this.getPixel(k, j, i));
                        ++n8;
                    }
                    ++n9;
                }
            }
        }
        arrayUtil.setSize(n8);
        return arrayUtil;
    }

    public ArrayUtil getNeighborhoodKernel(Object3D object3D, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = object3D.getVolumePixels();
        ArrayUtil arrayUtil = new ArrayUtil(n9);
        ImageInt imageInt = object3D.getLabelImage();
        int[] nArray = object3D.getBoundingBox();
        float f = (float)(0.5 * (double)(nArray[1] - nArray[0]));
        float f2 = (float)(0.5 * (double)(nArray[3] - nArray[2]));
        float f3 = (float)(0.5 * (double)(nArray[5] - nArray[4]));
        int n10 = (int)Math.ceil(f);
        int n11 = (int)Math.ceil(f2);
        int n12 = (int)Math.ceil(f3);
        int n13 = 0;
        int n14 = n3 - n12;
        if (n14 < 0) {
            n14 = 0;
        }
        if ((n8 = n3 + n12) >= this.sizeZ) {
            n8 = this.sizeZ - 1;
        }
        if ((n7 = n2 - n11) < 0) {
            n7 = 0;
        }
        if ((n6 = n2 + n11) >= this.sizeY) {
            n6 = this.sizeY - 1;
        }
        if ((n5 = n - n10) < 0) {
            n5 = 0;
        }
        if ((n4 = n + n10) >= this.sizeX) {
            n4 = this.sizeX - 1;
        }
        int n15 = n5 - nArray[0];
        int n16 = n7 - nArray[2];
        int n17 = n14 - nArray[4];
        for (int i = n14; i <= n8; ++i) {
            for (int j = n7; j <= n6; ++j) {
                for (int k = n5; k <= n4; ++k) {
                    if (!imageInt.contains(k - n15, j - n16, i - n17) || !(imageInt.getPixel(k - n15, j - n16, i - n17) > 0.0f)) continue;
                    arrayUtil.putValue(n13, this.getPixel(k, j, i));
                    ++n13;
                }
            }
        }
        arrayUtil.setSize(n13);
        return arrayUtil;
    }

    public ArrayUtil getNeighborhoodKernelAdd(Object3D object3D, ImageHandler imageHandler, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = object3D.getVolumePixels();
        ArrayUtil arrayUtil = new ArrayUtil(n9);
        ImageInt imageInt = object3D.getLabelImage();
        int[] nArray = object3D.getBoundingBox();
        float f = (float)(0.5 * (double)(nArray[1] - nArray[0]));
        float f2 = (float)(0.5 * (double)(nArray[3] - nArray[2]));
        float f3 = (float)(0.5 * (double)(nArray[5] - nArray[4]));
        int n10 = (int)Math.ceil(f);
        int n11 = (int)Math.ceil(f2);
        int n12 = (int)Math.ceil(f3);
        int n13 = 0;
        int n14 = n3 - n12;
        if (n14 < 0) {
            n14 = 0;
        }
        if ((n8 = n3 + n12) >= this.sizeZ) {
            n8 = this.sizeZ - 1;
        }
        if ((n7 = n2 - n11) < 0) {
            n7 = 0;
        }
        if ((n6 = n2 + n11) >= this.sizeY) {
            n6 = this.sizeY - 1;
        }
        if ((n5 = n - n10) < 0) {
            n5 = 0;
        }
        if ((n4 = n + n10) >= this.sizeX) {
            n4 = this.sizeX - 1;
        }
        int n15 = n5 - nArray[0];
        int n16 = n7 - nArray[2];
        int n17 = n14 - nArray[4];
        for (int i = n14; i <= n8; ++i) {
            for (int j = n7; j <= n6; ++j) {
                for (int k = n5; k <= n4; ++k) {
                    if (!imageInt.contains(k - n15, j - n16, i - n17) || !(imageInt.getPixel(k - n15, j - n16, i - n17) > 0.0f)) continue;
                    arrayUtil.putValue(n13, this.getPixel(k, j, i) + imageHandler.getPixel(k - n15, j - n16, i - n17));
                    ++n13;
                }
            }
        }
        arrayUtil.setSize(n13);
        return arrayUtil;
    }

    public ArrayUtil getNeighborhoodKernelSubstract(Object3D object3D, ImageHandler imageHandler, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = object3D.getVolumePixels();
        ArrayUtil arrayUtil = new ArrayUtil(n9);
        ImageInt imageInt = object3D.getLabelImage();
        int[] nArray = object3D.getBoundingBox();
        float f = (float)(0.5 * (double)(nArray[1] - nArray[0]));
        float f2 = (float)(0.5 * (double)(nArray[3] - nArray[2]));
        float f3 = (float)(0.5 * (double)(nArray[5] - nArray[4]));
        int n10 = (int)Math.ceil(f);
        int n11 = (int)Math.ceil(f2);
        int n12 = (int)Math.ceil(f3);
        int n13 = 0;
        int n14 = n3 - n12;
        if (n14 < 0) {
            n14 = 0;
        }
        if ((n8 = n3 + n12) >= this.sizeZ) {
            n8 = this.sizeZ - 1;
        }
        if ((n7 = n2 - n11) < 0) {
            n7 = 0;
        }
        if ((n6 = n2 + n11) >= this.sizeY) {
            n6 = this.sizeY - 1;
        }
        if ((n5 = n - n10) < 0) {
            n5 = 0;
        }
        if ((n4 = n + n10) >= this.sizeX) {
            n4 = this.sizeX - 1;
        }
        int n15 = n5 - nArray[0];
        int n16 = n7 - nArray[2];
        int n17 = n14 - nArray[4];
        for (int i = n14; i <= n8; ++i) {
            for (int j = n7; j <= n6; ++j) {
                for (int k = n5; k <= n4; ++k) {
                    if (!imageInt.contains(k - n15, j - n16, i - n17) || !(imageInt.getPixel(k - n15, j - n16, i - n17) > 0.0f)) continue;
                    float f4 = this.getPixel(k, j, i) - imageHandler.getPixel(k - n15, j - n16, i - n17);
                    arrayUtil.putValue(n13, f4);
                    ++n13;
                }
            }
        }
        arrayUtil.setSize(n13);
        return arrayUtil;
    }

    public ArrayUtil getNeighborhoodLayer(int n, int n2, int n3, float f, float f2) {
        return this.getNeighborhoodLayer(n, n2, n3, f, f2, null);
    }

    public ArrayUtil getNeighborhoodLayer(int n, int n2, int n3, float f, float f2, ImageInt imageInt) {
        int n4 = 0;
        double d = f * f;
        double d2 = f2 * f2;
        double d3 = this.getScaleZ() / this.getScaleXY();
        double d4 = d3 * d3;
        int n5 = (int)Math.ceil(f2);
        int n6 = (int)Math.ceil(f2);
        int n7 = (int)Math.ceil((double)f2 / d3);
        double[] dArray = new double[(2 * n5 + 1) * (2 * n6 + 1) * (2 * n7 + 1)];
        int n8 = 0;
        if (imageInt != null) {
            n8 = imageInt.getPixelInt(n, n2, n3);
        }
        for (int i = n3 - n7; i <= n3 + n7; ++i) {
            for (int j = n2 - n6; j <= n2 + n6; ++j) {
                for (int k = n - n5; k <= n + n5; ++k) {
                    double d5;
                    if (k < 0 || j < 0 || i < 0 || k >= this.sizeX || j >= this.sizeY || i >= this.sizeZ || (imageInt == null || imageInt.getPixel(k, j, i) != (float)n8) && imageInt != null || !((d5 = (double)((n - k) * (n - k) + (n2 - j) * (n2 - j)) + (double)((n3 - i) * (n3 - i)) * d4) >= d) || !(d5 < d2)) continue;
                    dArray[n4] = this.getPixel(k, j, i);
                    ++n4;
                }
            }
        }
        if (n4 > 0) {
            ArrayUtil arrayUtil = new ArrayUtil(dArray);
            arrayUtil.setSize(n4);
            return arrayUtil;
        }
        return null;
    }

    public ArrayUtil getNeighborhoodLayerAngle(int n, int n2, int n3, float f, float f2, double d, Vector3D vector3D) {
        int n4 = 0;
        double d2 = f * f;
        double d3 = f2 * f2;
        double d4 = this.getScaleZ() / this.getScaleXY();
        double d5 = d4 * d4;
        int n5 = (int)Math.ceil(f2);
        int n6 = (int)Math.ceil(f2);
        int n7 = (int)Math.ceil((double)f2 / d4);
        double[] dArray = new double[(2 * n5 + 1) * (2 * n6 + 1) * (2 * n7 + 1)];
        Vector3D vector3D2 = new Vector3D(n, n2, n3);
        for (int i = n3 - n7; i <= n3 + n7; ++i) {
            for (int j = n2 - n6; j <= n2 + n6; ++j) {
                for (int k = n - n5; k <= n + n5; ++k) {
                    double d6;
                    double d7;
                    if (k < 0 || j < 0 || i < 0 || k >= this.sizeX || j >= this.sizeY || i >= this.sizeZ || !((d7 = (double)((n - k) * (n - k) + (n2 - j) * (n2 - j)) + (double)((n3 - i) * (n3 - i)) * d5) >= d2) || !(d7 < d3) || !((d6 = vector3D.angleDegrees(new Vector3D(k - n, j - n2, i - n3))) < d)) continue;
                    dArray[n4] = this.getPixel(k, j, i);
                    ++n4;
                }
            }
        }
        if (n4 > 0) {
            ArrayUtil arrayUtil = new ArrayUtil(dArray);
            arrayUtil.setSize(n4);
            return arrayUtil;
        }
        return null;
    }

    public ImageStack getImageStack() {
        return this.img.getImageStack();
    }

    public abstract void draw(Object3D var1, float var2);

    public abstract void setPixel(int var1, float var2);

    public abstract void setPixel(Point3D var1, float var2);

    public abstract void setPixel(int var1, int var2, int var3, float var4);

    public abstract void setPixel(int var1, int var2, float var3);

    public abstract Object getArray1D();

    public abstract Object getArray1D(int var1);

    public void setTitle(String string) {
        this.title = string;
        if (this.img != null) {
            this.img.setTitle(string);
        }
    }

    public Calibration getCalibration() {
        if (this.img == null) {
            return null;
        }
        return this.img.getCalibration();
    }

    public void setCalibration(Calibration calibration) {
        if (this.img != null) {
            this.img.setCalibration(calibration);
        }
    }

    public void setScale(double d, double d2, String string) {
        if (this.img != null) {
            Calibration calibration = this.img.getCalibration();
            calibration.pixelDepth = d2;
            calibration.pixelHeight = d;
            calibration.pixelWidth = d;
            calibration.setUnit(string);
        }
    }

    public void setScale(ImageHandler imageHandler) {
        if (this.img != null) {
            Calibration calibration = imageHandler.getImagePlus().getCalibration().copy();
            this.img.setCalibration(calibration);
        }
    }

    public void setOffset(ImageHandler imageHandler) {
        this.offsetX = imageHandler.offsetX;
        this.offsetY = imageHandler.offsetY;
        this.offsetZ = imageHandler.offsetZ;
    }

    public double getScaleXY() {
        if (this.img != null) {
            Calibration calibration = this.img.getCalibration();
            return calibration.pixelWidth;
        }
        return 1.0;
    }

    public String getUnit() {
        if (this.img != null) {
            Calibration calibration = this.img.getCalibration();
            return calibration.getUnit();
        }
        return "";
    }

    public double getScaleZ() {
        if (this.img != null) {
            Calibration calibration = this.img.getCalibration();
            return calibration.pixelDepth;
        }
        return 1.0;
    }

    public static ImageHandler wrap(ImagePlus imagePlus) {
        switch (imagePlus.getBitDepth()) {
            case 8: {
                return new ImageByte(imagePlus);
            }
            case 16: {
                return new ImageShort(imagePlus);
            }
            case 32: {
                return new ImageFloat(imagePlus);
            }
        }
        return null;
    }

    public ImageHandler createSameDimensions() {
        if (this instanceof ImageByte) {
            ImageStack imageStack = ImageStack.create((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)8);
            return new ImageByte(imageStack);
        }
        if (this instanceof ImageShort) {
            ImageStack imageStack = ImageStack.create((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)16);
            return new ImageShort(imageStack);
        }
        if (this instanceof ImageFloat) {
            ImageStack imageStack = ImageStack.create((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)32);
            return new ImageFloat(imageStack);
        }
        return null;
    }

    public static ImageHandler wrap(ImageStack imageStack) {
        switch (imageStack.getBitDepth()) {
            case 8: {
                return new ImageByte(imageStack);
            }
            case 16: {
                return new ImageShort(imageStack);
            }
            case 32: {
                return new ImageFloat(imageStack);
            }
        }
        return null;
    }

    public static ImageHandler openImage(File file) throws Exception {
        Opener opener = new Opener();
        opener.setSilentMode(true);
        ImagePlus imagePlus = opener.openImage(file.getAbsolutePath());
        imagePlus.setTitle(file.getName());
        imagePlus.setTitle(imagePlus.getShortTitle());
        switch (imagePlus.getBitDepth()) {
            case 8: {
                return new ImageByte(imagePlus);
            }
            case 16: {
                return new ImageShort(imagePlus);
            }
            case 32: {
                return new ImageFloat(imagePlus);
            }
        }
        return null;
    }

    public static ImageHandler newBlankImageHandler(String string, ImageHandler imageHandler) {
        switch (imageHandler.img.getBitDepth()) {
            case 8: {
                return new ImageByte(string, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
            }
            case 16: {
                return new ImageShort(string, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
            }
            case 32: {
                return new ImageFloat(string, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
            }
        }
        return null;
    }

    public ImageHandler addImage(ImageHandler imageHandler, float f, float f2) {
        if (!this.sameDimentions(imageHandler)) {
            return null;
        }
        ImageFloat imageFloat = new ImageFloat("res", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            imageFloat.setPixel(i, f * this.getPixel(i) + f2 * imageHandler.getPixel(i));
        }
        return imageFloat;
    }

    public ImageHandler multiplyImage(ImageHandler imageHandler, float f) {
        ImageFloat imageFloat = new ImageFloat("multiply", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            imageFloat.setPixel(i, f * this.getPixel(i) * imageHandler.getPixel(i));
        }
        return imageFloat;
    }

    public ImageHandler divideImage(ImageHandler imageHandler, float f) {
        ImageFloat imageFloat = new ImageFloat("divide", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            imageFloat.setPixel(i, this.getPixel(i) / (imageHandler.getPixel(i) * f));
        }
        return imageFloat;
    }

    public void addValue(float f) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            this.setPixel(i, this.getPixel(i) + f);
        }
    }

    public ImageHandler duplicate() {
        return ImageHandler.wrap(this.img.duplicate());
    }

    public abstract ImageHandler deleteSlices(int var1, int var2);

    public abstract void trimSlices(int var1, int var2);

    public abstract void erase();

    public abstract void fill(double var1);

    public abstract boolean isOpened();

    public boolean isVisible() {
        return this.img != null && this.img.isVisible();
    }

    public void updateDisplay() {
        if (this.isVisible()) {
            this.img.updateAndRepaintWindow();
        }
    }

    public double[] getMinAndMaxArray(ArrayList<? extends Point3D> arrayList) {
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (Point3D point3D : arrayList) {
            double d3 = this.getPixel(point3D);
            if (d3 > d2) {
                d2 = d3;
            }
            if (!(d3 < d)) continue;
            d = d3;
        }
        return new double[]{d, d2};
    }

    protected abstract void getMinAndMax(ImageInt var1);

    public synchronized double getMin(ImageInt imageInt) {
        return this.getImageStats(imageInt).getMin();
    }

    public synchronized double getMax(ImageInt imageInt) {
        return this.getImageStats(imageInt).getMax();
    }

    public double getMin() {
        return this.getMin(new BlankMask(this));
    }

    public double getMax() {
        return this.getMax(new BlankMask(this));
    }

    public double getMean(ImageInt imageInt) {
        return this.getImageStats(imageInt).getMean();
    }

    public double getMean() {
        return this.getImageStats(new BlankMask(this)).getMean();
    }

    public double[] extractLine(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n4 - n;
        int n8 = n5 - n2;
        int n9 = n6 - n3;
        int n10 = Math.abs(n7) + Math.abs(n8) + Math.abs(n9);
        double[] dArray = new double[n10];
        float f = (float)n7 / (float)n10;
        float f2 = (float)n8 / (float)n10;
        float f3 = (float)n9 / (float)n10;
        if (!this.contains(n4, n5, n6) || !this.contains(n, n2, n3)) {
            for (int i = 0; i < n10; ++i) {
                float f4 = (float)n + (float)i * f;
                float f5 = (float)n2 + (float)i * f2;
                float f6 = (float)n3 + (float)i * f3;
                if (!this.contains(f4, f5, f6)) {
                    if (i == 0) {
                        dArray[i] = 0.0;
                        continue;
                    }
                    dArray[i] = dArray[i - 1];
                    continue;
                }
                dArray[i] = bl ? (double)this.getPixel(f4, f5, f6) : (double)this.getPixel(Math.round(f4), Math.round(f5), Math.round(f6));
            }
        } else {
            for (int i = 0; i < n10; ++i) {
                float f7 = (float)n + (float)i * f;
                float f8 = (float)n2 + (float)i * f2;
                float f9 = (float)n3 + (float)i * f3;
                dArray[i] = bl ? (double)this.getPixel(f7, f8, f9) : (double)this.getPixel(Math.round(f7), Math.round(f8), Math.round(f9));
            }
        }
        return dArray;
    }

    public void setMinAndMax(ImageInt imageInt) {
        if (!this.isOpened()) {
            return;
        }
        this.getMinAndMax(imageInt);
        ImageStats imageStats = this.getImageStats(imageInt);
        this.img.getProcessor().setMinAndMax(imageStats.getMin(), imageStats.getMax());
    }

    protected void getMoments(ImageInt imageInt) {
        ImageStats imageStats;
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        if ((imageStats = this.getImageStats(imageInt)).momentsSet()) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f) continue;
                double d4 = this.getPixel(j, i);
                d2 += d4;
                d += d4 * d4;
                d3 += 1.0;
            }
        }
        if (d3 != 0.0) {
            imageStats.setMoments(d2 /= d3, d, Math.sqrt(d / d3 - d2 * d2));
        } else {
            imageStats.setMoments(0.0, 0.0, 0.0);
        }
    }

    public void setMinAndMax(float f, float f2) {
        if (this.img != null) {
            this.img.getProcessor().setMinAndMax((double)f, (double)f2);
        }
    }

    public int[] getHistogram(ImageInt imageInt) {
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        ImageStats imageStats = this.getImageStats(imageInt);
        return imageStats.getHisto256();
    }

    public int[] getHistogram() {
        return this.getHistogram(null);
    }

    public int[] getHistogram(ImageInt imageInt, int n, double d, double d2) {
        return this.getHisto(imageInt, n, d, d2);
    }

    public int[] getHistogram(ArrayList<? extends Point3D> arrayList, int n, double d, double d2) {
        int[] nArray = new int[n];
        double d3 = (double)n / (d2 - d);
        for (Point3D point3D : arrayList) {
            int n2 = (int)(((double)this.getPixel(point3D) - d) * d3);
            if (n2 >= 255) {
                nArray[255] = nArray[255] + 1;
                continue;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
        return nArray;
    }

    protected abstract int[] getHisto(ImageInt var1);

    protected abstract int[] getHisto(ImageInt var1, int var2, double var3, double var5);

    public double getPercentile(double d, ImageInt imageInt) {
        ImageStats imageStats = this.getImageStats(imageInt);
        int[] nArray = imageStats.getHisto256();
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        double d2 = (double)n * d;
        if (d2 >= (double)n) {
            return imageStats.getMin();
        }
        n = nArray[255];
        int n3 = 255;
        while ((double)n < d2 && n3 > 0) {
            n += nArray[--n3];
        }
        double d3 = nArray[n3] != 0 ? ((double)n - d2) / (double)nArray[n3] : 0.0;
        return (double)((float)((double)n3 + d3)) * imageStats.getHisto256BinSize() + imageStats.getMin();
    }

    public void show() {
        this.setMinAndMax(null);
        this.img.show();
    }

    public void show(String string) {
        this.setMinAndMax(null);
        this.img.setTitle(string);
        this.img.show();
    }

    public void showDuplicate(String string) {
        this.setMinAndMax(null);
        ImagePlus imagePlus = this.img.duplicate();
        if (string != null) {
            imagePlus.setTitle(string);
        } else {
            imagePlus.setTitle(this.title);
        }
        imagePlus.setCalibration(this.img.getCalibration());
        imagePlus.show();
    }

    public void closeImagePlus() {
        if (this.img != null) {
            try {
                this.img.close();
            }
            catch (Exception exception) {
                exceptionPrinter.print(exception, "", false);
            }
        }
        this.img = null;
    }

    public void flush() {
        if (this.img != null) {
            try {
                this.img.hide();
                this.img.flush();
            }
            catch (Exception exception) {
                exceptionPrinter.print(exception, "", false);
            }
        }
        this.img = null;
        this.stats = new HashMap();
        this.flushPixels();
    }

    public synchronized ImageStats getImageStats(ImageInt imageInt) {
        ImageStats imageStats;
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        if ((imageStats = this.stats.get(imageInt)) == null) {
            imageStats = new ImageStats(this, imageInt);
            this.stats.put(imageInt, imageStats);
        }
        return imageStats;
    }

    public synchronized void resetStats(ImageInt imageInt) {
        if (imageInt == null) {
            imageInt = new BlankMask(this);
        }
        this.stats.remove(imageInt);
    }

    public void hide() {
        if (this.img != null) {
            this.img.hide();
        }
    }

    protected abstract void flushPixels();

    public void save(String string) {
        FileSaver fileSaver = new FileSaver(this.img);
        this.setMinAndMax(null);
        fileSaver.saveAsTiffStack(string + File.separator + this.img.getTitle());
    }

    public void saveThumbNail(int n, int n2, String string) {
        ZProjector zProjector = new ZProjector(this.img);
        zProjector.setMethod(1);
        zProjector.doProjection();
        ImagePlus imagePlus = zProjector.getProjection();
        ImageProcessor imageProcessor = imagePlus.getProcessor().resize(n, n2, true);
        imageProcessor.convertToByte(true);
        imageProcessor.setMinAndMax(0.0, 255.0);
        imagePlus = new ImagePlus(this.img.getShortTitle() + "_tmb", imageProcessor);
        FileSaver fileSaver = new FileSaver(imagePlus);
        FileSaver.setJpegQuality((int)75);
        fileSaver.saveAsJpeg(string + File.separator + imagePlus.getTitle() + ".jpg");
    }

    public byte[] getThumbNail(int n, int n2) {
        return this.getThumbNail(n, n2, null);
    }

    public byte[] getThumbNail(int n, int n2, ImageInt imageInt) {
        ImagePlus imagePlus;
        ZProjector zProjector;
        this.setMinAndMax(imageInt);
        if (this.sizeZ > 1) {
            zProjector = new ZProjector(this.img);
            zProjector.setMethod(1);
            zProjector.doProjection();
            imagePlus = zProjector.getProjection();
        } else {
            imagePlus = this.img;
        }
        zProjector = imagePlus.getProcessor().resize(n, n2, true);
        zProjector = zProjector.convertToByte(true);
        zProjector.setMinAndMax(zProjector.getMin(), zProjector.getMax());
        imagePlus = new ImagePlus(this.img.getShortTitle() + "_tmb", (ImageProcessor)zProjector);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)imagePlus.getBufferedImage(), "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            Logger.getLogger(ImageHandler.class.getName()).log(Level.SEVERE, null, iOException);
            return null;
        }
    }

    public byte[] getBinaryData() throws Exception, OutOfMemoryError {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInfo fileInfo = this.img.getFileInfo();
        TiffEncoder tiffEncoder = new TiffEncoder(fileInfo);
        try {
            tiffEncoder.write((OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, "", true);
            return null;
        }
    }

    public boolean touchBorders(int n, int n2, int n3) {
        return n == 0 || n2 == 0 || n3 == 0 || n == this.sizeX - 1 || n2 == this.sizeY - 1 || n3 == this.sizeZ - 1;
    }

    public abstract void eraseOutsideMask(ImageInt var1);

    public abstract ImageByte threshold(float var1, boolean var2, boolean var3);

    public ImageByte thresholdAboveInclusive(float f) {
        return this.threshold(f, false, false);
    }

    public ImageByte thresholdAboveExclusive(float f) {
        return this.threshold(f, false, true);
    }

    public abstract void thresholdCut(float var1, boolean var2, boolean var3);

    public abstract ImageHandler cropRadius(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);

    public abstract ImageHandler crop3D(String var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract ImageHandler[] crop3D(TreeMap<Integer, int[]> var1);

    public abstract ImageHandler crop3DMask(String var1, ImageInt var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static ImageShort merge3DBinary(ImageInt[] imageIntArray, int n, int n2, int n3) {
        ImageShort imageShort = new ImageShort("merge", n, n2, n3);
        if (imageIntArray == null || imageIntArray.length == 0 || imageIntArray[0] == null) {
            return imageShort;
        }
        for (int i = 0; i < imageIntArray.length; ++i) {
            short s = (short)(i + 1);
            for (int j = 0; j < imageIntArray[i].sizeZ; ++j) {
                for (int k = 0; k < imageIntArray[i].sizeY; ++k) {
                    for (int i2 = 0; i2 < imageIntArray[i].sizeX; ++i2) {
                        if (imageIntArray[i].getPixel(i2, k, j) == 0.0f) continue;
                        int n4 = i2 + imageIntArray[i].offsetX;
                        int n5 = k + imageIntArray[i].offsetY;
                        int n6 = j + imageIntArray[i].offsetZ;
                        if (n6 < 0 || n6 >= n3 || n4 < 0 || n4 >= n || n5 < 0 || n5 >= n2) continue;
                        imageShort.pixels[n6][n4 + n5 * n] = s;
                    }
                }
            }
        }
        return imageShort;
    }

    public static ImageShort merge3D(ImageInt[] imageIntArray, int n, int n2, int n3) {
        ImageShort imageShort = new ImageShort("merge", n, n2, n3);
        if (imageIntArray == null || imageIntArray.length == 0 || imageIntArray[0] == null) {
            return imageShort;
        }
        int n4 = 1;
        for (int i = 0; i < imageIntArray.length; ++i) {
            short s = (short)imageIntArray[i].getMinAboveValue(0.0f);
            short s2 = (short)imageIntArray[i].getMax();
            for (int j = 0; j < imageIntArray[i].sizeZ; ++j) {
                for (int k = 0; k < imageIntArray[i].sizeY; ++k) {
                    for (int i2 = 0; i2 < imageIntArray[i].sizeX; ++i2) {
                        if (imageIntArray[i].getPixel(i2, k, j) == 0.0f) continue;
                        int n5 = imageIntArray[i].getPixelInt(i2, k, j);
                        int n6 = i2 + imageIntArray[i].offsetX;
                        int n7 = k + imageIntArray[i].offsetY;
                        int n8 = j + imageIntArray[i].offsetZ;
                        if (n8 < 0 || n8 >= n3 || n6 < 0 || n6 >= n || n7 < 0 || n7 >= n2) continue;
                        imageShort.pixels[n8][n6 + n7 * n] = (short)(n5 - s + n4);
                    }
                }
            }
            n4 += s2 - s + 1;
        }
        return imageShort;
    }

    public void insert(ImageHandler imageHandler, int n, int n2, int n3, boolean bl) {
        int n4 = Math.max(n, 0);
        int n5 = Math.max(n2, 0);
        int n6 = Math.max(n3, 0);
        int n7 = Math.min(n + imageHandler.sizeX, this.sizeX);
        int n8 = Math.min(n2 + imageHandler.sizeY, this.sizeY);
        int n9 = Math.min(n3 + imageHandler.sizeZ, this.sizeZ);
        for (int i = n6; i < n9; ++i) {
            for (int j = n4; j < n7; ++j) {
                for (int k = n5; k < n8; ++k) {
                    float f = imageHandler.getPixel(j - n, k - n2, i - n3);
                    if (bl) {
                        float f2 = this.getPixel(j - n, k - n2, i - n3);
                        this.setPixel(j, k, i, 0.5f * (f2 + f));
                        continue;
                    }
                    this.setPixel(j, k, i, f);
                }
            }
        }
    }

    public abstract ImageHandler resize(int var1, int var2, int var3);

    public abstract ImageHandler resample(int var1, int var2, int var3, int var4);

    public abstract ImageHandler resample(int var1, int var2);

    protected abstract ImageFloat normalize_(ImageInt var1, double var2);

    public abstract ImageFloat normalize(double var1, double var3);

    public ImageFloat normalize(ImageInt imageInt, double d) {
        return this.normalize_(imageInt, d);
    }

    public abstract void invert(ImageInt var1);

    public void invert() {
        this.invert(null);
    }

    public ImageFloat substractImage(ImageHandler imageHandler) {
        if (!this.sameDimentions(imageHandler)) {
            return null;
        }
        ImageFloat imageFloat = ImageFloat.newBlankImageFloat(this.title + "-" + imageHandler.title, this);
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                imageFloat.pixels[i][j] = this.getPixel(j, i) - imageHandler.getPixel(j, i);
            }
        }
        return imageFloat;
    }

    public static ImagePlus getHyperStack(String string, ImageHandler[] imageHandlerArray) {
        ImageHandler.homogenizeBitDepth(imageHandlerArray);
        ImageStack imageStack = new ImageStack(imageHandlerArray[0].sizeX, imageHandlerArray[0].sizeY, imageHandlerArray[0].sizeZ * imageHandlerArray.length);
        int n = 1;
        ImageHandler[] imageHandlerArray2 = imageHandlerArray;
        int n2 = imageHandlerArray2.length;
        for (int i = 0; i < n2; ++i) {
            ImageHandler imageHandler = imageHandlerArray2[i];
            if (imageHandler == null) continue;
            imageHandler.setMinAndMax(null);
        }
        for (int i = 1; i <= imageHandlerArray[0].sizeZ; ++i) {
            for (n2 = 0; n2 < imageHandlerArray.length; ++n2) {
                imageStack.setPixels(imageHandlerArray[n2].img.getStack().getPixels(i), n);
                ++n;
            }
        }
        ImagePlus imagePlus = new ImagePlus();
        imagePlus.setStack(imageStack, imageHandlerArray.length, imageHandlerArray[0].sizeZ, 1);
        imagePlus.setTitle(string);
        imagePlus.setOpenAsHyperStack(true);
        return imagePlus;
    }

    public static void homogenizeBitDepth(ImageHandler[] imageHandlerArray) {
        block6: {
            boolean bl;
            block5: {
                bl = false;
                boolean bl2 = false;
                for (ImageHandler imageHandler : imageHandlerArray) {
                    if (imageHandler instanceof ImageShort) {
                        bl = true;
                        continue;
                    }
                    if (!(imageHandler instanceof ImageFloat)) continue;
                    bl2 = true;
                }
                if (!bl2) break block5;
                for (int i = 0; i < imageHandlerArray.length; ++i) {
                    if (imageHandlerArray[i] instanceof ImageByte) {
                        imageHandlerArray[i] = ((ImageByte)imageHandlerArray[i]).convertToFloat(false);
                    }
                    if (!(imageHandlerArray[i] instanceof ImageShort)) continue;
                    imageHandlerArray[i] = ((ImageShort)imageHandlerArray[i]).convertToFloat(false);
                }
                break block6;
            }
            if (!bl) break block6;
            for (int i = 0; i < imageHandlerArray.length; ++i) {
                if (!(imageHandlerArray[i] instanceof ImageByte)) continue;
                imageHandlerArray[i] = ((ImageByte)imageHandlerArray[i]).convertToShort(false);
            }
        }
    }

    public static void convertToByte(ImageHandler[] imageHandlerArray) {
        for (int i = 0; i < imageHandlerArray.length; ++i) {
            if (imageHandlerArray[i] instanceof ImageShort) {
                imageHandlerArray[i] = ((ImageShort)imageHandlerArray[i]).convertToByte(true);
            }
            if (!(imageHandlerArray[i] instanceof ImageFloat)) continue;
            imageHandlerArray[i] = ((ImageFloat)imageHandlerArray[i]).convertToByte(true);
        }
    }

    public static void convertToByte(ImageHandler imageHandler) {
        if (imageHandler instanceof ImageShort) {
            imageHandler = ((ImageShort)imageHandler).convertToByte(true);
        }
        if (imageHandler instanceof ImageFloat) {
            imageHandler = ((ImageFloat)imageHandler).convertToByte(true);
        }
    }

    public abstract void intersectMask(ImageInt var1);

    public ImageFloat getDistanceMap(float f, float f2, float f3, boolean bl, int n) {
        return EDT.run(this, f, f2, f3, bl, n);
    }

    public void set332RGBLut() {
        IndexColorModel indexColorModel = this.get332RGB();
        this.img.getChannelProcessor().setColorModel((ColorModel)indexColorModel);
        this.img.getStack().setColorModel((ColorModel)indexColorModel);
        this.img.updateAndRepaintWindow();
    }

    public void setGraysLut() {
        IndexColorModel indexColorModel = this.getGrays();
        this.img.getChannelProcessor().setColorModel((ColorModel)indexColorModel);
        this.img.getStack().setColorModel((ColorModel)indexColorModel);
        this.img.updateAndRepaintWindow();
    }

    private IndexColorModel get332RGB() {
        FileInfo fileInfo = new FileInfo();
        fileInfo.reds = new byte[256];
        fileInfo.greens = new byte[256];
        fileInfo.blues = new byte[256];
        fileInfo.lutSize = 256;
        for (int i = 0; i < 256; ++i) {
            fileInfo.reds[i] = (byte)(i & 0xE0);
            fileInfo.greens[i] = (byte)(i << 3 & 0xE0);
            fileInfo.blues[i] = (byte)(i << 6 & 0xC0);
        }
        return new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
    }

    private IndexColorModel getGrays() {
        FileInfo fileInfo = new FileInfo();
        fileInfo.reds = new byte[256];
        fileInfo.greens = new byte[256];
        fileInfo.blues = new byte[256];
        fileInfo.lutSize = 256;
        for (int i = 0; i < 256; ++i) {
            fileInfo.reds[i] = (byte)i;
            fileInfo.greens[i] = (byte)i;
            fileInfo.blues[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
    }

    public float getMinAboveValue(float f) {
        float f2 = Float.MAX_VALUE;
        for (int i = 0; i < this.sizeXYZ; ++i) {
            float f3 = this.getPixel(i);
            if (!(f3 > f) || !(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public double[] radialDistribution(int n, int n2, int n3, int n4, ImageInt imageInt) {
        ArrayUtil arrayUtil;
        int n5;
        int n6;
        double[] dArray = new double[2 * n4 + 1];
        int n7 = 0;
        for (n6 = -n4; n6 <= 0; ++n6) {
            n5 = -n6;
            arrayUtil = this.getNeighborhoodLayer(n, n2, n3, n5, n5 + 1, imageInt);
            dArray[n7] = arrayUtil != null ? arrayUtil.getMean() : Double.NaN;
            ++n7;
        }
        for (n6 = 1; n6 <= n4; ++n6) {
            n5 = n6;
            arrayUtil = this.getNeighborhoodLayer(n, n2, n3, n5, n5 + 1, imageInt);
            dArray[n7] = arrayUtil != null ? arrayUtil.getMean() : Double.NaN;
            ++n7;
        }
        return dArray;
    }

    public double[] radialDistribution(int n, int n2, int n3, int n4) {
        return this.radialDistribution(n, n2, n3, n4, null);
    }

    public boolean hasOneValue(float f) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            if (this.getPixel(i) != f) continue;
            return true;
        }
        return false;
    }
}

