/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.ElectricPotential;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsElectricPotentialEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsElectricPotential implements Enumeration
{
    YOTTAV("YV"),
    ZETTAV("ZV"),
    EXAV("EV"),
    PETAV("PV"),
    TERAV("TV"),
    GIGAV("GV"),
    MEGAV("MV"),
    KV("kV"),
    HV("hV"),
    DAV("daV"),
    V("V"),
    DV("dV"),
    CV("cV"),
    MV("mV"),
    MICROV("\u00b5V"),
    NV("nV"),
    PV("pV"),
    FV("fV"),
    AV("aV"),
    ZV("zV"),
    YV("yV");

    private final String value;

    private UnitsElectricPotential(String value) {
        this.value = value;
    }

    public static UnitsElectricPotential fromString(String value) throws EnumerationException {
        if ("YV".equals(value)) {
            return YOTTAV;
        }
        if ("ZV".equals(value)) {
            return ZETTAV;
        }
        if ("EV".equals(value)) {
            return EXAV;
        }
        if ("PV".equals(value)) {
            return PETAV;
        }
        if ("TV".equals(value)) {
            return TERAV;
        }
        if ("GV".equals(value)) {
            return GIGAV;
        }
        if ("MV".equals(value)) {
            return MEGAV;
        }
        if ("kV".equals(value)) {
            return KV;
        }
        if ("hV".equals(value)) {
            return HV;
        }
        if ("daV".equals(value)) {
            return DAV;
        }
        if ("V".equals(value)) {
            return V;
        }
        if ("dV".equals(value)) {
            return DV;
        }
        if ("cV".equals(value)) {
            return CV;
        }
        if ("mV".equals(value)) {
            return MV;
        }
        if ("\u00b5V".equals(value)) {
            return MICROV;
        }
        if ("nV".equals(value)) {
            return NV;
        }
        if ("pV".equals(value)) {
            return PV;
        }
        if ("fV".equals(value)) {
            return FV;
        }
        if ("aV".equals(value)) {
            return AV;
        }
        if ("zV".equals(value)) {
            return ZV;
        }
        if ("yV".equals(value)) {
            return YV;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsElectricPotential.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PrimitiveNumber> ElectricPotential create(T newValue, UnitsElectricPotential newUnit) {
        ElectricPotential theQuantity = null;
        try {
            theQuantity = UnitsElectricPotentialEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Number> ElectricPotential create(T newValue, UnitsElectricPotential newUnit) {
        ElectricPotential theQuantity = null;
        try {
            theQuantity = UnitsElectricPotentialEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

