/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Temperature;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsTemperature;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsTemperatureEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsTemperatureEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsTemperatureEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*\u00b0C\\s*", "\u00b0C");
        p.put("^\\s*\u00b0F\\s*", "\u00b0F");
        p.put("^\\s*K\\s*", "K");
        p.put("^\\s*\u00b0R\\s*", "\u00b0R");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsTemperature.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsTemperature", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Temperature inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Temperature> getBaseUnit(UnitsTemperature inModelUnit) {
        Unit<Temperature> theResult = UNITS.KELVIN;
        if (UnitsTemperature.DEGREEC.equals(inModelUnit)) {
            theResult = UNITS.DEGREEC;
        }
        if (UnitsTemperature.DEGREEF.equals(inModelUnit)) {
            theResult = UNITS.DEGREEF;
        }
        if (UnitsTemperature.K.equals(inModelUnit)) {
            theResult = UNITS.K;
        }
        if (UnitsTemperature.DEGREER.equals(inModelUnit)) {
            theResult = UNITS.DEGREER;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Temperature getQuantity(T inValue, UnitsTemperature inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Temperature((Number)typedValue.getValue(), UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Temperature((Number)typedValue.getValue(), UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Temperature((Number)typedValue.getValue(), UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Temperature((Number)typedValue.getValue(), UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Temperature((Number)typedValue.getValue(), UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Temperature((Number)typedValue.getValue(), UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Temperature((Number)typedValue.getValue(), UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Temperature' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsTemperatureEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Temperature getQuantity(T inValue, UnitsTemperature inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Temperature(doubleValue, UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Temperature(intValue, UnitsTemperatureEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Temperature' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsTemperatureEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsTemperature.class;
    }
}

