/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix1D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = 1L;
    protected int[] elements;

    public DenseIntMatrix1D(int[] values) {
        this(values.length);
        this.assign(values);
    }

    public DenseIntMatrix1D(int size) {
        this.setUp(size);
        this.elements = new int[size];
    }

    public DenseIntMatrix1D(int size, int[] elements, int zero, int stride, boolean isView) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int a = f.apply(DenseIntMatrix1D.this.elements[idx]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride]));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero]);
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride]));
                ++i;
            }
        }
        return a;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int idx = DenseIntMatrix1D.this.zero + indexElements[firstIdx] * DenseIntMatrix1D.this.stride;
                        int a = f.apply(DenseIntMatrix1D.this.elements[idx]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            idx = DenseIntMatrix1D.this.zero + indexElements[i] * DenseIntMatrix1D.this.stride;
                            int elem = DenseIntMatrix1D.this.elements[idx];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero + indexElements[0] * this.stride;
            a = f.apply(this.elements[idx]);
            int i = 1;
            while (i < size) {
                idx = this.zero + indexElements[i] * this.stride;
                int elem = this.elements[idx];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public int aggregate(IntMatrix1D other, final IntIntFunction aggr, final IntIntFunction f) {
        if (!(other instanceof DenseIntMatrix1D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkSize(other);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final int[] elemsOther = (int[])other.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int a = f.apply(DenseIntMatrix1D.this.elements[idx], elemsOther[idxOther]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride], elemsOther[idxOther += strideOther]));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero], elemsOther[zeroOther]);
            int idx = this.zero;
            int idxOther = zeroOther;
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride], elemsOther[idxOther += strideOther]));
                ++i;
            }
        }
        return a;
    }

    @Override
    public IntMatrix1D assign(final IntFunction function) {
        int nthreads;
        int multiplicator;
        if (function instanceof IntMult) {
            multiplicator = ((IntMult)function).multiplicator;
            if (multiplicator == 1) {
                return this;
            }
        } else {
            multiplicator = 0;
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        if (function instanceof IntMult) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseIntMatrix1D.this.elements[n] = DenseIntMatrix1D.this.elements[n] * multiplicator;
                                idx += DenseIntMatrix1D.this.stride;
                                ++k;
                            }
                        } else {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                DenseIntMatrix1D.this.elements[idx] = function.apply(DenseIntMatrix1D.this.elements[idx]);
                                idx += DenseIntMatrix1D.this.stride;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero - this.stride;
            if (function instanceof IntMult) {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = this.elements[idx] * multiplicator;
                }
            } else {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = function.apply(this.elements[idx]);
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix1D assign(final IntProcedure cond, final IntFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (cond.apply(DenseIntMatrix1D.this.elements[idx])) {
                                DenseIntMatrix1D.this.elements[idx] = function.apply(DenseIntMatrix1D.this.elements[idx]);
                            }
                            idx += DenseIntMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = function.apply(this.elements[idx]);
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public IntMatrix1D assign(final IntProcedure cond, final int value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (cond.apply(DenseIntMatrix1D.this.elements[idx])) {
                                DenseIntMatrix1D.this.elements[idx] = value;
                            }
                            idx += DenseIntMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = value;
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public IntMatrix1D assign(final int value) {
        final int[] elems = this.elements;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            elems[idx] = value;
                            idx += DenseIntMatrix1D.this.stride;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                elems[idx] = value;
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public IntMatrix1D assign(final int[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DenseIntMatrix1D.this.elements[idx] = values[i];
                            idx += DenseIntMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                this.elements[idx] = values[i];
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public IntMatrix1D assign(IntMatrix1D source) {
        if (!(source instanceof DenseIntMatrix1D)) {
            super.assign(source);
            return this;
        }
        DenseIntMatrix1D other = (DenseIntMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            IntMatrix1D c = other.copy();
            if (!(c instanceof DenseIntMatrix1D)) {
                super.assign(source);
                return this;
            }
            other = (DenseIntMatrix1D)c;
        }
        final int[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            DenseIntMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            idx += DenseIntMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                this.elements[idx] = elemsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
        return this;
    }

    @Override
    public IntMatrix1D assign(IntMatrix1D y, final IntIntFunction function) {
        if (!(y instanceof DenseIntMatrix1D)) {
            super.assign(y, function);
            return this;
        }
        this.checkSize(y);
        final int zeroOther = (int)y.index(0);
        final int strideOther = y.stride();
        final int[] elemsOther = (int[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        if (function == IntFunctions.mult) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseIntMatrix1D.this.elements[n] = DenseIntMatrix1D.this.elements[n] * elemsOther[idxOther];
                                idx += DenseIntMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == IntFunctions.div) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseIntMatrix1D.this.elements[n] = DenseIntMatrix1D.this.elements[n] / elemsOther[idxOther];
                                idx += DenseIntMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function instanceof IntPlusMultFirst) {
                            int multiplicator = ((IntPlusMultFirst)function).multiplicator;
                            if (multiplicator == 0) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseIntMatrix1D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseIntMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == 1) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseIntMatrix1D.this.elements[n] = DenseIntMatrix1D.this.elements[n] + elemsOther[idxOther];
                                    idx += DenseIntMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == -1) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseIntMatrix1D.this.elements[idx] = elemsOther[idxOther] - DenseIntMatrix1D.this.elements[idx];
                                    idx += DenseIntMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseIntMatrix1D.this.elements[idx] = multiplicator * DenseIntMatrix1D.this.elements[idx] + elemsOther[idxOther];
                                    idx += DenseIntMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            }
                        } else if (function instanceof IntPlusMultSecond) {
                            int multiplicator = ((IntPlusMultSecond)function).multiplicator;
                            if (multiplicator == 0) {
                                return;
                            }
                            if (multiplicator == 1) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseIntMatrix1D.this.elements[n] = DenseIntMatrix1D.this.elements[n] + elemsOther[idxOther];
                                    idx += DenseIntMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == -1) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseIntMatrix1D.this.elements[n] = DenseIntMatrix1D.this.elements[n] - elemsOther[idxOther];
                                    idx += DenseIntMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseIntMatrix1D.this.elements[n] = DenseIntMatrix1D.this.elements[n] + multiplicator * elemsOther[idxOther];
                                    idx += DenseIntMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            }
                        } else {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                DenseIntMatrix1D.this.elements[idx] = function.apply(DenseIntMatrix1D.this.elements[idx], elemsOther[idxOther]);
                                idx += DenseIntMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            if (function == IntFunctions.mult) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] * elemsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == IntFunctions.div) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] / elemsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function instanceof IntPlusMultSecond) {
                int multiplicator = ((IntPlusMultSecond)function).multiplicator;
                if (multiplicator == 0) {
                    return this;
                }
                if (multiplicator == 1) {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + elemsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                } else if (multiplicator == -1) {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] - elemsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                } else {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + multiplicator * elemsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                }
            } else {
                int k = 0;
                while (k < this.size) {
                    this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (DenseIntMatrix1D.this.elements[idx] != 0) {
                                ++cardinality;
                            }
                            idx += DenseIntMatrix1D.this.stride;
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (this.elements[idx] != 0) {
                    ++cardinality;
                }
                idx += this.stride;
                ++i;
            }
        }
        return cardinality;
    }

    public int[] elements() {
        return this.elements;
    }

    @Override
    public void getNonZeros(IntArrayList indexList, IntArrayList valueList) {
        indexList.clear();
        valueList.clear();
        int idx = this.zero;
        int rem = this.size % 2;
        if (rem == 1) {
            int value = this.elements[idx];
            if (value != 0) {
                indexList.add(0);
                valueList.add(value);
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            int value = this.elements[idx];
            if (value != 0) {
                indexList.add(i);
                valueList.add(value);
            }
            if ((value = this.elements[idx += this.stride]) != 0) {
                indexList.add(i + 1);
                valueList.add(value);
            }
            idx += this.stride;
            i += 2;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList indexList, IntArrayList valueList) {
        indexList.clear();
        valueList.clear();
        int idx = this.zero;
        int rem = this.size % 2;
        if (rem == 1) {
            int value = this.elements[idx];
            if (value > 0) {
                indexList.add(0);
                valueList.add(value);
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            int value = this.elements[idx];
            if (value > 0) {
                indexList.add(i);
                valueList.add(value);
            }
            if ((value = this.elements[idx += this.stride]) > 0) {
                indexList.add(i + 1);
                valueList.add(value);
            }
            idx += this.stride;
            i += 2;
        }
    }

    @Override
    public void getNegativeValues(IntArrayList indexList, IntArrayList valueList) {
        indexList.clear();
        valueList.clear();
        int idx = this.zero;
        int rem = this.size % 2;
        if (rem == 1) {
            int value = this.elements[idx];
            if (value < 0) {
                indexList.add(0);
                valueList.add(value);
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            int value = this.elements[idx];
            if (value < 0) {
                indexList.add(i);
                valueList.add(value);
            }
            if ((value = this.elements[idx += this.stride]) < 0) {
                indexList.add(i + 1);
                valueList.add(value);
            }
            idx += this.stride;
            i += 2;
        }
    }

    @Override
    public int[] getMaxLocation() {
        int location = 0;
        int maxValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int maxValue = DenseIntMatrix1D.this.elements[idx];
                        int location = (idx - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            if (maxValue < DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride]) {
                                maxValue = DenseIntMatrix1D.this.elements[idx];
                                location = (idx - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                            }
                            ++i;
                        }
                        return new int[]{maxValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                location = results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        location = results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                if (maxValue < this.elements[idx += this.stride]) {
                    maxValue = this.elements[idx];
                    location = (idx - this.zero) / this.stride;
                }
                ++i;
            }
        }
        return new int[]{maxValue, location};
    }

    @Override
    public int[] getMinLocation() {
        int location = 0;
        int minValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int minValue = DenseIntMatrix1D.this.elements[idx];
                        int location = (idx - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            if (minValue > DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride]) {
                                minValue = DenseIntMatrix1D.this.elements[idx];
                                location = (idx - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                            }
                            ++i;
                        }
                        return new int[]{minValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                location = results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        location = results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                if (minValue > this.elements[idx += this.stride]) {
                    minValue = this.elements[idx];
                    location = (idx - this.zero) / this.stride;
                }
                ++i;
            }
        }
        return new int[]{minValue, location};
    }

    @Override
    public int getQuick(int index) {
        return this.elements[this.zero + index * this.stride];
    }

    @Override
    public IntMatrix1D like(int size) {
        return new DenseIntMatrix1D(size);
    }

    @Override
    public IntMatrix2D like2D(int rows, int columns) {
        return new DenseIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseIntMatrix2D M = new DenseIntMatrix2D(rows, columns);
        final int[] elemsOther = (int[])((IntMatrix2D)M).elements();
        final int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        final int rowStrideOther = M.rowStride();
        final int colStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, columns);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idxOther = zeroOther + c * colStrideOther;
                            int idx = DenseIntMatrix1D.this.zero + c * rows * DenseIntMatrix1D.this.stride;
                            int r = 0;
                            while (r < rows) {
                                elemsOther[idxOther] = DenseIntMatrix1D.this.elements[idx];
                                idxOther += rowStrideOther;
                                idx += DenseIntMatrix1D.this.stride;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int c = 0;
            while (c < columns) {
                int idxOther = zeroOther + c * colStrideOther;
                int r = 0;
                while (r < rows) {
                    elemsOther[idxOther] = this.elements[idx];
                    idxOther += rowStrideOther;
                    idx += this.stride;
                    ++r;
                }
                ++c;
            }
        }
        return M;
    }

    @Override
    public IntMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseIntMatrix3D M = new DenseIntMatrix3D(slices, rows, columns);
        final int[] elemsOther = (int[])((IntMatrix3D)M).elements();
        final int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        final int sliceStrideOther = M.sliceStride();
        final int rowStrideOther = M.rowStride();
        final int colStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < columns) {
                                int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                                int idx = DenseIntMatrix1D.this.zero + (s * rows * columns + c * rows) * DenseIntMatrix1D.this.stride;
                                int r = 0;
                                while (r < rows) {
                                    elemsOther[idxOther] = DenseIntMatrix1D.this.elements[idx];
                                    idxOther += rowStrideOther;
                                    idx += DenseIntMatrix1D.this.stride;
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int s = 0;
            while (s < slices) {
                int c = 0;
                while (c < columns) {
                    int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                    int r = 0;
                    while (r < rows) {
                        elemsOther[idxOther] = this.elements[idx];
                        idxOther += rowStrideOther;
                        idx += this.stride;
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
        }
        return M;
    }

    @Override
    public void setQuick(int index, int value) {
        this.elements[this.zero + index * this.stride] = value;
    }

    @Override
    public void swap(IntMatrix1D other) {
        DenseIntMatrix1D y;
        if (!(other instanceof DenseIntMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseIntMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        final int[] elemsOther = y.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            int tmp = DenseIntMatrix1D.this.elements[idx];
                            DenseIntMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            elemsOther[idxOther] = tmp;
                            idx += DenseIntMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                int tmp = this.elements[idx];
                this.elements[idx] = elemsOther[idxOther];
                elemsOther[idxOther] = tmp;
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
    }

    @Override
    public void toArray(int[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    @Override
    public int zDotProduct(IntMatrix1D y) {
        if (!(y instanceof DenseIntMatrix1D)) {
            return super.zDotProduct(y);
        }
        DenseIntMatrix1D yy = (DenseIntMatrix1D)y;
        final int[] elemsOther = yy.elements;
        int zeroThis = (int)this.index(0);
        int zeroOther = (int)yy.index(0);
        int strideOther = yy.stride;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        int sum = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            final int zeroThisF = zeroThis;
            final int zeroOtherF = zeroOther;
            final int strideOtherF = strideOther;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int idx = zeroThisF + firstIdx * DenseIntMatrix1D.this.stride;
                        int idxOther = zeroOtherF + firstIdx * strideOtherF;
                        idx -= DenseIntMatrix1D.this.stride;
                        idxOther -= strideOtherF;
                        int sum = 0;
                        int min = lastIdx - firstIdx;
                        int k = min / 4;
                        while (--k >= 0) {
                            int n = idx + DenseIntMatrix1D.this.stride;
                            idx = n;
                            int n2 = idxOther + strideOtherF;
                            idxOther = n2;
                            int n3 = idx + DenseIntMatrix1D.this.stride;
                            idx = n3;
                            int n4 = idxOther + strideOtherF;
                            idxOther = n4;
                            idx = idx + DenseIntMatrix1D.this.stride;
                            idxOther = idxOther + strideOtherF;
                            sum += DenseIntMatrix1D.this.elements[n] * elemsOther[n2] + DenseIntMatrix1D.this.elements[n3] * elemsOther[n4] + DenseIntMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride] * elemsOther[idxOther += strideOtherF];
                        }
                        k = min % 4;
                        while (--k >= 0) {
                            sum += DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride] * elemsOther[idxOther += strideOtherF];
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            zeroThis -= this.stride;
            zeroOther -= strideOther;
            int k = this.size / 4;
            while (--k >= 0) {
                int n = zeroThis + this.stride;
                zeroThis = n;
                int n2 = zeroOther + strideOther;
                zeroOther = n2;
                int n3 = zeroThis + this.stride;
                zeroThis = n3;
                int n4 = zeroOther + strideOther;
                zeroOther = n4;
                zeroThis = zeroThis + this.stride;
                zeroOther = zeroOther + strideOther;
                sum += this.elements[n] * elemsOther[n2] + this.elements[n3] * elemsOther[n4] + this.elements[zeroThis] * elemsOther[zeroOther] + this.elements[zeroThis += this.stride] * elemsOther[zeroOther += strideOther];
            }
            k = this.size % 4;
            while (--k >= 0) {
                sum += this.elements[zeroThis += this.stride] * elemsOther[zeroOther += strideOther];
            }
        }
        return sum;
    }

    @Override
    public int zDotProduct(IntMatrix1D y, int from, int length) {
        if (!(y instanceof DenseIntMatrix1D)) {
            return super.zDotProduct(y, from, length);
        }
        DenseIntMatrix1D yy = (DenseIntMatrix1D)y;
        int tail = from + length;
        if (from < 0 || length < 0) {
            return 0;
        }
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size() < (long)tail) {
            tail = (int)y.size();
        }
        final int[] elementsOther = yy.elements;
        int zeroThis = (int)this.index(from);
        int zeroOther = (int)yy.index(from);
        int strideOther = yy.stride;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        int sum = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && length >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            final int zeroThisF = zeroThis;
            final int zeroOtherF = zeroOther;
            final int strideOtherF = strideOther;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int idx = zeroThisF + firstIdx * DenseIntMatrix1D.this.stride;
                        int idxOther = zeroOtherF + firstIdx * strideOtherF;
                        idx -= DenseIntMatrix1D.this.stride;
                        idxOther -= strideOtherF;
                        int sum = 0;
                        int min = lastIdx - firstIdx;
                        int k = min / 4;
                        while (--k >= 0) {
                            int n = idx + DenseIntMatrix1D.this.stride;
                            idx = n;
                            int n2 = idxOther + strideOtherF;
                            idxOther = n2;
                            int n3 = idx + DenseIntMatrix1D.this.stride;
                            idx = n3;
                            int n4 = idxOther + strideOtherF;
                            idxOther = n4;
                            idx = idx + DenseIntMatrix1D.this.stride;
                            idxOther = idxOther + strideOtherF;
                            sum += DenseIntMatrix1D.this.elements[n] * elementsOther[n2] + DenseIntMatrix1D.this.elements[n3] * elementsOther[n4] + DenseIntMatrix1D.this.elements[idx] * elementsOther[idxOther] + DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        k = min % 4;
                        while (--k >= 0) {
                            sum += DenseIntMatrix1D.this.elements[idx += DenseIntMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            zeroThis -= this.stride;
            zeroOther -= strideOther;
            int min = tail - from;
            int k = min / 4;
            while (--k >= 0) {
                int n = zeroThis + this.stride;
                zeroThis = n;
                int n2 = zeroOther + strideOther;
                zeroOther = n2;
                int n3 = zeroThis + this.stride;
                zeroThis = n3;
                int n4 = zeroOther + strideOther;
                zeroOther = n4;
                zeroThis = zeroThis + this.stride;
                zeroOther = zeroOther + strideOther;
                sum += this.elements[n] * elementsOther[n2] + this.elements[n3] * elementsOther[n4] + this.elements[zeroThis] * elementsOther[zeroOther] + this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
            k = min % 4;
            while (--k >= 0) {
                sum += this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
        }
        return sum;
    }

    @Override
    public int zSum() {
        int sum = 0;
        final int[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int sum = 0;
                        int idx = DenseIntMatrix1D.this.zero + firstIdx * DenseIntMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            sum += elems[idx];
                            idx += DenseIntMatrix1D.this.stride;
                            ++i;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            int k = 0;
            while (k < this.size) {
                sum += elems[idx];
                idx += this.stride;
                ++k;
            }
        }
        return sum;
    }

    @Override
    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int index = this.zero;
        int[] elems = this.elements;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (elems[index] != 0) {
                ++cardinality;
            }
            index += this.stride;
        }
        return cardinality;
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix1D other) {
        if (other instanceof SelectedDenseIntMatrix1D) {
            SelectedDenseIntMatrix1D otherMatrix = (SelectedDenseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseIntMatrix1D) {
            DenseIntMatrix1D otherMatrix = (DenseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    protected IntMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseIntMatrix1D(this.elements, offsets);
    }
}

