/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class CleanUpLocalThickness {
    public float[][] s;
    public float[][] sNew;
    public int w;
    public int h;
    public int d;

    public ImagePlus run(ImagePlus imagePlus) {
        int n;
        int n2;
        int n3;
        ImageStack imageStack = imagePlus.getStack();
        this.w = imageStack.getWidth();
        this.h = imageStack.getHeight();
        this.d = imagePlus.getStackSize();
        ImageStack imageStack2 = new ImageStack(this.w, this.h);
        this.sNew = new float[this.d][];
        for (n3 = 0; n3 < this.d; ++n3) {
            FloatProcessor floatProcessor = new FloatProcessor(this.w, this.h);
            imageStack2.addSlice(null, (ImageProcessor)floatProcessor);
            this.sNew[n3] = (float[])floatProcessor.getPixels();
        }
        this.s = new float[this.d][];
        for (n3 = 0; n3 < this.d; ++n3) {
            this.s[n3] = (float[])imageStack.getPixels(n3 + 1);
        }
        for (n3 = 0; n3 < this.d; ++n3) {
            for (int i = 0; i < this.h; ++i) {
                for (n2 = 0; n2 < this.w; ++n2) {
                    this.sNew[n3][n2 + this.w * i] = this.setFlag(n2, i, n3);
                }
            }
        }
        for (n3 = 0; n3 < this.d; ++n3) {
            for (int i = 0; i < this.h; ++i) {
                for (n2 = 0; n2 < this.w; ++n2) {
                    n = n2 + this.w * i;
                    if (this.sNew[n3][n] != -1.0f) continue;
                    this.sNew[n3][n] = -this.averageInteriorNeighbors(n2, i, n3);
                }
            }
        }
        for (n3 = 0; n3 < this.d; ++n3) {
            for (int i = 0; i < this.h; ++i) {
                for (n2 = 0; n2 < this.w; ++n2) {
                    n = n2 + this.w * i;
                    this.sNew[n3][n] = Math.abs(this.sNew[n3][n]);
                }
            }
        }
        String string = this.stripExtension(imagePlus.getTitle());
        ImagePlus imagePlus2 = new ImagePlus(string + "_CL", imageStack2);
        imagePlus2.getProcessor().setMinAndMax(0.0, 2.0 * imagePlus.getProcessor().getMax());
        return imagePlus2;
    }

    float setFlag(int n, int n2, int n3) {
        if (this.s[n3][n + this.w * n2] == 0.0f) {
            return 0.0f;
        }
        if (this.look(n, n2, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n, n2, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n, n2 - 1, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n, n2 + 1, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n, n2 + 1, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n, n2 + 1, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2 - 1, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2 + 1, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n, n2 - 1, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n, n2 - 1, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2 - 1, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2 + 1, n3) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2 + 1, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2 - 1, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2 + 1, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2 - 1, n3 + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2 + 1, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n + 1, n2 - 1, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2 + 1, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(n - 1, n2 - 1, n3 - 1) == 0.0f) {
            return -1.0f;
        }
        return this.s[n3][n + this.w * n2];
    }

    float averageInteriorNeighbors(int n, int n2, int n3) {
        int n4 = 0;
        float f = 0.0f;
        float f2 = this.lookNew(n, n2, n3 - 1);
        if (f2 > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n, n2, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n, n2 - 1, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n, n2 + 1, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n, n2 + 1, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n, n2 + 1, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2 - 1, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2 + 1, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n, n2 - 1, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n, n2 - 1, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2 - 1, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2 + 1, n3)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2 + 1, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2 - 1, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2 + 1, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2 - 1, n3 + 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2 + 1, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n + 1, n2 - 1, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2 + 1, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if ((f2 = this.lookNew(n - 1, n2 - 1, n3 - 1)) > 0.0f) {
            ++n4;
            f += f2;
        }
        if (n4 > 0) {
            return f / (float)n4;
        }
        return this.s[n3][n + this.w * n2];
    }

    float look(int n, int n2, int n3) {
        if (n < 0 || n >= this.w) {
            return -1.0f;
        }
        if (n2 < 0 || n2 >= this.h) {
            return -1.0f;
        }
        if (n3 < 0 || n3 >= this.d) {
            return -1.0f;
        }
        return this.s[n3][n + this.w * n2];
    }

    float lookNew(int n, int n2, int n3) {
        if (n < 0 || n >= this.w) {
            return -1.0f;
        }
        if (n2 < 0 || n2 >= this.h) {
            return -1.0f;
        }
        if (n3 < 0 || n3 >= this.d) {
            return -1.0f;
        }
        return this.sNew[n3][n + this.w * n2];
    }

    String stripExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }
}

