/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.listenable;

import com.ochafik.util.listenable.CollectionEvent;
import com.ochafik.util.listenable.CollectionListener;
import com.ochafik.util.listenable.ListenableList;
import com.ochafik.util.listenable.SwingCollectionListener;
import javax.swing.AbstractListModel;

public class ListenableListModel<T>
extends AbstractListModel {
    private static final long serialVersionUID = 1794077239948305400L;
    private ListenableList<T> list;
    CollectionListener<T> listener = new SwingCollectionListener(new CollectionListener<T>(){

        @Override
        public void collectionChanged(CollectionEvent<T> e) {
            switch (e.getType()) {
                case ADDED: {
                    ListenableListModel.this.fireIntervalAdded(this, e.getFirstIndex(), e.getLastIndex());
                    break;
                }
                case REMOVED: {
                    ListenableListModel.this.fireIntervalRemoved(this, e.getFirstIndex(), e.getLastIndex());
                    break;
                }
                case UPDATED: {
                    ListenableListModel.this.fireContentsChanged(this, e.getFirstIndex(), e.getLastIndex());
                }
            }
        }
    });

    public ListenableListModel(ListenableList<T> list) {
        this.setList(list);
    }

    public ListenableListModel() {
    }

    public void setList(ListenableList<T> list) {
        ListenableList<T> oldList = this.list;
        if (oldList != null) {
            this.list = null;
            oldList.removeCollectionListener(this.listener);
            if (!oldList.isEmpty()) {
                this.fireIntervalRemoved(this, 0, oldList.size() - 1);
            }
        }
        this.list = list;
        if (list == null) {
            return;
        }
        list.addCollectionListener(this.listener);
        if (!list.isEmpty()) {
            this.fireIntervalAdded(this, 0, list.size() - 1);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public int getSize() {
        return this.list == null ? 0 : this.list.size();
    }

    public ListenableList<T> getList() {
        return this.list;
    }
}

