/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DFactory;
import mcib3d.geom.Object3DFuzzy;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.ThreadUtil;
import mcib3d.utils.exceptionPrinter;

public abstract class ImageInt
extends ImageHandler {
    public ImageInt(ImagePlus imagePlus) {
        super(imagePlus);
    }

    public ImageInt(ImageStack imageStack) {
        super(imageStack);
    }

    public ImageInt(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
    }

    public ImageInt(ImageHandler imageHandler, boolean bl) {
        super(imageHandler.title, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ, imageHandler.offsetX, imageHandler.offsetY, imageHandler.offsetZ);
    }

    protected ImageInt(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        super(string, n, n2, n3, n4, n5, n6);
    }

    public abstract void setPixel(int var1, int var2, int var3, int var4);

    public abstract void setPixel(int var1, int var2, int var3);

    public abstract void draw(Object3D var1, int var2);

    public abstract int getPixelInt(int var1, int var2);

    public abstract int getPixelInt(int var1, int var2, int var3);

    public abstract int getPixelInt(int var1);

    @Override
    public abstract float getPixel(Point3D var1);

    public abstract int getPixelInt(Point3D var1);

    @Override
    public abstract float getPixelInterpolated(Point3D var1);

    public abstract int getPixelIntInterpolated(Point3D var1);

    public TreeMap<Integer, int[]> getBounds(boolean bl) {
        TreeMap<Integer, int[]> treeMap = new TreeMap<Integer, int[]>();
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    int n = this.getPixelInt(k + j * this.sizeX, i);
                    if (n == 0) continue;
                    int[] nArray = treeMap.get(n);
                    if (nArray != null) {
                        if (k < nArray[0]) {
                            nArray[0] = k;
                        } else if (k > nArray[1]) {
                            nArray[1] = k;
                        }
                        if (j < nArray[2]) {
                            nArray[2] = j;
                        } else if (j > nArray[3]) {
                            nArray[3] = j;
                        }
                        if (i < nArray[4]) {
                            nArray[4] = i;
                        } else if (i > nArray[5]) {
                            nArray[5] = i;
                        }
                        nArray[6] = nArray[6] + 1;
                        continue;
                    }
                    int[] nArray2 = new int[]{k, k, j, j, i, i, 1};
                    treeMap.put(n, nArray2);
                }
            }
        }
        if (bl) {
            for (int[] nArray : treeMap.values()) {
                nArray[0] = nArray[0] - 1;
                nArray[1] = nArray[1] + 1;
                nArray[2] = nArray[2] - 1;
                nArray[3] = nArray[3] + 1;
                nArray[4] = nArray[4] - 1;
                nArray[5] = nArray[5] + 1;
            }
        }
        return treeMap;
    }

    public ArrayList<Integer> getUniqueValues(int n) {
        boolean[] blArray = new boolean[(int)(this.getMax() + 1.0)];
        Arrays.fill(blArray, false);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.sizeXYZ; ++i) {
            int n2 = this.getPixelInt(i);
            if (n2 <= n || blArray[n2]) continue;
            blArray[n2] = true;
            arrayList.add(n2);
        }
        return arrayList;
    }

    public ArrayList<Integer> getUniqueValues() {
        return this.getUniqueValues(-1);
    }

    @Override
    public abstract ImageInt crop3D(String var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract ImageByte crop3DBinary(String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract boolean shiftIndexes(TreeMap<Integer, int[]> var1);

    public abstract ImageInt[] crop3D(TreeMap<Integer, int[]> var1);

    @Override
    public abstract ImageInt crop3DMask(String var1, ImageInt var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public ImageByte[] crop3DBinary(TreeMap<Integer, int[]> treeMap) {
        ImageByte[] imageByteArray = new ImageByte[treeMap.size()];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeMap.keySet());
        for (int i = 0; i < imageByteArray.length; ++i) {
            int n = arrayList.get(i);
            int[] nArray = treeMap.get(n);
            imageByteArray[i] = this.crop3DBinary(this.title + ":" + n, n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
        }
        return imageByteArray;
    }

    public ImageByte[] crop3DBinary() {
        TreeMap<Integer, int[]> treeMap = this.getBounds(false);
        return this.crop3DBinary(treeMap);
    }

    @Override
    public ImageInt cropRadius(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        int n7 = Math.max(0, n - n4);
        int n8 = Math.max(0, n2 - n5);
        int n9 = Math.max(0, n3 - n6);
        int n10 = Math.min(this.sizeX, n + n4);
        int n11 = Math.min(this.sizeY, n2 + n5);
        int n12 = Math.min(this.sizeZ, n3 + n6);
        double d = n4 * n4;
        double d2 = n5 * n5;
        double d3 = n6 * n6;
        int n13 = 0;
        if (bl) {
            ImageStats imageStats = this.getImageStats(null);
            n13 = (int)imageStats.getMean();
        }
        ImageInt imageInt = this instanceof ImageByte ? new ImageByte("crop" + this.title, n10 - n7 + 1, n11 - n8 + 1, n12 - n9 + 1) : new ImageShort("crop" + this.title, n10 - n7 + 1, n11 - n8 + 1, n12 - n9 + 1);
        for (int i = n3 - n6; i <= n12; ++i) {
            for (int j = n - n4; j <= n10; ++j) {
                for (int k = n2 - n5; k <= n11; ++k) {
                    if (bl2) {
                        double d4 = (double)((j - n) * (j - n)) / d + (double)((k - n2) * (k - n2)) / d2 + (double)((i - n3) * (i - n3)) / d3;
                        if (d4 <= 1.0) {
                            imageInt.setPixel(j - n + n4, k - n2 + n5, i - n3 + n6, this.getPixelInt(j, k, i));
                            continue;
                        }
                        imageInt.setPixel(j - n + n4, k - n2 + n5, i - n3 + n6, n13);
                        continue;
                    }
                    imageInt.setPixel(j - n + n4, k - n2 + n5, i - n3 + n6, this.getPixelInt(j, k, i));
                }
            }
        }
        return imageInt;
    }

    public Object3DFuzzy[] getObjects3D(ImageFloat imageFloat, float f) {
        try {
            Object3DFactory object3DFactory = new Object3DFactory(this);
            return object3DFactory.getFuzzyObjects(f, imageFloat);
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, "", false);
            return null;
        }
    }

    public Object3DVoxels[] getObjects3D() {
        try {
            Object3DFactory object3DFactory = new Object3DFactory(this);
            return object3DFactory.getObjects();
        }
        catch (Exception exception) {
            exceptionPrinter.print(exception, "", false);
            return null;
        }
    }

    public Objects3DPopulation getObjects3DPopulation() {
        return new Objects3DPopulation(this.getObjects3D(), this.getCalibration());
    }

    public Object3DVoxels getObject3DBackground(ImageInt imageInt) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeXY; ++j) {
                if (imageInt.getPixel(j, i) == 0.0f || this.getPixel(j, i) != 0.0f) continue;
                arrayList.add(new Voxel3D(j % this.sizeX, j / this.sizeX, i, 0.0f));
            }
        }
        if (arrayList.isEmpty()) {
            return new Object3DVoxels(0);
        }
        return new Object3DVoxels(arrayList);
    }

    public ImageFloat getDistanceMapInsideMask(int n) {
        return EDT.run(this, 0.0f, false, n);
    }

    public static ImageInt wrap(ImagePlus imagePlus) {
        switch (imagePlus.getBitDepth()) {
            case 8: {
                return new ImageByte(imagePlus);
            }
            case 16: {
                return new ImageShort(imagePlus);
            }
            case 32: {
                return new ImageShort(ImageHandler.wrap(imagePlus), true);
            }
        }
        return null;
    }

    public static ImageInt wrap(ImageStack imageStack) {
        switch (imageStack.getBitDepth()) {
            case 8: {
                return new ImageByte(imageStack);
            }
            case 16: {
                return new ImageShort(imageStack);
            }
            case 32: {
                return new ImageShort(ImageHandler.wrap(imageStack), true);
            }
        }
        return null;
    }

    public void replacePixelsValue(int n, int n2) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            if (this.getPixel(i) != (float)n) continue;
            this.setPixel(i, (float)n2);
        }
    }

    public void replacePixelsValue(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            if (this.getPixel(i) == (float)n) {
                this.setPixel(i, (float)n2);
                continue;
            }
            if (this.getPixel(i) != (float)n3) continue;
            this.setPixel(i, (float)n4);
        }
    }

    public void replacePixelsValue(int[] nArray, int[] nArray2) {
        block0: for (int i = 0; i < this.sizeXYZ; ++i) {
            int n = this.getPixelInt(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (n != nArray[j]) continue;
                this.setPixel(i, (float)nArray2[j]);
                continue block0;
            }
        }
    }

    public void replacePixelsValue(int[] nArray, int n) {
        block0: for (int i = 0; i < this.sizeXYZ; ++i) {
            int n2 = this.getPixelInt(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (n2 != nArray[j]) continue;
                this.setPixel(i, (float)n);
                continue block0;
            }
        }
    }

    public boolean isBinary(int n) {
        float f = this.getMinAboveValue(n);
        float f2 = this.getMinAboveValue(f);
        return f2 == Float.MAX_VALUE;
    }

    @Override
    public abstract ImageInt resample(int var1, int var2, int var3, int var4);

    @Override
    public abstract ImageInt resample(int var1, int var2);

    public abstract ImageByte toMask();

    public ImageByte toCenterMask() {
        Object3DVoxels[] object3DVoxelsArray;
        ImageByte imageByte = new ImageByte("mask", this.sizeX, this.sizeY, this.sizeZ);
        imageByte.setScale(this);
        imageByte.setOffset(this);
        for (Object3DVoxels object3DVoxels : object3DVoxelsArray = this.getObjects3D()) {
            imageByte.setPixel(object3DVoxels.getCenterAsPoint(), 255.0f);
        }
        return imageByte;
    }

    public abstract int countMaskVolume();

    public ImageInt addImage(ImageInt imageInt) {
        if (!this.sameDimentions(imageInt)) {
            return null;
        }
        ImageInt imageInt2 = this instanceof ImageByte && imageInt instanceof ImageByte ? (ImageInt)this.createSameDimensions() : new ImageShort("add", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            imageInt2.setPixel(i, (float)(this.getPixelInt(i) + imageInt.getPixelInt(i)));
        }
        return imageInt2;
    }

    public ImageInt diffAbsImage(ImageHandler imageHandler) {
        if (!this.sameDimentions(imageHandler)) {
            return null;
        }
        ImageInt imageInt = this instanceof ImageByte && imageHandler instanceof ImageByte ? (ImageInt)this.createSameDimensions() : new ImageShort("diff", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            imageInt.setPixel(i, Math.abs(this.getPixel(i) - imageHandler.getPixel(i)));
        }
        return imageInt;
    }

    @Override
    public abstract ImageInt duplicate();

    public ImageInt substractImage(ImageInt imageInt) {
        if (!this.sameDimentions(imageInt)) {
            return null;
        }
        ImageInt imageInt2 = this instanceof ImageByte && imageInt instanceof ImageByte ? (ImageInt)this.createSameDimensions() : new ImageShort("add", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            imageInt2.setPixel(i, (float)(this.getPixelInt(i) - imageInt.getPixelInt(i)));
        }
        return imageInt2;
    }

    public ImageInt invertMask(ImageInt imageInt) {
        ImageByte imageByte = new ImageByte("mask", imageInt.sizeX, imageInt.sizeY, imageInt.sizeZ);
        int n = -1;
        for (int i = 0; i < imageByte.sizeZ; ++i) {
            for (int j = 0; j < imageByte.sizeXY; ++j) {
                if (imageInt.getPixelInt(j, i) == 0 || this.getPixelInt(j, i) != 0) continue;
                imageByte.setPixel(j, i, n);
            }
        }
        return imageByte;
    }

    public boolean hasOneValueInt(int n) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            if (this.getPixelInt(i) != n) continue;
            return true;
        }
        return false;
    }

    public Voxel3D firstVoxelValueInt(int n) {
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    if (this.getPixelInt(k, j, i) != n) continue;
                    return new Voxel3D(k, j, i, n);
                }
            }
        }
        return null;
    }

    public void filterGeneric(ImageInt imageInt, float f, float f2, float f3, int n, int n2, int n3) {
        int[] nArray = FastFilters3D.createKernelEllipsoid(f, f2, f3);
        int n4 = FastFilters3D.getNbFromKernel(nArray);
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.sizeZ) {
            n2 = this.sizeZ;
        }
        for (int i = n; i < n2; ++i) {
            IJ.showStatus((String)("3D filter : " + (i + 1) + "/" + n2));
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    ArrayUtil arrayUtil = this.getNeighborhoodKernel(nArray, n4, k, j, i, f, f2, f3);
                    if (n3 == 0) {
                        imageInt.setPixel(k, j, i, (int)(arrayUtil.getMean() + 0.5));
                    } else if (n3 == 1) {
                        imageInt.setPixel(k, j, i, (int)arrayUtil.medianSort());
                    }
                    if (n3 == 2) {
                        imageInt.setPixel(k, j, i, (int)arrayUtil.getMinimum());
                    }
                    if (n3 == 3) {
                        imageInt.setPixel(k, j, i, (int)arrayUtil.getMaximum());
                    }
                    if (n3 == 8) {
                        imageInt.setPixel(k, j, i, (int)(arrayUtil.getVariance2() + 0.5));
                    }
                    if (n3 != 4) continue;
                    int n5 = this.getPixelInt(k, j, i);
                    if (arrayUtil.isMaximum(n5)) {
                        imageInt.setPixel(k, j, i, n5);
                        continue;
                    }
                    imageInt.setPixel(k, j, i, 0);
                }
            }
        }
    }

    public void filterGeneric(ImageInt imageInt, Object3DVoxels object3DVoxels, int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.sizeZ) {
            n2 = this.sizeZ;
        }
        int[] nArray = FastFilters3D.createKernelFromObject(object3DVoxels);
        int n4 = FastFilters3D.getNbFromKernel(nArray);
        float[] fArray = FastFilters3D.getRadiiFromObject(object3DVoxels);
        for (int i = n; i < n2; ++i) {
            IJ.showStatus((String)("3D filter : " + (i + 1) + "/" + n2));
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    ArrayUtil arrayUtil = this.getNeighborhoodKernel(nArray, n4, k, j, i, fArray[0], fArray[1], fArray[2]);
                    if (n3 == 0) {
                        imageInt.setPixel(k, j, i, (int)(arrayUtil.getMean() + 0.5));
                    } else if (n3 == 1) {
                        imageInt.setPixel(k, j, i, (int)arrayUtil.medianSort());
                    }
                    if (n3 == 2) {
                        imageInt.setPixel(k, j, i, (int)arrayUtil.getMinimum());
                    }
                    if (n3 == 3) {
                        imageInt.setPixel(k, j, i, (int)arrayUtil.getMaximum());
                    }
                    if (n3 == 8) {
                        imageInt.setPixel(k, j, i, (int)(arrayUtil.getVariance2() + 0.5));
                    }
                    if (n3 != 4) continue;
                    int n5 = this.getPixelInt(k, j, i);
                    if (arrayUtil.isMaximum(n5)) {
                        imageInt.setPixel(k, j, i, n5);
                        continue;
                    }
                    imageInt.setPixel(k, j, i, 0);
                }
            }
        }
    }

    public ImageInt sobelFilter() {
        ImageInt imageInt = (ImageInt)this.createSameDimensions();
        double[] dArray = new double[]{-1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -4.0, 0.0, 4.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0};
        double[] dArray2 = new double[]{-1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, -2.0, -4.0, -2.0, 0.0, 0.0, 0.0, 2.0, 4.0, 2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0};
        double[] dArray3 = new double[]{-1.0, -2.0, -1.0, -2.0, -4.0, -2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 2.0, 4.0, 2.0, 1.0, 2.0, 1.0};
        for (int i = 0; i < this.sizeZ; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                for (int k = 0; k < this.sizeX; ++k) {
                    double d;
                    double d2;
                    ArrayUtil arrayUtil = this.getNeighborhood3x3x3(k, j, i);
                    double d3 = arrayUtil.convolve(dArray, 1.0);
                    double d4 = Math.sqrt(d3 * d3 + (d2 = arrayUtil.convolve(dArray2, 1.0)) * d2 + (d = arrayUtil.convolve(dArray3, 1.0)) * d);
                    if (d4 > 65535.0 && this.getType() == 1) {
                        d4 = 65535.0;
                    }
                    if (d4 > 255.0 && this.getType() == 0) {
                        d4 = 255.0;
                    }
                    imageInt.setPixel(k, j, i, (int)d4);
                }
            }
        }
        return imageInt;
    }

    public ImageInt adaptiveFilter(float f, float f2, float f3, int n) {
        int n2;
        ImageInt imageInt;
        final ImageInt imageInt2 = imageInt = (ImageInt)this.createSameDimensions();
        final int[] nArray = FastFilters3D.createKernelEllipsoid(f, f2, f3);
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 += nArray[n2];
        }
        n2 = n3;
        final float f4 = f;
        final float f5 = f2;
        final float f6 = f3;
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = ThreadUtil.createThreadArray(n);
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(){

                @Override
                public void run() {
                    ArrayUtil[] arrayUtilArray = new ArrayUtil[7];
                    int n = 1;
                    int n22 = atomicInteger.getAndIncrement();
                    while (n22 < ImageInt.this.sizeZ) {
                        for (int i = 0; i < ImageInt.this.sizeY; ++i) {
                            for (int j = 0; j < ImageInt.this.sizeX; ++j) {
                                arrayUtilArray[0] = ImageInt.this.getNeighborhoodKernel(nArray, n2, j, i, n22, f4, f5, f6);
                                arrayUtilArray[1] = ImageInt.this.getNeighborhoodKernel(nArray, n2, j + n, i, n22, f4, f5, f6);
                                arrayUtilArray[2] = ImageInt.this.getNeighborhoodKernel(nArray, n2, j - n, i, n22, f4, f5, f6);
                                arrayUtilArray[3] = ImageInt.this.getNeighborhoodKernel(nArray, n2, j, i + n, n22, f4, f5, f6);
                                arrayUtilArray[4] = ImageInt.this.getNeighborhoodKernel(nArray, n2, j, i - n, n22, f4, f5, f6);
                                arrayUtilArray[5] = ImageInt.this.getNeighborhoodKernel(nArray, n2, j, i, n22 + n, f4, f5, f6);
                                arrayUtilArray[6] = ImageInt.this.getNeighborhoodKernel(nArray, n2, j, i, n22 - n, f4, f5, f6);
                                double d = 0.0;
                                double d2 = 3.4028234663852886E38;
                                for (int k = 0; k < 7; ++k) {
                                    double d3 = arrayUtilArray[k].getMean();
                                    double d4 = arrayUtilArray[k].getStdDev();
                                    if (!(d4 < d2)) continue;
                                    d2 = d4;
                                    d = d3;
                                }
                                imageInt2.setPixel(j, i, n22, (int)d);
                            }
                        }
                        n22 = atomicInteger.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin(threadArray);
        return imageInt2;
    }
}

