/*
 * Decompiled with CFR 0.152.
 */
package mitiv.microscopy;

import mitiv.utils.MathUtils;

public class Zernike {
    protected int J;
    protected int n;
    protected int m;
    protected double[] R_mn;
    protected double[] degR_mn;
    protected double[] r;
    protected double[] theta;
    protected double[] z;
    double[] Z;

    public Zernike(int Width, int Height) {
        this.r = MathUtils.fftDist1D(Width, Height);
        this.theta = MathUtils.fftAngle1D(Width, Height);
    }

    public Zernike(int J, int Width, int Height, double radius) {
        this.J = J;
        int[] nm = Zernike.zernumeroNoll(J);
        this.n = nm[0];
        this.m = nm[1];
        this.R_mn = this.coeffRadialZCumSumLog(this.n, this.m);
        this.degR_mn = this.radialZDegree(this.n, this.m);
    }

    public static int[] zernumeroNoll(int J) {
        int[] nm = new int[2];
        double k = 0.0;
        int n = 0;
        double n1 = (Math.sqrt(1 + 8 * J) - 1.0) / 2.0;
        if (n1 == (double)(n = (int)Math.floor(n1))) {
            --n;
        }
        k = (n + 1) * (n + 2) / 2;
        nm[1] = (int)((double)n - 2.0 * Math.floor((k - (double)J) / 2.0));
        nm[0] = n;
        return nm;
    }

    public double[] coeffRadialZCumSumLog(int n, int m) {
        int p = (n - m) / 2;
        int q = (n + m) / 2;
        double[] R_mn = new double[p + 1];
        double[] lfact = new double[n + 1];
        int i = 1;
        while (i < n + 1) {
            lfact[i] = Math.log(i);
            ++i;
        }
        lfact = MathUtils.cumSum(lfact);
        int s = 0;
        while (s <= (n - m) / 2) {
            R_mn[s] = Math.exp(lfact[n - s] - lfact[s] - lfact[p - s] - lfact[q - s]);
            if (!MathUtils.even(s)) {
                R_mn[s] = -R_mn[s];
            }
            ++s;
        }
        return R_mn;
    }

    public double[] radialZDegree(int n, int m) {
        double[] degR_mn = new double[(n - m) / 2 + 1];
        int s = 0;
        while (s <= (n - m) / 2) {
            degR_mn[s] = n - 2 * s;
            ++s;
        }
        return degR_mn;
    }

    public void info() {
        System.out.println("Zernike mode : " + this.J);
        System.out.println("Radius : " + this.J);
    }

    public double[] zernikeNoll(int J, int W, int H, double radius) {
        double[] r = MathUtils.fftDist1D(W, H);
        double[] theta = MathUtils.fftAngle1D(W, H);
        double[] z = new double[H * W];
        int L = W * H;
        if (J == 1) {
            int i = 0;
            while (i < L) {
                if (r[i] < radius) {
                    z[i] = 1.0;
                }
                ++i;
            }
        } else {
            int[] nm = Zernike.zernumeroNoll(J);
            this.n = nm[0];
            this.m = nm[1];
            this.R_mn = this.coeffRadialZCumSumLog(this.n, this.m);
            this.degR_mn = this.radialZDegree(this.n, this.m);
            if (this.m == 0) {
                double N = Math.sqrt(this.n + 1);
                int i = 0;
                while (i < L) {
                    if (r[i] < radius) {
                        double zr = 0.0;
                        r[i] = r[i] / radius;
                        int s = (this.n - this.m) / 2;
                        while (s >= 0) {
                            zr += this.R_mn[s] * Math.pow(r[i], this.degR_mn[s]);
                            --s;
                        }
                        z[i] = N * zr;
                    }
                    ++i;
                }
            } else {
                double N = Math.sqrt(2 * (this.n + 1));
                if (MathUtils.even(J)) {
                    int i = 0;
                    while (i < L) {
                        if (r[i] < radius) {
                            r[i] = r[i] / radius;
                            double sinCos_m = Math.cos((double)this.m * theta[i]);
                            double zr = 0.0;
                            int s = (this.n - this.m) / 2;
                            while (s >= 0) {
                                zr += this.R_mn[s] * Math.pow(r[i], this.degR_mn[s]);
                                --s;
                            }
                            z[i] = N * zr * sinCos_m;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < L) {
                        if (r[i] < radius) {
                            r[i] = r[i] / radius;
                            double sinCos_m = Math.sin((double)this.m * theta[i]);
                            double zr = 0.0;
                            int s = (this.n - this.m) / 2;
                            while (s >= 0) {
                                zr += this.R_mn[s] * Math.pow(r[i], this.degR_mn[s]);
                                --s;
                            }
                            z[i] = N * zr * sinCos_m;
                        }
                        ++i;
                    }
                }
            }
        }
        return z;
    }

    public double[] zernikePupilMultipleOpt(int Nzer, int W, int H, double radius, int normalise) {
        int[] nm = Zernike.zernumeroNoll(Nzer + 1);
        this.n = nm[0];
        double[] rPowers = new double[(this.n + 1) * W * H];
        double[] Z = new double[Nzer * W * H];
        int WH = W * H;
        int l = 0;
        while (l < WH) {
            if (this.r[l] < radius) {
                rPowers[l] = 1.0;
                Z[l] = 1.0;
                rPowers[l + WH] = this.r[l] / radius;
            }
            ++l;
        }
        if (normalise == 1) {
            double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, 0, W + WH - 1, 0)));
            int l2 = 0;
            while (l2 < WH) {
                Z[l2] = Z[l2] * NormZ;
                ++l2;
            }
        }
        int k = 2;
        while (k < this.n + 1) {
            int l3 = 0;
            while (l3 < WH) {
                rPowers[l3 + k * WH] = rPowers[l3 + (k - 1) * WH] * rPowers[l3 + WH];
                ++l3;
            }
            ++k;
        }
        int nz = 1;
        while (nz < Nzer) {
            int l4;
            int s;
            nm = Zernike.zernumeroNoll(nz + 1);
            this.n = nm[0];
            this.m = nm[1];
            this.R_mn = this.coeffRadialZCumSumLog(this.n, this.m);
            double zr = 0.0;
            if (this.m == 0) {
                int l5 = 0;
                while (l5 < WH) {
                    zr = 0.0;
                    double N = Math.sqrt(this.n + 1);
                    s = (this.n - this.m) / 2;
                    while (s >= 0) {
                        zr += this.R_mn[s] * rPowers[l5 + (this.n - 2 * s) * WH];
                        --s;
                    }
                    Z[l5 + nz * WH] = N * zr;
                    ++l5;
                }
                if (normalise == 1) {
                    double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, nz * WH, nz * WH + WH - 1, 0)));
                    l4 = 0;
                    while (l4 < WH) {
                        int n = l4 + nz * WH;
                        Z[n] = Z[n] * NormZ;
                        ++l4;
                    }
                }
            } else if (MathUtils.even(nz + 1)) {
                int l6 = 0;
                while (l6 < WH) {
                    double N = Math.sqrt(2 * (this.n + 1));
                    zr = 0.0;
                    s = (this.n - this.m) / 2;
                    while (s >= 0) {
                        zr += this.R_mn[s] * rPowers[l6 + (this.n - 2 * s) * WH];
                        --s;
                    }
                    Z[l6 + nz * WH] = N * zr * Math.cos((double)this.m * this.theta[l6]);
                    ++l6;
                }
                if (normalise == 1) {
                    double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, nz * WH, nz * WH + WH - 1, 0)));
                    l4 = 0;
                    while (l4 < WH) {
                        Z[l4 + nz * WH] = Z[l4 + nz * WH] * NormZ;
                        ++l4;
                    }
                }
            } else {
                int l7 = 0;
                while (l7 < WH) {
                    double N = Math.sqrt(2 * (this.n + 1));
                    zr = 0.0;
                    s = (this.n - this.m) / 2;
                    while (s >= 0) {
                        zr += this.R_mn[s] * rPowers[l7 + (this.n - 2 * s) * WH];
                        --s;
                    }
                    Z[l7 + nz * WH] = N * zr * Math.sin((double)this.m * this.theta[l7]);
                    ++l7;
                }
                if (normalise == 1) {
                    double NormZ = 1.0 / Math.sqrt(MathUtils.sum(MathUtils.abs2(Z, nz * WH, nz * WH + WH - 1, 0)));
                    l4 = 0;
                    while (l4 < WH) {
                        Z[l4 + nz * WH] = Z[l4 + nz * WH] * NormZ;
                        ++l4;
                    }
                }
            }
            ++nz;
        }
        return Z;
    }

    public double[] zernikePupilMultipleOptTab(int Nzer, int H, int W, double radius, int normalise) {
        int[] nm = Zernike.zernumeroNoll(Nzer + 1);
        this.n = nm[0];
        double[] Zr = new double[(this.n + 1) * W * H];
        double[] Z = new double[Nzer * W * H];
        int[] pupil = new int[H * W];
        int LPupil = 0;
        int L = H * W;
        int i = 0;
        while (i < L) {
            if (this.r[i] < radius) {
                Zr[i] = 1.0;
                Z[i] = 1.0;
                Zr[L + i] = this.r[i] / radius;
                pupil[LPupil] = i;
                ++LPupil;
            }
            ++i;
        }
        int nz = 2;
        while (nz < this.n + 1) {
            int k = 0;
            while (k < LPupil) {
                Zr[pupil[k] + nz * L] = Zr[pupil[k] + (nz - 1) * L] * Zr[pupil[k] + L];
                ++k;
            }
            ++nz;
        }
        nz = 1;
        while (nz < Nzer) {
            double sinCos_m;
            int s;
            int k;
            nm = Zernike.zernumeroNoll(nz + 1);
            this.n = nm[0];
            this.m = nm[1];
            this.R_mn = this.coeffRadialZCumSumLog(this.n, this.m);
            double zr = 0.0;
            if (this.m == 0) {
                k = 0;
                while (k < LPupil) {
                    zr = 0.0;
                    double N = Math.sqrt(this.n + 1);
                    s = (this.n - this.m) / 2;
                    while (s >= 0) {
                        zr += this.R_mn[s] * Zr[pupil[k] + (this.n - 2 * s) * W * H];
                        --s;
                    }
                    Z[pupil[k] + nz * W * H] = N * zr;
                    ++k;
                }
            } else if (MathUtils.even(nz + 1)) {
                k = 0;
                while (k < LPupil) {
                    sinCos_m = Math.cos((double)this.m * this.theta[pupil[k]]);
                    double N = Math.sqrt(2 * (this.n + 1));
                    zr = 0.0;
                    s = (this.n - this.m) / 2;
                    while (s >= 0) {
                        zr += this.R_mn[s] * Zr[pupil[k] + (this.n - 2 * s) * W * H];
                        --s;
                    }
                    Z[pupil[k] + nz * W * H] = N * zr * sinCos_m;
                    ++k;
                }
            } else {
                k = 0;
                while (k < LPupil) {
                    sinCos_m = Math.sin((double)this.m * this.theta[pupil[k]]);
                    double N = Math.sqrt(2 * (this.n + 1));
                    zr = 0.0;
                    s = (this.n - this.m) / 2;
                    while (s >= 0) {
                        zr += this.R_mn[s] * Zr[pupil[k] + (this.n - 2 * s) * W * H];
                        --s;
                    }
                    Z[pupil[k] + nz * W * H] = N * zr * sinCos_m;
                    ++k;
                }
            }
            ++nz;
        }
        return Z;
    }
}

