/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

public enum LineSearchStatus {
    ERROR_ILLEGAL_FX(-13, "Illegal function value."),
    ERROR_ILLEGAL_ADDRESS(-12, "Illegal address"),
    ERROR_CORRUPTED_WORKSPACE(-11, "Corrupted workspace"),
    ERROR_BAD_WORKSPACE(-10, "Bad workspace"),
    ERROR_STP_CHANGED(-9, "Step changed"),
    ERROR_STP_OUTSIDE_BRACKET(-8, "Step outside bracket"),
    ERROR_NOT_A_DESCENT(-7, "Not a descent direction"),
    ERROR_STPMIN_GT_STPMAX(-6, "Upper step bound smaller than lower bound"),
    ERROR_STPMIN_LT_ZERO(-5, "Lower step bound less than zero"),
    ERROR_STP_LT_STPMIN(-4, "Step below lower bound"),
    ERROR_STP_GT_STPMAX(-3, "Step above upper bound"),
    ERROR_INITIAL_DERIVATIVE_GE_ZERO(-2, "Initial directional derivative greater or equal zero"),
    ERROR_NOT_STARTED(-1, "Linesearch not started"),
    SEARCH(0, "Linesearch in progress"),
    CONVERGENCE(1, "Linesearch has converged"),
    WARNING_ROUNDING_ERRORS_PREVENT_PROGRESS(2, "Rounding errors prevent progress"),
    WARNING_XTOL_TEST_SATISFIED(3, "Search interval smaller than tolerance"),
    WARNING_STP_EQ_STPMAX(4, "Step at upper bound"),
    WARNING_STP_EQ_STPMIN(5, "Step at lower bound");

    private final String description;
    private final int code;

    private LineSearchStatus(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    public int getCode() {
        return this.code;
    }

    public boolean isWarning() {
        return this.code > LineSearchStatus.CONVERGENCE.code;
    }

    public final boolean isError() {
        return this.code < 0;
    }
}

