/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.measure.CurveFitter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Arrays;

public class ArrayUtil {
    private double[] values;
    private int size;
    private boolean sorted;
    private boolean debug = false;

    public ArrayUtil(int n) {
        this.size = n;
        this.values = new double[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = 0.0;
        }
        this.sorted = false;
    }

    public ArrayUtil(double[] dArray) {
        this.size = dArray.length;
        this.sorted = false;
        this.values = dArray;
    }

    public ArrayUtil(int[] nArray) {
        this.size = nArray.length;
        this.sorted = false;
        this.values = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = nArray[i];
        }
    }

    public boolean putValue(int n, double d) {
        if (n < this.size) {
            this.values[n] = d;
            this.sorted = false;
            return true;
        }
        return false;
    }

    public double getValue(int n) {
        if (n < this.size) {
            return this.values[n];
        }
        return Double.NaN;
    }

    public int getValueInt(int n) {
        if (n < this.size) {
            return (int)this.values[n];
        }
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public double[] getArray() {
        return this.values;
    }

    public void setSize(int n) {
        if (n > this.size) {
            double[] dArray = new double[n];
            System.arraycopy(this.values, 0, dArray, 0, this.size);
            this.values = dArray;
        }
        this.size = n;
        this.sorted = false;
    }

    public void fillValue(double d) {
        for (int i = 0; i < this.size; ++i) {
            this.putValue(i, d);
        }
        this.sorted = false;
    }

    public double getMaximum() {
        double d = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] > d)) continue;
            d = this.values[i];
        }
        return d;
    }

    public int getMaximumIndex() {
        double d = this.values[0];
        int n = 0;
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] > d)) continue;
            d = this.values[i];
            n = i;
        }
        return n;
    }

    public int getFirstLocalMaxima(double d) {
        for (int i = 1; i < this.size - 1; ++i) {
            if (!(this.values[i] >= d)) continue;
            double d2 = this.values[i - 1];
            double d3 = this.values[i];
            double d4 = this.values[i + 1];
            if (!(d3 >= d2) || !(d3 >= d4)) continue;
            return i;
        }
        return -1;
    }

    public int getFirstLocalMinima(double d) {
        for (int i = 1; i < this.size - 1; ++i) {
            if (!(this.values[i] <= d)) continue;
            double d2 = this.values[i - 1];
            double d3 = this.values[i];
            double d4 = this.values[i + 1];
            if (!(d3 <= d2) || !(d3 <= d4)) continue;
            return i;
        }
        return -1;
    }

    public int getFirstLocalExtrema(double d, double d2) {
        for (int i = 1; i < this.size - 1; ++i) {
            double d3;
            double d4;
            double d5;
            if (this.values[i] >= d) {
                d5 = this.values[i - 1];
                d4 = this.values[i];
                d3 = this.values[i + 1];
                if (d4 >= d5 && d4 >= d3) {
                    return i;
                }
            }
            if (!(this.values[i] <= d2)) continue;
            d5 = this.values[i - 1];
            d4 = this.values[i];
            d3 = this.values[i + 1];
            if (!(d4 <= d5) || !(d4 <= d3)) continue;
            return i;
        }
        return -1;
    }

    public boolean isMaximum(double d) {
        int n;
        boolean bl = true;
        for (n = 0; n < this.size && this.values[n] <= d; ++n) {
        }
        if (n < this.size) {
            bl = false;
        }
        return bl;
    }

    public double getMaximumBelow(double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.values[i] > d2) || !(this.values[i] < d)) continue;
            d2 = this.values[i];
        }
        return d2;
    }

    public int getLimitSup() {
        int n;
        for (n = this.size - 1; n >= 0 && this.values[n] == 0.0; --n) {
        }
        return n;
    }

    public int getLimitInf(int n) {
        int n2;
        for (n2 = n; n2 < this.size && this.values[n2] == 0.0; ++n2) {
        }
        return n2;
    }

    public double getMinimum() {
        double d = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] < d)) continue;
            d = this.values[i];
        }
        return d;
    }

    public int getMinimumIndex() {
        double d = this.values[0];
        int n = 0;
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] < d)) continue;
            d = this.values[i];
            n = i;
        }
        return n;
    }

    public double getMinimumAbove(double d) {
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.values[i] > d) || !(this.values[i] < d2)) continue;
            d2 = this.values[i];
        }
        if (d2 < Double.MAX_VALUE) {
            return d2;
        }
        return d;
    }

    public double getMean() {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            d += this.values[i];
        }
        return d / (double)this.size;
    }

    public double getSum() {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            d += this.values[i];
        }
        return d;
    }

    public double getStdDev() {
        double d = this.getVariance();
        return Math.sqrt(d);
    }

    public double getSkewness() {
        double d = this.getMean();
        double d2 = this.getStdDev();
        double d3 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double d4 = (this.values[i] - d) / d2;
            d3 += d4 * d4 * d4;
        }
        if (this.size > 1) {
            double d5 = this.size;
            d3 *= d5 / ((d5 - 1.0) * (d5 - 2.0));
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public double getKurtosis() {
        double d = this.getMean();
        double d2 = this.getVariance();
        double d3 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double d4 = this.values[i] - d;
            d3 += d4 * d4 * d4 * d4;
        }
        if (this.size > 1) {
            double d5 = this.size;
            d3 *= d5 * (d5 + 1.0) / ((d5 - 1.0) * (d5 - 2.0) * (d5 - 3.0) * d2 * d2);
            d3 -= 3.0 * (d5 - 1.0) * (d5 - 1.0) / ((d5 - 2.0) * (d5 - 3.0));
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public double getVariance() {
        if (this.size == 1) {
            return 0.0;
        }
        double d = this.getMean();
        double d2 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            d2 += (this.values[i] - d) * (this.values[i] - d);
        }
        d2 = this.size > 1 ? (d2 /= (double)(this.size - 1)) : 0.0;
        return d2;
    }

    public double getVariance2() {
        if (this.size == 1) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            d += this.values[i];
            d2 += this.values[i] * this.values[i];
        }
        double d3 = (d2 - d * d / (double)this.size) / (double)(this.size - 1);
        return d3;
    }

    public double getMaxAbsDifference(ArrayUtil arrayUtil) {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double d2 = Math.abs(this.values[i] - arrayUtil.getValue(i));
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public int countValue(double d) {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != d) continue;
            ++n;
        }
        return n;
    }

    public int countValueAbove(double d) {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.values[i] > d)) continue;
            ++n;
        }
        return n;
    }

    public ArrayUtil distinctValues() {
        this.sort();
        ArrayUtil arrayUtil = new ArrayUtil(this.getSize());
        int n = 0;
        double d = this.getValue(0);
        arrayUtil.addValue(0, d);
        ++n;
        int n2 = 1;
        int n3 = this.getSize();
        while (n2 < n3) {
            while (n2 < n3 && this.getValue(n2) == d) {
                ++n2;
            }
            if (n2 >= n3) continue;
            d = this.getValue(n2);
            arrayUtil.addValue(n, d);
            ++n;
            ++n2;
        }
        return arrayUtil.getSubTabUtil(0, n);
    }

    public ArrayUtil localMean(int n) {
        ArrayUtil arrayUtil = new ArrayUtil(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (i > n && i < this.size - n) {
                int n2 = 0;
                int n3 = 0;
                for (int j = i - n; j <= i + n; ++j) {
                    n2 = (int)((double)n2 + this.values[j]);
                    ++n3;
                }
                arrayUtil.putValue(i, n2 / n3);
                continue;
            }
            arrayUtil.putValue(i, this.values[i]);
        }
        return arrayUtil;
    }

    public boolean addValue(int n, double d) {
        if (n < this.size) {
            int n2 = n;
            this.values[n2] = this.values[n2] + d;
            this.sorted = false;
            return true;
        }
        return false;
    }

    public void divideAll(double d) {
        int n = 0;
        while (n < this.size) {
            int n2 = n++;
            this.values[n2] = this.values[n2] / d;
        }
        if (d < 0.0) {
            this.sorted = false;
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void sortJava() {
        if (this.size < this.values.length) {
            double[] dArray = new double[this.size];
            System.arraycopy(this.values, 0, dArray, 0, this.size);
            Arrays.sort(dArray);
            System.arraycopy(dArray, 0, this.values, 0, this.size);
        } else {
            Arrays.sort(this.values);
        }
        this.sorted = true;
    }

    public void sort() {
        this.sortJava();
    }

    public void sortShellMeitzner() {
        for (int i = this.size / 2; i > 0; i /= 2) {
            int n = 0;
            int n2 = 0;
            while (n < this.size - i) {
                if (this.values[n] > this.values[n + i]) {
                    double d = this.values[n];
                    this.values[n] = this.values[n + i];
                    this.values[n + i] = d;
                    if (n - i >= 0) {
                        n -= i;
                        continue;
                    }
                    n = ++n2;
                    continue;
                }
                n = ++n2;
            }
        }
        this.sorted = true;
    }

    public int[] sortIndexShellMeitzner() {
        int n;
        int[] nArray = new int[this.size];
        for (n = 0; n < this.size; ++n) {
            nArray[n] = n;
        }
        for (int i = this.size / 2; i > 0; i /= 2) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.size - i) {
                if (this.values[nArray[n2]] > this.values[nArray[n2 + i]]) {
                    n = nArray[n2];
                    nArray[n2] = nArray[n2 + i];
                    nArray[n2 + i] = n;
                    if (n2 - i >= 0) {
                        n2 -= i;
                        continue;
                    }
                    n2 = ++n3;
                    continue;
                }
                n2 = ++n3;
            }
        }
        return nArray;
    }

    public double medianSort() {
        if (!this.sorted) {
            this.sort();
        }
        if (this.size % 2 == 1) {
            return this.values[this.size / 2];
        }
        return 0.5 * (this.values[this.size / 2 - 1] + this.values[this.size / 2]);
    }

    public double median() {
        int n = this.size;
        int n2 = (n - 1) / 2;
        int n3 = 0;
        int n4 = n - 1;
        double d = this.values[n2];
        while (n3 < n4) {
            int n5 = n3;
            int n6 = n4;
            while (true) {
                if (this.values[n5] < d) {
                    ++n5;
                    continue;
                }
                while (d < this.values[n6]) {
                    --n6;
                }
                double d2 = this.values[n6];
                this.values[n6] = this.values[n5];
                this.values[n5] = d2;
                if (--n6 < n2 || ++n5 > n2) break;
            }
            if (n6 < n2) {
                n3 = n5;
            }
            if (n2 < n5) {
                n4 = n6;
            }
            d = this.values[n2];
        }
        return d;
    }

    public double convolve(double[] dArray, double d) {
        if (this.size != dArray.length) {
            return -1.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            d2 += this.values[i] * dArray[i];
        }
        return d2 /= d;
    }

    public int indexOf(double d) {
        int n;
        for (n = 0; n < this.size && this.values[n] != d; ++n) {
        }
        if (n == this.size) {
            n = -1;
        }
        return n;
    }

    public int indexOfSumPercent(double d) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            n2 = (int)((double)n2 + this.values[n]);
        }
        for (n = 0; n < this.size; ++n) {
            if (!((double)(n3 = (int)((double)n3 + this.values[n])) >= d * (double)n2)) continue;
            return n > 0 ? n - 1 : 0;
        }
        return this.size - 1;
    }

    public boolean hasValue(int n) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.size; ++i) {
            if (this.values[i] != (double)n) continue;
            bl = true;
        }
        return bl;
    }

    public boolean hasOneValue(ArrayList arrayList) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.size; ++i) {
            if (!arrayList.contains(this.values[i])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean hasOneValueInt(ArrayList arrayList) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.size; ++i) {
            if (!arrayList.contains((int)this.values[i])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean hasOnlyValue(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] == (double)n) continue;
            return false;
        }
        return true;
    }

    public boolean hasOnlyValuesInt(ArrayList arrayList) {
        for (int i = 0; i < this.size; ++i) {
            if (arrayList.contains((int)this.values[i])) continue;
            return false;
        }
        return true;
    }

    public int IsoData() {
        int n = this.getLimitSup();
        int n2 = n / 2;
        int n3 = 0;
        int n4 = 0;
        while (Math.abs(n3 - n2) > 2 && n4 < this.size) {
            int n5;
            ++n4;
            n3 = n2;
            double d = 0.0;
            double d2 = 0.0;
            if (this.debug) {
                IJ.log((String)("size=" + this.size + " m0=" + n3));
            }
            for (n5 = 0; n5 < n3; ++n5) {
                d2 += this.values[n5];
                d += this.values[n5] * (double)n5;
            }
            if (this.debug) {
                IJ.log((String)("md=" + d + " nb=" + d2));
            }
            d /= d2;
            double d3 = 0.0;
            d2 = 0.0;
            for (n5 = n3; n5 <= n; ++n5) {
                d2 += this.values[n5];
                d3 += this.values[n5] * (double)n5;
            }
            if (this.debug) {
                IJ.log((String)("mg=" + d3 + " nb=" + d2));
            }
            n2 = (int)((d + (d3 /= d2)) / 2.0);
            if (!this.debug) continue;
            IJ.log((String)("m0=" + n3 + " m1=" + n2));
        }
        if (n4 == this.size && this.debug) {
            System.out.println("Pb convergence moyenne intermediaire");
        }
        return n2;
    }

    public ImagePlus drawBar(int n) {
        int n2 = 256;
        double d = this.getMaximum();
        ByteProcessor byteProcessor = new ByteProcessor(this.size, n2);
        byteProcessor.setColor(255);
        for (int i = 0; i < this.size; ++i) {
            byteProcessor.moveTo(i, n2 - 1);
            double d2 = n == -1 ? (double)n2 * this.values[i] / d : (this.values[i] > (double)n ? (double)(n2 - 1) : (double)n2 * this.values[i] / (double)n);
            byteProcessor.lineTo(i, (int)((double)n2 - d2));
        }
        return new ImagePlus("tab", (ImageProcessor)byteProcessor);
    }

    public void randomize() {
        this.sorted = false;
        for (int i = 0; i < this.size - 1; ++i) {
            int n = (int)Math.round(Math.random() * (double)(this.size - 1 - i) + (double)i);
            double d = this.values[i];
            this.values[i] = this.values[n];
            this.values[n] = d;
        }
    }

    public void setValues(ArrayUtil arrayUtil) {
        if (arrayUtil.getSize() > this.values.length) {
            this.values = new double[arrayUtil.getSize()];
        }
        this.setSize(arrayUtil.getSize());
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = arrayUtil.getValue(i);
        }
        this.sorted = false;
    }

    public void insertValues(int n, ArrayUtil arrayUtil) {
        if (arrayUtil.getSize() + n > this.values.length) {
            double[] dArray = new double[arrayUtil.getSize() + n];
            System.arraycopy(this.values, 0, dArray, 0, n);
            this.values = dArray;
            this.size = this.values.length;
        }
        System.arraycopy(arrayUtil.getArray(), 0, this.values, n, arrayUtil.getSize());
        this.size = Math.max(this.size, n + arrayUtil.getSize());
        this.sorted = false;
    }

    public boolean isEqual(ArrayUtil arrayUtil) {
        if (arrayUtil.getSize() != this.getSize()) {
            return false;
        }
        return this.isEqual(arrayUtil, 0, this.getSize() - 1);
    }

    public boolean isEqual(ArrayUtil arrayUtil, int n, int n2) {
        boolean bl = true;
        for (int i = n; i <= n2; ++i) {
            if (this.values[i] == arrayUtil.values[i]) continue;
            bl = false;
        }
        return bl;
    }

    public ArrayUtil getCopy() {
        ArrayUtil arrayUtil = new ArrayUtil(this.size);
        System.arraycopy(this.values, 0, arrayUtil.values, 0, this.size);
        return arrayUtil;
    }

    public String toString() {
        String string = "{" + this.values[0];
        for (int i = 1; i < this.size; ++i) {
            string = string + ", " + this.values[i];
        }
        return string + "}";
    }

    public void removeValueAt(int n) {
        --this.size;
        for (int i = n; i < this.size; ++i) {
            this.values[i] = this.values[i + 1];
        }
    }

    public void addValueArray(ArrayUtil arrayUtil) {
        if (this.size != arrayUtil.size) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.values[n] = this.values[n] + arrayUtil.values[i];
        }
        this.sorted = false;
    }

    public Plot getPlot() {
        double[] dArray = new double[this.size];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = i;
        }
        Plot plot = new Plot("Plot", "indices", "y values", dArray, this.values);
        plot.draw();
        return plot;
    }

    public void concat(ArrayUtil arrayUtil) {
        int n = this.size + arrayUtil.size;
        double[] dArray = new double[n];
        System.arraycopy(this.values, 0, dArray, 0, this.size);
        System.arraycopy(arrayUtil.values, 0, dArray, this.size, arrayUtil.size);
        this.values = dArray;
        this.size = n;
        this.sorted = false;
    }

    public void reverse() {
        for (int i = 0; i < this.size / 2; ++i) {
            double d = this.values[i];
            this.values[i] = this.values[this.size - 1 - i];
            this.values[this.size - 1 - i] = d;
        }
    }

    public ArrayUtil getSubTabUtil(int n, int n2) {
        ArrayUtil arrayUtil = new ArrayUtil(n2);
        int n3 = 0;
        while (n3 < n2) {
            arrayUtil.putValue(n3, this.getValue(n));
            ++n3;
            ++n;
        }
        return arrayUtil;
    }

    public ArrayUtil getDifferenceNext() {
        ArrayUtil arrayUtil = new ArrayUtil(this.getSize() - 1);
        for (int i = 0; i < arrayUtil.getSize(); ++i) {
            arrayUtil.putValue(i, this.getValue(i + 1) - this.getValue(i));
        }
        return arrayUtil;
    }

    public ArrayUtil getDifferenceNextAbs() {
        ArrayUtil arrayUtil = new ArrayUtil(this.getSize() - 1);
        for (int i = 0; i < arrayUtil.getSize(); ++i) {
            arrayUtil.putValue(i, Math.abs(this.getValue(i + 1) - this.getValue(i)));
        }
        return arrayUtil;
    }

    public static double[] fitGaussian(double[] dArray, double d, int n) {
        int n2;
        double[] dArray2;
        int n3 = 0;
        while (Double.isNaN(dArray[n3])) {
            ++n3;
        }
        if (n3 > 0) {
            n -= n3;
            dArray2 = new double[dArray.length - 2 * n3];
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                dArray2[n2] = dArray[n2 + n3];
            }
            dArray = dArray2;
        }
        dArray2 = new double[dArray.length];
        n2 = 0;
        double d2 = dArray[0];
        double d3 = dArray[0];
        for (int i = -n; i <= n; ++i) {
            double d4 = dArray[n2];
            if (d4 > d3) {
                d3 = d4;
            }
            if (d4 < d2) {
                d2 = d4;
            }
            dArray2[n2] = i;
            ++n2;
        }
        CurveFitter curveFitter = new CurveFitter(dArray2, dArray);
        double[] dArray3 = new double[]{d2, d3, 0.0, d};
        curveFitter.setInitialParameters(dArray3);
        curveFitter.setMaxIterations(10000);
        curveFitter.setRestarts(1000);
        curveFitter.doFit(12);
        dArray3 = curveFitter.getParams();
        if (Double.isNaN(dArray3[0])) {
            return null;
        }
        return dArray3;
    }

    public static int[] kMeans_Histogram1D(int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        ArrayUtil arrayUtil = new ArrayUtil(nArray);
        int n4 = arrayUtil.getLimitInf(0);
        int n5 = arrayUtil.getLimitSup();
        if (n2 > n4 && n2 < n5) {
            n4 = n2;
        }
        double d = (n5 - n4) / n;
        for (n3 = 0; n3 < n; ++n3) {
            nArray2[n3] = (int)((double)n4 + (double)(n3 + 1) * d);
        }
        n3 = 0;
        int n6 = 1;
        while (n3 == 0) {
            int n7;
            int n8;
            IJ.showStatus((String)("K-means " + n6));
            ++n6;
            n3 = 1;
            Arrays.fill(dArray2, 0.0);
            Arrays.fill(dArray, 0.0);
            for (n8 = n2; n8 < nArray.length; ++n8) {
                if (nArray[n8] == 0) continue;
                n7 = 0;
                double d2 = Double.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    double d3 = Math.abs(n8 - nArray2[i]);
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    n7 = i;
                }
                double d4 = nArray[n8];
                int n9 = n7;
                dArray[n9] = dArray[n9] + (double)n8 * d4;
                int n10 = n7;
                dArray2[n10] = dArray2[n10] + d4;
            }
            for (n8 = 0; n8 < n; ++n8) {
                n7 = nArray2[n8];
                int n11 = (int)(dArray[n8] / dArray2[n8]);
                n3 &= n7 == n11 ? 1 : 0;
                nArray2[n8] = n11;
            }
        }
        return nArray2;
    }
}

