/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.Long6D;
import mitiv.array.Long7D;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong7D;
import mitiv.array.impl.StriddenLong6D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class StriddenLong7D
extends Long7D {
    final int order;
    final long[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final int stride4;
    final int stride5;
    final int stride6;
    final int stride7;

    public StriddenLong7D(long[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 7) {
            throw new IllegalArgumentException("There must be as many strides as the rank.");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.stride2 = stride[1];
        this.stride3 = stride[2];
        this.stride4 = stride[3];
        this.stride5 = stride[4];
        this.stride6 = stride[5];
        this.stride7 = stride[6];
        this.order = Long7D.checkViewStrides(this.data.length, offset, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.stride7, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    public StriddenLong7D(long[] arr, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.stride2 = stride2;
        this.stride3 = stride3;
        this.stride4 = stride4;
        this.stride5 = stride5;
        this.stride6 = stride6;
        this.stride7 = stride7;
        this.order = Long7D.checkViewStrides(this.data.length, offset, stride1, stride2, stride3, stride4, stride5, stride6, stride7, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    @Override
    public void checkSanity() {
        Long7D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.stride7, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    private boolean isFlat() {
        return this.offset == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2 && this.stride4 == this.dim3 * this.stride3 && this.stride5 == this.dim4 * this.stride4 && this.stride6 == this.dim5 * this.stride5 && this.stride7 == this.dim6 * this.stride6;
    }

    final int index(int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        return this.offset + this.stride7 * i7 + this.stride6 * i6 + this.stride5 * i5 + this.stride4 * i4 + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1;
    }

    @Override
    public final long get(int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        return this.data[this.offset + this.stride7 * i7 + this.stride6 * i6 + this.stride5 * i5 + this.stride4 * i4 + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, int i5, int i6, int i7, long value) {
        this.data[this.offset + this.stride7 * i7 + this.stride6 * i6 + this.stride5 * i5 + this.stride4 * i4 + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int j5 = this.stride5 * i5 + j4;
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int j6 = this.stride6 * i6 + j5;
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int j7 = this.stride7 * i7 + j6;
                                        this.data[j7] = value;
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int j7 = this.stride7 * i7 + this.offset;
                int i6 = 0;
                while (i6 < this.dim6) {
                    int j6 = this.stride6 * i6 + j7;
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int j5 = this.stride5 * i5 + j6;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j5;
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int j3 = this.stride3 * i3 + j4;
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int j2 = this.stride2 * i2 + j3;
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        int j1 = this.stride1 * i1 + j2;
                                        this.data[j1] = value;
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int j5 = this.stride5 * i5 + j4;
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int j6 = this.stride6 * i6 + j5;
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int j7 = this.stride7 * i7 + j6;
                                        this.data[j7] = generator.nextLong();
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int j7 = this.stride7 * i7 + this.offset;
                int i6 = 0;
                while (i6 < this.dim6) {
                    int j6 = this.stride6 * i6 + j7;
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int j5 = this.stride5 * i5 + j6;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j5;
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int j3 = this.stride3 * i3 + j4;
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int j2 = this.stride2 * i2 + j3;
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        int j1 = this.stride1 * i1 + j2;
                                        this.data[j1] = generator.nextLong();
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void increment(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int j5 = this.stride5 * i5 + j4;
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int j6 = this.stride6 * i6 + j5;
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int j7;
                                        int n = j7 = this.stride7 * i7 + j6;
                                        this.data[n] = this.data[n] + value;
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int j7 = this.stride7 * i7 + this.offset;
                int i6 = 0;
                while (i6 < this.dim6) {
                    int j6 = this.stride6 * i6 + j7;
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int j5 = this.stride5 * i5 + j6;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j5;
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int j3 = this.stride3 * i3 + j4;
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int j2 = this.stride2 * i2 + j3;
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        int j1;
                                        int n = j1 = this.stride1 * i1 + j2;
                                        this.data[n] = this.data[n] + value;
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void decrement(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int j5 = this.stride5 * i5 + j4;
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int j6 = this.stride6 * i6 + j5;
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int j7;
                                        int n = j7 = this.stride7 * i7 + j6;
                                        this.data[n] = this.data[n] - value;
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int j7 = this.stride7 * i7 + this.offset;
                int i6 = 0;
                while (i6 < this.dim6) {
                    int j6 = this.stride6 * i6 + j7;
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int j5 = this.stride5 * i5 + j6;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j5;
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int j3 = this.stride3 * i3 + j4;
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int j2 = this.stride2 * i2 + j3;
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        int j1;
                                        int n = j1 = this.stride1 * i1 + j2;
                                        this.data[n] = this.data[n] - value;
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void scale(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int j5 = this.stride5 * i5 + j4;
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int j6 = this.stride6 * i6 + j5;
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int j7;
                                        int n = j7 = this.stride7 * i7 + j6;
                                        this.data[n] = this.data[n] * value;
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int j7 = this.stride7 * i7 + this.offset;
                int i6 = 0;
                while (i6 < this.dim6) {
                    int j6 = this.stride6 * i6 + j7;
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int j5 = this.stride5 * i5 + j6;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j5;
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int j3 = this.stride3 * i3 + j4;
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int j2 = this.stride2 * i2 + j3;
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        int j1;
                                        int n = j1 = this.stride1 * i1 + j2;
                                        this.data[n] = this.data[n] * value;
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void map(LongFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int j5 = this.stride5 * i5 + j4;
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int j6 = this.stride6 * i6 + j5;
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int j7 = this.stride7 * i7 + j6;
                                        this.data[j7] = function.apply(this.data[j7]);
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int j7 = this.stride7 * i7 + this.offset;
                int i6 = 0;
                while (i6 < this.dim6) {
                    int j6 = this.stride6 * i6 + j7;
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int j5 = this.stride5 * i5 + j6;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j5;
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int j3 = this.stride3 * i3 + j4;
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int j2 = this.stride2 * i2 + j3;
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        int j1 = this.stride1 * i1 + j2;
                                        this.data[j1] = function.apply(this.data[j1]);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int j5 = this.stride5 * i5 + j4;
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int j6 = this.stride6 * i6 + j5;
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        int j7 = this.stride7 * i7 + j6;
                                        if (initialized) {
                                            scanner.update(this.data[j7]);
                                        } else {
                                            scanner.initialize(this.data[j7]);
                                            initialized = true;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int j7 = this.stride7 * i7 + this.offset;
                int i6 = 0;
                while (i6 < this.dim6) {
                    int j6 = this.stride6 * i6 + j7;
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int j5 = this.stride5 * i5 + j6;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j5;
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int j3 = this.stride3 * i3 + j4;
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int j2 = this.stride2 * i2 + j3;
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        int j1 = this.stride1 * i1 + j2;
                                        if (initialized) {
                                            scanner.update(this.data[j1]);
                                        } else {
                                            scanner.initialize(this.data[j1]);
                                            initialized = true;
                                        }
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        if (!forceCopy && this.isFlat()) {
            return this.data;
        }
        long[] out = new long[this.number];
        int j = -1;
        int i7 = 0;
        while (i7 < this.dim7) {
            int j7 = this.stride7 * i7 + this.offset;
            int i6 = 0;
            while (i6 < this.dim6) {
                int j6 = this.stride6 * i6 + j7;
                int i5 = 0;
                while (i5 < this.dim5) {
                    int j5 = this.stride5 * i5 + j6;
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int j4 = this.stride4 * i4 + j5;
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int j3 = this.stride3 * i3 + j4;
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int j2 = this.stride2 * i2 + j3;
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    int j1 = this.stride1 * i1 + j2;
                                    out[++j] = this.data[j1];
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
            ++i7;
        }
        return out;
    }

    @Override
    public Long6D slice(int idx) {
        return new StriddenLong6D(this.data, this.offset + this.stride7 * idx, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Long6D slice(int idx, int dim) {
        int sliceDim6;
        int sliceDim5;
        int sliceDim4;
        int sliceDim3;
        int sliceDim2;
        int sliceDim1;
        int sliceStride6;
        int sliceStride5;
        int sliceStride4;
        int sliceStride3;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if (dim < 0) {
            dim += 7;
        }
        if (dim == 0) {
            sliceOffset = this.offset + this.stride1 * idx;
            sliceStride1 = this.stride2;
            sliceStride2 = this.stride3;
            sliceStride3 = this.stride4;
            sliceStride4 = this.stride5;
            sliceStride5 = this.stride6;
            sliceStride6 = this.stride7;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
        } else if (dim == 1) {
            sliceOffset = this.offset + this.stride2 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride3;
            sliceStride3 = this.stride4;
            sliceStride4 = this.stride5;
            sliceStride5 = this.stride6;
            sliceStride6 = this.stride7;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
        } else if (dim == 2) {
            sliceOffset = this.offset + this.stride3 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceStride3 = this.stride4;
            sliceStride4 = this.stride5;
            sliceStride5 = this.stride6;
            sliceStride6 = this.stride7;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim4;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
        } else if (dim == 3) {
            sliceOffset = this.offset + this.stride4 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceStride3 = this.stride3;
            sliceStride4 = this.stride5;
            sliceStride5 = this.stride6;
            sliceStride6 = this.stride7;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim5;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
        } else if (dim == 4) {
            sliceOffset = this.offset + this.stride5 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceStride3 = this.stride3;
            sliceStride4 = this.stride4;
            sliceStride5 = this.stride6;
            sliceStride6 = this.stride7;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim6;
            sliceDim6 = this.dim7;
        } else if (dim == 5) {
            sliceOffset = this.offset + this.stride6 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceStride3 = this.stride3;
            sliceStride4 = this.stride4;
            sliceStride5 = this.stride5;
            sliceStride6 = this.stride7;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim5;
            sliceDim6 = this.dim7;
        } else if (dim == 6) {
            sliceOffset = this.offset + this.stride7 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceStride3 = this.stride3;
            sliceStride4 = this.stride4;
            sliceStride5 = this.stride5;
            sliceStride6 = this.stride6;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
            sliceDim4 = this.dim4;
            sliceDim5 = this.dim5;
            sliceDim6 = this.dim6;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds.");
        }
        return new StriddenLong6D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceStride3, sliceStride4, sliceStride5, sliceStride6, sliceDim1, sliceDim2, sliceDim3, sliceDim4, sliceDim5, sliceDim6);
    }

    @Override
    public Long7D view(Range rng1, Range rng2, Range rng3, Range rng4, Range rng5, Range rng6, Range rng7) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.stride2);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.stride3);
        CompiledRange cr4 = new CompiledRange(rng4, this.dim4, 0, this.stride4);
        CompiledRange cr5 = new CompiledRange(rng5, this.dim5, 0, this.stride5);
        CompiledRange cr6 = new CompiledRange(rng6, this.dim6, 0, this.stride6);
        CompiledRange cr7 = new CompiledRange(rng7, this.dim7, 0, this.stride7);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing() && cr4.doesNothing() && cr5.doesNothing() && cr6.doesNothing() && cr7.doesNothing()) {
            return this;
        }
        return new StriddenLong7D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset() + cr4.getOffset() + cr5.getOffset() + cr6.getOffset() + cr7.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr4.getStride(), cr5.getStride(), cr6.getStride(), cr7.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber(), cr4.getNumber(), cr5.getNumber(), cr6.getNumber(), cr7.getNumber());
    }

    @Override
    public Long7D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4, int[] sel5, int[] sel6, int[] sel7) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.stride2, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.stride3, this.dim3, sel3);
        int[] idx4 = Helper.select(0, this.stride4, this.dim4, sel4);
        int[] idx5 = Helper.select(0, this.stride5, this.dim5, sel5);
        int[] idx6 = Helper.select(0, this.stride6, this.dim6, sel6);
        int[] idx7 = Helper.select(0, this.stride7, this.dim7, sel7);
        return new SelectedLong7D(this.data, idx1, idx2, idx3, idx4, idx5, idx6, idx7);
    }

    @Override
    public Long1D as1D() {
        return new FlatLong1D(this.flatten(), this.number);
    }
}

