/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.icy.gui.pair;

/**
 * VarEditorModel for Pair objects. Here, the pair represents a range.
 * Therefore, the first value cannot be higher than the second one.
 * 
 * @version May 3, 2014
 * 
 * @author Julien Jacquemot
 */
public class RangeRangeModel extends PairRangeModel {
	public RangeRangeModel(Pair defaultValue, double min, double max,
			double step) {
		super(defaultValue, min, max, new Pair.Double(step, step));
	}

	@Override
	public void setFirstMinimum(double min) {
		super.setFirstMinimum(Math.min(min, getSecondMaximum()));
		super.setFirstMaximum(Math.max(getFirstMinimum(), getFirstMaximum()));
		super.setSecondMinimum(Math.max(getFirstMaximum(), getSecondMinimum()));
	}

	@Override
	public void setFirstMaximum(double max) {
		super.setFirstMaximum(Math.min(Math.max(max, getFirstMinimum()),
				getSecondMaximum()));
		super.setSecondMinimum(Math.min(getSecondMinimum(), getSecondMaximum()));
	}

	@Override
	public void setSecondMinimum(double min) {
		super.setSecondMinimum(Math.min(Math.max(min, getFirstMinimum()),
				getSecondMaximum()));
		super.setFirstMaximum(Math.max(getSecondMinimum(), getFirstMaximum()));
	}

	@Override
	public void setSecondMaximum(double max) {
		super.setSecondMaximum(Math.max(max, getFirstMinimum()));
		super.setSecondMinimum(Math.min(getSecondMinimum(), getSecondMaximum()));
		super.setFirstMaximum(Math.min(getFirstMaximum(), getSecondMinimum()));
	}

	@Override
	public void updateBounds(Pair value) {
		setFirstMaximum(value.getSecond());
		setSecondMinimum(value.getFirst());
	}
}
