/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class RibbonApplicationMenuButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> imageCache = new LazyResettableHashMap("Substance.Flamingo.RibbonApplicationMenuButtonBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(JRibbonApplicationMenuButton menuButton, SubstanceFillPainter painter, SubstanceBorderPainter borderPainter, int width, int height) {
        JRibbon ribbon = menuButton.getRibbon();
        DefaultButtonModel model = new DefaultButtonModel();
        model.setEnabled(true);
        model.setSelected(menuButton.getPopupModel().isSelected());
        boolean popupShowing = menuButton.getPopupModel().isPopupShowing();
        model.setRollover(menuButton.getPopupModel().isRollover() && !popupShowing);
        model.setPressed(menuButton.getPopupModel().isPressed() || popupShowing);
        model.setArmed(menuButton.getActionModel().isArmed() || popupShowing);
        ActionPopupTransitionAwareUI ui = (ActionPopupTransitionAwareUI)menuButton.getUI();
        StateTransitionTracker popupStateTransitionTracker = ui.getPopupTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = popupStateTransitionTracker.getModelStateInfo();
        Map activeStates = modelStateInfo.getStateContributionMap();
        ComponentState currState = ComponentState.getState((ButtonModel)model, (JComponent)menuButton);
        SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (ComponentState)currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)ribbon, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)currState);
        HashMapKey baseKey = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), painter.getDisplayName(), borderPainter.getDisplayName(), SubstanceSizeUtils.getComponentFontSize((Component)menuButton)});
        BufferedImage baseLayer = (BufferedImage)imageCache.get(baseKey);
        if (baseLayer == null) {
            baseLayer = RibbonApplicationMenuButtonBackgroundDelegate.getSingleLayer(menuButton, painter, borderPainter, width, height, baseFillScheme, baseBorderScheme);
            imageCache.put(baseKey, (Object)baseLayer);
        }
        if (popupShowing || currState.isDisabled() || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)baseLayer, 0, 0, null);
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState == currState || (contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (ComponentState)activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)ribbon, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), painter.getDisplayName(), borderPainter.getDisplayName(), SubstanceSizeUtils.getComponentFontSize((Component)menuButton)});
            BufferedImage layer = (BufferedImage)imageCache.get(key);
            if (layer == null) {
                layer = RibbonApplicationMenuButtonBackgroundDelegate.getSingleLayer(menuButton, painter, borderPainter, width, height, fillScheme, borderScheme);
                imageCache.put(key, (Object)layer);
            }
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            g2d.drawImage((Image)layer, 0, 0, null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getSingleLayer(JRibbonApplicationMenuButton menuButton, SubstanceFillPainter painter, SubstanceBorderPainter borderPainter, int width, int height, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme) {
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)menuButton)) / 2.0);
        int outerRadius = Math.min(width - 2 * borderDelta - 2, height - 2 * borderDelta - 2);
        int delta = outerRadius % 2 == 1 ? 1 : 0;
        Ellipse2D.Double contour = new Ellipse2D.Double(borderDelta + delta, borderDelta + delta, outerRadius - delta, outerRadius - delta);
        BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        painter.paintContourBackground((Graphics)finalGraphics, (Component)menuButton, width, height, (Shape)contour, false, fillScheme, true);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)menuButton));
        int innerRadius = Math.min(width - 2 * (borderDelta + borderThickness) - 2, height - 2 * (borderDelta + borderThickness) - 2);
        delta = innerRadius % 2 == 1 ? 1 : 0;
        Ellipse2D.Double contourInner = new Ellipse2D.Double(borderDelta + borderThickness + delta, borderDelta + borderThickness + delta, innerRadius - delta, innerRadius - delta);
        borderPainter.paintBorder((Graphics)finalGraphics, (Component)menuButton, width, height, (Shape)contour, (Shape)contourInner, borderScheme);
        return newBackground;
    }
}

