/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array3D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;

    protected Array3D(int dim1, int dim2, int dim3) {
        this.shape = Shape.make(dim1, dim2, dim3);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large.");
        }
        this.number = (int)this.shape.number();
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.dim3 = dim3;
    }

    protected Array3D(int[] dims) {
        this(Shape.make(dims));
    }

    protected Array3D(Shape shape) {
        if (shape.rank() != 3) {
            throw new IllegalArgumentException("Bad number of dimensions for 3-D array.");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large.");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
    }

    @Override
    public final int getRank() {
        return 3;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int k) {
        return this.shape.dimension(k);
    }

    @Override
    public abstract Array3D copy();

    public abstract Array2D slice(int var1);

    public abstract Array2D slice(int var1, int var2);

    public abstract Array3D view(Range var1, Range var2, Range var3);

    public abstract Array3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int number, int offset, int stride1, int stride2, int stride3, int dim1, int dim2, int dim3) {
        int imax;
        int imin;
        int itmp = (dim1 - 1) * stride1;
        if (itmp >= 0) {
            imin = offset;
            imax = offset + itmp;
        } else {
            imin = offset + itmp;
            imax = offset;
        }
        itmp = (dim2 - 1) * stride2;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim3 - 1) * stride3;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        if (imin < 0 || imax >= number) {
            throw new IndexOutOfBoundsException("3D view is not within available space");
        }
        int s1 = Math.abs(stride1);
        int s2 = Math.abs(stride2);
        int s3 = Math.abs(stride3);
        if (s1 <= s2 && s2 <= s3) {
            return 1;
        }
        if (s1 >= s2 && s2 >= s3) {
            return 2;
        }
        return 0;
    }
}

