/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import cern.colt.ConcurrencyUtils;
import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.ref.FloatAbstractHistogram1D;
import hep.aida.tfloat.ref.FloatFixedAxis;
import hep.aida.tfloat.ref.FloatHistogram1DContents;
import hep.aida.tfloat.ref.FloatVariableAxis;
import java.util.concurrent.Future;

public class FloatHistogram1D
extends FloatAbstractHistogram1D
implements FloatIHistogram1D {
    private static final long serialVersionUID = 1L;
    private float[] errors;
    private float[] heights;
    private int[] entries;
    private int nEntry;
    private float sumWeight;
    private float sumWeightSquared;
    private float mean;
    private float rms;

    public FloatHistogram1D(String title, float[] edges) {
        this(title, new FloatVariableAxis(edges));
    }

    public FloatHistogram1D(String title, FloatIAxis axis) {
        super(title);
        this.xAxis = axis;
        int bins = axis.bins();
        this.entries = new int[bins + 2];
        this.heights = new float[bins + 2];
        this.errors = new float[bins + 2];
    }

    public FloatHistogram1D(String title, int bins, float min, float max) {
        this(title, new FloatFixedAxis(bins, min, max));
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int index) {
        return this.entries[this.map(index)];
    }

    @Override
    public float binError(int index) {
        return (float)Math.sqrt(this.errors[this.map(index)]);
    }

    @Override
    public float binHeight(int index) {
        return this.heights[this.map(index)];
    }

    @Override
    public float equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(float x) {
        int bin;
        int n = bin = this.map(this.xAxis.coordToIndex(x));
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + 1.0f;
        int n3 = bin;
        this.errors[n3] = this.errors[n3] + 1.0f;
        ++this.nEntry;
        this.sumWeight += 1.0f;
        this.sumWeightSquared += 1.0f;
        this.mean += x;
        this.rms += x * x;
    }

    @Override
    public void fill(float x, float weight) {
        int bin;
        int n = bin = this.map(this.xAxis.coordToIndex(x));
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + weight;
        int n3 = bin;
        this.errors[n3] = this.errors[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.mean += x * weight;
        this.rms += x * weight * weight;
    }

    @Override
    public void fill_2D(final float[] data, int rows, final int columns, final int zero, final int rowStride, final int columnStride) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, rows);
            Future[] futures = new Future[nthreads];
            int k = rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int i;
                        float[] errors_loc = new float[FloatHistogram1D.this.errors.length];
                        float[] heights_loc = new float[FloatHistogram1D.this.heights.length];
                        int[] entries_loc = new int[FloatHistogram1D.this.entries.length];
                        int nEntry_loc = 0;
                        float sumWeight_loc = 0.0f;
                        float sumWeightSquared_loc = 0.0f;
                        float mean_loc = 0.0f;
                        float rms_loc = 0.0f;
                        int idx = zero + firstRow * rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            i = idx;
                            int c = 0;
                            while (c < columns) {
                                int bin;
                                int n = bin = FloatHistogram1D.this.map(FloatHistogram1D.this.xAxis.coordToIndex(data[i]));
                                entries_loc[n] = entries_loc[n] + 1;
                                int n2 = bin;
                                heights_loc[n2] = heights_loc[n2] + 1.0f;
                                int n3 = bin;
                                errors_loc[n3] = errors_loc[n3] + 1.0f;
                                ++nEntry_loc;
                                sumWeight_loc += 1.0f;
                                sumWeightSquared_loc += 1.0f;
                                mean_loc += data[i];
                                rms_loc += data[i] * data[i];
                                i += columnStride;
                                ++c;
                            }
                            idx += rowStride;
                            ++r;
                        }
                        1 var10_11 = this;
                        synchronized (var10_11) {
                            i = 0;
                            while (i < FloatHistogram1D.this.entries.length) {
                                float[] fArray = FloatHistogram1D.this.errors;
                                int n = i;
                                fArray[n] = fArray[n] + errors_loc[i];
                                float[] fArray2 = FloatHistogram1D.this.heights;
                                int n4 = i;
                                fArray2[n4] = fArray2[n4] + heights_loc[i];
                                int[] nArray = FloatHistogram1D.this.entries;
                                int n5 = i;
                                nArray[n5] = nArray[n5] + entries_loc[i];
                                ++i;
                            }
                            FloatHistogram1D floatHistogram1D = FloatHistogram1D.this;
                            floatHistogram1D.nEntry = floatHistogram1D.nEntry + nEntry_loc;
                            FloatHistogram1D floatHistogram1D2 = FloatHistogram1D.this;
                            floatHistogram1D2.sumWeight = floatHistogram1D2.sumWeight + sumWeight_loc;
                            FloatHistogram1D floatHistogram1D3 = FloatHistogram1D.this;
                            floatHistogram1D3.sumWeightSquared = floatHistogram1D3.sumWeightSquared + sumWeightSquared_loc;
                            FloatHistogram1D floatHistogram1D4 = FloatHistogram1D.this;
                            floatHistogram1D4.mean = floatHistogram1D4.mean + mean_loc;
                            FloatHistogram1D floatHistogram1D5 = FloatHistogram1D.this;
                            floatHistogram1D5.rms = floatHistogram1D5.rms + rms_loc;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < rows) {
                int i = idx;
                int c = 0;
                while (c < columns) {
                    int bin;
                    int n = bin = this.map(this.xAxis.coordToIndex(data[i]));
                    this.entries[n] = this.entries[n] + 1;
                    int n2 = bin;
                    this.heights[n2] = this.heights[n2] + 1.0f;
                    int n3 = bin;
                    this.errors[n3] = this.errors[n3] + 1.0f;
                    ++this.nEntry;
                    this.sumWeight += 1.0f;
                    this.sumWeightSquared += 1.0f;
                    this.mean += data[i];
                    this.rms += data[i] * data[i];
                    i += columnStride;
                    ++c;
                }
                idx += rowStride;
                ++r;
            }
        }
    }

    @Override
    public void fill_2D(final float[] data, final float[] weights, int rows, final int columns, final int zero, final int rowStride, final int columnStride) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, rows);
            Future[] futures = new Future[nthreads];
            int k = rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int i;
                        int idx = zero + firstRow * rowStride;
                        float[] errors_loc = new float[FloatHistogram1D.this.errors.length];
                        float[] heights_loc = new float[FloatHistogram1D.this.heights.length];
                        int[] entries_loc = new int[FloatHistogram1D.this.entries.length];
                        int nEntry_loc = 0;
                        float sumWeight_loc = 0.0f;
                        float sumWeightSquared_loc = 0.0f;
                        float mean_loc = 0.0f;
                        float rms_loc = 0.0f;
                        int r = firstRow;
                        while (r < lastRow) {
                            i = idx;
                            int c = 0;
                            while (c < columns) {
                                int bin = FloatHistogram1D.this.map(FloatHistogram1D.this.xAxis.coordToIndex(data[i]));
                                int widx = r * columns + c;
                                float w2 = weights[widx] * weights[widx];
                                int n = bin;
                                entries_loc[n] = entries_loc[n] + 1;
                                int n2 = bin;
                                heights_loc[n2] = heights_loc[n2] + weights[widx];
                                int n3 = bin;
                                errors_loc[n3] = errors_loc[n3] + w2;
                                ++nEntry_loc;
                                sumWeight_loc += weights[widx];
                                sumWeightSquared_loc += w2;
                                mean_loc += data[i] * weights[widx];
                                rms_loc += data[i] * w2;
                                i += columnStride;
                                ++c;
                            }
                            idx += rowStride;
                            ++r;
                        }
                        2 var10_11 = this;
                        synchronized (var10_11) {
                            i = 0;
                            while (i < FloatHistogram1D.this.entries.length) {
                                float[] fArray = FloatHistogram1D.this.errors;
                                int n = i;
                                fArray[n] = fArray[n] + errors_loc[i];
                                float[] fArray2 = FloatHistogram1D.this.heights;
                                int n4 = i;
                                fArray2[n4] = fArray2[n4] + heights_loc[i];
                                int[] nArray = FloatHistogram1D.this.entries;
                                int n5 = i;
                                nArray[n5] = nArray[n5] + entries_loc[i];
                                ++i;
                            }
                            FloatHistogram1D floatHistogram1D = FloatHistogram1D.this;
                            floatHistogram1D.nEntry = floatHistogram1D.nEntry + nEntry_loc;
                            FloatHistogram1D floatHistogram1D2 = FloatHistogram1D.this;
                            floatHistogram1D2.sumWeight = floatHistogram1D2.sumWeight + sumWeight_loc;
                            FloatHistogram1D floatHistogram1D3 = FloatHistogram1D.this;
                            floatHistogram1D3.sumWeightSquared = floatHistogram1D3.sumWeightSquared + sumWeightSquared_loc;
                            FloatHistogram1D floatHistogram1D4 = FloatHistogram1D.this;
                            floatHistogram1D4.mean = floatHistogram1D4.mean + mean_loc;
                            FloatHistogram1D floatHistogram1D5 = FloatHistogram1D.this;
                            floatHistogram1D5.rms = floatHistogram1D5.rms + rms_loc;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < rows) {
                int i = idx;
                int c = 0;
                while (c < columns) {
                    int bin = this.map(this.xAxis.coordToIndex(data[i]));
                    int widx = r * columns + c;
                    float w2 = weights[widx] * weights[widx];
                    int n = bin;
                    this.entries[n] = this.entries[n] + 1;
                    int n2 = bin;
                    this.heights[n2] = this.heights[n2] + weights[widx];
                    int n3 = bin;
                    this.errors[n3] = this.errors[n3] + w2;
                    ++this.nEntry;
                    this.sumWeight += weights[widx];
                    this.sumWeightSquared += w2;
                    this.mean += data[i] * weights[widx];
                    this.rms += data[i] * w2;
                    i += columnStride;
                    ++c;
                }
                idx += rowStride;
                ++r;
            }
        }
    }

    public FloatHistogram1DContents getContents() {
        return new FloatHistogram1DContents(this.entries, this.heights, this.errors, this.nEntry, this.sumWeight, this.sumWeightSquared, this.mean, this.rms);
    }

    @Override
    public float mean() {
        return this.mean / this.sumWeight;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i] = 0;
            this.heights[i] = 0.0f;
            this.errors[i] = 0.0f;
            ++i;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0f;
        this.sumWeightSquared = 0.0f;
        this.mean = 0.0f;
        this.rms = 0.0f;
    }

    @Override
    public float rms() {
        return (float)Math.sqrt(this.rms / this.sumWeight - this.mean * this.mean / this.sumWeight / this.sumWeight);
    }

    public void setContents(FloatHistogram1DContents contents) {
        this.entries = contents.getEntries();
        this.heights = contents.getHeights();
        this.errors = contents.getErrors();
        this.nEntry = contents.getNentry();
        this.sumWeight = contents.getSumWeight();
        this.sumWeightSquared = contents.getSumWeightSquared();
        this.mean = contents.getMean();
        this.rms = contents.getRms();
    }

    void setContents(int[] entries, float[] heights, float[] errors) {
        this.entries = entries;
        this.heights = heights;
        this.errors = errors;
        int i = 0;
        while (i < entries.length) {
            this.nEntry += entries[i];
            this.sumWeight += heights[i];
            ++i;
        }
        this.sumWeightSquared = Float.NaN;
        this.mean = Float.NaN;
        this.rms = Float.NaN;
    }
}

