/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.Executer;
import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.CommandLister;
import ij.plugin.PlugIn;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Hotkeys
implements PlugIn {
    private static final String TITLE = "Hotkeys";
    private static String command = "";
    private static String shortcut = "";

    public void run(String arg) {
        if (arg.equals("install") || arg.equals("install2")) {
            this.installHotkey(arg);
        } else if (arg.equals("remove")) {
            this.removeHotkey();
        } else if (arg.equals("list")) {
            this.listCommands();
        } else {
            Executer e = new Executer(arg);
            e.run();
        }
        IJ.register(Hotkeys.class);
    }

    void installHotkey(String arg) {
        boolean byName = arg.equals("install2");
        String[] commands = byName ? null : this.getAllCommands();
        String[] shortcuts = this.getAvailableShortcuts();
        String nCommands = commands != null ? " (" + commands.length + ")" : "";
        GenericDialog gd = new GenericDialog("Add Shortcut" + nCommands);
        gd.addChoice("Shortcut:", shortcuts, shortcuts[0]);
        if (byName) {
            gd.addStringField("Command:", "", 20);
        } else {
            gd.addChoice("Command:", commands, command);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        shortcut = gd.getNextChoice();
        if (byName) {
            command = gd.getNextString();
            Hashtable cmds = Menus.getCommands();
            if (cmds == null || cmds.get(command) == null) {
                String command2 = command;
                if (cmds.get(command) == null) {
                    command = command + " ";
                }
                if (cmds.get(command) == null && cmds.get(command = command2 + "...") == null) {
                    command = command2;
                    IJ.error("Command not found:\n \n   \"" + command + "\"");
                    return;
                }
            }
        } else {
            command = gd.getNextChoice();
        }
        String plugin = "ij.plugin.Hotkeys(\"" + command + "\")";
        int err = Menus.installPlugin(plugin, 'h', "*" + command, shortcut, IJ.getInstance());
        switch (err) {
            case -1: {
                IJ.showMessage(TITLE, "The command \"" + command + "\" is already installed.");
                break;
            }
            case -2: {
                IJ.showMessage(TITLE, "The shortcut must be a single character or F1-F24.");
                break;
            }
            case -3: {
                IJ.showMessage("The \"" + shortcut + "\" shortcut is in use.");
                break;
            }
            default: {
                shortcut = "";
            }
        }
    }

    void removeHotkey() {
        String[] shortcuts = this.getShortcuts();
        if (shortcuts == null) {
            IJ.showMessage("Remove...", "No shortcuts found.");
            return;
        }
        GenericDialog gd = new GenericDialog("Remove");
        gd.addChoice("Shortcut:", shortcuts, "");
        if (shortcuts.length > 1) {
            gd.addCheckbox("Remove all " + shortcuts.length + " shortcuts", false);
        }
        gd.addMessage("Shortcuts are not removed\nuntil ImageJ is restarted.");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        command = gd.getNextChoice();
        boolean removeAll = false;
        if (shortcuts.length > 1) {
            removeAll = gd.getNextBoolean();
        }
        if (removeAll) {
            boolean ok = IJ.showMessageWithCancel("Remove", "Remove all " + shortcuts.length + " shortcuts?");
            if (!ok) {
                return;
            }
            command = "";
        } else {
            shortcuts = new String[]{command};
        }
        int count = 0;
        for (int i = 0; i < shortcuts.length; ++i) {
            int err = Menus.uninstallPlugin(shortcuts[i]);
            if (err != 0) continue;
            ++count;
        }
        if (count == 0) {
            IJ.showStatus("No shortcuts removed");
        } else {
            IJ.showStatus(count + " shortcut" + (count > 1 ? "s" : "") + " removed; ImageJ restart required");
        }
    }

    private void listCommands() {
        String[] commands = this.getAllCommands();
        Hashtable classes = Menus.getCommands();
        ResultsTable rt = new ResultsTable();
        for (int i = 0; i < commands.length; ++i) {
            rt.incrementCounter();
            rt.addValue("Command", commands[i]);
            rt.addValue("Plugin", (String)classes.get(commands[i]));
        }
        rt.show("Commands");
    }

    String[] getAllCommands() {
        Vector<String> v = new Vector<String>();
        Hashtable commandTable = Menus.getCommands();
        Hashtable shortcuts = Menus.getShortcuts();
        Enumeration en = commandTable.keys();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (cmd.startsWith("*") || cmd.startsWith(" ") || cmd.length() >= 35 || shortcuts.contains(cmd)) continue;
            v.addElement(cmd);
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    String[] getAvailableShortcuts() {
        String shortcut;
        char c;
        Vector<String> v = new Vector<String>();
        String[] existingShortcuts = new CommandLister().getShortcuts();
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            shortcut = "" + c;
            if (Menus.shortcutInUse(shortcut)) continue;
            v.add(shortcut);
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            shortcut = "" + c;
            if (Menus.shortcutInUse(shortcut)) continue;
            v.add(shortcut);
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            shortcut = "" + c;
            if (Menus.shortcutInUse(shortcut)) continue;
            v.add(shortcut);
        }
        for (int i = 1; i <= 12; ++i) {
            shortcut = "F" + i;
            if (Menus.shortcutInUse(shortcut)) continue;
            v.add(shortcut);
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        return list;
    }

    String[] getShortcuts() {
        Vector<String> v = new Vector<String>();
        Hashtable commandTable = Menus.getCommands();
        Enumeration en = commandTable.keys();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (!cmd.startsWith("*")) continue;
            v.addElement(cmd);
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }
}

