/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class DiagonalOperator
extends LinearEndomorphism {
    protected Vector diag;

    protected DiagonalOperator(VectorSpace space) {
        super(space);
        this.diag = null;
    }

    public DiagonalOperator(Vector diag) {
        super(diag.space);
        this.diag = diag;
    }

    public Vector getDiagonal() {
        return this.diag;
    }

    public void setDiagonal(Vector diag) {
        if (diag == null || !diag.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        this.diag = diag;
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) throws IncorrectSpaceException, NotImplementedException {
        if (job != DIRECT && job != ADJOINT) {
            throw new NotImplementedException();
        }
        this.space._multiply(dst, src, this.diag);
    }

    @Override
    protected void _apply(Vector vec, int job) throws IncorrectSpaceException, NotImplementedException {
        if (job != DIRECT && job != ADJOINT) {
            throw new NotImplementedException();
        }
        this.space._multiply(vec, vec, this.diag);
    }
}

