/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.IJ;
import ij.ImageStack;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mcib3d.geom.GeomTransform3D;
import mcib3d.geom.MeshEditor;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;
import mcib3d.utils.ThreadUtil;
import plugins.adufour.quickhull.QuickHull3D;

public class Object3DSurface
extends Object3D {
    protected List<Point3f> vertices = null;
    protected List<Integer> vertices_unique_index = null;
    protected List<Point3f> smooth_vertices = null;
    protected List<Point3f> unique_vertices = null;
    protected List<List<Point3f>> uniques_vertices_index = null;
    protected ArrayList<Vector3D> verticesNormals;
    ArrayList<Voxel3D> voxels = null;
    double surfaceMesh = Double.NaN;
    double surfaceMeshUnit = Double.NaN;
    double smooth_surface_area = Double.NaN;
    double smooth_surface_area_unit = Double.NaN;
    private float smoothing_factor = 0.1f;
    public static final int SMOOTH_LAPLACE = 1;
    public static final int SMOOTH_IJ3D = 2;
    public static final int SMOOTH_BLENDER = 3;
    private int smooth_method = 2;

    public Object3DSurface(List<Point3f> list) {
        this.vertices = list;
        this.smooth_vertices = null;
        this.voxels = null;
        this.smooth_surface_area = Double.NaN;
        this.smoothing_factor = 0.1f;
        this.value = 1;
        this.computeUniqueVertices();
        this.init();
    }

    public Object3DSurface(List<Point3f> list, int n) {
        this.vertices = list;
        this.smooth_vertices = null;
        this.voxels = null;
        this.smooth_surface_area = Double.NaN;
        this.smoothing_factor = 0.1f;
        this.value = n;
        this.computeUniqueVertices();
        this.init();
    }

    public void deCalibrateObject() {
        this.deCalibratePoints();
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.smooth_vertices = null;
        this.voxels = null;
        this.smooth_surface_area = Double.NaN;
        this.init();
    }

    private void deCalibratePoints() {
        for (Point3f point3f : this.vertices) {
            point3f.set(point3f.x / (float)this.resXY, point3f.y / (float)this.resXY, point3f.z / (float)this.resZ);
        }
        this.computeCenter();
        this.computeBounding();
    }

    public void reCalibrateObject() {
        this.reCalibratePoints();
        this.smooth_vertices = null;
        this.voxels = null;
        this.smooth_surface_area = Double.NaN;
        this.init();
    }

    public void reCalibratePoints() {
        for (Point3f point3f : this.vertices) {
            point3f.set(point3f.x * (float)this.resXY, point3f.y * (float)this.resXY, point3f.z * (float)this.resZ);
        }
        this.computeCenter();
        this.computeBounding();
    }

    public double getSmoothSurfaceArea() {
        if (Double.isNaN(this.smooth_surface_area)) {
            this.computeSmoothSurfaceArea();
        }
        return this.smooth_surface_area;
    }

    public double getSmoothSurfaceAreaUnit() {
        if (Double.isNaN(this.smooth_surface_area)) {
            this.computeSmoothSurfaceArea();
        }
        return this.smooth_surface_area_unit;
    }

    public double getSurfaceMesh() {
        if (Double.isNaN(this.surfaceMesh)) {
            this.computeSurfaceAreas();
        }
        return this.surfaceMesh;
    }

    public double getSurfaceMeshUnit() {
        if (Double.isNaN(this.surfaceMeshUnit)) {
            this.computeSurfaceAreas();
        }
        return this.surfaceMeshUnit;
    }

    public List<Point3f> getSmoothSurface() {
        if (this.smooth_vertices == null) {
            this.computeSmoothSurfaceArea();
        }
        return this.smooth_vertices;
    }

    public List<Point3f> getSurfaceTrianglesPixels(boolean bl) {
        if (bl && this.smooth_vertices == null) {
            this.computeSmoothSurfaceArea();
        }
        List<Point3f> list = bl ? this.smooth_vertices : this.vertices;
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        Iterator<Point3f> iterator = list.iterator();
        float f = (float)this.resXY;
        float f2 = (float)this.resZ;
        while (iterator.hasNext()) {
            Point3f point3f = iterator.next();
            Point3f point3f2 = new Point3f(point3f.x / f, point3f.y / f, point3f.z / f2);
            arrayList.add(point3f2);
        }
        return arrayList;
    }

    public List<Point3f> getSurfaceTrianglesUnit(boolean bl) {
        if (bl && this.smooth_vertices == null) {
            this.computeSmoothSurfaceArea();
        }
        List<Point3f> list = bl ? this.smooth_vertices : this.vertices;
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        for (Point3f point3f : list) {
            Point3f point3f2 = new Point3f(point3f.x, point3f.y, point3f.z);
            arrayList.add(point3f2);
        }
        return arrayList;
    }

    private double computeSurfaceMeshArea(boolean bl, double d, double d2) {
        double d3 = 0.0;
        List<Point3f> list = !bl ? this.vertices : this.smooth_vertices;
        for (int i = 0; i < list.size(); i += 3) {
            Vector3f vector3f = new Vector3f((Tuple3f)list.get(i));
            vector3f.sub((Tuple3f)list.get(i + 1));
            Vector3f vector3f2 = new Vector3f((Tuple3f)list.get(i));
            vector3f2.sub((Tuple3f)list.get(i + 2));
            Vector3f vector3f3 = new Vector3f();
            vector3f.set((float)((double)vector3f.x * d), (float)((double)vector3f.y * d), (float)((double)vector3f.z * d2));
            vector3f2.set((float)((double)vector3f2.x * d), (float)((double)vector3f2.y * d), (float)((double)vector3f2.z * d2));
            vector3f3.cross(vector3f, vector3f2);
            float f = vector3f3.length() * 0.5f;
            d3 += (double)f;
        }
        return d3;
    }

    public ArrayList<Point3f> computeConvexHull3D() {
        QuickHull3D quickHull3D = new QuickHull3D();
        ArrayList<Voxel3D> arrayList = this.getContours();
        Point3d[] point3dArray = new Point3d[arrayList.size()];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray[i] = new Point3d(arrayList.get(i).getX(), arrayList.get(i).getY(), arrayList.get(i).getZ());
        }
        quickHull3D.build(point3dArray);
        quickHull3D.triangulate();
        ArrayList<Point3f> arrayList2 = new ArrayList<Point3f>();
        int[][] nArray = quickHull3D.getFaces();
        Point3d[] point3dArray2 = quickHull3D.getVertices();
        for (int i = 0; i < point3dArray2.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                Point3d point3d = point3dArray2[nArray[i][j]];
                arrayList2.add(new Point3f((float)point3d.x, (float)point3d.y, (float)point3d.z));
            }
        }
        for (int[] nArray2 : nArray) {
            for (int i = 0; i < 3; ++i) {
                Point3d point3d = point3dArray2[nArray2[i]];
                arrayList2.add(new Point3f((float)point3d.x, (float)point3d.y, (float)point3d.z));
            }
        }
        return arrayList2;
    }

    private void computeSurfaceAreas() {
        this.areaContactVoxels = this.areaNbVoxels = this.computeSurfaceMeshArea(false, 1.0, 1.0);
        this.areaContactUnit = this.computeSurfaceMeshArea(false, this.resXY, this.resZ);
        this.surfaceMesh = this.areaNbVoxels;
        this.surfaceMeshUnit = this.areaContactUnit;
    }

    private void computeSmoothSurfaceArea() {
        if (this.smooth_vertices == null) {
            switch (this.smooth_method) {
                case 1: {
                    IJ.showStatus((String)"Smoothing Laplace");
                    this.computeSmoothSurface_Laplace();
                    break;
                }
                case 2: {
                    IJ.showStatus((String)"Smoothing IJ3D");
                    this.computeSmoothSurface_IJ3D();
                    break;
                }
                case 3: {
                    IJ.showStatus((String)"Smoothing blender");
                    this.computeSmoothSurface_BLENDER();
                    break;
                }
            }
        }
        this.smooth_surface_area = this.computeSurfaceMeshArea(true, 1.0, 1.0);
        this.smooth_surface_area_unit = this.computeSurfaceMeshArea(true, this.resXY, this.resZ);
    }

    private HashMap computeNeighorhood() {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.vertices.size(); i += 3) {
            this.computeNeighborhoodSurface(hashMap, i, 0);
            this.computeNeighborhoodSurface(hashMap, i, 1);
            this.computeNeighborhoodSurface(hashMap, i, 2);
        }
        return hashMap;
    }

    private void computeNeighborhoodSurface(HashMap hashMap, int n, int n2) {
        HashSet hashSet;
        if (hashMap.containsKey(this.vertices.get(n + n2))) {
            hashSet = (HashSet)hashMap.get(this.vertices.get(n + n2));
        } else {
            hashSet = new HashSet();
            hashMap.put(this.vertices.get(n + n2 % 3), hashSet);
        }
        if (!hashSet.contains(this.vertices.get(n + (n2 + 1) % 3))) {
            hashSet.add(this.vertices.get(n + (n2 + 1) % 3));
        }
        if (!hashSet.contains(this.vertices.get(n + (n2 + 2) % 3))) {
            hashSet.add(this.vertices.get(n + (n2 + 2) % 3));
        }
    }

    private void computeSmoothSurface_IJ3D() {
        this.smooth_vertices = MeshEditor.smooth(this.vertices, this.smoothing_factor);
    }

    private void computeSmoothSurface_BLENDER() {
        this.smooth_vertices = MeshEditor.smooth2(this.vertices, (int)(this.smoothing_factor * 10.0f));
    }

    private void computeSmoothSurface_Laplace() {
        HashMap hashMap = this.computeNeighorhood();
        HashMap<Point3f, Point3f> hashMap2 = new HashMap<Point3f, Point3f>();
        Iterator<Point3f> iterator = this.vertices.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Point3f point3f = iterator.next();
            Point3f point3f2 = new Point3f(0.0f, 0.0f, 0.0f);
            Object[] objectArray = ((HashSet)hashMap.get(point3f)).toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                point3f2.add((Tuple3f)((Point3f)objectArray[i]));
            }
            point3f2.scale(1.0f / (float)objectArray.length);
            point3f2.interpolate((Tuple3f)point3f, 1.0f - this.smoothing_factor);
            hashMap2.put(point3f, point3f2);
            ++n;
        }
        this.smooth_vertices = new ArrayList<Point3f>();
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.smooth_vertices.add((Point3f)hashMap2.get(this.vertices.get(i)));
        }
    }

    public static List<Point3f> invertNormals(List<Point3f> list) {
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        for (int i = 0; i < list.size(); i += 3) {
            arrayList.add(list.get(i));
            arrayList.add(list.get(i + 2));
            arrayList.add(list.get(i + 1));
        }
        return arrayList;
    }

    public float getSmoothingFactor() {
        return this.smoothing_factor;
    }

    public void setSmooth_method(int n) {
        if (n != this.smooth_method) {
            this.smooth_method = n;
            this.smooth_vertices = null;
            this.smooth_surface_area = Double.NaN;
        }
    }

    public void setSmoothingFactor(float f) {
        if (f != this.smoothing_factor) {
            this.smoothing_factor = f;
            this.smooth_vertices = null;
            this.smooth_surface_area = Double.NaN;
        }
    }

    private ArrayList<Vector3D> computeSurfaceNormals() {
        ArrayList<Vector3D> arrayList = new ArrayList<Vector3D>();
        for (int i = 0; i < this.vertices.size(); i += 3) {
            Vector3D vector3D = new Vector3D(this.vertices.get(i), this.vertices.get(i + 1));
            Vector3D vector3D2 = new Vector3D(this.vertices.get(i + 1), this.vertices.get(i + 2));
            Vector3D vector3D3 = vector3D.crossProduct(vector3D2);
            vector3D3.normalize();
            arrayList.add(vector3D3);
        }
        return arrayList;
    }

    public void computeVerticesNormals() {
        ArrayList<Vector3D> arrayList = this.computeSurfaceNormals();
        List<Integer> list = this.getUniqueVerticesIndexes();
        this.verticesNormals = new ArrayList();
        for (int i = 0; i < this.unique_vertices.size(); ++i) {
            int n = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int j = 0; j < list.size(); ++j) {
                if (list.get(j) != i) continue;
                int n2 = j / 3;
                f3 = (float)((double)f3 + arrayList.get((int)n2).x);
                f2 = (float)((double)f2 + arrayList.get((int)n2).y);
                f = (float)((double)f + arrayList.get((int)n2).z);
                ++n;
            }
            Vector3D vector3D = new Vector3D(f3 / (float)n, f2 / (float)n, f / (float)n);
            vector3D.normalize();
            this.verticesNormals.add(vector3D);
        }
    }

    @Override
    protected void computeCenter() {
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        for (Point3f point3f : this.unique_vertices) {
            this.bx += (double)point3f.x;
            this.by += (double)point3f.y;
            this.bz += (double)point3f.z;
        }
        int n = this.unique_vertices.size();
        this.bx /= (double)n;
        this.by /= (double)n;
        this.bz /= (double)n;
        this.volume = -1;
    }

    @Override
    protected void computeMassCenter(ImageHandler imageHandler) {
        if (imageHandler != null) {
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            for (Voxel3D voxel3D : this.getVoxels()) {
                double d5 = voxel3D.getX();
                double d6 = voxel3D.getY();
                double d7 = voxel3D.getZ();
                double d8 = imageHandler.getPixel(voxel3D);
                this.cx += d5 * d8;
                this.cy += d6 * d8;
                this.cz += d7 * d8;
                d += d8;
                d2 += d8 * d8;
                if (d8 > d4) {
                    d4 = d8;
                }
                if (!(d8 < d3)) continue;
                d3 = d8;
            }
            this.cx /= d;
            this.cy /= d;
            this.cz /= d;
            this.integratedDensity = d;
            this.pixmin = d3;
            this.pixmax = d4;
            int n = this.getVolumePixels();
            this.sigma = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1));
        }
    }

    @Override
    protected void computeBounding() {
        this.xmin = Integer.MAX_VALUE;
        this.xmax = 0;
        this.ymin = Integer.MAX_VALUE;
        this.ymax = 0;
        this.zmin = Integer.MAX_VALUE;
        this.zmax = 0;
        for (Point3f point3f : this.unique_vertices) {
            if (point3f.x < (float)this.xmin) {
                this.xmin = (int)point3f.x;
            }
            if (point3f.x > (float)this.xmax) {
                this.xmax = (int)point3f.x;
            }
            if (point3f.y < (float)this.ymin) {
                this.ymin = (int)point3f.y;
            }
            if (point3f.y > (float)this.ymax) {
                this.ymax = (int)point3f.y;
            }
            if (point3f.z < (float)this.zmin) {
                this.zmin = (int)point3f.z;
            }
            if (!(point3f.z > (float)this.zmax)) continue;
            this.zmax = (int)point3f.z;
        }
    }

    private void computeUniqueVertices() {
        this.uniques_vertices_index = new ArrayList<List<Point3f>>();
        this.unique_vertices = new ArrayList<Point3f>();
        IJ.showStatus((String)("Unique Vertices : " + this.vertices.size()));
        for (Point3f point3f : this.vertices) {
            int n;
            Point3f point3f2 = point3f;
            if (!this.unique_vertices.contains(point3f2)) {
                this.unique_vertices.add(point3f2);
                n = this.unique_vertices.indexOf(point3f2);
                ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
                arrayList.add(point3f2);
                this.uniques_vertices_index.add(n, arrayList);
                continue;
            }
            n = this.unique_vertices.indexOf(point3f2);
            this.uniques_vertices_index.get(n).add(point3f2);
        }
    }

    private void computeUniqueVerticesIndexes() {
        this.unique_vertices = new ArrayList<Point3f>();
        this.vertices_unique_index = new ArrayList<Integer>();
        Iterator<Point3f> iterator = this.vertices.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Point3f point3f = iterator.next();
            if (!this.unique_vertices.contains(point3f)) {
                this.unique_vertices.add(point3f);
                this.vertices_unique_index.add(n);
                ++n;
                continue;
            }
            this.vertices_unique_index.add(this.unique_vertices.indexOf(point3f));
        }
    }

    public List<Integer> getUniqueVerticesIndexes() {
        if (this.vertices_unique_index == null) {
            this.computeUniqueVerticesIndexes();
        }
        return this.vertices_unique_index;
    }

    @Override
    public void computeContours() {
        this.kdtreeContours = new KDTreeC(3);
        this.kdtreeContours.setScale3(this.resXY, this.resXY, this.resZ);
        this.contours = new ArrayList();
        double d = 1.0;
        for (Point3f point3f : this.unique_vertices) {
            Voxel3D voxel3D = new Voxel3D(point3f, d);
            this.contours.add(voxel3D);
            this.kdtreeContours.add(voxel3D.getArray(), voxel3D);
        }
        this.computeSurfaceAreas();
    }

    private ArrayList<Voxel3D> computeVoxelsMultithread() {
        final int n = (int)Math.floor(this.getZmin()) - 1;
        final int n2 = (int)Math.floor(this.getYmin()) - 1;
        final int n3 = (int)Math.floor(this.getXmin()) - 1;
        final int n4 = (int)Math.ceil(this.getZmax()) + 1;
        final int n5 = (int)Math.ceil(this.getYmax()) + 1;
        final int n6 = (int)Math.ceil(this.getXmax()) + 1;
        final int n7 = ThreadUtil.getNbCpus();
        final int n8 = this.getValue();
        final ArrayList[] arrayListArray = new ArrayList[n7];
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        final Vector3D vector3D = new Vector3D(1.0f, 0.0f, 0.0f);
        final Vector3D vector3D2 = new Vector3D(-1.0f, 0.0f, 0.0f);
        final int n9 = (int)Math.ceil((double)(n4 - n + 1) / (double)n7);
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = ThreadUtil.createThreadArray(n7);
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(){

                @Override
                public void run() {
                    int n10 = atomicInteger.getAndIncrement();
                    while (n10 < n7) {
                        int n22 = Math.min(n + (n10 + 1) * n9, n4);
                        for (float f = (float)(n + n9 * n10); f < (float)n22; f += 1.0f) {
                            IJ.showStatus((String)(n10 + " : Voxellisation " + f + "/" + (n22 - 1)));
                            for (float f2 = (float)n2; f2 <= (float)n5; f2 += 1.0f) {
                                boolean bl = false;
                                for (float f3 = (float)n3; f3 <= (float)n6; f3 += 1.0f) {
                                    int n32;
                                    double d;
                                    Point3D point3D;
                                    if (!bl) {
                                        point3D = new Point3D(f3, (double)f2 + 0.5, (double)f + 0.5);
                                        d = Object3DSurface.this.minDistSquareTriangles(point3D, vector3D, 1.0);
                                        if (d <= 1.0) {
                                            bl = true;
                                            continue;
                                        }
                                        if (d >= 9.0 && d < Double.MAX_VALUE) {
                                            f3 = (float)((double)f3 + (Math.floor(Math.sqrt(d)) - 1.0));
                                            continue;
                                        }
                                        if (d != Double.MAX_VALUE) continue;
                                        f3 += (float)n6;
                                        continue;
                                    }
                                    arrayListArray[n10].add(new Voxel3D(f3, f2, f, (double)n8));
                                    point3D = new Point3D(f3, (double)f2 + 0.5, (double)f + 0.5);
                                    d = Object3DSurface.this.minDistSquareTriangles(point3D, vector3D2, 1.0);
                                    if (d <= 1.0) {
                                        bl = false;
                                        continue;
                                    }
                                    if (!(d >= 9.0) || !(d < Double.MAX_VALUE) || !(f3 + (float)(n32 = (int)Math.floor(Math.sqrt(d))) < (float)n6)) continue;
                                    Object3DSurface.this.addLineXVoxels(arrayListArray[n10], n8, f3 + 1.0f, f2, f, n32);
                                    f3 += (float)n32;
                                    bl = false;
                                }
                            }
                        }
                        n10 = atomicInteger.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin(threadArray);
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        for (ArrayList arrayList2 : arrayListArray) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private ArrayList<Voxel3D> computeVoxels() {
        Vector3D vector3D = new Vector3D(1.0f, 0.0f, 0.0f);
        Vector3D vector3D2 = new Vector3D(-1.0f, 0.0f, 0.0f);
        int n = this.getValue();
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        float f = (float)this.getZmin() - 1.0f;
        float f2 = (float)this.getYmin() - 1.0f;
        float f3 = (float)this.getXmin() - 1.0f;
        float f4 = (float)this.getZmax() + 1.0f;
        float f5 = (float)this.getYmax() + 1.0f;
        float f6 = (float)this.getXmax() + 1.0f;
        for (float f7 = f; f7 <= f4; f7 += 1.0f) {
            IJ.showStatus((String)("Voxellisation " + f7 + "/" + f4));
            for (float f8 = f2; f8 <= f5; f8 += 1.0f) {
                boolean bl = false;
                for (float f9 = f3; f9 <= f6; f9 += 1.0f) {
                    int n2;
                    double d;
                    Point3D point3D;
                    if (!bl) {
                        point3D = new Point3D(f9, (double)f8 + 0.5, (double)f7 + 0.5);
                        d = this.minDistSquareTriangles(point3D, vector3D, 1.0);
                        if (d <= 1.0) {
                            bl = true;
                            continue;
                        }
                        if (!(d >= 9.0) || !(d < Double.MAX_VALUE)) continue;
                        f9 = (float)((double)f9 + (Math.floor(Math.sqrt(d)) - 1.0));
                        continue;
                    }
                    arrayList.add(new Voxel3D(f9, f8, f7, (double)n));
                    point3D = new Point3D(f9, (double)f8 + 0.5, (double)f7 + 0.5);
                    d = this.minDistSquareTriangles(point3D, vector3D2, 1.0);
                    if (d <= 1.0) {
                        bl = false;
                        continue;
                    }
                    if (!(d >= 9.0) || !(d < Double.MAX_VALUE) || !(f9 + (float)(n2 = (int)Math.floor(Math.sqrt(d))) < f6)) continue;
                    this.addLineXVoxels(arrayList, n, f9 + 1.0f, f8, f7, n2);
                    f9 += (float)n2;
                    bl = false;
                }
            }
        }
        return arrayList;
    }

    private void addLineXVoxels(ArrayList<Voxel3D> arrayList, int n, float f, float f2, float f3, int n2) {
        for (float f4 = 0.0f; f4 < (float)n2; f4 += 1.0f) {
            arrayList.add(new Voxel3D(f + f4, f2, f3, (double)n));
        }
    }

    private double minDistSquareTriangles(Point3D point3D, Vector3D vector3D, double d) {
        double d2 = d * d;
        double d3 = Double.MAX_VALUE;
        for (int i = 0; i < this.vertices.size(); i += 3) {
            double d4 = this.distanceSquareIntersectTriangle(this.vertices.get(i), this.vertices.get(i + 1), this.vertices.get(i + 2), vector3D, point3D);
            if (!(d4 <= d3) || !((d3 = d4) <= d2)) continue;
            return d3;
        }
        return d3;
    }

    private boolean intersectTriangle2(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3D vector3D, Point3D point3D) {
        Vector3D vector3D2 = new Vector3D(point3f, point3f2);
        Vector3D vector3D3 = new Vector3D(point3f, point3f3);
        Vector3D vector3D4 = vector3D2.crossProduct(vector3D3);
        boolean bl = false;
        double d = vector3D4.dotProduct(vector3D);
        if (d <= 0.0) {
            Point3D point3D2;
            Vector3D vector3D5 = new Vector3D(new Point3D(point3f), point3D);
            double d2 = vector3D5.crossProduct(vector3D3).dotProduct(vector3D) / d;
            double d3 = vector3D2.crossProduct(vector3D5).dotProduct(vector3D) / d;
            double d4 = -vector3D4.dotProduct(vector3D5) / d;
            if (d2 + d3 <= 1.0 && d2 >= 0.0 && d3 >= 0.0 && d4 >= 0.0 && point3D.distance(point3D2 = new Point3D((double)point3f.x + vector3D2.x * d2 + vector3D3.x * d3, (double)point3f.y + vector3D2.y * d2 + vector3D3.y * d3, (double)point3f.z + vector3D2.z * d2 + vector3D3.z * d3)) <= 1.0) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean intersectTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3D vector3D, Point3D point3D) {
        double d = this.distanceSquareIntersectTriangle(point3f, point3f2, point3f3, vector3D, point3D);
        return d <= 1.0;
    }

    private double distanceSquareIntersectTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3D vector3D, Point3D point3D) {
        Vector3D vector3D2 = new Vector3D(point3f, point3f2);
        Vector3D vector3D3 = new Vector3D(point3f, point3f3);
        Vector3D vector3D4 = vector3D2.crossProduct(vector3D3);
        double d = vector3D4.dotProduct(vector3D);
        if (d <= 0.0) {
            Vector3D vector3D5 = new Vector3D(new Point3D(point3f), point3D);
            double d2 = vector3D5.crossProduct(vector3D3).dotProduct(vector3D) / d;
            double d3 = vector3D2.crossProduct(vector3D5).dotProduct(vector3D) / d;
            double d4 = -vector3D4.dotProduct(vector3D5) / d;
            if (d2 + d3 <= 1.0 && d2 >= 0.0 && d3 >= 0.0 && d4 >= 0.0) {
                Point3D point3D2 = new Point3D((double)point3f.x + vector3D2.x * d2 + vector3D3.x * d3, (double)point3f.y + vector3D2.y * d2 + vector3D3.y * d3, (double)point3f.z + vector3D2.z * d2 + vector3D3.z * d3);
                return point3D.distanceSquare(point3D2);
            }
        }
        return Double.MAX_VALUE;
    }

    public static List<Point3f> createSphere(GeomTransform3D geomTransform3D, int n, int n2) {
        int n3;
        double[][][] dArray = Object3DSurface.generateGlobe(n, n2);
        Vector3D vector3D = new Vector3D(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < dArray.length; ++i) {
            for (n3 = 0; n3 < dArray[0].length; ++n3) {
                Vector3D vector3D2 = new Vector3D(dArray[i][n3][0], dArray[i][n3][1], dArray[i][n3][2]);
                Vector3D vector3D3 = geomTransform3D.getVectorTransformed(vector3D2, vector3D);
                dArray[i][n3][0] = vector3D3.getX();
                dArray[i][n3][1] = vector3D3.getY();
                dArray[i][n3][2] = vector3D3.getZ();
            }
        }
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        for (n3 = 0; n3 < dArray.length - 1; ++n3) {
            for (int i = 0; i < dArray[0].length - 1; ++i) {
                if (n3 != dArray.length - 2) {
                    arrayList.add(new Point3f((float)dArray[n3 + 1][i + 1][0], (float)dArray[n3 + 1][i + 1][1], (float)dArray[n3 + 1][i + 1][2]));
                    arrayList.add(new Point3f((float)dArray[n3][i][0], (float)dArray[n3][i][1], (float)dArray[n3][i][2]));
                    arrayList.add(new Point3f((float)dArray[n3 + 1][i][0], (float)dArray[n3 + 1][i][1], (float)dArray[n3 + 1][i][2]));
                }
                if (n3 == 0) continue;
                arrayList.add(new Point3f((float)dArray[n3][i][0], (float)dArray[n3][i][1], (float)dArray[n3][i][2]));
                arrayList.add(new Point3f((float)dArray[n3 + 1][i + 1][0], (float)dArray[n3 + 1][i + 1][1], (float)dArray[n3 + 1][i + 1][2]));
                arrayList.add(new Point3f((float)dArray[n3][i + 1][0], (float)dArray[n3][i + 1][1], (float)dArray[n3][i + 1][2]));
            }
        }
        return arrayList;
    }

    private static double[][][] generateGlobe(int n, int n2) {
        int n3;
        if (n < 3) {
            n = 3;
        }
        if (n2 < 3) {
            n2 = 3;
        }
        double d = Math.PI * 2 / (double)n;
        double d2 = 0.0;
        double[][] dArray = new double[n + 1][2];
        dArray[0][0] = 1.0;
        dArray[0][1] = 0.0;
        for (int i = 1; i < n; ++i) {
            d2 = d * (double)i;
            dArray[i][0] = Math.cos(d2);
            dArray[i][1] = Math.sin(d2);
        }
        dArray[dArray.length - 1][0] = 1.0;
        dArray[dArray.length - 1][1] = 0.0;
        d = Math.PI / (double)n2;
        double[][][] dArray2 = new double[n2 + 1][dArray.length][3];
        for (n3 = 1; n3 < dArray2.length - 1; ++n3) {
            double d3 = Math.sin(d * (double)n3);
            double d4 = Math.cos(d * (double)n3);
            for (int i = 0; i < dArray2[0].length - 1; ++i) {
                dArray2[n3][i][0] = dArray[i][0] * d3;
                dArray2[n3][i][1] = dArray[i][1] * d3;
                dArray2[n3][i][2] = d4;
            }
            dArray2[n3][dArray2[0].length - 1][0] = dArray2[n3][0][0];
            dArray2[n3][dArray2[0].length - 1][1] = dArray2[n3][0][1];
            dArray2[n3][dArray2[0].length - 1][2] = dArray2[n3][0][2];
        }
        for (n3 = 0; n3 < dArray2[0].length; ++n3) {
            dArray2[0][n3][0] = 0.0;
            dArray2[0][n3][1] = 0.0;
            dArray2[0][n3][2] = 1.0;
            dArray2[dArray2.length - 1][n3][0] = 0.0;
            dArray2[dArray2.length - 1][n3][1] = 0.0;
            dArray2[dArray2.length - 1][n3][2] = -1.0;
        }
        return dArray2;
    }

    @Override
    protected void computeMoments2(boolean bl) {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        ArrayList<Voxel3D> arrayList = this.getVoxels();
        for (Voxel3D voxel3D : arrayList) {
            double d = voxel3D.x;
            double d2 = voxel3D.y;
            double d3 = voxel3D.z;
            this.s200 += (d - this.bx) * (d - this.bx);
            this.s020 += (d2 - this.by) * (d2 - this.by);
            this.s002 += (d3 - this.bz) * (d3 - this.bz);
            this.s110 += (d - this.bx) * (d2 - this.by);
            this.s101 += (d - this.bx) * (d3 - this.bz);
            this.s011 += (d2 - this.by) * (d3 - this.bz);
        }
        double d = arrayList.size();
        if (bl) {
            this.s200 /= d;
            this.s020 /= d;
            this.s002 /= d;
            this.s110 /= d;
            this.s101 /= d;
            this.s011 /= d;
        }
        this.eigen = null;
    }

    @Override
    protected void computeMoments3() {
        double d;
        this.s003 = 0.0;
        this.s030 = 0.0;
        this.s300 = 0.0;
        this.s111 = 0.0;
        this.s012 = 0.0;
        this.s102 = 0.0;
        this.s021 = 0.0;
        this.s120 = 0.0;
        this.s201 = 0.0;
        this.s210 = 0.0;
        ArrayList<Voxel3D> arrayList = this.getVoxels();
        for (Voxel3D voxel3D : arrayList) {
            double d2 = voxel3D.x;
            double d3 = voxel3D.y;
            double d4 = voxel3D.z;
            d = d2 - this.bx;
            double d5 = d3 - this.by;
            double d6 = d4 - this.bz;
            this.s300 += d * d * d;
            this.s030 += d5 * d5 * d5;
            this.s003 += d6 * d6 * d6;
            this.s210 += d * d * d5;
            this.s201 += d * d * d6;
            this.s120 += d5 * d5 * d;
            this.s021 += d5 * d5 * d6;
            this.s102 += d6 * d6 * d;
            this.s012 += d6 * d6 * d5;
            this.s111 += d * d5 * d6;
        }
        this.s300 *= this.resXY * this.resXY * this.resXY;
        this.s030 *= this.resXY * this.resXY * this.resXY;
        this.s003 *= this.resZ * this.resZ * this.resZ;
        this.s210 *= this.resXY * this.resXY * this.resXY;
        this.s201 *= this.resXY * this.resXY * this.resZ;
        this.s120 *= this.resXY * this.resXY * this.resXY;
        this.s021 *= this.resXY * this.resXY * this.resZ;
        this.s102 *= this.resZ * this.resZ * this.resXY;
        this.s012 *= this.resZ * this.resZ * this.resXY;
        this.s111 *= this.resXY * this.resXY * this.resZ;
        d = arrayList.size();
        this.s300 /= d;
        this.s030 /= d;
        this.s003 /= d;
        this.s210 /= d;
        this.s201 /= d;
        this.s120 /= d;
        this.s021 /= d;
        this.s102 /= d;
        this.s012 /= d;
        this.s111 /= d;
    }

    @Override
    public void computeMoments4() {
        this.s211 = 0.0;
        this.s112 = 0.0;
        this.s121 = 0.0;
        this.s022 = 0.0;
        this.s202 = 0.0;
        this.s220 = 0.0;
        this.s040 = 0.0;
        this.s040 = 0.0;
        this.s400 = 0.0;
        this.s031 = 0.0;
        this.s013 = 0.0;
        this.s310 = 0.0;
        this.s130 = 0.0;
        this.s301 = 0.0;
        this.s103 = 0.0;
        ArrayList<Voxel3D> arrayList = this.getVoxels();
        for (Voxel3D voxel3D : arrayList) {
            double d = voxel3D.getX();
            double d2 = voxel3D.getY();
            double d3 = voxel3D.getZ();
            double d4 = d - this.bx;
            double d5 = d2 - this.by;
            double d6 = d3 - this.bz;
            this.s400 += d4 * d4 * d4 * d4;
            this.s040 += d5 * d5 * d5 * d5;
            this.s004 += d6 * d6 * d6 * d6;
            this.s220 += d4 * d4 * d5 * d5;
            this.s202 += d4 * d4 * d6 * d6;
            this.s022 += d5 * d5 * d6 * d6;
            this.s121 += d4 * d5 * d5 * d6;
            this.s112 += d4 * d5 * d6 * d6;
            this.s211 += d4 * d4 * d5 * d6;
            this.s103 += d4 * d6 * d6 * d6;
            this.s301 += d4 * d4 * d4 * d6;
            this.s130 += d4 * d5 * d5 * d5;
            this.s310 += d4 * d4 * d4 * d5;
            this.s013 += d5 * d6 * d6 * d6;
            this.s031 += d5 * d5 * d5 * d6;
        }
        this.s400 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s040 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s004 *= this.resZ * this.resZ * this.resZ * this.resZ;
        this.s220 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s202 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s022 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s121 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s112 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s211 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s103 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s301 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s130 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s310 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s013 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s031 *= this.resXY * this.resXY * this.resXY * this.resZ;
    }

    @Override
    public Voxel3D getPixelMax(ImageHandler imageHandler) {
        Voxel3D voxel3D = null;
        float f = -3.4028235E38f;
        for (Voxel3D voxel3D2 : this.getVoxels()) {
            float f2 = imageHandler.getPixel(voxel3D2);
            if (!(f2 > f)) continue;
            f = f2;
            voxel3D = new Voxel3D(voxel3D2);
        }
        return voxel3D;
    }

    public ArrayList listVoxels(ImageHandler imageHandler, double d) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        Iterator<Voxel3D> iterator = this.getVoxels().iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel3D = new Voxel3D(iterator.next());
            float f = imageHandler.getPixel(voxel3D);
            if (!((double)f > d)) continue;
            voxel3D.setValue(f);
            arrayList.add(voxel3D);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Voxel3D> getVoxels() {
        if (this.voxels != null) {
            return this.voxels;
        }
        if (this.resXY != 1.0 || this.resZ != 1.0) {
            this.deCalibratePoints();
        }
        this.voxels = this.multiThread ? this.computeVoxelsMultithread() : this.computeVoxels();
        if (this.resXY != 1.0 || this.resZ != 1.0) {
            this.reCalibratePoints();
        }
        return this.voxels;
    }

    protected Object3DVoxels buildObject3DVoxels() {
        Object3DVoxels object3DVoxels = new Object3DVoxels(this.getVoxels());
        object3DVoxels.setCalibration(this.getCalibration());
        return object3DVoxels;
    }

    public Point3f getVertex(int n) {
        return this.vertices.get(n);
    }

    public Point3f getUniqueVertex(int n) {
        return this.unique_vertices.get(n);
    }

    public int getNbUniqueVertices() {
        return this.unique_vertices.size();
    }

    public List<Point3f> getSurfaceTriangles(boolean bl) {
        if (bl) {
            return this.vertices;
        }
        return this.getSurfaceTrianglesPixels(false);
    }

    public List computeMeshSurface(boolean bl) {
        return this.getSurfaceTriangles(bl);
    }

    @Override
    public void draw(ByteProcessor byteProcessor, int n, int n2) {
        for (Voxel3D voxel3D : this.getVoxels()) {
            if (!(Math.abs((double)n - voxel3D.getZ()) < 0.5)) continue;
            byteProcessor.putPixel((int)Math.round(voxel3D.getX()), (int)Math.round(voxel3D.getY()), n2);
        }
    }

    @Override
    public void draw(ImageStack imageStack, int n) {
        for (Voxel3D voxel3D : this.getVoxels()) {
            imageStack.setVoxel((int)Math.round(voxel3D.getX()), (int)Math.round(voxel3D.getY()), (int)Math.round(voxel3D.getY()), (double)n);
        }
    }

    @Override
    public void draw(ImageHandler imageHandler, int n) {
        for (Voxel3D voxel3D : this.getVoxels()) {
            imageHandler.setPixel((int)Math.round(voxel3D.getX()), (int)Math.round(voxel3D.getY()), (int)Math.round(voxel3D.getY()), n);
        }
    }

    @Override
    public void draw(ImageStack imageStack, int n, int n2, int n3) {
        Color color = new Color(n, n2, n3);
        for (Voxel3D voxel3D : this.getVoxels()) {
            ImageProcessor imageProcessor = imageStack.getProcessor((int)(voxel3D.getZ() + 1.0));
            imageProcessor.setColor(color);
            imageProcessor.drawPixel((int)voxel3D.getX(), (int)voxel3D.getY());
        }
    }

    @Override
    public Roi createRoi(int n) {
        float[] fArray = new float[this.vertices.size()];
        float[] fArray2 = new float[this.vertices.size()];
        int n2 = 0;
        for (Point3f point3f : this.unique_vertices) {
            if (!((double)Math.abs((float)n - point3f.z) < 0.5)) continue;
            fArray[n2] = point3f.x;
            fArray2[n2] = point3f.y;
        }
        PolygonRoi polygonRoi = new PolygonRoi(fArray, fArray2, fArray.length, 10);
        return polygonRoi;
    }

    @Override
    public void writeVoxels(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void translate(double d, double d2, double d3) {
        Point3f point3f = new Point3f((float)d, (float)d2, (float)d3);
        for (Point3f point3f2 : this.vertices) {
            point3f2.add((Tuple3f)point3f);
        }
        this.init();
    }

    public static List translateTool(List list, float f, float f2, float f3) {
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>(list.size());
        for (Point3f point3f : list) {
            Point3f point3f2 = new Point3f(point3f.x + f, point3f.y + f2, point3f.z + f3);
            arrayList.add(point3f2);
        }
        return arrayList;
    }

    public void scale(double d) {
        Vector3D vector3D = this.getCenterAsVector();
        for (int i = 0; i < this.vertices.size(); ++i) {
            Point3f point3f = this.getVertex(i);
            Vector3D vector3D2 = new Vector3D(point3f);
            Vector3D vector3D3 = new Vector3D(vector3D, vector3D2);
            Vector3D vector3D4 = vector3D3.multiply(d);
            Vector3D vector3D5 = new Vector3D((Point3D)vector3D);
            vector3D5.translate(vector3D4);
            point3f.set((Tuple3f)vector3D5.getPoint3f());
        }
        this.init();
    }

    public void scale(double d, Vector3D vector3D) {
        Vector3D vector3D2 = vector3D.getNormalizedVector();
        Vector3D vector3D3 = this.getCenterAsVector();
        for (int i = 0; i < this.vertices.size(); ++i) {
            Point3f point3f = this.getVertex(i);
            Vector3D vector3D4 = new Vector3D(point3f);
            Vector3D vector3D5 = new Vector3D(vector3D3, vector3D4);
            double d2 = Math.abs(vector3D5.getNormalizedVector().dotProduct(vector3D2));
            double d3 = 1.0 + d2 * d2 * (d - 1.0);
            Vector3D vector3D6 = vector3D5.multiply(d3);
            Vector3D vector3D7 = new Vector3D((Point3D)vector3D3);
            vector3D7.translate(vector3D6);
            point3f.set((Tuple3f)vector3D7.getPoint3f());
        }
        this.init();
    }

    public void rotate(Vector3D vector3D, double d) {
        GeomTransform3D geomTransform3D = new GeomTransform3D();
        geomTransform3D.setRotation(vector3D, d);
        Vector3D vector3D2 = this.getCenterAsVector();
        for (Point3f point3f : this.vertices) {
            Vector3D vector3D3 = geomTransform3D.getVectorTransformed(new Vector3D(point3f), vector3D2);
            point3f.set((float)vector3D3.getX(), (float)vector3D3.getY(), (float)vector3D3.getZ());
        }
        this.init();
    }

    public ArrayList<Point3f> getRotated(Vector3D vector3D, double d) {
        GeomTransform3D geomTransform3D = new GeomTransform3D();
        geomTransform3D.setRotation(vector3D, d);
        Vector3D vector3D2 = this.getCenterAsVector();
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>(this.vertices.size());
        for (Point3f point3f : this.vertices) {
            Vector3D vector3D3 = geomTransform3D.getVectorTransformed(new Vector3D(point3f), vector3D2);
            arrayList.add(new Point3f((float)vector3D3.getX(), (float)vector3D3.getY(), (float)vector3D3.getZ()));
        }
        return arrayList;
    }

    @Override
    public int getColoc(Object3D object3D) {
        Object3DVoxels object3DVoxels = this.getObject3DVoxels();
        Object3DVoxels object3DVoxels2 = object3D.getObject3DVoxels();
        return object3DVoxels.getColoc(object3DVoxels2);
    }

    @Override
    public boolean hasOneVoxelColoc(Object3D object3D) {
        Object3DVoxels object3DVoxels = this.getObject3DVoxels();
        Object3DVoxels object3DVoxels2 = object3D.getObject3DVoxels();
        return object3DVoxels.hasOneVoxelColoc(object3DVoxels2);
    }

    @Override
    public ArrayUtil listValues(ImageHandler imageHandler) {
        ArrayUtil arrayUtil = new ArrayUtil(this.getVolumePixels());
        int n = 0;
        for (Voxel3D voxel3D : this.voxels) {
            if (!imageHandler.contains(voxel3D)) continue;
            float f = imageHandler.getPixel(voxel3D);
            arrayUtil.addValue(n, f);
            ++n;
        }
        arrayUtil.setSize(n);
        return arrayUtil;
    }
}

