/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;

public class CircularRoiMaker
implements PlugIn,
DialogListener {
    private static double saveRadius;
    private double xcenter;
    private double ycenter;
    private double radius;
    private boolean bAbort;
    private ImagePlus imp;
    private Calibration cal;

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.cal = this.imp.getCalibration();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        this.xcenter = width / 2;
        this.ycenter = height / 2;
        boolean macro = Macro.getOptions() != null;
        double d = this.radius = !macro && saveRadius != 0.0 ? saveRadius : (double)(width / 4);
        if (this.radius > (double)(width / 2)) {
            this.radius = width / 2;
        }
        if (this.radius > (double)(height / 2)) {
            this.radius = height / 2;
        }
        this.showDialog();
        if (!macro) {
            saveRadius = this.radius;
        }
    }

    private void showDialog() {
        Roi roi = this.imp.getRoi();
        this.drawRoi();
        GenericDialog gd = new GenericDialog("Circular ROI");
        gd.addSlider("Radius:", 0.0, this.imp.getWidth() / 2, this.radius);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (roi == null) {
                this.imp.deleteRoi();
            } else {
                this.imp.setRoi(roi);
            }
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        this.radius = gd.getNextNumber();
        if (gd.invalidNumber()) {
            return false;
        }
        this.drawRoi();
        return true;
    }

    private void drawRoi() {
        double x = this.xcenter - this.radius;
        double y = this.ycenter - this.radius;
        OvalRoi roi = new OvalRoi(x, y, this.radius * 2.0, this.radius * 2.0);
        this.imp.setRoi(roi);
        this.showRadius();
    }

    private void showRadius() {
        String units = this.cal.getUnits();
        String s = " radius = ";
        if (this.imp.getProperty("FHT") != null) {
            int width = this.imp.getWidth();
            s = this.radius < 1.0 ? s + "Infinity/c" : (this.cal.scaled() ? s + IJ.d2s((double)width / this.radius * this.cal.pixelWidth, 2) + " " + units + "/c" : s + IJ.d2s((double)width / this.radius, 2) + " p/c");
        } else {
            int digits = this.cal.pixelWidth == 1.0 ? 0 : 2;
            s = s + IJ.d2s(this.radius * this.cal.pixelWidth, digits) + " " + units;
        }
        IJ.showStatus(s);
    }
}

