/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleLUDecompositionQuick;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DoubleAMG
implements DoublePreconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private SparseRCDoubleMatrix2D[] A;
    private DenseDoubleLUDecompositionQuick lu;
    private DenseDoubleMatrix1D[] u;
    private DenseDoubleMatrix1D[] f;
    private DenseDoubleMatrix1D[] r;
    private SparseCCDoubleMatrix2D[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final double omegaPreF;
    private final double omegaPreR;
    private final double omegaPostF;
    private final double omegaPostR;
    private final boolean reverse;
    private final double omega;
    private boolean transpose;

    public DoubleAMG(double omegaPreF, double omegaPreR, double omegaPostF, double omegaPostR, int nu1, int nu2, int gamma, int min, double omega) {
        this.omegaPreF = omegaPreF;
        this.omegaPreR = omegaPreR;
        this.omegaPostF = omegaPostF;
        this.omegaPostR = omegaPostR;
        this.reverse = true;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min;
        this.omega = omega;
    }

    public DoubleAMG(double omegaPre, double omegaPost, int nu1, int nu2, int gamma, int min, double omega) {
        this.omegaPreF = omegaPre;
        this.omegaPreR = omegaPre;
        this.omegaPostF = omegaPost;
        this.omegaPostR = omegaPost;
        this.reverse = false;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min;
        this.omega = omega;
    }

    public DoubleAMG() {
        this(1.0, 1.85, 1.85, 1.0, 1, 1, 1, 40, 0.6666666666666666);
    }

    @Override
    public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.u[0].assign(x);
        this.f[0].assign(b);
        this.transpose = false;
        this.cycle(0);
        return x.assign(this.u[0]);
    }

    @Override
    public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.u[0].assign(x);
        this.f[0].assign(b);
        this.transpose = true;
        this.cycle(0);
        return x.assign(this.u[0]);
    }

    @Override
    public void setMatrix(DoubleMatrix2D A) {
        LinkedList<SparseRCDoubleMatrix2D> Al = new LinkedList<SparseRCDoubleMatrix2D>();
        LinkedList<SparseCCDoubleMatrix2D> Il = new LinkedList<SparseCCDoubleMatrix2D>();
        SparseRCDoubleMatrix2D Arc = new SparseRCDoubleMatrix2D(A.rows(), A.columns());
        Arc.assign(A);
        if (!Arc.hasColumnIndexesSorted()) {
            Arc.sortColumnIndexes();
        }
        Al.add(Arc);
        int k = 0;
        while (((SparseRCDoubleMatrix2D)Al.get(k)).rows() > this.min) {
            double eps;
            SparseRCDoubleMatrix2D Af = (SparseRCDoubleMatrix2D)Al.get(k);
            Aggregator aggregator = new Aggregator(Af, eps = 0.08 * Math.pow(0.5, k));
            if (aggregator.getAggregates().size() == 0) break;
            Interpolator sa = new Interpolator(aggregator, Af, this.omega);
            Al.add(sa.getGalerkinOperator());
            Il.add(sa.getInterpolationOperator());
            ++k;
        }
        this.m = Al.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new SparseCCDoubleMatrix2D[this.m - 1];
        this.A = new SparseRCDoubleMatrix2D[this.m - 1];
        Il.toArray(this.I);
        int i = 0;
        while (i < Al.size() - 1) {
            this.A[i] = (SparseRCDoubleMatrix2D)Al.get(i);
            ++i;
        }
        DenseDoubleMatrix2D Ac = new DenseDoubleMatrix2D(((SparseRCDoubleMatrix2D)Al.get(Al.size() - 1)).toArray());
        this.lu = new DenseDoubleLUDecompositionQuick();
        this.lu.decompose(Ac);
        this.u = new DenseDoubleMatrix1D[this.m];
        this.f = new DenseDoubleMatrix1D[this.m];
        this.r = new DenseDoubleMatrix1D[this.m];
        int k2 = 0;
        while (k2 < this.m) {
            int n = ((SparseRCDoubleMatrix2D)Al.get(k2)).rows();
            this.u[k2] = new DenseDoubleMatrix1D(n);
            this.f[k2] = new DenseDoubleMatrix1D(n);
            this.r[k2] = new DenseDoubleMatrix1D(n);
            ++k2;
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        k2 = 0;
        while (k2 < this.m - 1) {
            SparseRCDoubleMatrix2D Ak = this.A[k2];
            this.preM[k2] = new SSOR(Ak, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[k2] = new SSOR(Ak, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[k2].setMatrix(Ak);
            this.postM[k2].setMatrix(Ak);
            ++k2;
        }
    }

    private void cycle(int k) {
        if (k == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(k);
            this.u[k + 1].assign(0.0);
            this.A[k].zMult(this.u[k], this.r[k].assign(this.f[k]), -1.0, 1.0, false);
            this.I[k].zMult(this.r[k], this.f[k + 1], 1.0, 0.0, true);
            int i = 0;
            while (i < this.gamma) {
                this.cycle(k + 1);
                ++i;
            }
            this.I[k].zMult(this.u[k + 1], this.u[k], 1.0, 1.0, false);
            this.postRelax(k);
        }
    }

    private void directSolve() {
        int k = this.m - 1;
        this.u[k].assign(this.f[k]);
        if (this.transpose) {
            this.lu.setLU(this.lu.getLU().viewDice());
            this.lu.solve(this.u[k]);
            this.lu.setLU(this.lu.getLU().viewDice());
        } else {
            this.lu.solve(this.u[k]);
        }
    }

    private void preRelax(int k) {
        int i = 0;
        while (i < this.nu1) {
            if (this.transpose) {
                this.preM[k].transApply(this.f[k], this.u[k]);
            } else {
                this.preM[k].apply(this.f[k], this.u[k]);
            }
            ++i;
        }
    }

    private void postRelax(int k) {
        int i = 0;
        while (i < this.nu2) {
            if (this.transpose) {
                this.postM[k].transApply(this.f[k], this.u[k]);
            } else {
                this.postM[k].apply(this.f[k], this.u[k]);
            }
            ++i;
        }
    }

    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(SparseRCDoubleMatrix2D A, double eps) {
            this.diagind = this.findDiagonalindexes(A);
            this.N = this.findNodeNeighborhood(A, this.diagind, eps);
            boolean[] R = this.createInitialR(A);
            this.C = this.createInitialAggregates(this.N, R);
            this.C = this.enlargeAggregates(this.C, this.N, R);
            this.C = this.createFinalAggregates(this.C, this.N, R);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalindexes() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalindexes(SparseRCDoubleMatrix2D A) {
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            int[] diagind = new int[A.rows()];
            int i = 0;
            while (i < A.rows()) {
                diagind[i] = Sorting.binarySearchFromTo(colind, i, rowptr[i], rowptr[i + 1]);
                if (diagind[i] < 0) {
                    throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i + 1));
                }
                ++i;
            }
            return diagind;
        }

        private List<Set<Integer>> findNodeNeighborhood(SparseRCDoubleMatrix2D A, int[] diagind, double eps) {
            this.N = new ArrayList<Set<Integer>>(A.rows());
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            double[] data = A.getValues();
            int i = 0;
            while (i < A.rows()) {
                HashSet<Integer> Ni = new HashSet<Integer>();
                double aii = data[diagind[i]];
                int j = rowptr[i];
                while (j < rowptr[i + 1]) {
                    double aij = data[j];
                    double ajj = data[diagind[colind[j]]];
                    if (Math.abs(aij) >= eps * Math.sqrt(aii * ajj)) {
                        Ni.add(colind[j]);
                    }
                    ++j;
                }
                this.N.add(Ni);
                ++i;
            }
            return this.N;
        }

        private boolean[] createInitialR(SparseRCDoubleMatrix2D A) {
            boolean[] R = new boolean[A.rows()];
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            double[] data = A.getValues();
            int i = 0;
            while (i < A.rows()) {
                boolean hasOffDiagonal = false;
                int j = rowptr[i];
                while (j < rowptr[i + 1]) {
                    if (colind[j] != i && data[j] != 0.0) {
                        hasOffDiagonal = true;
                        break;
                    }
                    ++j;
                }
                R[i] = hasOffDiagonal;
                ++i;
            }
            return R;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> N, boolean[] R) {
            this.C = new ArrayList<Set<Integer>>();
            int i = 0;
            while (i < R.length) {
                if (R[i]) {
                    boolean free = true;
                    for (int j : N.get(i)) {
                        free &= R[j];
                    }
                    if (free) {
                        this.C.add(new HashSet(N.get(i)));
                        for (int j : N.get(i)) {
                            R[j] = false;
                        }
                    }
                }
                ++i;
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            ArrayList belong = new ArrayList(R.length);
            int i = 0;
            while (i < R.length) {
                belong.add(new ArrayList());
                ++i;
            }
            int k = 0;
            while (k < C.size()) {
                for (int j : C.get(k)) {
                    ((List)belong.get(j)).add(k);
                }
                ++k;
            }
            int[] intersect = new int[C.size()];
            int i2 = 0;
            while (i2 < R.length) {
                if (R[i2]) {
                    Arrays.fill(intersect, 0);
                    int largest = 0;
                    int maxValue = 0;
                    for (int j : N.get(i2)) {
                        Iterator iterator = ((List)belong.get(j)).iterator();
                        while (iterator.hasNext()) {
                            int k2;
                            int n = k2 = ((Integer)iterator.next()).intValue();
                            intersect[n] = intersect[n] + 1;
                            if (intersect[k2] <= maxValue) continue;
                            largest = k2;
                            maxValue = intersect[largest];
                        }
                    }
                    if (maxValue > 0) {
                        R[i2] = false;
                        C.get(largest).add(i2);
                    }
                }
                ++i2;
            }
            return C;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            int i = 0;
            while (i < R.length) {
                if (R[i]) {
                    HashSet<Integer> Cn = new HashSet<Integer>();
                    for (int j : N.get(i)) {
                        if (!R[j]) continue;
                        R[j] = false;
                        Cn.add(j);
                    }
                    if (!Cn.isEmpty()) {
                        C.add(Cn);
                    }
                }
                ++i;
            }
            return C;
        }
    }

    private static class Interpolator {
        private SparseRCDoubleMatrix2D Ac;
        private SparseCCDoubleMatrix2D I;

        public Interpolator(Aggregator aggregator, SparseRCDoubleMatrix2D A, double omega) {
            List<Set<Integer>> C = aggregator.getAggregates();
            List<Set<Integer>> N = aggregator.getNodeNeighborhoods();
            int[] diagind = aggregator.getDiagonalindexes();
            int[] pt = this.createTentativeProlongation(C, A.rows());
            if (omega != 0.0) {
                List<Map<Integer, Double>> P = this.createSmoothedProlongation(C, N, A, diagind, omega, pt);
                this.I = this.createInterpolationMatrix(P, A.rows());
                this.Ac = this.createGalerkinSlow(this.I, A);
            } else {
                this.Ac = this.createGalerkinFast(A, pt, C.size());
                this.I = this.createInterpolationMatrix(pt, C.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> C, int n) {
            int[] pt = new int[n];
            Arrays.fill(pt, -1);
            int i = 0;
            while (i < C.size()) {
                for (int j : C.get(i)) {
                    pt[j] = i;
                }
                ++i;
            }
            return pt;
        }

        private SparseRCDoubleMatrix2D createGalerkinFast(SparseRCDoubleMatrix2D A, int[] pt, int c) {
            int n = pt.length;
            SparseRCMDoubleMatrix2D Ac = new SparseRCMDoubleMatrix2D(c, c);
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            double[] data = A.getValues();
            int i = 0;
            while (i < n) {
                if (pt[i] != -1) {
                    int j = rowptr[i];
                    while (j < rowptr[i + 1]) {
                        if (pt[colind[j]] != -1) {
                            Ac.setQuick(pt[i], pt[colind[j]], data[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return (SparseRCDoubleMatrix2D)new SparseRCDoubleMatrix2D(Ac.rows(), Ac.columns()).assign(Ac);
        }

        private SparseCCDoubleMatrix2D createInterpolationMatrix(List<Map<Integer, Double>> P, int n) {
            int c = P.size();
            this.I = new SparseCCDoubleMatrix2D(n, c);
            int j = 0;
            while (j < c) {
                Map<Integer, Double> Pj = P.get(j);
                for (Map.Entry<Integer, Double> e : Pj.entrySet()) {
                    this.I.setQuick(e.getKey(), j, e.getValue());
                }
                ++j;
            }
            return this.I;
        }

        private SparseCCDoubleMatrix2D createInterpolationMatrix(int[] pt, int c) {
            SparseCCMDoubleMatrix2D If = new SparseCCMDoubleMatrix2D(pt.length, c);
            int i = 0;
            while (i < pt.length) {
                if (pt[i] != -1) {
                    If.setQuick(i, pt[i], 1.0);
                }
                ++i;
            }
            return (SparseCCDoubleMatrix2D)new SparseCCDoubleMatrix2D(If.rows(), If.columns()).assign(If);
        }

        public SparseCCDoubleMatrix2D getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Double>> createSmoothedProlongation(List<Set<Integer>> C, List<Set<Integer>> N, SparseRCDoubleMatrix2D A, int[] diagind, double omega, int[] pt) {
            int n = A.rows();
            int c = C.size();
            ArrayList<Map<Integer, Double>> P = new ArrayList<Map<Integer, Double>>(c);
            int i = 0;
            while (i < c) {
                P.add(new HashMap());
                ++i;
            }
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndexes();
            double[] data = A.getValues();
            double[] dot = new double[c];
            int i2 = 0;
            while (i2 < n) {
                if (pt[i2] != -1) {
                    Arrays.fill(dot, 0.0);
                    Set<Integer> Ni = N.get(i2);
                    double weakAij = 0.0;
                    int j = rowptr[i2];
                    while (j < rowptr[i2 + 1]) {
                        if (pt[colind[j]] != -1) {
                            double aij = data[j];
                            if (aij != 0.0 && !Ni.contains(colind[j])) {
                                weakAij += aij;
                            } else {
                                int n2 = pt[colind[j]];
                                dot[n2] = dot[n2] + aij;
                            }
                        }
                        ++j;
                    }
                    int n3 = pt[i2];
                    dot[n3] = dot[n3] - weakAij;
                    double scale = -omega / data[diagind[i2]];
                    int j2 = 0;
                    while (j2 < dot.length) {
                        int n4 = j2++;
                        dot[n4] = dot[n4] * scale;
                    }
                    int n5 = pt[i2];
                    dot[n5] = dot[n5] + 1.0;
                    j2 = 0;
                    while (j2 < dot.length) {
                        if (dot[j2] != 0.0) {
                            ((Map)P.get(j2)).put(i2, dot[j2]);
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
            return P;
        }

        private SparseRCDoubleMatrix2D createGalerkinSlow(SparseCCDoubleMatrix2D I, SparseRCDoubleMatrix2D A) {
            int n = I.rows();
            int c = I.columns();
            SparseRCMDoubleMatrix2D Ac = new SparseRCMDoubleMatrix2D(c, c);
            double[] aiCol = new double[n];
            double[] iCol = new double[n];
            DenseDoubleMatrix1D aiV = new DenseDoubleMatrix1D(n, aiCol, 0, 1, false);
            DenseDoubleMatrix1D iV = new DenseDoubleMatrix1D(n, iCol, 0, 1, false);
            double[] itaiCol = new double[c];
            DenseDoubleMatrix1D itaiV = new DenseDoubleMatrix1D(c, itaiCol, 0, 1, false);
            int[] colptr = I.getColumnPointers();
            int[] rowind = I.getRowIndexes();
            double[] Idata = I.getValues();
            int k = 0;
            while (k < c) {
                iV.assign(0.0);
                int i = colptr[k];
                while (i < colptr[k + 1]) {
                    iCol[rowind[i]] = Idata[i];
                    ++i;
                }
                A.zMult(iV, aiV);
                I.zMult(aiV, itaiV, 1.0, 0.0, true);
                i = 0;
                while (i < c) {
                    if (itaiCol[i] != 0.0) {
                        Ac.setQuick(i, k, itaiCol[i]);
                    }
                    ++i;
                }
                ++k;
            }
            return (SparseRCDoubleMatrix2D)new SparseRCDoubleMatrix2D(Ac.rows(), Ac.columns()).assign(Ac);
        }

        public SparseRCDoubleMatrix2D getGalerkinOperator() {
            return this.Ac;
        }
    }

    private class SSOR
    implements DoublePreconditioner {
        private double omegaF;
        private double omegaR;
        private final SparseRCDoubleMatrix2D F;
        private final int[] diagind;
        private final double[] xx;
        private final boolean reverse;

        public SSOR(SparseRCDoubleMatrix2D F, boolean reverse, double omegaF, double omegaR) {
            if (F.rows() != F.columns()) {
                throw new IllegalArgumentException("SSOR only applies to square matrices");
            }
            this.F = F;
            this.reverse = reverse;
            this.setOmega(omegaF, omegaR);
            int n = F.rows();
            this.diagind = new int[n];
            this.xx = new double[n];
        }

        public SSOR(SparseRCDoubleMatrix2D F) {
            this(F, true, 1.0, 1.0);
        }

        public void setOmega(double omegaF, double omegaR) {
            if (omegaF < 0.0 || omegaF > 2.0) {
                throw new IllegalArgumentException("omegaF must be between 0 and 2");
            }
            if (omegaR < 0.0 || omegaR > 2.0) {
                throw new IllegalArgumentException("omegaR must be between 0 and 2");
            }
            this.omegaF = omegaF;
            this.omegaR = omegaR;
        }

        @Override
        public void setMatrix(DoubleMatrix2D A) {
            this.F.assign(A);
            int n = this.F.rows();
            int[] rowptr = this.F.getRowPointers();
            int[] colind = this.F.getColumnIndexes();
            int k = 0;
            while (k < n) {
                this.diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
                if (this.diagind[k] < 0) {
                    throw new RuntimeException("Missing diagonal on row " + (k + 1));
                }
                ++k;
            }
        }

        @Override
        public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
            int j;
            double sigma;
            if (!(b instanceof DenseDoubleMatrix1D) || !(x instanceof DenseDoubleMatrix1D)) {
                throw new IllegalArgumentException("b and x must be a DenseDoubleMatrix1D");
            }
            int[] rowptr = this.F.getRowPointers();
            int[] colind = this.F.getColumnIndexes();
            double[] data = this.F.getValues();
            double[] bd = ((DenseDoubleMatrix1D)b).elements();
            double[] xd = ((DenseDoubleMatrix1D)x).elements();
            int n = this.F.rows();
            System.arraycopy(xd, 0, this.xx, 0, n);
            int i = 0;
            while (i < n) {
                sigma = 0.0;
                j = rowptr[i];
                while (j < this.diagind[i]) {
                    sigma += data[j] * this.xx[colind[j]];
                    ++j;
                }
                j = this.diagind[i] + 1;
                while (j < rowptr[i + 1]) {
                    sigma += data[j] * xd[colind[j]];
                    ++j;
                }
                sigma = (bd[i] - sigma) / data[this.diagind[i]];
                this.xx[i] = xd[i] + this.omegaF * (sigma - xd[i]);
                ++i;
            }
            if (!this.reverse) {
                System.arraycopy(this.xx, 0, xd, 0, n);
                return x;
            }
            i = n - 1;
            while (i >= 0) {
                sigma = 0.0;
                j = rowptr[i];
                while (j < this.diagind[i]) {
                    sigma += data[j] * this.xx[colind[j]];
                    ++j;
                }
                j = this.diagind[i] + 1;
                while (j < rowptr[i + 1]) {
                    sigma += data[j] * xd[colind[j]];
                    ++j;
                }
                sigma = (bd[i] - sigma) / data[this.diagind[i]];
                xd[i] = this.xx[i] + this.omegaR * (sigma - this.xx[i]);
                --i;
            }
            x.assign(xd);
            return x;
        }

        @Override
        public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
            return this.apply(b, x);
        }
    }
}

