/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class SimpleBounds
extends BoundProjector {
    private final double lowerBound;
    private final double upperBound;
    private final boolean single;

    public SimpleBounds(ShapedVectorSpace vsp, double lowerBound, double upperBound) {
        super(vsp);
        if (vsp.getType() == 5) {
            this.single = false;
        } else if (vsp.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        this.checkBounds(lowerBound, upperBound, this.single);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    protected void _projectVariables(Vector dst, Vector src) {
        int n = src.getNumber();
        if (this.single) {
            float xmin = this.convertToFloat(this.getLowerBound());
            float xmax = this.convertToFloat(this.getUpperBound());
            float[] x = ((FloatShapedVector)src).getData();
            float[] xp = ((FloatShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = SimpleBounds.clamp(x[j], xmin, xmax);
                ++j;
            }
        } else {
            double xmin = this.getLowerBound();
            double xmax = this.getUpperBound();
            double[] x = ((DoubleShapedVector)src).getData();
            double[] xp = ((DoubleShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = SimpleBounds.clamp(x[j], xmin, xmax);
                ++j;
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vx, Vector vd, boolean ascent, Vector vdp, double[] bnd) {
        int n = vx.getNumber();
        if (this.single) {
            float zero = 0.0f;
            float xmin = this.convertToFloat(this.getLowerBound());
            float xmax = this.convertToFloat(this.getUpperBound());
            float[] x = ((FloatShapedVector)vx).getData();
            float[] d = ((FloatShapedVector)vd).getData();
            float[] dp = ((FloatShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0f ? (x[j] < xmax ? d[j] : 0.0f) : (d[j] > 0.0f ? (x[j] > xmin ? d[j] : 0.0f) : 0.0f);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0f ? (x[j] < xmax ? d[j] : 0.0f) : (d[j] < 0.0f ? (x[j] > xmin ? d[j] : 0.0f) : 0.0f);
                        ++j;
                    }
                }
            } else {
                float amin = Float.POSITIVE_INFINITY;
                float amax = 0.0f;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        float tmp;
                        if (d[j] < 0.0f) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Float.POSITIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmax) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else if (d[j] > 0.0f) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmin) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        float tmp;
                        if (d[j] > 0.0f) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Float.POSITIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmax - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else if (d[j] < 0.0f) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmin - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        } else {
            double zero = 0.0;
            double xmin = this.getLowerBound();
            double xmax = this.getUpperBound();
            double[] x = ((DoubleShapedVector)vx).getData();
            double[] d = ((DoubleShapedVector)vd).getData();
            double[] dp = ((DoubleShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0 ? (x[j] < xmax ? d[j] : 0.0) : (d[j] > 0.0 ? (x[j] > xmin ? d[j] : 0.0) : 0.0);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0 ? (x[j] < xmax ? d[j] : 0.0) : (d[j] < 0.0 ? (x[j] > xmin ? d[j] : 0.0) : 0.0);
                        ++j;
                    }
                }
            } else {
                double amin = Double.POSITIVE_INFINITY;
                double amax = 0.0;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        double tmp;
                        if (d[j] < 0.0) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Double.POSITIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmax) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else if (d[j] > 0.0) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmin) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        double tmp;
                        if (d[j] > 0.0) {
                            if (x[j] < xmax) {
                                dp[j] = d[j];
                                if (xmax == Double.POSITIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmax - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else if (d[j] < 0.0) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmin - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        }
    }
}

