/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Array5D;
import mitiv.array.Array6D;
import mitiv.array.Array7D;
import mitiv.array.Array8D;
import mitiv.array.Array9D;
import mitiv.array.Byte1D;
import mitiv.array.Byte2D;
import mitiv.array.Byte3D;
import mitiv.array.Byte4D;
import mitiv.array.Byte5D;
import mitiv.array.Byte6D;
import mitiv.array.Byte7D;
import mitiv.array.Byte8D;
import mitiv.array.Byte9D;
import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Double4D;
import mitiv.array.Double5D;
import mitiv.array.Double6D;
import mitiv.array.Double7D;
import mitiv.array.Double8D;
import mitiv.array.Double9D;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.Float4D;
import mitiv.array.Float5D;
import mitiv.array.Float6D;
import mitiv.array.Float7D;
import mitiv.array.Float8D;
import mitiv.array.Float9D;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.Int1D;
import mitiv.array.Int2D;
import mitiv.array.Int3D;
import mitiv.array.Int4D;
import mitiv.array.Int5D;
import mitiv.array.Int6D;
import mitiv.array.Int7D;
import mitiv.array.Int8D;
import mitiv.array.Int9D;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.Long1D;
import mitiv.array.Long2D;
import mitiv.array.Long3D;
import mitiv.array.Long4D;
import mitiv.array.Long5D;
import mitiv.array.Long6D;
import mitiv.array.Long7D;
import mitiv.array.Long8D;
import mitiv.array.Long9D;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.array.Short4D;
import mitiv.array.Short5D;
import mitiv.array.Short6D;
import mitiv.array.Short7D;
import mitiv.array.Short8D;
import mitiv.array.Short9D;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.base.Shape;
import mitiv.exception.IllegalTypeException;

public class ArrayFactory {
    public static final ArrayFactory factory = new ArrayFactory();

    protected ArrayFactory() {
    }

    public static Scalar create(int type) {
        switch (type) {
            case 0: {
                return new ByteScalar();
            }
            case 1: {
                return new ShortScalar();
            }
            case 2: {
                return new IntScalar();
            }
            case 3: {
                return new LongScalar();
            }
            case 4: {
                return new FloatScalar();
            }
            case 5: {
                return new DoubleScalar();
            }
        }
        throw new IllegalTypeException();
    }

    public static Array1D create(int type, int dim1) {
        switch (type) {
            case 0: {
                return Byte1D.create(dim1);
            }
            case 1: {
                return Short1D.create(dim1);
            }
            case 2: {
                return Int1D.create(dim1);
            }
            case 3: {
                return Long1D.create(dim1);
            }
            case 4: {
                return Float1D.create(dim1);
            }
            case 5: {
                return Double1D.create(dim1);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array2D create(int type, int dim1, int dim2) {
        switch (type) {
            case 0: {
                return Byte2D.create(dim1, dim2);
            }
            case 1: {
                return Short2D.create(dim1, dim2);
            }
            case 2: {
                return Int2D.create(dim1, dim2);
            }
            case 3: {
                return Long2D.create(dim1, dim2);
            }
            case 4: {
                return Float2D.create(dim1, dim2);
            }
            case 5: {
                return Double2D.create(dim1, dim2);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array3D create(int type, int dim1, int dim2, int dim3) {
        switch (type) {
            case 0: {
                return Byte3D.create(dim1, dim2, dim3);
            }
            case 1: {
                return Short3D.create(dim1, dim2, dim3);
            }
            case 2: {
                return Int3D.create(dim1, dim2, dim3);
            }
            case 3: {
                return Long3D.create(dim1, dim2, dim3);
            }
            case 4: {
                return Float3D.create(dim1, dim2, dim3);
            }
            case 5: {
                return Double3D.create(dim1, dim2, dim3);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array4D create(int type, int dim1, int dim2, int dim3, int dim4) {
        switch (type) {
            case 0: {
                return Byte4D.create(dim1, dim2, dim3, dim4);
            }
            case 1: {
                return Short4D.create(dim1, dim2, dim3, dim4);
            }
            case 2: {
                return Int4D.create(dim1, dim2, dim3, dim4);
            }
            case 3: {
                return Long4D.create(dim1, dim2, dim3, dim4);
            }
            case 4: {
                return Float4D.create(dim1, dim2, dim3, dim4);
            }
            case 5: {
                return Double4D.create(dim1, dim2, dim3, dim4);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array5D create(int type, int dim1, int dim2, int dim3, int dim4, int dim5) {
        switch (type) {
            case 0: {
                return Byte5D.create(dim1, dim2, dim3, dim4, dim5);
            }
            case 1: {
                return Short5D.create(dim1, dim2, dim3, dim4, dim5);
            }
            case 2: {
                return Int5D.create(dim1, dim2, dim3, dim4, dim5);
            }
            case 3: {
                return Long5D.create(dim1, dim2, dim3, dim4, dim5);
            }
            case 4: {
                return Float5D.create(dim1, dim2, dim3, dim4, dim5);
            }
            case 5: {
                return Double5D.create(dim1, dim2, dim3, dim4, dim5);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array6D create(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        switch (type) {
            case 0: {
                return Byte6D.create(dim1, dim2, dim3, dim4, dim5, dim6);
            }
            case 1: {
                return Short6D.create(dim1, dim2, dim3, dim4, dim5, dim6);
            }
            case 2: {
                return Int6D.create(dim1, dim2, dim3, dim4, dim5, dim6);
            }
            case 3: {
                return Long6D.create(dim1, dim2, dim3, dim4, dim5, dim6);
            }
            case 4: {
                return Float6D.create(dim1, dim2, dim3, dim4, dim5, dim6);
            }
            case 5: {
                return Double6D.create(dim1, dim2, dim3, dim4, dim5, dim6);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array7D create(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        switch (type) {
            case 0: {
                return Byte7D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
            }
            case 1: {
                return Short7D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
            }
            case 2: {
                return Int7D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
            }
            case 3: {
                return Long7D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
            }
            case 4: {
                return Float7D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
            }
            case 5: {
                return Double7D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array8D create(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        switch (type) {
            case 0: {
                return Byte8D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
            }
            case 1: {
                return Short8D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
            }
            case 2: {
                return Int8D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
            }
            case 3: {
                return Long8D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
            }
            case 4: {
                return Float8D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
            }
            case 5: {
                return Double8D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array9D create(int type, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        switch (type) {
            case 0: {
                return Byte9D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
            }
            case 1: {
                return Short9D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
            }
            case 2: {
                return Int9D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
            }
            case 3: {
                return Long9D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
            }
            case 4: {
                return Float9D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
            }
            case 5: {
                return Double9D.create(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
            }
        }
        throw new IllegalTypeException();
    }

    public static ShapedArray create(int type, int[] dims) {
        int rank = dims.length;
        switch (type) {
            case 0: {
                switch (rank) {
                    case 0: {
                        return new ByteScalar();
                    }
                    case 1: {
                        return Byte1D.create(dims);
                    }
                    case 2: {
                        return Byte2D.create(dims);
                    }
                    case 3: {
                        return Byte3D.create(dims);
                    }
                    case 4: {
                        return Byte4D.create(dims);
                    }
                    case 5: {
                        return Byte5D.create(dims);
                    }
                    case 6: {
                        return Byte6D.create(dims);
                    }
                    case 7: {
                        return Byte7D.create(dims);
                    }
                    case 8: {
                        return Byte8D.create(dims);
                    }
                    case 9: {
                        return Byte9D.create(dims);
                    }
                }
                break;
            }
            case 1: {
                switch (rank) {
                    case 0: {
                        return new ShortScalar();
                    }
                    case 1: {
                        return Short1D.create(dims);
                    }
                    case 2: {
                        return Short2D.create(dims);
                    }
                    case 3: {
                        return Short3D.create(dims);
                    }
                    case 4: {
                        return Short4D.create(dims);
                    }
                    case 5: {
                        return Short5D.create(dims);
                    }
                    case 6: {
                        return Short6D.create(dims);
                    }
                    case 7: {
                        return Short7D.create(dims);
                    }
                    case 8: {
                        return Short8D.create(dims);
                    }
                    case 9: {
                        return Short9D.create(dims);
                    }
                }
                break;
            }
            case 2: {
                switch (rank) {
                    case 0: {
                        return new IntScalar();
                    }
                    case 1: {
                        return Int1D.create(dims);
                    }
                    case 2: {
                        return Int2D.create(dims);
                    }
                    case 3: {
                        return Int3D.create(dims);
                    }
                    case 4: {
                        return Int4D.create(dims);
                    }
                    case 5: {
                        return Int5D.create(dims);
                    }
                    case 6: {
                        return Int6D.create(dims);
                    }
                    case 7: {
                        return Int7D.create(dims);
                    }
                    case 8: {
                        return Int8D.create(dims);
                    }
                    case 9: {
                        return Int9D.create(dims);
                    }
                }
                break;
            }
            case 3: {
                switch (rank) {
                    case 0: {
                        return new LongScalar();
                    }
                    case 1: {
                        return Long1D.create(dims);
                    }
                    case 2: {
                        return Long2D.create(dims);
                    }
                    case 3: {
                        return Long3D.create(dims);
                    }
                    case 4: {
                        return Long4D.create(dims);
                    }
                    case 5: {
                        return Long5D.create(dims);
                    }
                    case 6: {
                        return Long6D.create(dims);
                    }
                    case 7: {
                        return Long7D.create(dims);
                    }
                    case 8: {
                        return Long8D.create(dims);
                    }
                    case 9: {
                        return Long9D.create(dims);
                    }
                }
                break;
            }
            case 4: {
                switch (rank) {
                    case 0: {
                        return new FloatScalar();
                    }
                    case 1: {
                        return Float1D.create(dims);
                    }
                    case 2: {
                        return Float2D.create(dims);
                    }
                    case 3: {
                        return Float3D.create(dims);
                    }
                    case 4: {
                        return Float4D.create(dims);
                    }
                    case 5: {
                        return Float5D.create(dims);
                    }
                    case 6: {
                        return Float6D.create(dims);
                    }
                    case 7: {
                        return Float7D.create(dims);
                    }
                    case 8: {
                        return Float8D.create(dims);
                    }
                    case 9: {
                        return Float9D.create(dims);
                    }
                }
                break;
            }
            case 5: {
                switch (rank) {
                    case 0: {
                        return new DoubleScalar();
                    }
                    case 1: {
                        return Double1D.create(dims);
                    }
                    case 2: {
                        return Double2D.create(dims);
                    }
                    case 3: {
                        return Double3D.create(dims);
                    }
                    case 4: {
                        return Double4D.create(dims);
                    }
                    case 5: {
                        return Double5D.create(dims);
                    }
                    case 6: {
                        return Double6D.create(dims);
                    }
                    case 7: {
                        return Double7D.create(dims);
                    }
                    case 8: {
                        return Double8D.create(dims);
                    }
                    case 9: {
                        return Double9D.create(dims);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
        throw new IllegalArgumentException("Invalid rank in shape.");
    }

    public static ShapedArray create(int type, Shape shape) {
        int rank = shape.rank();
        switch (type) {
            case 0: {
                switch (rank) {
                    case 0: {
                        return new ByteScalar();
                    }
                    case 1: {
                        return Byte1D.create(shape);
                    }
                    case 2: {
                        return Byte2D.create(shape);
                    }
                    case 3: {
                        return Byte3D.create(shape);
                    }
                    case 4: {
                        return Byte4D.create(shape);
                    }
                    case 5: {
                        return Byte5D.create(shape);
                    }
                    case 6: {
                        return Byte6D.create(shape);
                    }
                    case 7: {
                        return Byte7D.create(shape);
                    }
                    case 8: {
                        return Byte8D.create(shape);
                    }
                    case 9: {
                        return Byte9D.create(shape);
                    }
                }
                break;
            }
            case 1: {
                switch (rank) {
                    case 0: {
                        return new ShortScalar();
                    }
                    case 1: {
                        return Short1D.create(shape);
                    }
                    case 2: {
                        return Short2D.create(shape);
                    }
                    case 3: {
                        return Short3D.create(shape);
                    }
                    case 4: {
                        return Short4D.create(shape);
                    }
                    case 5: {
                        return Short5D.create(shape);
                    }
                    case 6: {
                        return Short6D.create(shape);
                    }
                    case 7: {
                        return Short7D.create(shape);
                    }
                    case 8: {
                        return Short8D.create(shape);
                    }
                    case 9: {
                        return Short9D.create(shape);
                    }
                }
                break;
            }
            case 2: {
                switch (rank) {
                    case 0: {
                        return new IntScalar();
                    }
                    case 1: {
                        return Int1D.create(shape);
                    }
                    case 2: {
                        return Int2D.create(shape);
                    }
                    case 3: {
                        return Int3D.create(shape);
                    }
                    case 4: {
                        return Int4D.create(shape);
                    }
                    case 5: {
                        return Int5D.create(shape);
                    }
                    case 6: {
                        return Int6D.create(shape);
                    }
                    case 7: {
                        return Int7D.create(shape);
                    }
                    case 8: {
                        return Int8D.create(shape);
                    }
                    case 9: {
                        return Int9D.create(shape);
                    }
                }
                break;
            }
            case 3: {
                switch (rank) {
                    case 0: {
                        return new LongScalar();
                    }
                    case 1: {
                        return Long1D.create(shape);
                    }
                    case 2: {
                        return Long2D.create(shape);
                    }
                    case 3: {
                        return Long3D.create(shape);
                    }
                    case 4: {
                        return Long4D.create(shape);
                    }
                    case 5: {
                        return Long5D.create(shape);
                    }
                    case 6: {
                        return Long6D.create(shape);
                    }
                    case 7: {
                        return Long7D.create(shape);
                    }
                    case 8: {
                        return Long8D.create(shape);
                    }
                    case 9: {
                        return Long9D.create(shape);
                    }
                }
                break;
            }
            case 4: {
                switch (rank) {
                    case 0: {
                        return new FloatScalar();
                    }
                    case 1: {
                        return Float1D.create(shape);
                    }
                    case 2: {
                        return Float2D.create(shape);
                    }
                    case 3: {
                        return Float3D.create(shape);
                    }
                    case 4: {
                        return Float4D.create(shape);
                    }
                    case 5: {
                        return Float5D.create(shape);
                    }
                    case 6: {
                        return Float6D.create(shape);
                    }
                    case 7: {
                        return Float7D.create(shape);
                    }
                    case 8: {
                        return Float8D.create(shape);
                    }
                    case 9: {
                        return Float9D.create(shape);
                    }
                }
                break;
            }
            case 5: {
                switch (rank) {
                    case 0: {
                        return new DoubleScalar();
                    }
                    case 1: {
                        return Double1D.create(shape);
                    }
                    case 2: {
                        return Double2D.create(shape);
                    }
                    case 3: {
                        return Double3D.create(shape);
                    }
                    case 4: {
                        return Double4D.create(shape);
                    }
                    case 5: {
                        return Double5D.create(shape);
                    }
                    case 6: {
                        return Double6D.create(shape);
                    }
                    case 7: {
                        return Double7D.create(shape);
                    }
                    case 8: {
                        return Double8D.create(shape);
                    }
                    case 9: {
                        return Double9D.create(shape);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
        throw new IllegalArgumentException("Invalid rank in shape.");
    }

    public ByteArray toByte(ShapedArray src) {
        int srcType = src.getType();
        if (src.getType() == 0) {
            return (ByteArray)src;
        }
        int number = src.getNumber();
        byte[] out = new byte[number];
        switch (srcType) {
            case 1: {
                short[] inp = ((ShortArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (byte)inp[j];
                    ++j;
                }
                break;
            }
            case 2: {
                int[] inp = ((IntArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (byte)inp[j];
                    ++j;
                }
                break;
            }
            case 3: {
                long[] inp = ((LongArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (byte)inp[j];
                    ++j;
                }
                break;
            }
            case 4: {
                float[] inp = ((FloatArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (byte)inp[j];
                    ++j;
                }
                break;
            }
            case 5: {
                double[] inp = ((DoubleArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (byte)inp[j];
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(out, src.getShape());
    }

    public ShortArray toShort(ShapedArray src) {
        int srcType = src.getType();
        if (src.getType() == 1) {
            return (ShortArray)src;
        }
        int number = src.getNumber();
        short[] out = new short[number];
        switch (srcType) {
            case 0: {
                byte[] inp = ((ByteArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 2: {
                int[] inp = ((IntArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (short)inp[j];
                    ++j;
                }
                break;
            }
            case 3: {
                long[] inp = ((LongArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (short)inp[j];
                    ++j;
                }
                break;
            }
            case 4: {
                float[] inp = ((FloatArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (short)inp[j];
                    ++j;
                }
                break;
            }
            case 5: {
                double[] inp = ((DoubleArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (short)inp[j];
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(out, src.getShape());
    }

    public IntArray toInt(ShapedArray src) {
        int srcType = src.getType();
        if (src.getType() == 2) {
            return (IntArray)src;
        }
        int number = src.getNumber();
        int[] out = new int[number];
        switch (srcType) {
            case 0: {
                byte[] inp = ((ByteArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 1: {
                short[] inp = ((ShortArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 3: {
                long[] inp = ((LongArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (int)inp[j];
                    ++j;
                }
                break;
            }
            case 4: {
                float[] inp = ((FloatArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (int)inp[j];
                    ++j;
                }
                break;
            }
            case 5: {
                double[] inp = ((DoubleArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (int)inp[j];
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(out, src.getShape());
    }

    public LongArray toLong(ShapedArray src) {
        int srcType = src.getType();
        if (src.getType() == 3) {
            return (LongArray)src;
        }
        int number = src.getNumber();
        long[] out = new long[number];
        switch (srcType) {
            case 0: {
                byte[] inp = ((ByteArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 1: {
                short[] inp = ((ShortArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 2: {
                int[] inp = ((IntArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 4: {
                float[] inp = ((FloatArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (long)inp[j];
                    ++j;
                }
                break;
            }
            case 5: {
                double[] inp = ((DoubleArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (long)inp[j];
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(out, src.getShape());
    }

    public FloatArray toFloat(ShapedArray src) {
        int srcType = src.getType();
        if (src.getType() == 4) {
            return (FloatArray)src;
        }
        int number = src.getNumber();
        float[] out = new float[number];
        switch (srcType) {
            case 0: {
                byte[] inp = ((ByteArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 1: {
                short[] inp = ((ShortArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 2: {
                int[] inp = ((IntArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 3: {
                long[] inp = ((LongArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 5: {
                double[] inp = ((DoubleArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = (float)inp[j];
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(out, src.getShape());
    }

    public DoubleArray toDouble(ShapedArray src) {
        int srcType = src.getType();
        if (src.getType() == 5) {
            return (DoubleArray)src;
        }
        int number = src.getNumber();
        double[] out = new double[number];
        switch (srcType) {
            case 0: {
                byte[] inp = ((ByteArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 1: {
                short[] inp = ((ShortArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 2: {
                int[] inp = ((IntArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 3: {
                long[] inp = ((LongArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            case 4: {
                float[] inp = ((FloatArray)src).flatten(false);
                int j = 0;
                while (j < number) {
                    out[j] = inp[j];
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(out, src.getShape());
    }

    public static ByteScalar wrap(byte[] arr) {
        return ByteScalar.wrap(arr, 0);
    }

    public static Byte1D wrap(byte[] arr, int dim1) {
        return Byte1D.wrap(arr, dim1);
    }

    public static Byte2D wrap(byte[] arr, int dim1, int dim2) {
        return Byte2D.wrap(arr, dim1, dim2);
    }

    public static Byte3D wrap(byte[] arr, int dim1, int dim2, int dim3) {
        return Byte3D.wrap(arr, dim1, dim2, dim3);
    }

    public static Byte4D wrap(byte[] arr, int dim1, int dim2, int dim3, int dim4) {
        return Byte4D.wrap(arr, dim1, dim2, dim3, dim4);
    }

    public static Byte5D wrap(byte[] arr, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return Byte5D.wrap(arr, dim1, dim2, dim3, dim4, dim5);
    }

    public static Byte6D wrap(byte[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return Byte6D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Byte7D wrap(byte[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return Byte7D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Byte8D wrap(byte[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return Byte8D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Byte9D wrap(byte[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return Byte9D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static ByteArray wrap(byte[] arr, int[] dims) {
        return ArrayFactory.wrap(arr, Shape.make(dims));
    }

    public static ByteArray wrap(byte[] data, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return ByteScalar.wrap(data, 0);
            }
            case 1: {
                return Byte1D.wrap(data, shape);
            }
            case 2: {
                return Byte2D.wrap(data, shape);
            }
            case 3: {
                return Byte3D.wrap(data, shape);
            }
            case 4: {
                return Byte4D.wrap(data, shape);
            }
            case 5: {
                return Byte5D.wrap(data, shape);
            }
            case 6: {
                return Byte6D.wrap(data, shape);
            }
            case 7: {
                return Byte7D.wrap(data, shape);
            }
            case 8: {
                return Byte8D.wrap(data, shape);
            }
            case 9: {
                return Byte9D.wrap(data, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape.");
    }

    public static ShortScalar wrap(short[] arr) {
        return ShortScalar.wrap(arr, 0);
    }

    public static Short1D wrap(short[] arr, int dim1) {
        return Short1D.wrap(arr, dim1);
    }

    public static Short2D wrap(short[] arr, int dim1, int dim2) {
        return Short2D.wrap(arr, dim1, dim2);
    }

    public static Short3D wrap(short[] arr, int dim1, int dim2, int dim3) {
        return Short3D.wrap(arr, dim1, dim2, dim3);
    }

    public static Short4D wrap(short[] arr, int dim1, int dim2, int dim3, int dim4) {
        return Short4D.wrap(arr, dim1, dim2, dim3, dim4);
    }

    public static Short5D wrap(short[] arr, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return Short5D.wrap(arr, dim1, dim2, dim3, dim4, dim5);
    }

    public static Short6D wrap(short[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return Short6D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Short7D wrap(short[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return Short7D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Short8D wrap(short[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return Short8D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Short9D wrap(short[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return Short9D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static ShortArray wrap(short[] arr, int[] dims) {
        return ArrayFactory.wrap(arr, Shape.make(dims));
    }

    public static ShortArray wrap(short[] data, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return ShortScalar.wrap(data, 0);
            }
            case 1: {
                return Short1D.wrap(data, shape);
            }
            case 2: {
                return Short2D.wrap(data, shape);
            }
            case 3: {
                return Short3D.wrap(data, shape);
            }
            case 4: {
                return Short4D.wrap(data, shape);
            }
            case 5: {
                return Short5D.wrap(data, shape);
            }
            case 6: {
                return Short6D.wrap(data, shape);
            }
            case 7: {
                return Short7D.wrap(data, shape);
            }
            case 8: {
                return Short8D.wrap(data, shape);
            }
            case 9: {
                return Short9D.wrap(data, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape.");
    }

    public static IntScalar wrap(int[] arr) {
        return IntScalar.wrap(arr, 0);
    }

    public static Int1D wrap(int[] arr, int dim1) {
        return Int1D.wrap(arr, dim1);
    }

    public static Int2D wrap(int[] arr, int dim1, int dim2) {
        return Int2D.wrap(arr, dim1, dim2);
    }

    public static Int3D wrap(int[] arr, int dim1, int dim2, int dim3) {
        return Int3D.wrap(arr, dim1, dim2, dim3);
    }

    public static Int4D wrap(int[] arr, int dim1, int dim2, int dim3, int dim4) {
        return Int4D.wrap(arr, dim1, dim2, dim3, dim4);
    }

    public static Int5D wrap(int[] arr, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return Int5D.wrap(arr, dim1, dim2, dim3, dim4, dim5);
    }

    public static Int6D wrap(int[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return Int6D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Int7D wrap(int[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return Int7D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Int8D wrap(int[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return Int8D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Int9D wrap(int[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return Int9D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static IntArray wrap(int[] arr, int[] dims) {
        return ArrayFactory.wrap(arr, Shape.make(dims));
    }

    public static IntArray wrap(int[] data, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return IntScalar.wrap(data, 0);
            }
            case 1: {
                return Int1D.wrap(data, shape);
            }
            case 2: {
                return Int2D.wrap(data, shape);
            }
            case 3: {
                return Int3D.wrap(data, shape);
            }
            case 4: {
                return Int4D.wrap(data, shape);
            }
            case 5: {
                return Int5D.wrap(data, shape);
            }
            case 6: {
                return Int6D.wrap(data, shape);
            }
            case 7: {
                return Int7D.wrap(data, shape);
            }
            case 8: {
                return Int8D.wrap(data, shape);
            }
            case 9: {
                return Int9D.wrap(data, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape.");
    }

    public static LongScalar wrap(long[] arr) {
        return LongScalar.wrap(arr, 0);
    }

    public static Long1D wrap(long[] arr, int dim1) {
        return Long1D.wrap(arr, dim1);
    }

    public static Long2D wrap(long[] arr, int dim1, int dim2) {
        return Long2D.wrap(arr, dim1, dim2);
    }

    public static Long3D wrap(long[] arr, int dim1, int dim2, int dim3) {
        return Long3D.wrap(arr, dim1, dim2, dim3);
    }

    public static Long4D wrap(long[] arr, int dim1, int dim2, int dim3, int dim4) {
        return Long4D.wrap(arr, dim1, dim2, dim3, dim4);
    }

    public static Long5D wrap(long[] arr, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return Long5D.wrap(arr, dim1, dim2, dim3, dim4, dim5);
    }

    public static Long6D wrap(long[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return Long6D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Long7D wrap(long[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return Long7D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Long8D wrap(long[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return Long8D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Long9D wrap(long[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return Long9D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static LongArray wrap(long[] arr, int[] dims) {
        return ArrayFactory.wrap(arr, Shape.make(dims));
    }

    public static LongArray wrap(long[] data, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return LongScalar.wrap(data, 0);
            }
            case 1: {
                return Long1D.wrap(data, shape);
            }
            case 2: {
                return Long2D.wrap(data, shape);
            }
            case 3: {
                return Long3D.wrap(data, shape);
            }
            case 4: {
                return Long4D.wrap(data, shape);
            }
            case 5: {
                return Long5D.wrap(data, shape);
            }
            case 6: {
                return Long6D.wrap(data, shape);
            }
            case 7: {
                return Long7D.wrap(data, shape);
            }
            case 8: {
                return Long8D.wrap(data, shape);
            }
            case 9: {
                return Long9D.wrap(data, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape.");
    }

    public static FloatScalar wrap(float[] arr) {
        return FloatScalar.wrap(arr, 0);
    }

    public static Float1D wrap(float[] arr, int dim1) {
        return Float1D.wrap(arr, dim1);
    }

    public static Float2D wrap(float[] arr, int dim1, int dim2) {
        return Float2D.wrap(arr, dim1, dim2);
    }

    public static Float3D wrap(float[] arr, int dim1, int dim2, int dim3) {
        return Float3D.wrap(arr, dim1, dim2, dim3);
    }

    public static Float4D wrap(float[] arr, int dim1, int dim2, int dim3, int dim4) {
        return Float4D.wrap(arr, dim1, dim2, dim3, dim4);
    }

    public static Float5D wrap(float[] arr, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return Float5D.wrap(arr, dim1, dim2, dim3, dim4, dim5);
    }

    public static Float6D wrap(float[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return Float6D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Float7D wrap(float[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return Float7D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Float8D wrap(float[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return Float8D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Float9D wrap(float[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return Float9D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static FloatArray wrap(float[] arr, int[] dims) {
        return ArrayFactory.wrap(arr, Shape.make(dims));
    }

    public static FloatArray wrap(float[] data, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return FloatScalar.wrap(data, 0);
            }
            case 1: {
                return Float1D.wrap(data, shape);
            }
            case 2: {
                return Float2D.wrap(data, shape);
            }
            case 3: {
                return Float3D.wrap(data, shape);
            }
            case 4: {
                return Float4D.wrap(data, shape);
            }
            case 5: {
                return Float5D.wrap(data, shape);
            }
            case 6: {
                return Float6D.wrap(data, shape);
            }
            case 7: {
                return Float7D.wrap(data, shape);
            }
            case 8: {
                return Float8D.wrap(data, shape);
            }
            case 9: {
                return Float9D.wrap(data, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape.");
    }

    public static DoubleScalar wrap(double[] arr) {
        return DoubleScalar.wrap(arr, 0);
    }

    public static Double1D wrap(double[] arr, int dim1) {
        return Double1D.wrap(arr, dim1);
    }

    public static Double2D wrap(double[] arr, int dim1, int dim2) {
        return Double2D.wrap(arr, dim1, dim2);
    }

    public static Double3D wrap(double[] arr, int dim1, int dim2, int dim3) {
        return Double3D.wrap(arr, dim1, dim2, dim3);
    }

    public static Double4D wrap(double[] arr, int dim1, int dim2, int dim3, int dim4) {
        return Double4D.wrap(arr, dim1, dim2, dim3, dim4);
    }

    public static Double5D wrap(double[] arr, int dim1, int dim2, int dim3, int dim4, int dim5) {
        return Double5D.wrap(arr, dim1, dim2, dim3, dim4, dim5);
    }

    public static Double6D wrap(double[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return Double6D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Double7D wrap(double[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return Double7D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Double8D wrap(double[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return Double8D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Double9D wrap(double[] arr, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8, int dim9) {
        return Double9D.wrap(arr, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8, dim9);
    }

    public static DoubleArray wrap(double[] arr, int[] dims) {
        return ArrayFactory.wrap(arr, Shape.make(dims));
    }

    public static DoubleArray wrap(double[] data, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return DoubleScalar.wrap(data, 0);
            }
            case 1: {
                return Double1D.wrap(data, shape);
            }
            case 2: {
                return Double2D.wrap(data, shape);
            }
            case 3: {
                return Double3D.wrap(data, shape);
            }
            case 4: {
                return Double4D.wrap(data, shape);
            }
            case 5: {
                return Double5D.wrap(data, shape);
            }
            case 6: {
                return Double6D.wrap(data, shape);
            }
            case 7: {
                return Double7D.wrap(data, shape);
            }
            case 8: {
                return Double8D.wrap(data, shape);
            }
            case 9: {
                return Double9D.wrap(data, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape.");
    }
}

