/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dataset;
import ome.xml.model.Experiment;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.Image;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Project;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Experimenter
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(Experimenter.class);
    private String email;
    private String userName;
    private String firstName;
    private String middleName;
    private String lastName;
    private String id;
    private String institution;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private List<Image> images = new ReferenceList<Image>();
    private List<MicrobeamManipulation> microbeamManipulations = new ReferenceList<MicrobeamManipulation>();
    private List<Project> projects = new ReferenceList<Project>();
    private List<ExperimenterGroup> experimenterGroupLinks = new ReferenceList<ExperimenterGroup>();
    private List<Dataset> datasets = new ReferenceList<Dataset>();
    private List<Experiment> experiments = new ReferenceList<Experiment>();

    public Experimenter() {
    }

    public Experimenter(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Experimenter(Experimenter orig) {
        this.email = orig.email;
        this.userName = orig.userName;
        this.firstName = orig.firstName;
        this.middleName = orig.middleName;
        this.lastName = orig.lastName;
        this.id = orig.id;
        this.institution = orig.institution;
        this.annotationLinks = orig.annotationLinks;
        this.images = orig.images;
        this.microbeamManipulations = orig.microbeamManipulations;
        this.projects = orig.projects;
        this.experimenterGroupLinks = orig.experimenterGroupLinks;
        this.datasets = orig.datasets;
        this.experiments = orig.experiments;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Experimenter".equals(tagName)) {
            LOGGER.debug("Expecting node name of Experimenter got {}", (Object)tagName);
        }
        if (element.hasAttribute("Email")) {
            this.setEmail(String.valueOf(element.getAttribute("Email")));
        }
        if (element.hasAttribute("UserName")) {
            this.setUserName(String.valueOf(element.getAttribute("UserName")));
        }
        if (element.hasAttribute("FirstName")) {
            this.setFirstName(String.valueOf(element.getAttribute("FirstName")));
        }
        if (element.hasAttribute("MiddleName")) {
            this.setMiddleName(String.valueOf(element.getAttribute("MiddleName")));
        }
        if (element.hasAttribute("LastName")) {
            this.setLastName(String.valueOf(element.getAttribute("LastName")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Experimenter missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Institution")) {
            this.setInstitution(String.valueOf(element.getAttribute("Institution")));
        }
        List<Element> AnnotationRef_nodeList = Experimenter.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkExperimenter(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkExperimenter(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkExperimenter(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.images.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.images);
    }

    public Image getLinkedImage(int index) {
        return this.images.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.images.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.images.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.images.remove(o);
    }

    public int sizeOfLinkedMicrobeamManipulationList() {
        return this.microbeamManipulations.size();
    }

    public List<MicrobeamManipulation> copyLinkedMicrobeamManipulationList() {
        return new ArrayList<MicrobeamManipulation>(this.microbeamManipulations);
    }

    public MicrobeamManipulation getLinkedMicrobeamManipulation(int index) {
        return this.microbeamManipulations.get(index);
    }

    public MicrobeamManipulation setLinkedMicrobeamManipulation(int index, MicrobeamManipulation o) {
        return this.microbeamManipulations.set(index, o);
    }

    public boolean linkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulations.add(o);
    }

    public boolean unlinkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulations.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.projects.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.projects);
    }

    public Project getLinkedProject(int index) {
        return this.projects.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.projects.set(index, o);
    }

    public boolean linkProject(Project o) {
        return this.projects.add(o);
    }

    public boolean unlinkProject(Project o) {
        return this.projects.remove(o);
    }

    public int sizeOfLinkedExperimenterGroupList() {
        return this.experimenterGroupLinks.size();
    }

    public List<ExperimenterGroup> copyLinkedExperimenterGroupList() {
        return new ArrayList<ExperimenterGroup>(this.experimenterGroupLinks);
    }

    public ExperimenterGroup getLinkedExperimenterGroup(int index) {
        return this.experimenterGroupLinks.get(index);
    }

    public ExperimenterGroup setLinkedExperimenterGroup(int index, ExperimenterGroup o) {
        return this.experimenterGroupLinks.set(index, o);
    }

    public boolean linkExperimenterGroup(ExperimenterGroup o) {
        return this.experimenterGroupLinks.add(o);
    }

    public boolean unlinkExperimenterGroup(ExperimenterGroup o) {
        return this.experimenterGroupLinks.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.datasets.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.datasets);
    }

    public Dataset getLinkedDataset(int index) {
        return this.datasets.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.datasets.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        return this.datasets.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        return this.datasets.remove(o);
    }

    public int sizeOfLinkedExperimentList() {
        return this.experiments.size();
    }

    public List<Experiment> copyLinkedExperimentList() {
        return new ArrayList<Experiment>(this.experiments);
    }

    public Experiment getLinkedExperiment(int index) {
        return this.experiments.get(index);
    }

    public Experiment setLinkedExperiment(int index, Experiment o) {
        return this.experiments.set(index, o);
    }

    public boolean linkExperiment(Experiment o) {
        return this.experiments.add(o);
    }

    public boolean unlinkExperiment(Experiment o) {
        return this.experiments.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Experimenter_element) {
        if (Experimenter_element == null) {
            Experimenter_element = document.createElementNS(NAMESPACE, "Experimenter");
        }
        if (this.email != null) {
            Experimenter_element.setAttribute("Email", this.email.toString());
        }
        if (this.userName != null) {
            Experimenter_element.setAttribute("UserName", this.userName.toString());
        }
        if (this.firstName != null) {
            Experimenter_element.setAttribute("FirstName", this.firstName.toString());
        }
        if (this.middleName != null) {
            Experimenter_element.setAttribute("MiddleName", this.middleName.toString());
        }
        if (this.lastName != null) {
            Experimenter_element.setAttribute("LastName", this.lastName.toString());
        }
        if (this.id != null) {
            Experimenter_element.setAttribute("ID", this.id.toString());
        }
        if (this.institution != null) {
            Experimenter_element.setAttribute("Institution", this.institution.toString());
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Experimenter_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.images != null) {
            // empty if block
        }
        if (this.microbeamManipulations != null) {
            // empty if block
        }
        if (this.projects != null) {
            // empty if block
        }
        if (this.experimenterGroupLinks != null) {
            // empty if block
        }
        if (this.datasets != null) {
            // empty if block
        }
        if (this.experiments != null) {
            // empty if block
        }
        return super.asXMLElement(document, Experimenter_element);
    }
}

