/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Length;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Instrument;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Objective
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(Objective.class);
    private Boolean iris;
    private Length workingDistance;
    private Immersion immersion;
    private Correction correction;
    private Double lensNA;
    private Double nominalMagnification;
    private Double calibratedMagnification;
    private String id;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Instrument instrument;

    public Objective() {
    }

    public Objective(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Objective(Objective orig) {
        super(orig);
        this.iris = orig.iris;
        this.workingDistance = orig.workingDistance;
        this.immersion = orig.immersion;
        this.correction = orig.correction;
        this.lensNA = orig.lensNA;
        this.nominalMagnification = orig.nominalMagnification;
        this.calibratedMagnification = orig.calibratedMagnification;
        this.id = orig.id;
        this.annotationLinks = orig.annotationLinks;
        this.instrument = orig.instrument;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Objective".equals(tagName)) {
            LOGGER.debug("Expecting node name of Objective got {}", (Object)tagName);
        }
        if (element.hasAttribute("Iris")) {
            this.setIris(Boolean.valueOf(element.getAttribute("Iris")));
        }
        if (element.hasAttribute("WorkingDistance")) {
            String unitSymbol = element.getAttribute("WorkingDistanceUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Objective.getWorkingDistanceUnitXsdDefault();
            }
            UnitsLength modelUnit = UnitsLength.fromString(unitSymbol);
            Double baseValue = Double.valueOf(element.getAttribute("WorkingDistance"));
            if (baseValue != null) {
                this.setWorkingDistance(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("Immersion")) {
            this.setImmersion(Immersion.fromString(element.getAttribute("Immersion")));
        }
        if (element.hasAttribute("Correction")) {
            this.setCorrection(Correction.fromString(element.getAttribute("Correction")));
        }
        if (element.hasAttribute("LensNA")) {
            this.setLensNA(Double.valueOf(element.getAttribute("LensNA")));
        }
        if (element.hasAttribute("NominalMagnification")) {
            this.setNominalMagnification(Double.valueOf(element.getAttribute("NominalMagnification")));
        }
        if (element.hasAttribute("CalibratedMagnification")) {
            this.setCalibratedMagnification(Double.valueOf(element.getAttribute("CalibratedMagnification")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Objective missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> AnnotationRef_nodeList = Objective.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkObjective(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Boolean getIris() {
        return this.iris;
    }

    public void setIris(Boolean iris) {
        this.iris = iris;
    }

    public Length getWorkingDistance() {
        return this.workingDistance;
    }

    public void setWorkingDistance(Length workingDistance) {
        this.workingDistance = workingDistance;
    }

    public static String getWorkingDistanceUnitXsdDefault() {
        return "\u00b5m";
    }

    public Immersion getImmersion() {
        return this.immersion;
    }

    public void setImmersion(Immersion immersion) {
        this.immersion = immersion;
    }

    public Correction getCorrection() {
        return this.correction;
    }

    public void setCorrection(Correction correction) {
        this.correction = correction;
    }

    public Double getLensNA() {
        return this.lensNA;
    }

    public void setLensNA(Double lensNA) {
        this.lensNA = lensNA;
    }

    public Double getNominalMagnification() {
        return this.nominalMagnification;
    }

    public void setNominalMagnification(Double nominalMagnification) {
        this.nominalMagnification = nominalMagnification;
    }

    public Double getCalibratedMagnification() {
        return this.calibratedMagnification;
    }

    public void setCalibratedMagnification(Double calibratedMagnification) {
        this.calibratedMagnification = calibratedMagnification;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkObjective(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkObjective(this);
        return this.annotationLinks.remove(o);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Objective_element) {
        if (Objective_element == null) {
            Objective_element = document.createElementNS(NAMESPACE, "Objective");
        }
        if (this.iris != null) {
            Objective_element.setAttribute("Iris", this.iris.toString());
        }
        if (this.workingDistance != null) {
            if (this.workingDistance.value() != null) {
                Objective_element.setAttribute("WorkingDistance", this.workingDistance.value().toString());
            }
            if (this.workingDistance.unit() != null) {
                try {
                    UnitsLength enumUnits = UnitsLength.fromString(this.workingDistance.unit().getSymbol());
                    Objective_element.setAttribute("WorkingDistanceUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Objective:WorkingDistanceUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.immersion != null) {
            Objective_element.setAttribute("Immersion", this.immersion.toString());
        }
        if (this.correction != null) {
            Objective_element.setAttribute("Correction", this.correction.toString());
        }
        if (this.lensNA != null) {
            Objective_element.setAttribute("LensNA", this.lensNA.toString());
        }
        if (this.nominalMagnification != null) {
            Objective_element.setAttribute("NominalMagnification", this.nominalMagnification.toString());
        }
        if (this.calibratedMagnification != null) {
            Objective_element.setAttribute("CalibratedMagnification", this.calibratedMagnification.toString());
        }
        if (this.id != null) {
            Objective_element.setAttribute("ID", this.id.toString());
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Objective_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.instrument != null) {
            // empty if block
        }
        return super.asXMLElement(document, Objective_element);
    }
}

