/*
 * Decompiled with CFR 0.152.
 */
package mitiv.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import mitiv.array.ArrayFactory;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.Float3D;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.exception.DataFormatException;
import mitiv.exception.RecoverableFormatException;
import mitiv.io.BufferedInputDataStream;
import mitiv.io.BufferedOutputDataStream;

public class MdaFormat {
    public static final int MDA_NONE = 0;
    public static final int MDA_INT8 = 1;
    public static final int MDA_UINT8 = 2;
    public static final int MDA_INT16 = 3;
    public static final int MDA_UINT16 = 4;
    public static final int MDA_INT32 = 5;
    public static final int MDA_UINT32 = 6;
    public static final int MDA_INT64 = 7;
    public static final int MDA_UINT64 = 8;
    public static final int MDA_FLOAT = 9;
    public static final int MDA_DOUBLE = 10;
    public static final int MDA_BYTE = 2;
    public static final int MDA_SHORT = 3;
    public static final int MDA_INT = 5;
    public static final int MDA_LONG = 7;
    public static final byte MDA_HDR0 = 77;
    public static final byte MDA_HDR1 = 68;
    public static final byte MDA_HDR2 = 65;
    public static final int MDA_HDR = 1296318720;
    public static final int MDA_MAX_RANK = 15;

    public static final int getPrimitiveType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: {
                return 1;
            }
            case 5: 
            case 6: {
                return 2;
            }
            case 7: 
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
        }
        return -1;
    }

    public static final boolean isUnsignedInteger(int type) {
        return 2 <= type && type <= 8 && type % 2 == 0;
    }

    public static final boolean isInteger(int type) {
        return type > 0 && type < 9;
    }

    public static final boolean isFloatingPoint(int type) {
        return type == 10 || type == 9;
    }

    public static ShapedArray load(BufferedInputDataStream dataStream) throws IOException, DataFormatException, RecoverableFormatException {
        Object[] arr;
        int number;
        int[] shape;
        int type;
        int minHeaderSize = 4;
        int maxHeaderSize = 64;
        int preserved = dataStream.insure(64);
        if (preserved < 4) {
            throw new DataFormatException("insufficient data for getting 4-byte MDA identifier");
        }
        dataStream.mark();
        int dimensionsRead = 0;
        try {
            int info;
            byte[] hdr = new byte[4];
            if (dataStream.read(hdr, 0, 4) != 4) {
                throw new RecoverableFormatException("failed to read 4-byte MDA identifier");
            }
            if (hdr[0] == 77 && hdr[1] == 68 && hdr[2] == 65) {
                dataStream.setByteOrder(ByteOrder.BIG_ENDIAN);
                info = hdr[3] & 0xFF;
            } else if (hdr[3] == 77 && hdr[2] == 68 && hdr[1] == 65) {
                dataStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                info = hdr[0] & 0xFF;
            } else {
                throw new RecoverableFormatException("unrecognized MDA header {" + (hdr[0] & 0xFF) + "," + (hdr[1] & 0xFF) + "," + (hdr[2] & 0xFF) + "," + (hdr[3] & 0xFF) + "}");
            }
            type = MdaFormat.getPrimitiveType(info >> 4 & 0xF);
            if (type == -1) {
                throw new RecoverableFormatException("bad type in MDA header");
            }
            int rank = info & 0xF;
            shape = new int[rank];
            dimensionsRead = dataStream.read(shape, 0, rank);
            if (dimensionsRead != rank) {
                throw new RecoverableFormatException("short MDA stream (missing some dimensions)");
            }
            long bigNumber = 1L;
            int k = 0;
            while (k < rank) {
                int length = shape[k];
                if (length <= 0) {
                    throw new RecoverableFormatException("bad dimension in MDA header (dim" + (k + 1) + " = " + length + ")");
                }
                bigNumber *= (long)length;
                ++k;
            }
            if (bigNumber > Integer.MAX_VALUE) {
                throw new RecoverableFormatException("number of elements too large in MDA data (number = " + bigNumber + ")");
            }
            number = (int)bigNumber;
        }
        catch (RecoverableFormatException ex) {
            if (4 + dimensionsRead * 4 <= preserved) {
                dataStream.reset();
                throw ex;
            }
            throw new DataFormatException(ex.getMessage());
        }
        catch (IOException ex) {
            if (4 + dimensionsRead * 4 <= preserved) {
                dataStream.reset();
            }
            throw ex;
        }
        if (type == 0) {
            arr = new byte[number];
            if (dataStream.read((byte[])arr, 0, number) == number) {
                return ArrayFactory.wrap(arr, shape);
            }
        } else if (type == 1) {
            arr = new short[number];
            if (dataStream.read((short[])arr, 0, number) == number) {
                return ArrayFactory.wrap((short[])arr, shape);
            }
        } else if (type == 2) {
            arr = new int[number];
            if (dataStream.read((int[])arr, 0, number) == number) {
                return ArrayFactory.wrap((int[])arr, shape);
            }
        } else if (type == 3) {
            arr = new long[number];
            if (dataStream.read((long[])arr, 0, number) == number) {
                return ArrayFactory.wrap((long[])arr, shape);
            }
        } else if (type == 4) {
            arr = new float[number];
            if (dataStream.read((float[])arr, 0, number) == number) {
                return ArrayFactory.wrap((float[])arr, shape);
            }
        } else {
            arr = new double[number];
            if (dataStream.read((double[])arr, 0, number) == number) {
                return ArrayFactory.wrap((double[])arr, shape);
            }
        }
        throw new DataFormatException("short MDA data (some elements cannot be read)");
    }

    public static ShapedArray load(String fileName) throws FileNotFoundException, IOException, DataFormatException, RecoverableFormatException {
        ShapedArray obj;
        FileInputStream fileStream = new FileInputStream(fileName);
        BufferedInputDataStream dataStream = new BufferedInputDataStream(fileStream);
        try {
            try {
                obj = MdaFormat.load(dataStream);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (DataFormatException ex) {
                throw ex;
            }
            catch (RecoverableFormatException ex) {
                throw ex;
            }
        }
        finally {
            dataStream.close();
            fileStream.close();
        }
        return obj;
    }

    public static void save(ShapedArray obj, String fileName) throws FileNotFoundException, IOException {
        MdaFormat.save(obj, fileName, ByteOrder.nativeOrder());
    }

    public static void save(ShapedArray obj, String fileName, ByteOrder order) throws FileNotFoundException, IOException {
        FileOutputStream fileStream = new FileOutputStream(fileName);
        BufferedOutputDataStream dataStream = new BufferedOutputDataStream(fileStream);
        dataStream.setByteOrder(order);
        try {
            try {
                MdaFormat.save(obj, dataStream);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
        }
        finally {
            dataStream.close();
            fileStream.close();
        }
    }

    public static void save(ShapedArray obj, BufferedOutputDataStream dataStream) throws IOException {
        int mdaType;
        int rank = obj.getRank();
        if (rank <= 0 || rank > 15) {
            throw new IllegalArgumentException("illegal rank for MDA data");
        }
        int type = obj.getType();
        int number = obj.getNumber();
        switch (type) {
            case 0: {
                mdaType = 2;
                break;
            }
            case 1: {
                mdaType = 3;
                break;
            }
            case 2: {
                mdaType = 5;
                break;
            }
            case 3: {
                mdaType = 7;
                break;
            }
            case 4: {
                mdaType = 9;
                break;
            }
            case 5: {
                mdaType = 10;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported data type");
            }
        }
        int headerCount = 1 + rank;
        int[] headerData = new int[headerCount];
        headerData[0] = 0x4D444100 | (mdaType << 4 | rank);
        int k = 0;
        while (k < rank) {
            headerData[k + 1] = obj.getDimension(k);
            ++k;
        }
        if (dataStream.write(headerData, 0, headerCount) != headerCount) {
            throw new IOException("failed to write MDA header part");
        }
        int transfered = 0;
        if (type == 0) {
            byte[] arr = ((ByteArray)obj).flatten();
            transfered = dataStream.write(arr, 0, number);
        } else if (type == 1) {
            short[] arr = ((ShortArray)obj).flatten();
            transfered = dataStream.write(arr, 0, number);
        } else if (type == 2) {
            int[] arr = ((IntArray)obj).flatten();
            transfered = dataStream.write(arr, 0, number);
        } else if (type == 3) {
            long[] arr = ((LongArray)obj).flatten();
            transfered = dataStream.write(arr, 0, number);
        } else if (type == 4) {
            float[] arr = ((FloatArray)obj).flatten();
            transfered = dataStream.write(arr, 0, number);
        } else if (type == 5) {
            double[] arr = ((DoubleArray)obj).flatten();
            transfered = dataStream.write(arr, 0, number);
        }
        if (transfered != number) {
            throw new IOException("failed to write MDA data part");
        }
    }

    public static void main(String[] args) {
        Float3D obj;
        int dim1 = 3;
        int dim2 = 4;
        int dim3 = 5;
        float[] arr = new float[dim1 * dim2 * dim3];
        Float3D orig = obj = Float3D.wrap(arr, dim1, dim2, dim3);
        float value = 1.0E38f;
        float scale = 0.33333334f;
        int j = 0;
        while (j < arr.length) {
            arr[j] = value;
            value *= scale;
            ++j;
        }
        try {
            String[] names = new String[]{"/tmp/testdata0.mda", "/tmp/testdata1.mda", "/tmp/testdata2.mda"};
            int j2 = 0;
            while (j2 < names.length) {
                String order;
                String name = names[j2];
                if (j2 == 1) {
                    MdaFormat.save(obj, name, ByteOrder.BIG_ENDIAN);
                    order = "big endian";
                } else if (j2 == 2) {
                    MdaFormat.save(obj, name, ByteOrder.LITTLE_ENDIAN);
                    order = "little endian";
                } else {
                    MdaFormat.save((ShapedArray)obj, name);
                    order = "native";
                }
                System.out.println("test file \"" + name + "\" written in " + order + " byte order");
                ShapedArray tmp = MdaFormat.load(name);
                System.out.println("test file \"" + name + "\" successfully read");
                Float3D cpy = (Float3D)tmp;
                int errors = 0;
                int i3 = 0;
                while (i3 < dim3) {
                    int i2 = 0;
                    while (i2 < dim2) {
                        int i1 = 0;
                        while (i1 < dim1) {
                            if (cpy.get(i1, i2, i3) != orig.get(i1, i2, i3)) {
                                ++errors;
                                System.err.println("copy.get(" + i1 + "," + i2 + "," + i3 + ") = " + cpy.get(i1, i2, i3) + " != " + orig.get(i1, i2, i3));
                            }
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                if (errors == 0) {
                    System.out.println("identical contents for test file \"" + name + "\"");
                }
                ++j2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

