/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Mask;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.Reference;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinData
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/BinaryFile/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(BinData.class);
    private Boolean bigEndian;
    private NonNegativeLong length;
    private Compression compression;
    private Pixels pixels;
    private Mask mask;

    public BinData() {
    }

    public BinData(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public BinData(BinData orig) {
        this.bigEndian = orig.bigEndian;
        this.length = orig.length;
        this.compression = orig.compression;
        this.pixels = orig.pixels;
        this.mask = orig.mask;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"BinData".equals(tagName)) {
            LOGGER.debug("Expecting node name of BinData got {}", (Object)tagName);
        }
        if (element.hasAttribute("BigEndian")) {
            this.setBigEndian(Boolean.valueOf(element.getAttribute("BigEndian")));
        }
        if (element.hasAttribute("Length")) {
            this.setLength(NonNegativeLong.valueOf(element.getAttribute("Length")));
        }
        if (element.hasAttribute("Compression")) {
            this.setCompression(Compression.fromString(element.getAttribute("Compression")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Boolean getBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(Boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public NonNegativeLong getLength() {
        return this.length;
    }

    public void setLength(NonNegativeLong length) {
        this.length = length;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels_BackReference) {
        this.pixels = pixels_BackReference;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask_BackReference) {
        this.mask = mask_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element BinData_element) {
        if (BinData_element == null) {
            BinData_element = document.createElementNS(NAMESPACE, "BinData");
        }
        if (this.bigEndian != null) {
            BinData_element.setAttribute("BigEndian", this.bigEndian.toString());
        }
        if (this.length != null) {
            BinData_element.setAttribute("Length", this.length.toString());
        }
        if (this.compression != null) {
            BinData_element.setAttribute("Compression", this.compression.toString());
        }
        if (this.pixels != null) {
            // empty if block
        }
        if (this.mask != null) {
            // empty if block
        }
        return super.asXMLElement(document, BinData_element);
    }
}

