/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;

public class LocalThickness {
    public float[][] data;
    public int w;
    public int h;
    public int d;
    public float scale;
    public float scaleInv;
    public float scaleSq;
    public float scaleInvSq;

    public void run(ImagePlus imagePlus, float f, float f2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        ImageStack imageStack = imagePlus.getStack();
        this.w = imageStack.getWidth();
        this.h = imageStack.getHeight();
        this.d = imagePlus.getStackSize();
        this.scale = f / f2;
        this.scaleInv = f2 / f;
        this.scaleSq = this.scale * this.scale;
        this.scaleInvSq = this.scaleInv * this.scaleInv;
        int n7 = this.w * this.h;
        float[][] fArrayArray = new float[this.d][];
        for (int i = 0; i < this.d; ++i) {
            fArrayArray[i] = (float[])imageStack.getPixels(i + 1);
        }
        int[] nArray = new int[this.d];
        for (int i = 0; i < this.d; ++i) {
            float[] fArray = fArrayArray[i];
            n6 = 0;
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    n5 = k + this.w * j;
                    if (!(fArray[n5] > 0.0f)) continue;
                    ++n6;
                }
            }
            nArray[i] = n6;
        }
        int[][] nArrayArray = new int[this.d][];
        int[][] nArrayArray2 = new int[this.d][];
        float[][] fArrayArray2 = new float[this.d][];
        float f3 = 0.0f;
        for (n4 = 0; n4 < this.d; ++n4) {
            n6 = nArray[n4];
            nArrayArray[n4] = new int[n6];
            nArrayArray2[n4] = new int[n6];
            fArrayArray2[n4] = new float[n6];
            float[] fArray = fArrayArray[n4];
            int[] nArray2 = nArrayArray[n4];
            int[] nArray3 = nArrayArray2[n4];
            float[] fArray2 = fArrayArray2[n4];
            int n8 = 0;
            for (int i = 0; i < this.h; ++i) {
                for (n3 = 0; n3 < this.w; ++n3) {
                    n5 = n3 + this.w * i;
                    if (!(fArray[n5] > 0.0f)) continue;
                    nArray2[n8] = n3;
                    nArray3[n8] = i;
                    fArray2[n8++] = fArray[n5];
                    if (fArray[n5] > f3) {
                        f3 = fArray[n5];
                    }
                    fArray[n5] = 0.0f;
                }
            }
        }
        n4 = n;
        Object[] objectArray = new Object[this.d];
        for (n3 = 0; n3 < this.d; ++n3) {
            objectArray[n3] = new Object();
        }
        LTThread[] lTThreadArray = new LTThread[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            lTThreadArray[n2] = new LTThread(n2, n4, this.w, this.h, this.d, nArray, fArrayArray, nArrayArray, nArrayArray2, fArrayArray2, objectArray);
            lTThreadArray[n2].start();
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                lTThreadArray[n2].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted .");
        }
        for (int i = 0; i < this.d; ++i) {
            float[] fArray = fArrayArray[i];
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    n5 = k + this.w * j;
                    fArray[n5] = (float)(2.0 * Math.sqrt(fArray[n5]));
                }
            }
        }
        String string = this.stripExtension(imagePlus.getTitle());
        imagePlus.setTitle(string + "_LT_");
        imagePlus.getProcessor().setMinAndMax(0.0, (double)f3);
    }

    String stripExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    class LTThread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        int nR;
        float[][] s;
        int[] nRidge;
        int[][] iRidge;
        int[][] jRidge;
        float[][] rRidge;
        Object[] resources;

        public LTThread(int n, int n2, int n3, int n4, int n5, int[] nArray, float[][] fArray, int[][] nArray2, int[][] nArray3, float[][] fArray2, Object[] objectArray) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
            this.nRidge = nArray;
            this.iRidge = nArray2;
            this.jRidge = nArray3;
            this.rRidge = fArray2;
            this.resources = objectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                int n = this.nRidge[i];
                int[] nArray = this.iRidge[i];
                int[] nArray2 = this.jRidge[i];
                float[] fArray = this.rRidge[i];
                for (int j = 0; j < n; ++j) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8 = nArray[j];
                    int n9 = nArray2[j];
                    float f = fArray[j];
                    int n10 = (int)(f * f + 0.5f);
                    int n11 = (int)f;
                    int n12 = (int)(f * LocalThickness.this.scale);
                    if ((float)n11 < f) {
                        ++n11;
                    }
                    if ((float)n12 < f * LocalThickness.this.scale) {
                        ++n12;
                    }
                    if ((n7 = n8 - n11) < 0) {
                        n7 = 0;
                    }
                    if ((n6 = n8 + n11) >= this.w) {
                        n6 = this.w - 1;
                    }
                    if ((n5 = n9 - n11) < 0) {
                        n5 = 0;
                    }
                    if ((n4 = n9 + n11) >= this.h) {
                        n4 = this.h - 1;
                    }
                    if ((n3 = i - n11) < 0) {
                        n3 = 0;
                    }
                    if ((n2 = i + n11) >= this.d) {
                        n2 = this.d - 1;
                    }
                    for (int k = n3; k <= n2; ++k) {
                        float f2 = (float)((k - i) * (k - i)) * LocalThickness.this.scaleInvSq;
                        float[] fArray2 = this.s[k];
                        for (int i2 = n5; i2 <= n4; ++i2) {
                            float f3 = f2 + (float)((i2 - n9) * (i2 - n9));
                            if (!(f3 <= (float)n10)) continue;
                            for (int i3 = n7; i3 <= n6; ++i3) {
                                int n13;
                                float f4;
                                float f5 = f3 + (float)((i3 - n8) * (i3 - n8));
                                if (!(f5 <= (float)n10) || !((float)n10 > (f4 = fArray2[n13 = i3 + this.w * i2]))) continue;
                                Object object = this.resources[k];
                                synchronized (object) {
                                    f4 = fArray2[n13];
                                    if ((float)n10 > f4) {
                                        fArray2[n13] = n10;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

