/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array1D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;

    protected Array1D(int dim1) {
        this.shape = Shape.make(dim1);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large.");
        }
        this.number = (int)this.shape.number();
        this.dim1 = dim1;
    }

    protected Array1D(int[] dims) {
        this(Shape.make(dims));
    }

    protected Array1D(Shape shape) {
        if (shape.rank() != 1) {
            throw new IllegalArgumentException("Bad number of dimensions for 1-D array.");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large.");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
    }

    @Override
    public final int getRank() {
        return 1;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int k) {
        return this.shape.dimension(k);
    }

    @Override
    public abstract Array1D copy();

    public abstract Scalar slice(int var1);

    public abstract Scalar slice(int var1, int var2);

    public abstract Array1D view(Range var1);

    public abstract Array1D view(int[] var1);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int number, int offset, int stride1, int dim1) {
        int imax;
        int imin;
        int itmp = (dim1 - 1) * stride1;
        if (itmp >= 0) {
            imin = offset;
            imax = offset + itmp;
        } else {
            imin = offset + itmp;
            imax = offset;
        }
        if (imin < 0 || imax >= number) {
            throw new IndexOutOfBoundsException("1D view is not within available space");
        }
        return 1;
    }
}

