/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.PentaxMakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PentaxMakernoteDescriptor
extends TagDescriptor<PentaxMakernoteDirectory> {
    public PentaxMakernoteDescriptor(@NotNull PentaxMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getCaptureModeDescription();
            }
            case 2: {
                return this.getQualityLevelDescription();
            }
            case 3: {
                return this.getFocusModeDescription();
            }
            case 4: {
                return this.getFlashModeDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getSharpnessDescription();
            }
            case 12: {
                return this.getContrastDescription();
            }
            case 13: {
                return this.getSaturationDescription();
            }
            case 20: {
                return this.getIsoSpeedDescription();
            }
            case 23: {
                return this.getColourDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getColourDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(23);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Black & White";
            }
            case 3: {
                return "Sepia";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getIsoSpeedDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(20);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 10: {
                return "ISO 100";
            }
            case 16: {
                return "ISO 200";
            }
            case 100: {
                return "ISO 100";
            }
            case 200: {
                return "ISO 200";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(13);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(12);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(11);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Soft";
            }
            case 2: {
                return "Hard";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Float value = ((PentaxMakernoteDirectory)this._directory).getFloatObject(10);
        if (value == null) {
            return null;
        }
        if (value.floatValue() == 0.0f) {
            return "Off";
        }
        return Float.toString(value.floatValue());
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(7);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Shade";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Fluorescent";
            }
            case 5: {
                return "Manual";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(4);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Flash On";
            }
            case 4: {
                return "Flash Off";
            }
            case 6: {
                return "Red-eye Reduction";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusModeDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(3);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 2: {
                return "Custom";
            }
            case 3: {
                return "Auto";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getQualityLevelDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(2);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Good";
            }
            case 1: {
                return "Better";
            }
            case 2: {
                return "Best";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getCaptureModeDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(1);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Night-scene";
            }
            case 3: {
                return "Manual";
            }
            case 4: {
                return "Multiple";
            }
        }
        return "Unknown (" + value + ")";
    }
}

