/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array6D;
import mitiv.array.Byte6D;
import mitiv.array.Double1D;
import mitiv.array.Double5D;
import mitiv.array.DoubleArray;
import mitiv.array.Float6D;
import mitiv.array.Int6D;
import mitiv.array.Long6D;
import mitiv.array.ShapedArray;
import mitiv.array.Short6D;
import mitiv.array.impl.FlatDouble6D;
import mitiv.array.impl.StriddenDouble6D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double6D
extends Array6D
implements DoubleArray {
    protected Double6D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        super(dim1, dim2, dim3, dim4, dim5, dim6);
    }

    protected Double6D(int[] dims) {
        super(dims);
    }

    protected Double6D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, double var7);

    @Override
    public void fill(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void increment(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) + value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) + value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void decrement(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) - value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) - value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void scale(double value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) * value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) * value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void map(DoubleFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, function.apply(this.get(i1, i2, i3, i4, i5, i6)));
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, function.apply(this.get(i1, i2, i3, i4, i5, i6)));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, generator.nextDouble());
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, generator.nextDouble());
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (initialized) {
                                        scanner.update(this.get(i1, i2, i3, i4, i5, i6));
                                    } else {
                                        scanner.initialize(this.get(i1, i2, i3, i4, i5, i6));
                                        initialized = true;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (initialized) {
                                        scanner.update(this.get(i1, i2, i3, i4, i5, i6));
                                    } else {
                                        scanner.initialize(this.get(i1, i2, i3, i4, i5, i6));
                                        initialized = true;
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        double[] out = new double[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return out;
    }

    @Override
    public double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double minValue = this.get(0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        double value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        double value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        return minValue;
    }

    @Override
    public double max() {
        double maxValue = this.get(0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        double value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        double value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        return maxValue;
    }

    @Override
    public double[] getMinAndMax() {
        double[] result = new double[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(double[] mm) {
        double minValue;
        double maxValue = minValue = this.get(0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        double value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        double value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public double sum() {
        double totalValue = 0.0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    totalValue += this.get(i1, i2, i3, i4, i5, i6);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    totalValue += this.get(i1, i2, i3, i4, i5, i6);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte6D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (byte)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Byte6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Short6D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (short)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Short6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Int6D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (int)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Int6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Long6D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (long)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Long6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Float6D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (float)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Float6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Double6D toDouble() {
        return this;
    }

    @Override
    public Double6D copy() {
        return new FlatDouble6D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Double6D src = arr.getType() == 5 ? (Double6D)arr : (Double6D)arr.toDouble();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, src.get(i1, i2, i3, i4, i5, i6));
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, src.get(i1, i2, i3, i4, i5, i6));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, src.get(++i));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, src.get(++i));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double6D create() {
        return new FlatDouble6D(this.getShape());
    }

    public static Double6D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new FlatDouble6D(dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Double6D create(int[] dims) {
        return new FlatDouble6D(dims);
    }

    public static Double6D create(Shape shape) {
        return new FlatDouble6D(shape);
    }

    public static Double6D wrap(double[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new FlatDouble6D(data, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Double6D wrap(double[] data, int[] dims) {
        return new FlatDouble6D(data, dims);
    }

    public static Double6D wrap(double[] data, Shape shape) {
        return new FlatDouble6D(data, shape);
    }

    public static Double6D wrap(double[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new StriddenDouble6D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    @Override
    public abstract Double5D slice(int var1);

    @Override
    public abstract Double5D slice(int var1, int var2);

    @Override
    public abstract Double6D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6);

    @Override
    public abstract Double6D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    @Override
    public abstract Double1D as1D();
}

