/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class GeneralBounds
extends BoundProjector {
    private final Vector lowerBound;
    private final Vector upperBound;
    private final boolean single;

    public GeneralBounds(ShapedVectorSpace vsp, Vector lowerBound, Vector upperBound) {
        super(vsp);
        if (vsp.getType() == 5) {
            this.single = false;
        } else if (vsp.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        if (!lowerBound.belongsTo(vsp)) {
            throw new IllegalArgumentException("Lower bound does not belong to the same vector space as the variables");
        }
        if (!upperBound.belongsTo(vsp)) {
            throw new IllegalArgumentException("Upper bound does not belong to the same vector space as the variables");
        }
        int n = vsp.getNumber();
        if (this.single) {
            float[] xmin = ((FloatShapedVector)lowerBound).getData();
            float[] xmax = ((FloatShapedVector)upperBound).getData();
            int j = 0;
            while (j < n) {
                if (Float.isNaN(xmin[j]) || Float.isInfinite(xmin[j]) && xmin[j] != Float.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid lower bound value(s)");
                }
                if (Float.isNaN(xmax[j]) || Float.isInfinite(xmax[j]) && xmax[j] != Float.POSITIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid upper bound value(s)");
                }
                if (xmin[j] > xmax[j]) {
                    throw new IllegalArgumentException("Lower bound must be less or equal upper bound");
                }
                ++j;
            }
        } else {
            double[] xmin = ((DoubleShapedVector)lowerBound).getData();
            double[] xmax = ((DoubleShapedVector)upperBound).getData();
            int j = 0;
            while (j < n) {
                if (Double.isNaN(xmin[j]) || Double.isInfinite(xmin[j]) && xmin[j] != Double.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid lower bound value(s)");
                }
                if (Double.isNaN(xmax[j]) || Double.isInfinite(xmax[j]) && xmax[j] != Double.POSITIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid upper bound value(s)");
                }
                if (xmin[j] > xmax[j]) {
                    throw new IllegalArgumentException("Lower bound must be less or equal upper bound");
                }
                ++j;
            }
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    protected void _projectVariables(Vector dst, Vector src) {
        int n = src.getNumber();
        if (this.single) {
            float[] xmin = ((FloatShapedVector)this.lowerBound).getData();
            float[] xmax = ((FloatShapedVector)this.upperBound).getData();
            float[] x = ((FloatShapedVector)src).getData();
            float[] xp = ((FloatShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = GeneralBounds.clamp(x[j], xmin[j], xmax[j]);
                ++j;
            }
        } else {
            double[] xmin = ((DoubleShapedVector)this.lowerBound).getData();
            double[] xmax = ((DoubleShapedVector)this.upperBound).getData();
            double[] x = ((DoubleShapedVector)src).getData();
            double[] xp = ((DoubleShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = GeneralBounds.clamp(x[j], xmin[j], xmax[j]);
                ++j;
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vx, Vector vd, boolean ascent, Vector vdp, double[] bnd) {
        int n = vx.getNumber();
        if (this.single) {
            float zero = 0.0f;
            float[] xmin = ((FloatShapedVector)this.lowerBound).getData();
            float[] xmax = ((FloatShapedVector)this.upperBound).getData();
            float[] x = ((FloatShapedVector)vx).getData();
            float[] d = ((FloatShapedVector)vd).getData();
            float[] dp = ((FloatShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0f ? (x[j] < xmax[j] ? d[j] : 0.0f) : (d[j] > 0.0f ? (x[j] > xmin[j] ? d[j] : 0.0f) : 0.0f);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0f ? (x[j] < xmax[j] ? d[j] : 0.0f) : (d[j] < 0.0f ? (x[j] > xmin[j] ? d[j] : 0.0f) : 0.0f);
                        ++j;
                    }
                }
            } else {
                float amin = Float.POSITIVE_INFINITY;
                float amax = 0.0f;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        float tmp;
                        if (d[j] < 0.0f) {
                            if (x[j] < xmax[j]) {
                                dp[j] = d[j];
                                if (xmax[j] == Float.POSITIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmax[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else if (d[j] > 0.0f) {
                            if (x[j] > xmin[j]) {
                                dp[j] = d[j];
                                if (xmin[j] == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmin[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        float tmp;
                        if (d[j] > 0.0f) {
                            if (x[j] < xmax[j]) {
                                dp[j] = d[j];
                                if (xmax[j] == Float.POSITIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmax[j] - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else if (d[j] < 0.0f) {
                            if (x[j] > xmin[j]) {
                                dp[j] = d[j];
                                if (xmin[j] == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmin[j] - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        } else {
            double zero = 0.0;
            double[] xmin = ((DoubleShapedVector)this.lowerBound).getData();
            double[] xmax = ((DoubleShapedVector)this.upperBound).getData();
            double[] x = ((DoubleShapedVector)vx).getData();
            double[] d = ((DoubleShapedVector)vd).getData();
            double[] dp = ((DoubleShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0 ? (x[j] < xmax[j] ? d[j] : 0.0) : (d[j] > 0.0 ? (x[j] > xmin[j] ? d[j] : 0.0) : 0.0);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0 ? (x[j] < xmax[j] ? d[j] : 0.0) : (d[j] < 0.0 ? (x[j] > xmin[j] ? d[j] : 0.0) : 0.0);
                        ++j;
                    }
                }
            } else {
                double amin = Double.POSITIVE_INFINITY;
                double amax = 0.0;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        double tmp;
                        if (d[j] < 0.0) {
                            if (x[j] < xmax[j]) {
                                dp[j] = d[j];
                                if (xmax[j] == Double.POSITIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmax[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else if (d[j] > 0.0) {
                            if (x[j] > xmin[j]) {
                                dp[j] = d[j];
                                if (xmin[j] == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (x[j] - xmin[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        double tmp;
                        if (d[j] > 0.0) {
                            if (x[j] < xmax[j]) {
                                dp[j] = d[j];
                                if (xmax[j] == Double.POSITIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmax[j] - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else if (d[j] < 0.0) {
                            if (x[j] > xmin[j]) {
                                dp[j] = d[j];
                                if (xmin[j] == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    tmp = (xmin[j] - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        }
    }
}

