/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tlong;

import cern.colt.list.tlong.AbstractLongList;
import cern.colt.list.tlong.MinMaxNumberList;
import java.util.Arrays;

public class DistinctNumberList
extends AbstractLongList {
    private static final long serialVersionUID = 1L;
    protected long[] distinctValues;
    protected MinMaxNumberList elements;

    public DistinctNumberList(long[] distinctValues, int initialCapacity) {
        this.setUp(distinctValues, initialCapacity);
    }

    @Override
    public void add(long element) {
        this.elements.add(this.codeOf(element));
        ++this.size;
    }

    protected int codeOf(long element) {
        int index = Arrays.binarySearch(this.distinctValues, element);
        if (index < 0) {
            throw new IllegalArgumentException("Element=" + element + " not contained in distinct elements.");
        }
        return index;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public long getQuick(int index) {
        return this.distinctValues[(int)this.elements.getQuick(index)];
    }

    @Override
    public void removeFromTo(int from, int to) {
        this.elements.removeFromTo(from, to);
        this.size -= to - from + 1;
    }

    @Override
    public void setQuick(int index, long element) {
        this.elements.setQuick(index, this.codeOf(element));
    }

    @Override
    public void setSizeRaw(int newSize) {
        super.setSizeRaw(newSize);
        this.elements.setSizeRaw(newSize);
    }

    protected void setUp(long[] distinctValues, int initialCapacity) {
        this.distinctValues = distinctValues;
        this.elements = new MinMaxNumberList(0L, distinctValues.length - 1, initialCapacity);
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }
}

