/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib3d.Jama.EigenvalueDecomposition;
import mcib3d.Jama.Matrix;
import mcib3d.geom.GeomTransform3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.Flood3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;

public class Object3DVoxels
extends Object3D {
    ArrayList<Voxel3D> voxels = null;
    private boolean showStatus = false;
    double correctedSurfaceArea = -1.0;

    public Object3DVoxels() {
        this.value = 1;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.voxels = new ArrayList();
    }

    public Object3DVoxels(int n) {
        this.value = n;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.voxels = new ArrayList();
    }

    public Object3DVoxels(ImageHandler imageHandler, int n) {
        this.value = n;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        Calibration calibration = imageHandler.getCalibration();
        if (calibration != null && calibration.scaled()) {
            this.resXY = calibration.getX(1.0);
            this.resZ = calibration.getZ(1.0);
            this.units = calibration.getUnits();
        }
        this.voxels = this.createArrayList(imageHandler, null);
        this.init();
    }

    public Object3DVoxels(ImageHandler imageHandler) {
        this.value = (int)imageHandler.getMax();
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        Calibration calibration = imageHandler.getCalibration();
        if (calibration != null && calibration.scaled()) {
            this.resXY = calibration.getX(1.0);
            this.resZ = calibration.getZ(1.0);
            this.units = calibration.getUnits();
        }
        this.voxels = this.createArrayList(imageHandler, null);
        this.init();
    }

    public Object3DVoxels(ImageHandler imageHandler, ImageHandler imageHandler2) {
        this.value = (int)imageHandler.getMax();
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        Calibration calibration = imageHandler.getCalibration();
        if (calibration != null && calibration.scaled()) {
            this.resXY = calibration.getX(1.0);
            this.resZ = calibration.getZ(1.0);
            this.units = calibration.getUnits();
        }
        this.voxels = this.createArrayList(imageHandler, imageHandler2);
        this.init();
    }

    public Object3DVoxels(ImagePlus imagePlus, int n) {
        this.value = n;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        Calibration calibration = imagePlus.getCalibration();
        if (calibration != null && calibration.scaled()) {
            this.resXY = calibration.getX(1.0);
            this.resZ = calibration.getZ(1.0);
            this.units = calibration.getUnits();
        }
        this.voxels = this.createArrayList(ImageInt.wrap(imagePlus), null);
        this.init();
    }

    public Object3DVoxels(ImageStack imageStack, int n) {
        this.value = n;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.voxels = this.createArrayList(ImageInt.wrap(imageStack), null);
        this.init();
    }

    public Object3DVoxels(ArrayList<Voxel3D> arrayList) {
        this.voxels = arrayList;
        this.init();
        this.value = (int)this.voxels.get(0).getValue();
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
    }

    public Object3DVoxels copyObject(int n) {
        Object3DVoxels object3DVoxels = new Object3DVoxels(this.getVoxels());
        if (n != this.value) {
            this.computeContours();
            object3DVoxels.setContours(this.contours, this.areaContactUnit);
            object3DVoxels.setValue(n);
        }
        object3DVoxels.resXY = this.resXY;
        object3DVoxels.resZ = this.resZ;
        object3DVoxels.units = this.units;
        return object3DVoxels;
    }

    public void setVoxels(ArrayList<Voxel3D> arrayList) {
        this.voxels = arrayList;
        this.init();
    }

    private ArrayList<Voxel3D> createArrayList(ImageHandler imageHandler, ImageHandler imageHandler2) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        this.xmin = imageHandler.sizeX;
        this.xmax = 0;
        this.ymin = imageHandler.sizeY;
        this.ymax = 0;
        this.zmin = imageHandler.sizeZ;
        this.zmax = 0;
        for (int i = 0; i < imageHandler.sizeZ; ++i) {
            for (int j = 0; j < imageHandler.sizeY; ++j) {
                for (int k = 0; k < imageHandler.sizeX; ++k) {
                    if (imageHandler.getPixel(k, j, i) != (float)this.value) continue;
                    float f = imageHandler2 == null ? (float)this.value : imageHandler2.getPixel(k, j, i);
                    arrayList.add(new Voxel3D(k, j, i, f));
                }
            }
        }
        return arrayList;
    }

    public Object3DVoxels(Object3DVoxels object3DVoxels) {
        this.voxels = new ArrayList();
        this.addVoxels(object3DVoxels.getVoxels());
        this.init();
        this.value = object3DVoxels.getValue();
        this.labelImage = object3DVoxels.getLabelImage();
        this.setCalibration(object3DVoxels.getResXY(), object3DVoxels.getResZ(), object3DVoxels.getUnits());
    }

    public Object3DVoxels(Object3D object3D) {
        this.voxels = new ArrayList();
        this.addVoxels(object3D.getVoxels());
        this.init();
        this.value = object3D.getValue();
        this.labelImage = object3D.getLabelImage();
        this.setCalibration(object3D.getResXY(), object3D.getResZ(), object3D.getUnits());
    }

    public void addVoxelsIntersection(Object3D object3D, Object3D object3D2) {
        ArrayList<Voxel3D> arrayList = object3D.getVoxels();
        ArrayList<Voxel3D> arrayList2 = object3D2.getVoxels();
        double d = 0.25;
        block0: for (Voxel3D voxel3D : arrayList) {
            for (Voxel3D voxel3D2 : arrayList2) {
                if (!(voxel3D.distanceSquare(voxel3D2) < d)) continue;
                this.voxels.add(new Voxel3D(voxel3D));
                continue block0;
            }
        }
        this.init();
        this.contours = null;
    }

    public void addVoxelsIntersection(ArrayList<Object3D> arrayList) {
        int n = arrayList.size();
        ArrayList<Voxel3D> arrayList2 = arrayList.get(0).getVoxels();
        ArrayList<Voxel3D> arrayList3 = arrayList.get(1).getVoxels();
        double d = 0.25;
        for (Voxel3D voxel3D : arrayList2) {
            for (Voxel3D voxel3D2 : arrayList3) {
                if (!(voxel3D.distanceSquare(voxel3D2) < d)) continue;
                boolean bl = true;
                int n2 = 2;
                block2: while (bl && n2 < n) {
                    bl = false;
                    for (Voxel3D voxel3D3 : arrayList.get(n2).getVoxels()) {
                        if (!(voxel3D.distanceSquare(voxel3D3) < d)) continue;
                        bl = true;
                        ++n2;
                        continue block2;
                    }
                }
                if (!bl) continue;
                this.voxels.add(new Voxel3D(voxel3D));
            }
        }
        this.init();
    }

    public void addVoxelsUnion(Object3D object3D, Object3D object3D2) {
        ArrayList<Voxel3D> arrayList = object3D.getVoxels();
        ArrayList<Voxel3D> arrayList2 = object3D2.getVoxels();
        for (Voxel3D voxel3D : arrayList) {
            this.voxels.add(voxel3D);
        }
        for (Voxel3D voxel3D : arrayList2) {
            this.voxels.add(voxel3D);
        }
        this.init();
        this.contours = null;
    }

    public void addVoxelsUnion(ArrayList<Object3D> arrayList) {
        for (Object3D object3D : arrayList) {
            for (Voxel3D voxel3D : object3D.getVoxels()) {
                this.voxels.add(voxel3D);
            }
        }
        this.init();
        this.contours = null;
    }

    private void substractObjectVoxels(Object3D object3D) {
        ArrayList<Voxel3D> arrayList = object3D.getVoxels();
        ArrayList<Voxel3D> arrayList2 = new ArrayList<Voxel3D>();
        double d = 0.25;
        IJ.showStatus((String)("Substracting " + object3D.getVolumePixels() + " voxels"));
        for (Voxel3D voxel3D : this.voxels) {
            boolean bl = false;
            for (Voxel3D voxel3D2 : arrayList) {
                if (!(voxel3D.distanceSquare(voxel3D2) < d)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList2.add(voxel3D);
        }
        this.voxels = arrayList2;
        this.init();
        this.contours = null;
    }

    private void substractObjectImage(Object3D object3D) {
        int n = this.getXmin();
        int n2 = this.getYmin();
        int n3 = this.getZmin();
        int n4 = this.getXmax();
        int n5 = this.getYmax();
        int n6 = this.getZmax();
        int n7 = object3D.getValue();
        ImageInt imageInt = object3D.getLabelImage();
        for (int i = n3; i <= n6; ++i) {
            for (int j = n2; j <= n5; ++j) {
                for (int k = n; k <= n4; ++k) {
                    if (!this.labelImage.contains(k, j, i) || !imageInt.contains(k, j, i) || this.labelImage.getPixel(k, j, i) != (float)this.value || imageInt.getPixel(k, j, i) != (float)n7) continue;
                    this.labelImage.setPixel(k, j, i, 0);
                }
            }
        }
        this.voxels = this.createArrayList(this.labelImage, null);
        this.init();
    }

    public void substractObject(Object3D object3D) {
        if (this.labelImage != null && object3D.getLabelImage() != null && this.getVolumePixels() > 20 && object3D.getVolumePixels() > 20) {
            this.substractObjectImage(object3D);
        } else {
            this.substractObjectVoxels(object3D);
        }
    }

    public final void addVoxels(ArrayList arrayList) {
        this.voxels.addAll(arrayList);
        this.init();
        this.contours = null;
    }

    public void removeVoxels(int n) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        for (Voxel3D voxel3D : this.voxels) {
            if (!(voxel3D.getValue() < (double)n)) continue;
            arrayList.add(voxel3D);
        }
        if (!arrayList.isEmpty()) {
            this.voxels.removeAll(arrayList);
            this.init();
            this.contours = null;
        }
    }

    public boolean isConnex() {
        ImageShort imageShort = (ImageShort)this.createSegImageMini(1, 1);
        Voxel3D voxel3D = this.getFirstVoxel();
        voxel3D.translate(-imageShort.offsetX, -imageShort.offsetY, -imageShort.offsetZ);
        Flood3D.flood3d26(imageShort, voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ(), 2);
        return !imageShort.hasOneValueInt(1);
    }

    public void setShowStatus(boolean bl) {
        this.showStatus = bl;
    }

    @Override
    public Voxel3D getPixelMax(ImageHandler imageHandler) {
        Voxel3D voxel3D = null;
        float f = -3.4028235E38f;
        for (Voxel3D voxel3D2 : this.voxels) {
            float f2 = imageHandler.getPixel(voxel3D2);
            if (!(f2 > f)) continue;
            f = f2;
            voxel3D = new Voxel3D(voxel3D2);
        }
        return voxel3D;
    }

    public void computeMomentsInertia() {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        for (Voxel3D voxel3D : this.voxels) {
            double d = voxel3D.getX();
            double d2 = voxel3D.getY();
            double d3 = voxel3D.getZ();
            this.s200 += this.resXY * this.resXY * (d2 - this.by) * (d2 - this.by) + this.resZ * this.resZ * (d3 - this.bz) * (d3 - this.bz);
            this.s020 += this.resXY * this.resXY * (d - this.bx) * (d - this.bx) + this.resZ * this.resZ * (d3 - this.bz) * (d3 - this.bz);
            this.s002 += this.resXY * this.resXY * (d - this.bx) * (d - this.bx) + this.resXY * this.resXY * (d2 - this.by) * (d2 - this.by);
            this.s110 += this.resXY * this.resXY * (d - this.bx) * (d2 - this.by);
            this.s101 += this.resXY * this.resZ * (d - this.bx) * (d3 - this.bz);
            this.s011 += this.resXY * this.resZ * (d2 - this.by) * (d3 - this.bz);
        }
    }

    @Override
    protected void computeMoments2(boolean bl) {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        for (Voxel3D voxel3D : this.voxels) {
            double d = voxel3D.getX();
            double d2 = voxel3D.getY();
            double d3 = voxel3D.getZ();
            this.s200 += (d - this.bx) * (d - this.bx);
            this.s020 += (d2 - this.by) * (d2 - this.by);
            this.s002 += (d3 - this.bz) * (d3 - this.bz);
            this.s110 += (d - this.bx) * (d2 - this.by);
            this.s101 += (d - this.bx) * (d3 - this.bz);
            this.s011 += (d2 - this.by) * (d3 - this.bz);
        }
        this.s200 *= this.resXY * this.resXY;
        this.s020 *= this.resXY * this.resXY;
        this.s002 *= this.resZ * this.resZ;
        this.s110 *= this.resXY * this.resXY;
        this.s101 *= this.resXY * this.resZ;
        this.s011 *= this.resXY * this.resZ;
        if (bl) {
            this.s200 /= (double)this.volume;
            this.s020 /= (double)this.volume;
            this.s002 /= (double)this.volume;
            this.s110 /= (double)this.volume;
            this.s101 /= (double)this.volume;
            this.s011 /= (double)this.volume;
        }
        this.eigen = null;
    }

    @Override
    public void computeMoments3() {
        this.s003 = 0.0;
        this.s030 = 0.0;
        this.s300 = 0.0;
        this.s111 = 0.0;
        this.s012 = 0.0;
        this.s102 = 0.0;
        this.s021 = 0.0;
        this.s120 = 0.0;
        this.s201 = 0.0;
        this.s210 = 0.0;
        for (Voxel3D voxel3D : this.voxels) {
            double d = voxel3D.getX();
            double d2 = voxel3D.getY();
            double d3 = voxel3D.getZ();
            double d4 = d - this.bx;
            double d5 = d2 - this.by;
            double d6 = d3 - this.bz;
            this.s300 += d4 * d4 * d4;
            this.s030 += d5 * d5 * d5;
            this.s003 += d6 * d6 * d6;
            this.s210 += d4 * d4 * d5;
            this.s201 += d4 * d4 * d6;
            this.s120 += d5 * d5 * d4;
            this.s021 += d5 * d5 * d6;
            this.s102 += d6 * d6 * d4;
            this.s012 += d6 * d6 * d5;
            this.s111 += d4 * d5 * d6;
        }
        this.s300 *= this.resXY * this.resXY * this.resXY;
        this.s030 *= this.resXY * this.resXY * this.resXY;
        this.s003 *= this.resZ * this.resZ * this.resZ;
        this.s210 *= this.resXY * this.resXY * this.resXY;
        this.s201 *= this.resXY * this.resXY * this.resZ;
        this.s120 *= this.resXY * this.resXY * this.resXY;
        this.s021 *= this.resXY * this.resXY * this.resZ;
        this.s102 *= this.resZ * this.resZ * this.resXY;
        this.s012 *= this.resZ * this.resZ * this.resXY;
        this.s111 *= this.resXY * this.resXY * this.resZ;
    }

    @Override
    public void computeMoments4() {
        this.s211 = 0.0;
        this.s112 = 0.0;
        this.s121 = 0.0;
        this.s022 = 0.0;
        this.s202 = 0.0;
        this.s220 = 0.0;
        this.s040 = 0.0;
        this.s040 = 0.0;
        this.s400 = 0.0;
        this.s031 = 0.0;
        this.s013 = 0.0;
        this.s310 = 0.0;
        this.s130 = 0.0;
        this.s301 = 0.0;
        this.s103 = 0.0;
        for (Voxel3D voxel3D : this.voxels) {
            double d = voxel3D.getX();
            double d2 = voxel3D.getY();
            double d3 = voxel3D.getZ();
            double d4 = d - this.bx;
            double d5 = d2 - this.by;
            double d6 = d3 - this.bz;
            this.s400 += d4 * d4 * d4 * d4;
            this.s040 += d5 * d5 * d5 * d5;
            this.s004 += d6 * d6 * d6 * d6;
            this.s220 += d4 * d4 * d5 * d5;
            this.s202 += d4 * d4 * d6 * d6;
            this.s022 += d5 * d5 * d6 * d6;
            this.s121 += d4 * d5 * d5 * d6;
            this.s112 += d4 * d5 * d6 * d6;
            this.s211 += d4 * d4 * d5 * d6;
            this.s103 += d4 * d6 * d6 * d6;
            this.s301 += d4 * d4 * d4 * d6;
            this.s130 += d4 * d5 * d5 * d5;
            this.s310 += d4 * d4 * d4 * d5;
            this.s013 += d5 * d6 * d6 * d6;
            this.s031 += d5 * d5 * d5 * d6;
        }
        this.s400 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s040 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s004 *= this.resZ * this.resZ * this.resZ * this.resZ;
        this.s220 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s202 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s022 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s121 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s112 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s211 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s103 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s301 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s130 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s310 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s013 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s031 *= this.resXY * this.resXY * this.resXY * this.resZ;
    }

    @Override
    protected void computeCenter() {
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        for (Voxel3D voxel3D : this.voxels) {
            this.bx += voxel3D.getX();
            this.by += voxel3D.getY();
            this.bz += voxel3D.getZ();
        }
        int n = this.voxels.size();
        this.bx /= (double)n;
        this.by /= (double)n;
        this.bz /= (double)n;
        this.volume = n;
    }

    public void setContours(ArrayList<Voxel3D> arrayList, double d) {
        this.areaContactUnit = d;
        this.areaNbVoxels = arrayList.size();
        this.contours = arrayList;
        this.kdtreeContours = null;
    }

    private void computeContours(ImageInt imageInt, int n, int n2, int n3) {
        this.kdtreeContours = new KDTreeC(3);
        this.kdtreeContours.setScale3(this.resXY, this.resXY, this.resZ);
        this.areaNbVoxels = 0.0;
        this.areaContactUnit = 0.0;
        this.areaContactVoxels = 0.0;
        this.contours = new ArrayList();
        double d = this.resXY * this.resZ;
        double d2 = this.resXY * this.resXY;
        int n4 = imageInt.sizeX;
        int n5 = imageInt.sizeY;
        int n6 = imageInt.sizeZ;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i = this.zmin - n3; i <= this.zmax - n3; ++i) {
            if (this.showStatus) {
                IJ.showStatus((String)("Contours " + 100 * (i - this.zmin) / (this.zmax - this.zmin + 1) + " % "));
            }
            for (int j = this.ymin - n2; j <= this.ymax - n2; ++j) {
                for (int k = this.xmin - n; k <= this.xmax - n; ++k) {
                    int n13;
                    boolean bl = false;
                    if (!imageInt.contains(k, j, i) || (n13 = imageInt.getPixelInt(k, j, i)) != this.value) continue;
                    int n14 = 0;
                    boolean bl2 = false;
                    int n15 = k + 1 < n4 ? imageInt.getPixelInt(k + 1, j, i) : 0;
                    int n16 = k - 1 >= 0 ? imageInt.getPixelInt(k - 1, j, i) : 0;
                    int n17 = j + 1 < n5 ? imageInt.getPixelInt(k, j + 1, i) : 0;
                    int n18 = j - 1 >= 0 ? imageInt.getPixelInt(k, j - 1, i) : 0;
                    int n19 = i + 1 < n6 ? imageInt.getPixelInt(k, j, i + 1) : 0;
                    int n20 = i - 1 >= 0 ? imageInt.getPixelInt(k, j, i - 1) : 0;
                    if (n15 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                        ++n14;
                        if (n16 != this.value) {
                            bl2 = true;
                        }
                    }
                    if (n16 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                        ++n14;
                    }
                    if (n17 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                        ++n14;
                        if (n18 != this.value) {
                            bl2 = true;
                        }
                    }
                    if (n18 != this.value) {
                        bl = true;
                        this.areaContactUnit += d;
                        this.areaContactVoxels += 1.0;
                        ++n14;
                    }
                    if (n19 != this.value) {
                        bl = true;
                        this.areaContactUnit += d2;
                        this.areaContactVoxels += 1.0;
                        ++n14;
                        if (n20 != this.value) {
                            bl2 = true;
                        }
                    }
                    if (n20 != this.value) {
                        bl = true;
                        this.areaContactUnit += d2;
                        this.areaContactVoxels += 1.0;
                        ++n14;
                    }
                    if (!bl) continue;
                    this.areaNbVoxels += 1.0;
                    Voxel3D voxel3D = new Voxel3D(k + n, j + n2, i + n3, this.value);
                    this.contours.add(voxel3D);
                    this.kdtreeContours.add(voxel3D.getArray(), voxel3D);
                    if (n14 == 1) {
                        ++n7;
                    }
                    if (n14 == 2) {
                        ++n8;
                    }
                    if (n14 == 3 && !bl2) {
                        ++n9;
                    }
                    if (n14 == 3 && bl2) {
                        ++n10;
                    }
                    if (n14 == 4) {
                        ++n11;
                    }
                    if (n14 != 5) continue;
                    ++n12;
                }
            }
        }
        double d3 = 0.894;
        double d4 = 1.3409;
        double d5 = 1.5879;
        double d6 = 2.0;
        double d7 = 2.6666666666666665;
        double d8 = 3.3333333333333335;
        this.correctedSurfaceArea = (double)n7 * d3 + (double)n8 * d4 + (double)n9 * d5 + (double)n10 * d6 + (double)n11 * d7 + (double)n12 * d8;
        if (this.areaNbVoxels == 0.0) {
            // empty if block
        }
    }

    @Override
    public void computeContours() {
        if (this.labelImage != null) {
            this.computeContours(this.labelImage, 0, 0, 0);
        } else {
            ImageInt imageInt = this.getLabelImage();
            this.computeContours(imageInt, imageInt.offsetX, imageInt.offsetY, imageInt.offsetZ);
        }
    }

    @Override
    protected void computeBounding() {
        this.xmin = Integer.MAX_VALUE;
        this.xmax = 0;
        this.ymin = Integer.MAX_VALUE;
        this.ymax = 0;
        this.zmin = Integer.MAX_VALUE;
        this.zmax = 0;
        for (Voxel3D voxel3D : this.voxels) {
            if (voxel3D.getX() < (double)this.xmin) {
                this.xmin = (int)Math.floor(voxel3D.getX());
            }
            if (voxel3D.getX() > (double)this.xmax) {
                this.xmax = (int)Math.ceil(voxel3D.getX());
            }
            if (voxel3D.getY() < (double)this.ymin) {
                this.ymin = (int)Math.floor(voxel3D.getY());
            }
            if (voxel3D.getY() > (double)this.ymax) {
                this.ymax = (int)Math.ceil(voxel3D.getY());
            }
            if (voxel3D.getZ() < (double)this.zmin) {
                this.zmin = (int)Math.floor(voxel3D.getZ());
            }
            if (!(voxel3D.getZ() > (double)this.zmax)) continue;
            this.zmax = (int)Math.ceil(voxel3D.getZ());
        }
    }

    private void computeEigenInertia() {
        if (this.eigen == null) {
            Matrix matrix = new Matrix(3, 3);
            matrix.set(0, 0, this.s200);
            matrix.set(0, 1, -this.s110);
            matrix.set(0, 2, -this.s101);
            matrix.set(1, 0, -this.s110);
            matrix.set(1, 1, this.s020);
            matrix.set(1, 2, -this.s011);
            matrix.set(2, 0, -this.s101);
            matrix.set(2, 1, -this.s011);
            matrix.set(2, 2, this.s002);
            this.eigen = new EigenvalueDecomposition(matrix);
        }
    }

    protected ArrayList<Voxel3D> getVoxelInsideBoundingBox(int[] nArray) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        for (Voxel3D voxel3D : this.voxels) {
            if (!voxel3D.isInsideBoundingBox(nArray)) continue;
            arrayList.add(voxel3D);
        }
        return arrayList;
    }

    @Override
    public int getColoc(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return 0;
        }
        if (this.getLabelImage() != null || object3D.getLabelImage() != null) {
            return this.getColocImage(object3D);
        }
        int n = 1000;
        if (this.getVolumePixels() > n && object3D.getVolumePixels() > n) {
            return this.getColocImage(object3D);
        }
        return this.getColocVoxels(object3D);
    }

    @Override
    public boolean hasOneVoxelColoc(Object3D object3D) {
        return this.hasOneVoxelColocVoxels(object3D);
    }

    private int getColocImage(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return 0;
        }
        if (this.getLabelImage() == null || object3D.getLabelImage() == null) {
            return this.getColocImageIntersection(object3D);
        }
        int n = 0;
        int n2 = object3D.getValue();
        ImageInt imageInt = object3D.getLabelImage();
        int n3 = this.getXmin();
        int n4 = this.getYmin();
        int n5 = this.getZmin();
        int n6 = this.getXmax();
        int n7 = this.getYmax();
        int n8 = this.getZmax();
        n3 = Math.max(n3, object3D.getXmin());
        n4 = Math.max(n4, object3D.getYmin());
        n5 = Math.max(n5, object3D.getZmin());
        n6 = Math.min(n6, object3D.getXmax());
        n7 = Math.min(n7, object3D.getYmax());
        n8 = Math.min(n8, object3D.getZmax());
        int n9 = this.labelImage.offsetX;
        int n10 = this.labelImage.offsetY;
        int n11 = this.labelImage.offsetZ;
        int n12 = imageInt.offsetX;
        int n13 = imageInt.offsetY;
        int n14 = imageInt.offsetZ;
        for (int i = n5; i <= n8; ++i) {
            for (int j = n4; j <= n7; ++j) {
                for (int k = n3; k <= n6; ++k) {
                    if (this.labelImage.getPixel(k - n9, j - n10, i - n11) != (float)this.value || imageInt.getPixel(k - n12, j - n13, i - n14) != (float)n2) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    private int getColocImageIntersection(Object3D object3D) {
        ImageInt imageInt = this.createIntersectionImage(object3D, 1, 2);
        int n = 0;
        for (int i = 0; i < imageInt.sizeXYZ; ++i) {
            if (imageInt.getPixelInt(i) != 3) continue;
            ++n;
        }
        return n;
    }

    private int getColocVoxels(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return 0;
        }
        int[] nArray = this.getIntersectionBox(object3D);
        ArrayList<Voxel3D> arrayList = this.getVoxelInsideBoundingBox(nArray);
        if (!(object3D instanceof Object3DVoxels)) {
            object3D = object3D.getObject3DVoxels();
        }
        ArrayList<Voxel3D> arrayList2 = ((Object3DVoxels)object3D).getVoxelInsideBoundingBox(nArray);
        int n = 0;
        for (Voxel3D voxel3D : arrayList) {
            for (Voxel3D voxel3D2 : arrayList2) {
                if (!voxel3D.sameVoxel(voxel3D2)) continue;
                ++n;
            }
        }
        return n;
    }

    private boolean hasOneVoxelColocImage(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return false;
        }
        if (this.getLabelImage() == null || object3D.getLabelImage() == null) {
            return false;
        }
        int n = object3D.getValue();
        ImageInt imageInt = object3D.getLabelImage();
        int n2 = this.getXmin();
        int n3 = this.getYmin();
        int n4 = this.getZmin();
        int n5 = this.getXmax();
        int n6 = this.getYmax();
        int n7 = this.getZmax();
        n2 = Math.max(n2, object3D.getXmin());
        n3 = Math.max(n3, object3D.getYmin());
        n4 = Math.max(n4, object3D.getZmin());
        n5 = Math.min(n5, object3D.getXmax());
        n6 = Math.min(n6, object3D.getYmax());
        n7 = Math.min(n7, object3D.getZmax());
        int n8 = this.labelImage.offsetX;
        int n9 = this.labelImage.offsetY;
        int n10 = this.labelImage.offsetZ;
        int n11 = imageInt.offsetX;
        int n12 = imageInt.offsetY;
        int n13 = imageInt.offsetZ;
        for (int i = n4; i <= n7; ++i) {
            for (int j = n3; j <= n6; ++j) {
                for (int k = n2; k <= n5; ++k) {
                    if (this.labelImage.getPixel(k - n8, j - n9, i - n10) != (float)this.value || imageInt.getPixel(k - n11, j - n12, i - n13) != (float)n) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasOneVoxelColocVoxels(Object3D object3D) {
        if (this.disjointBox(object3D)) {
            return false;
        }
        int[] nArray = this.getIntersectionBox(object3D);
        ArrayList<Voxel3D> arrayList = this.getVoxelInsideBoundingBox(nArray);
        if (!(object3D instanceof Object3DVoxels)) {
            object3D = object3D.getObject3DVoxels();
        }
        ArrayList<Voxel3D> arrayList2 = ((Object3DVoxels)object3D).getVoxelInsideBoundingBox(nArray);
        for (Voxel3D voxel3D : arrayList) {
            for (Voxel3D voxel3D2 : arrayList2) {
                if (!voxel3D.sameVoxel(voxel3D2)) continue;
                return true;
            }
        }
        return false;
    }

    public double pcColoc2(ArrayList<Object3DVoxels> arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 1;
        Object3DVoxels object3DVoxels = this;
        Object3DVoxels object3DVoxels2 = arrayList.get(0);
        if (object3DVoxels.pcColoc(object3DVoxels2) > 0.0) {
            Object3DVoxels object3DVoxels3 = new Object3DVoxels();
            object3DVoxels3.addVoxelsIntersection(object3DVoxels, object3DVoxels2);
            n2 = object3DVoxels3.getVolumePixels();
            n3 = object3DVoxels.getVolumePixels() + object3DVoxels2.getVolumePixels();
            int n4 = 1;
            boolean bl = true;
            while (bl && n4 < n) {
                bl = false;
                Object3DVoxels object3DVoxels4 = arrayList.get(n4);
                if (!object3DVoxels3.intersectionBox(object3DVoxels4)) {
                    n2 = 0;
                    continue;
                }
                if (object3DVoxels3.pcColoc(object3DVoxels4) > 0.0) {
                    bl = true;
                    n3 += object3DVoxels4.getVolumePixels();
                    Object3DVoxels object3DVoxels5 = new Object3DVoxels();
                    object3DVoxels5.addVoxelsIntersection(object3DVoxels3, object3DVoxels4);
                    object3DVoxels3 = object3DVoxels5;
                    n2 = object3DVoxels3.getVolumePixels();
                    ++n4;
                    continue;
                }
                n2 = 0;
            }
        }
        double d = 100.0 * (double)(n * n2) / (double)n3;
        return d;
    }

    @Override
    public Roi createRoi(int n) {
        int n2 = this.getXmax() - this.getXmin() + 1;
        int n3 = this.getYmax() - this.getYmin() + 1;
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3);
        this.draw(byteProcessor, n, 255);
        ImagePlus imagePlus = new ImagePlus("mask " + n, (ImageProcessor)byteProcessor);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus);
        thresholdToSelection.run((ImageProcessor)byteProcessor);
        imagePlus.updateAndDraw();
        Roi roi = imagePlus.getRoi();
        Rectangle rectangle = roi.getBounds();
        rectangle.x += this.getXmin();
        rectangle.y += this.getYmin();
        return roi;
    }

    @Override
    public void draw(ByteProcessor byteProcessor, int n, int n2) {
        for (Voxel3D voxel3D : this.voxels) {
            if (!(Math.abs((double)n - voxel3D.getZ()) < 0.5)) continue;
            byteProcessor.putPixel(voxel3D.getRoundX(), voxel3D.getRoundY(), n2);
        }
    }

    @Override
    public void draw(ImageStack imageStack, int n) {
        for (Voxel3D voxel3D : this.voxels) {
            imageStack.setVoxel(voxel3D.getRoundX(), voxel3D.getRoundY(), voxel3D.getRoundZ(), (double)n);
        }
    }

    @Override
    public void draw(ImageStack imageStack, int n, int n2, int n3) {
        Color color = new Color(n, n2, n3);
        for (Voxel3D voxel3D : this.voxels) {
            ImageProcessor imageProcessor = imageStack.getProcessor((int)(voxel3D.getZ() + 1.0));
            imageProcessor.setColor(color);
            imageProcessor.drawPixel(voxel3D.getRoundX(), voxel3D.getRoundY());
        }
    }

    @Override
    public ArrayList<Voxel3D> getVoxels() {
        return this.voxels;
    }

    public Voxel3D getFirstVoxel() {
        return this.voxels.get(0);
    }

    public double getDiscreteCompactness() {
        double d = this.getVolumePixels();
        double d2 = Math.pow(d, 0.6666666666666666);
        return (d - this.areaContactVoxels / 6.0) / (d - d2);
    }

    public double getCompactnessCorrected() {
        double d = this.getVolumePixels();
        double d2 = this.correctedSurfaceArea;
        return 113.09733552923255 * d * d / (d2 * d2 * d2);
    }

    public double getSphericityCorrected() {
        return Math.pow(this.getCompactnessCorrected(), 0.3333333333333333);
    }

    public double getAreaPixelsCorrected() {
        if (this.correctedSurfaceArea == -1.0) {
            this.computeContours();
        }
        return this.correctedSurfaceArea;
    }

    @Override
    public void writeVoxels(String string) {
        int n = 0;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + this.name + ".3droi"));
            Iterator<Voxel3D> iterator = this.voxels.iterator();
            while (iterator.hasNext()) {
                Voxel3D voxel3D = new Voxel3D(iterator.next());
                bufferedWriter.write(++n + "\t" + voxel3D.getX() + "\t" + voxel3D.getY() + "\t" + voxel3D.getZ() + "\t" + voxel3D.getValue() + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(Object3DVoxels.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public void loadVoxels(String string, String string2) {
        this.setName(string2);
        this.voxels = new ArrayList();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + string2));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                String[] stringArray = string3.split("\t");
                double d = Double.parseDouble(stringArray[1]);
                double d2 = Double.parseDouble(stringArray[2]);
                double d3 = Double.parseDouble(stringArray[3]);
                int n = (int)Double.parseDouble(stringArray[4]);
                this.voxels.add(new Voxel3D(d, d2, d3, (double)n));
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.init();
        }
        catch (IOException iOException) {
            Logger.getLogger(Object3DVoxels.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    @Override
    public void translate(double d, double d2, double d3) {
        for (Voxel3D voxel3D : this.voxels) {
            voxel3D.translate(d, d2, d3);
        }
        this.init();
    }

    @Override
    public void translate(Vector3D vector3D) {
        for (Voxel3D voxel3D : this.voxels) {
            voxel3D.translate(vector3D);
        }
        this.init();
    }

    public void rotate(Vector3D vector3D, double d) {
        GeomTransform3D geomTransform3D = new GeomTransform3D();
        geomTransform3D.setRotation(vector3D, d);
        for (Voxel3D voxel3D : this.voxels) {
            Vector3D vector3D2 = geomTransform3D.getVectorTransformed(voxel3D.getVector3D(), this.getCenterAsVector());
            voxel3D.setVoxel(vector3D2.getX(), vector3D2.getY(), vector3D2.getZ(), voxel3D.getValue());
        }
    }

    @Override
    protected void computeMassCenter(ImageHandler imageHandler) {
        if (imageHandler != null) {
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            for (Voxel3D voxel3D : this.voxels) {
                double d5;
                double d6;
                double d7 = voxel3D.getX();
                if (!imageHandler.contains(d7, d6 = voxel3D.getY(), d5 = voxel3D.getZ())) continue;
                double d8 = imageHandler.getPixel(voxel3D);
                this.cx += d7 * d8;
                this.cy += d6 * d8;
                this.cz += d5 * d8;
                d += d8;
                d2 += d8 * d8;
                if (d8 > d4) {
                    d4 = d8;
                }
                if (!(d8 < d3)) continue;
                d3 = d8;
            }
            this.cx /= d;
            this.cy /= d;
            this.cz /= d;
            this.integratedDensity = d;
            this.pixmin = d3;
            this.pixmax = d4;
            int n = this.getVolumePixels();
            this.sigma = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1));
        }
    }

    @Override
    public ArrayList<Voxel3D> listVoxels(ImageHandler imageHandler, double d) {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>();
        for (Voxel3D voxel3D : this.voxels) {
            float f;
            if (!imageHandler.contains(voxel3D.getX(), voxel3D.getY(), voxel3D.getZ()) || !((double)(f = imageHandler.getPixel(voxel3D)) > d)) continue;
            Voxel3D voxel3D2 = new Voxel3D(voxel3D);
            voxel3D2.setValue(f);
            arrayList.add(voxel3D2);
        }
        return arrayList;
    }

    public ArrayUtil listVoxels(ImageHandler imageHandler, int n, int n2, int n3) {
        ArrayUtil arrayUtil = new ArrayUtil(this.getVolumePixels());
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        double d = (double)n - this.bx;
        double d2 = (double)n2 - this.by;
        double d3 = (double)n3 - this.bz;
        int n4 = 0;
        while (iterator.hasNext()) {
            int n5;
            int n6;
            Voxel3D voxel3D = iterator.next();
            int n7 = (int)Math.round(d + voxel3D.getX());
            if (!imageHandler.contains(n7, n6 = (int)Math.round(d2 + voxel3D.getY()), n5 = (int)Math.round(d3 + voxel3D.getZ()))) continue;
            float f = imageHandler.getPixel(n7, n6, n5);
            arrayUtil.putValue(n4, f);
            ++n4;
        }
        arrayUtil.setSize(n4);
        return arrayUtil;
    }

    @Override
    public void draw(ImageHandler imageHandler, int n) {
        for (Voxel3D voxel3D : this.voxels) {
            int n2;
            int n3;
            int n4 = voxel3D.getRoundX();
            if (!imageHandler.contains(n4, n3 = voxel3D.getRoundY(), n2 = voxel3D.getRoundZ())) continue;
            imageHandler.setPixel(n4, n3, n2, n);
        }
    }

    @Override
    public ArrayUtil listValues(ImageHandler imageHandler) {
        ArrayUtil arrayUtil = new ArrayUtil(this.getVolumePixels());
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Voxel3D voxel3D = iterator.next();
            if (!imageHandler.contains(voxel3D.getX(), voxel3D.getY(), voxel3D.getZ())) continue;
            arrayUtil.putValue(n, imageHandler.getPixel(voxel3D));
            ++n;
        }
        arrayUtil.setSize(n);
        return arrayUtil;
    }
}

