/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public class MeshEditor {
    public static List smooth(List list, float f) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        if (0 != arrayList.size() % 3) {
            System.out.println("MeshEditor.smooth: need a list of points multiple of 3.");
            return null;
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < arrayList.size(); i += 3) {
            Object object = (Point3f)arrayList.get(i);
            Point3f point3f = (Point3f)arrayList.get(i + 1);
            Point3f point3f2 = (Point3f)arrayList.get(i + 2);
            MeshEditor.build((Point3f)object, point3f, point3f2, hashMap);
            MeshEditor.build(point3f, point3f2, (Point3f)object, hashMap);
            MeshEditor.build(point3f2, (Point3f)object, point3f, hashMap);
        }
        for (Object object : hashMap.values()) {
            ((PointGroup)object).smoothMembers(f);
        }
        return arrayList;
    }

    private static void build(Point3f point3f, Point3f point3f2, Point3f point3f3, HashMap hashMap) {
        PointGroup pointGroup = (PointGroup)hashMap.get(point3f);
        if (null != pointGroup) {
            pointGroup.addMember(point3f);
        } else {
            pointGroup = new PointGroup(point3f);
            hashMap.put(point3f, pointGroup);
        }
        pointGroup.addEdge(point3f2);
        pointGroup.addEdge(point3f3);
    }

    private static final Vertex uniqueVertex(Point3f point3f, HashMap<Point3f, Vertex> hashMap) {
        Vertex vertex = hashMap.get(point3f);
        if (null == vertex) {
            vertex = new Vertex(point3f);
            hashMap.put(point3f, vertex);
        } else {
            vertex.copies.add(point3f);
        }
        return vertex;
    }

    public static List smooth2(List<Point3f> list, int n) {
        int n2;
        HashMap<Point3f, Vertex> hashMap = new HashMap<Point3f, Vertex>();
        HashSet<Edge> hashSet = new HashSet<Edge>();
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        arrayList.addAll(list);
        for (n2 = 0; n2 < arrayList.size(); n2 += 3) {
            Iterator<Vertex> iterator = MeshEditor.uniqueVertex((Point3f)arrayList.get(n2), hashMap);
            Vertex object = MeshEditor.uniqueVertex((Point3f)arrayList.get(n2 + 1), hashMap);
            Vertex vertex = MeshEditor.uniqueVertex((Point3f)arrayList.get(n2 + 2), hashMap);
            hashSet.add(new Edge((Vertex)((Object)iterator), object));
            hashSet.add(new Edge(object, vertex));
            hashSet.add(new Edge((Vertex)((Object)iterator), vertex));
            if (0 != n2 % 300 || !Thread.currentThread().isInterrupted()) continue;
            return null;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            for (Edge edge : hashSet) {
                edge.averageVertices();
            }
            for (Vertex vertex : hashMap.values()) {
                vertex.smooth();
            }
            if (n2 + 1 >= n) continue;
            for (Vertex vertex : hashMap.values()) {
                vertex.reset();
            }
        }
        return arrayList;
    }

    private static final class Edge {
        private Vertex v1;
        private Vertex v2;

        Edge(Vertex vertex, Vertex vertex2) {
            this.v1 = vertex;
            this.v2 = vertex2;
        }

        public final boolean equals(Object object) {
            Edge edge = (Edge)object;
            return edge == this || edge.v1 == this.v1 && edge.v2 == this.v2 || edge.v1 == this.v2 && edge.v2 == this.v1;
        }

        private final void averageVertices() {
            this.v1.average(this.v2);
        }
    }

    private static final class Vertex {
        private final Point3f p;
        private final ArrayList<Point3f> copies = new ArrayList();
        private final Point3f tmp;
        private int n;

        Vertex(Point3f point3f) {
            this.p = point3f;
            this.tmp = new Point3f(0.0f, 0.0f, 0.0f);
            this.copies.add(point3f);
        }

        private final void reset() {
            this.tmp.set(0.0f, 0.0f, 0.0f);
            this.n = 0;
        }

        public final boolean equals(Object object) {
            Vertex vertex = (Vertex)object;
            return vertex.p == this.p || vertex.p.x == this.p.x && vertex.p.y == this.p.y && vertex.p.z == this.p.z;
        }

        private final void average(Vertex vertex) {
            ++this.n;
            ++vertex.n;
            Point3f point3f = new Point3f((this.p.x + vertex.p.x) / 2.0f, (this.p.y + vertex.p.y) / 2.0f, (this.p.z + vertex.p.z) / 2.0f);
            this.tmp.add((Tuple3f)point3f);
            vertex.tmp.add((Tuple3f)point3f);
        }

        private final void smooth() {
            float f = 0.5f / (float)this.n;
            this.tmp.set(0.5f * this.p.x + f * this.tmp.x, 0.5f * this.p.y + f * this.tmp.y, 0.5f * this.p.z + f * this.tmp.z);
            for (Point3f point3f : this.copies) {
                point3f.set((Tuple3f)this.tmp);
            }
        }
    }

    private static class PointGroup {
        Point3f first;
        HashSet edges = new HashSet();
        ArrayList members = new ArrayList();
        float vx;
        float vy;
        float vz;

        PointGroup(Point3f point3f) {
            this.first = point3f;
            this.members.add(point3f);
        }

        void addMember(Point3f point3f) {
            this.members.add(point3f);
        }

        void addEdge(Point3f point3f) {
            this.edges.add(point3f);
        }

        void smoothMembers(float f) {
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.vz = 0.0f;
            for (Object object : this.edges) {
                this.vx += ((Point3f)object).x;
                this.vy += ((Point3f)object).y;
                this.vz += ((Point3f)object).z;
            }
            int n = this.edges.size();
            this.vx = (this.vx / (float)n - this.first.x) * f;
            this.vy = (this.vy / (float)n - this.first.y) * f;
            this.vz = (this.vz / (float)n - this.first.z) * f;
            for (Point3f point3f : this.members) {
                point3f.x += this.vx;
                point3f.y += this.vy;
                point3f.z += this.vz;
            }
        }

        void computeVector(float f) {
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.vz = 0.0f;
            for (Point3f point3f : this.edges) {
                this.vx += point3f.x;
                this.vy += point3f.y;
                this.vz += point3f.z;
            }
            int n = this.edges.size();
            this.vx = (this.vx / (float)n - this.first.x) * f;
            this.vy = (this.vy / (float)n - this.first.y) * f;
            this.vz = (this.vz / (float)n - this.first.z) * f;
        }

        void applyVector(HashMap hashMap) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n = 0;
            Iterator iterator = this.edges.iterator();
            while (iterator.hasNext()) {
                PointGroup pointGroup = (PointGroup)hashMap.get(iterator.next());
                if (null == pointGroup) continue;
                ++n;
                f += pointGroup.vx;
                f2 += pointGroup.vy;
                f3 += pointGroup.vz;
            }
            f += this.vx;
            f2 += this.vy;
            f3 += this.vz;
            f /= (float)(++n);
            f2 /= (float)n;
            f3 /= (float)n;
            for (PointGroup pointGroup : this.members) {
                ((Point3f)pointGroup).x += this.vx;
                ((Point3f)pointGroup).y += this.vy;
                ((Point3f)pointGroup).z += this.vz;
            }
        }
    }
}

